package im.qingtui.qbee.open.platfrom.communication.model.param;

import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.FieldDefaults;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * [Description] 重试语音信箱的参数
 *
 * @author lixiaobin
 * @version 1.0
 * @since 2021-11-22 08:39
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@FieldDefaults(level = AccessLevel.PRIVATE)
public class MobileVmsRetryParam implements Serializable {

    private static final long serialVersionUID = -4160193904357247412L;

    /**
     * 短信/语音 模板编码
     */
    String templateCode;

    /**
     * 模版中的变量及其对应的值
     */
    Map<String, String> templateVar;

    /**
     * 重试间隔时间(毫秒)
     */
    Integer retryIntervalTime;

    /**
     * 呼叫业务对象包含手机号，业务id 、手机号
     */

    List<CallResultParam> callResultDtoList;

    /**
     * 呼叫响应应用方结果的回调地址
     */
    String callbackUrl;

    /**
     * 重试次数
     */
    Integer retryCount;

}
