package im.qingtui.qbee.open.platfrom.communication.model.param;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.FieldDefaults;

/**
 * [Description] 发送移动短信的参数
 *
 * @author QingSong
 * @version 1.0
 * @since 2021-09-17 14:12
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Accessors(chain = true)
@FieldDefaults(level = AccessLevel.PRIVATE)
public class MobileSmsParam implements Serializable {

    private static final long serialVersionUID = -3189211263806894903L;

    /**
     * 无任何前缀的11位手机号码 [必传]
     */
    List<String> mobilePhoneList;
    /**
     * 签名（参数中所有手机号均使用这一个签名） [必传]
     */
    String signName;
    /**
     * 短信/语音电话 模板编码 [必传]
     */
    String templateCode;
    /**
     * 模版中的变量及其对应的值
     */
    Map<String, String> templateVar;

}
