/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.mongo.utils;

import com.alibaba.fastjson.JSONObject;
import com.mongodb.assertions.Assertions;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.types.ObjectId;

public final class DocumentUtils {
    private DocumentUtils() {
    }

    public static List<Document> removeObjectId(List<Document> documents) {
        Assertions.notNull((String)"documents", documents);
        for (Document document : documents) {
            document.remove((Object)"_id");
        }
        return documents;
    }

    public static Document removeObjectId(Document document) {
        Assertions.notNull((String)"document", (Object)document);
        document.remove((Object)"_id");
        return document;
    }

    public static Document replaceObjectId(Document document) {
        Assertions.notNull((String)"document", (Object)document);
        return DocumentUtils.replaceObjectId(document, "id");
    }

    public static Document replaceObjectId(Document document, String newIdKey) {
        Assertions.notNull((String)"document", (Object)document);
        Assertions.notNull((String)"newIdKey", (Object)newIdKey);
        ObjectId objectId = document.getObjectId((Object)"_id");
        if (objectId != null) {
            document.put(newIdKey, (Object)objectId.toString());
            document.remove((Object)"_id");
        }
        return document;
    }

    public static List<Document> replaceObjectId(List<Document> documents) {
        Assertions.notNull((String)"documents", documents);
        return DocumentUtils.replaceObjectId(documents, "id");
    }

    public static List<Document> replaceObjectId(List<Document> documents, String newIdKey) {
        Assertions.notNull((String)"documents", documents);
        Assertions.notNull((String)"newIdKey", (Object)newIdKey);
        for (Document document : documents) {
            DocumentUtils.replaceObjectId(document, newIdKey);
        }
        return documents;
    }

    public static <T> List<T> parseArray(Object documentListObj, Class<T> clazz) {
        Assertions.notNull((String)"documentListObj", (Object)documentListObj);
        Assertions.notNull((String)"clazz", clazz);
        List documentList = (List)documentListObj;
        return DocumentUtils.parseArray(documentList, clazz);
    }

    public static <T> List<T> parseArray(List<Document> documentList, Class<T> clazz) {
        Assertions.notNull((String)"documentList", documentList);
        Assertions.notNull((String)"clazz", clazz);
        ArrayList<Object> result = new ArrayList<Object>();
        for (Document document : documentList) {
            if (document == null) continue;
            result.add(JSONObject.parseObject((String)document.toJson(), clazz));
        }
        return result;
    }

    public static Document aggregateResultToDocument(List<Document> documents, String fileName) {
        Assertions.notNull((String)"documents", documents);
        Assertions.notNull((String)"fileName", (Object)fileName);
        Document result = new Document();
        for (Document document : documents) {
            Object key = document.get((Object)"_id");
            if (key == null) continue;
            result.append(key.toString(), document.get((Object)fileName));
        }
        return result;
    }
}

