/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.mongo.entity;

import im.qingtui.mongo.entity.Order;
import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class PageAbstract {
    private int size;
    private List<Order> orders;

    public abstract int skip();

    public void setOrders(Order ... orders) {
        this.orders = Arrays.asList(orders);
    }

    public Bson getBsonOrder() {
        Document orderDocument = new Document();
        if (this.orders != null) {
            for (Order order : this.orders) {
                orderDocument.append(order.getOrderName(), (Object)order.getOrderValue());
            }
        }
        return orderDocument;
    }

    public int getSize() {
        return this.size;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageAbstract)) {
            return false;
        }
        PageAbstract other = (PageAbstract)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        List<Order> this$orders = this.getOrders();
        List<Order> other$orders = other.getOrders();
        return !(this$orders == null ? other$orders != null : !((Object)this$orders).equals(other$orders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageAbstract;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSize();
        List<Order> $orders = this.getOrders();
        result = result * 59 + ($orders == null ? 43 : ((Object)$orders).hashCode());
        return result;
    }

    public String toString() {
        return "PageAbstract(size=" + this.getSize() + ", orders=" + this.getOrders() + ")";
    }
}

