/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.mongo;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class MongoOperation {
    private static Properties properties = new Properties();
    private static volatile MongoClient mongoClient;

    private static void initProperty() {
        MongoOperation.loadPropertyFromConfig();
    }

    private static void loadPropertyFromConfig() {
        try {
            InputStream mongodbConfig = MongoOperation.class.getClassLoader().getResourceAsStream("mongodb.properties");
            if (mongodbConfig == null) {
                throw new IOException("\u52a0\u8f7d mongodb.properties \u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
            }
            properties.load(mongodbConfig);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static MongoClient connect() {
        if (mongoClient == null) {
            MongoOperation.doConnect();
        }
        return mongoClient;
    }

    public static MongoDatabase connectDatabase() {
        MongoClient mongoClient = MongoOperation.connect();
        return mongoClient.getDatabase(properties.getProperty("mongo.database"));
    }

    private static synchronized void doConnect() {
        if (mongoClient == null) {
            mongoClient = MongoClients.create((String)properties.getProperty("mongo.url"));
        }
    }

    static {
        MongoOperation.initProperty();
    }
}

