/*
 * Decompiled with CFR 0.152.
 */
package im.qingtui.mongo;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import im.qingtui.mongo.CollectionOperation;
import im.qingtui.mongo.MongoOperator;
import im.qingtui.mongo.entity.PageAbstract;
import im.qingtui.mongo.entity.PageResult;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class DocumentOperation {
    public static String insertOne(String collectionName, Document document) {
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        collection.insertOne((Object)document);
        return document.getObjectId((Object)"_id").toString();
    }

    public static List<String> insertMany(String collectionName, List<Document> documents) {
        Assertions.notNull((String)"documents", documents);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        collection.insertMany(documents);
        ArrayList<String> ids = new ArrayList<String>();
        for (Document document : documents) {
            ids.add(document.getObjectId((Object)"_id").toString());
        }
        return ids;
    }

    public static List<Document> find(String collectionName, Bson filter) {
        Assertions.notNull((String)"filter", (Object)filter);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        return DocumentOperation.toList((MongoCursor<Document>)collection.find(filter).iterator());
    }

    public static List<Document> findAndSort(String collectionName, Bson filter, Bson sort) {
        Assertions.notNull((String)"filter", (Object)filter);
        Assertions.notNull((String)"sort", (Object)sort);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        return DocumentOperation.toList((MongoCursor<Document>)collection.find(filter).sort(sort).iterator());
    }

    public static List<Document> find(String collectionName, Bson filter, Bson projection) {
        Assertions.notNull((String)"filter", (Object)filter);
        Assertions.notNull((String)"projection", (Object)projection);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        return DocumentOperation.toList((MongoCursor<Document>)collection.find(filter).projection(projection).iterator());
    }

    public static List<Document> find(String collectionName, Bson filter, Bson projection, Bson sort) {
        Assertions.notNull((String)"filter", (Object)filter);
        Assertions.notNull((String)"projection", (Object)projection);
        Assertions.notNull((String)"sort", (Object)sort);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        return DocumentOperation.toList((MongoCursor<Document>)collection.find(filter).projection(projection).sort(sort).iterator());
    }

    public static Document findById(String collectionName, String id) {
        if (!ObjectId.isValid((String)id)) {
            return null;
        }
        List<Document> documents = DocumentOperation.find(collectionName, Filters.eq((Object)new ObjectId(id)));
        if (documents == null || documents.size() <= 0) {
            return null;
        }
        return documents.get(0);
    }

    public static List<Document> findById(String collectionName, List<String> ids) {
        Assertions.notNull((String)"ids", ids);
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
        for (String id : ids) {
            if (!ObjectId.isValid((String)id)) continue;
            objectIds.add(new ObjectId(id));
        }
        return DocumentOperation.find(collectionName, Filters.in((String)"_id", objectIds));
    }

    public static Document findById(String collectionName, String id, Bson projection) {
        if (!ObjectId.isValid((String)id)) {
            return null;
        }
        List<Document> documents = DocumentOperation.find(collectionName, Filters.eq((Object)new ObjectId(id)), projection);
        if (documents == null || documents.size() <= 0) {
            return null;
        }
        return documents.get(0);
    }

    public static Document findOne(String collectionName, Bson filter) {
        List<Document> documents = DocumentOperation.find(collectionName, filter);
        if (documents == null || documents.size() <= 0) {
            return null;
        }
        return documents.get(0);
    }

    public static Document findOne(String collectionName, Bson filter, Bson projection) {
        List<Document> documents = DocumentOperation.find(collectionName, filter, projection);
        if (documents == null || documents.size() <= 0) {
            return null;
        }
        return documents.get(0);
    }

    public static List<Document> findAll(String collectionName) {
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        return DocumentOperation.toList((MongoCursor<Document>)collection.find().iterator());
    }

    public static List<Document> findAll(String collectionName, Bson projection) {
        Assertions.notNull((String)"projection", (Object)projection);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        return DocumentOperation.toList((MongoCursor<Document>)collection.find().projection(projection).iterator());
    }

    public static PageResult find(String collectionName, Bson filter, PageAbstract page) {
        Assertions.notNull((String)"filter", (Object)filter);
        Assertions.notNull((String)"page", (Object)page);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        long total = DocumentOperation.countDocuments(collectionName, filter);
        List<Document> documents = new ArrayList<Document>();
        if (page.getSize() != 0) {
            FindIterable filterCondition = collection.find(filter).skip(page.skip()).limit(page.getSize());
            if (page.getOrders() != null) {
                filterCondition.sort(page.getBsonOrder());
            }
            documents = DocumentOperation.toList((MongoCursor<Document>)filterCondition.iterator());
        }
        return new PageResult(documents, total);
    }

    public static PageResult find(String collectionName, Bson filter, PageAbstract page, Bson projection) {
        Assertions.notNull((String)"filter", (Object)filter);
        Assertions.notNull((String)"page", (Object)page);
        Assertions.notNull((String)"projection", (Object)projection);
        long total = DocumentOperation.countDocuments(collectionName, filter);
        List<Document> documents = new ArrayList<Document>();
        if (page.getSize() != 0) {
            MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
            FindIterable filterCondition = collection.find(filter).projection(projection).skip(page.skip()).limit(page.getSize());
            if (page.getOrders() != null) {
                filterCondition.sort(page.getBsonOrder());
            }
            documents = DocumentOperation.toList((MongoCursor<Document>)filterCondition.iterator());
        }
        return new PageResult(documents, total);
    }

    public static List<Document> aggregate(String collectionName, List<? extends Bson> pipeline) {
        Assertions.notNull((String)"pipeline", pipeline);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        MongoCursor aggregate = collection.aggregate(pipeline).iterator();
        return DocumentOperation.toList((MongoCursor<Document>)aggregate);
    }

    public static List<Document> aggregateCount(String collectionName, Bson filter, String fieldName, boolean unwind) {
        Assertions.notNull((String)"filter", (Object)filter);
        Assertions.notNull((String)"fieldName", (Object)fieldName);
        ArrayList<Bson> pipeline = new ArrayList<Bson>();
        if (filter != null) {
            pipeline.add(Aggregates.match((Bson)filter));
        }
        if (unwind) {
            pipeline.add(Aggregates.unwind((String)MongoOperator.getFieldKey(fieldName)));
        }
        pipeline.add(Aggregates.group((Object)MongoOperator.getFieldKey(fieldName), (BsonField[])new BsonField[]{Accumulators.sum((String)"count", (Object)1)}));
        return DocumentOperation.aggregate(collectionName, pipeline);
    }

    public static List<Document> aggregateCount(String collectionName, String fieldName, boolean unwind) {
        Assertions.notNull((String)"fieldName", (Object)fieldName);
        ArrayList<Bson> pipeline = new ArrayList<Bson>();
        if (unwind) {
            pipeline.add(Aggregates.unwind((String)MongoOperator.getFieldKey(fieldName)));
        }
        pipeline.add(Aggregates.group((Object)MongoOperator.getFieldKey(fieldName), (BsonField[])new BsonField[]{Accumulators.sum((String)"count", (Object)1)}));
        return DocumentOperation.aggregate(collectionName, pipeline);
    }

    public static long countDocuments(String collectionName, Bson filter) {
        Assertions.notNull((String)"filter", (Object)filter);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        return collection.countDocuments(filter);
    }

    public static long countDocuments(String collectionName) {
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        return collection.countDocuments();
    }

    public static void deleteById(String collectionName, String id) {
        if (!ObjectId.isValid((String)id)) {
            return;
        }
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        collection.deleteOne(Filters.eq((Object)new ObjectId(id)));
    }

    public static void deleteById(String collectionName, List<String> ids) {
        Assertions.notNull((String)"ids", ids);
        ArrayList<ObjectId> objectIds = new ArrayList<ObjectId>();
        for (String id : ids) {
            if (!ObjectId.isValid((String)id)) continue;
            objectIds.add(new ObjectId(id));
        }
        DocumentOperation.deleteMany(collectionName, Filters.in((String)"_id", objectIds));
    }

    public static void deleteMany(String collectionName, Bson filter) {
        Assertions.notNull((String)"filter", (Object)filter);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        collection.deleteMany(filter);
    }

    public static void replaceOne(String collectionName, String id, Document newDocument) {
        Assertions.notNull((String)"id", (Object)id);
        Assertions.notNull((String)"newDocument", (Object)newDocument);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        newDocument.remove((Object)"_id");
        collection.replaceOne(Filters.eq((Object)new ObjectId(id)), (Object)newDocument);
    }

    public static void replaceOne(String collectionName, Bson filter, Document newDocument) {
        Assertions.notNull((String)"filter", (Object)filter);
        Assertions.notNull((String)"newDocument", (Object)newDocument);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        newDocument.remove((Object)"_id");
        collection.replaceOne(filter, (Object)newDocument);
    }

    public static void updateOne(String collectionName, Bson filter, Bson update) {
        Assertions.notNull((String)"filter", (Object)filter);
        Assertions.notNull((String)"update", (Object)update);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        collection.updateOne(filter, update);
    }

    public static void updateOne(String collectionName, Bson filter, Bson update, UpdateOptions updateOptions) {
        Assertions.notNull((String)"filter", (Object)filter);
        Assertions.notNull((String)"update", (Object)update);
        Assertions.notNull((String)"updateOptions", (Object)updateOptions);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        collection.updateOne(filter, update, updateOptions);
    }

    public static void updateMany(String collectionName, Bson filter, Bson update) {
        Assertions.notNull((String)"filter", (Object)filter);
        Assertions.notNull((String)"update", (Object)update);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        collection.updateMany(filter, update);
    }

    public static void updateMany(String collectionName, Bson filter, Bson update, UpdateOptions updateOptions) {
        Assertions.notNull((String)"filter", (Object)filter);
        Assertions.notNull((String)"update", (Object)update);
        Assertions.notNull((String)"updateOptions", (Object)updateOptions);
        MongoCollection<Document> collection = CollectionOperation.getCollection(collectionName);
        collection.updateMany(filter, update, updateOptions);
    }

    private static List<Document> toList(MongoCursor<Document> mongoCursor) {
        ArrayList<Document> documents = new ArrayList<Document>();
        if (mongoCursor != null) {
            while (mongoCursor.hasNext()) {
                Document next = (Document)mongoCursor.next();
                documents.add(next);
            }
        }
        return documents;
    }
}

