package com.idenfy.idenfySdk.liveness.ui

import android.os.Parcel
import android.os.Parcelable

class IdenfyLivenessSettings(): Parcelable {
    var showPreEnrollmentScreen = false
    var showUserLockedScreen = false
    var showRetryScreen = false

    constructor(parcel: Parcel) : this() {
        showPreEnrollmentScreen = parcel.readByte() != 0.toByte()
        showUserLockedScreen = parcel.readByte() != 0.toByte()
        showRetryScreen = parcel.readByte() != 0.toByte()
    }

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeByte(if (showPreEnrollmentScreen) 1 else 0)
        parcel.writeByte(if (showUserLockedScreen) 1 else 0)
        parcel.writeByte(if (showRetryScreen) 1 else 0)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<IdenfyLivenessSettings> {
        override fun createFromParcel(parcel: Parcel): IdenfyLivenessSettings {
            return IdenfyLivenessSettings(parcel)
        }

        override fun newArray(size: Int): Array<IdenfyLivenessSettings?> {
            return arrayOfNulls(size)
        }
    }

}