package com.idenfy.idenfySdk.instructions.ui.view

import android.arch.lifecycle.ViewModelProviders
import android.graphics.SurfaceTexture
import android.media.MediaPlayer
import android.net.Uri
import android.os.Bundle
import android.support.v4.app.FragmentActivity
import android.support.v7.app.AppCompatDelegate
import android.view.LayoutInflater
import android.view.Surface
import android.view.TextureView
import android.view.View
import android.view.ViewGroup

import com.idenfy.idenfySdk.instructions.ui.viewmodel.InstructionViewModel
import com.idenfy.idenfySdk.core.ui.viewmodel.CameraViewModel
import com.idenfy.idenfysdk.core.extensions.livedataextensions.ViewLifecycleFragment
import com.idenfy.idenfysdk.core.models.InstructionModel
import com.idenfySdk.R

import java.io.IOException
import java.util.Objects

class InstructionFragment : ViewLifecycleFragment(), TextureView.SurfaceTextureListener {

    private var position: Int = 0
    private var instructionList: List<InstructionModel>? = null
    private var instructionViewModel: InstructionViewModel? = null
    private var cameraViewModel: CameraViewModel? = null

    private var mMediaPlayer: MediaPlayer? = null
    private var mPreview: TextureView? = null

    fun newInstance(position: Int): InstructionFragment {
        val args = Bundle()
        val fragment = InstructionFragment()
        fragment.arguments = args
        args.putInt("position", position)
        return fragment
    }

    override fun onCreate(savedInstanceState: Bundle?) {

        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true)
        super.onCreate(savedInstanceState)
        instructionViewModel = ViewModelProviders.of(Objects.requireNonNull<FragmentActivity>(activity)).get(InstructionViewModel::class.java)
        cameraViewModel = ViewModelProviders.of(activity!!).get(CameraViewModel::class.java)

    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        val rootView = inflater.inflate(R.layout.idenfy_view_instructions_video_view_container, container, false)
        val args = arguments!!
        position = args.getInt("position")
        mPreview = rootView.findViewById<View>(R.id.idenfy_texture_view_instructions_video_player) as TextureView
        mPreview!!.surfaceTextureListener = this

        return rootView
    }

    override fun onSurfaceTextureAvailable(surface: SurfaceTexture, width: Int, height: Int) {

        if (context == null)
            return

        try {
            mMediaPlayer = MediaPlayer()
            if (instructionViewModel!!.instructionModelList == null || instructionViewModel!!.instructionModelList!!.value == null)
                return
            instructionList = instructionViewModel!!.instructionModelList!!.value
            val mediaPath = Uri.parse("android.resource://" + context!!.packageName + "/" + instructionList!![position].video)
            mMediaPlayer!!.setDataSource(context!!, mediaPath)
            mMediaPlayer!!.setSurface(Surface(surface))
            mMediaPlayer!!.isLooping = true
            mMediaPlayer!!.prepareAsync()
            mMediaPlayer!!.setOnPreparedListener { mMediaPlayer!!.start() }
        } catch (e: IllegalArgumentException) {
            e.printStackTrace()
        } catch (e: SecurityException) {
            e.printStackTrace()
        } catch (e: IllegalStateException) {
            e.printStackTrace()
        } catch (e: IOException) {
            e.printStackTrace()
        }

    }

    override fun onSurfaceTextureSizeChanged(surface: SurfaceTexture, width: Int, height: Int) {

    }

    override fun onSurfaceTextureDestroyed(surface: SurfaceTexture): Boolean {
        return false
    }

    override fun onSurfaceTextureUpdated(surface: SurfaceTexture) {

    }

    override fun onDestroyView() {
        super.onDestroyView()
        if (cameraViewModel!!.getSaveFragment().value == null || !cameraViewModel!!.getSaveFragment().value!!) {
            if (mMediaPlayer != null) {
                mMediaPlayer!!.release()
                mMediaPlayer = null
            }
        }
    }
}
