package com.idenfy.idenfySdk.instructions.ui.utils

import android.app.Activity
import android.content.Context
import android.support.constraint.ConstraintLayout
import android.support.v4.view.ViewPager
import android.util.DisplayMetrics
import android.util.TypedValue
import android.widget.TextView

import java.util.Objects
import kotlin.math.roundToInt

class InstructionDynamicSizeManager {

    /**
     * Commented code is an option to set the top sheet peek high dynamically according to screen height
     */
    fun setUpUIDynamicSizes(context: Context, instructionText: TextView, instructionTitle: TextView, viewPager: ViewPager) {
        val displayMetrics = DisplayMetrics()
        (Objects.requireNonNull(context) as Activity).windowManager.defaultDisplay.getMetrics(displayMetrics)
        val screenHeight = displayMetrics.heightPixels
        val screenWidth = displayMetrics.widthPixels.toDouble()
        var viewPagerSizeRatio = 0.8

        /* ConstraintLayout.LayoutParams topSheetParams = new ConstraintLayout.LayoutParams(topSheet.getLayoutParams());
        topSheetParams.bottomMargin = screenHeight / 5;
        topSheetLayout.setLayoutParams(topSheetParams);*/

        if (screenHeight <= 1080) {
            instructionText.setTextSize(TypedValue.COMPLEX_UNIT_SP, 12f)
            instructionTitle.setTextSize(TypedValue.COMPLEX_UNIT_SP, 14f)
            viewPagerSizeRatio = 0.75
        }

        val viewPagerParams = viewPager.layoutParams as ConstraintLayout.LayoutParams
        viewPagerParams.height = (screenWidth * viewPagerSizeRatio).roundToInt()
        viewPagerParams.width = (screenWidth * viewPagerSizeRatio).roundToInt()
        viewPager.layoutParams = viewPagerParams

        //topSheetBehavior.setPeekHeight(screenHeight / 5);

        instructionTitle.maxWidth = (screenWidth * viewPagerSizeRatio).roundToInt()
        instructionText.maxWidth = (screenWidth * viewPagerSizeRatio).roundToInt()
    }
}
