package com.idenfy.idenfySdk.liveness.presentation

import com.idenfy.idenfyliveness.LivenessCheck

sealed class LivenessSessionResponseState {
    abstract val isSuccessful: Boolean
    abstract val livenessCheck: LivenessCheck?
    abstract val shouldRetryPresentation: Boolean
}

data class LivenessSessionSuccessful(override val isSuccessful: Boolean, override val livenessCheck: LivenessCheck,
                                     override val shouldRetryPresentation: Boolean) : LivenessSessionResponseState() {
    override fun toString(): String {
        return "LivenessSessionSuccessful(isSuccessful=$isSuccessful, shouldRetryPresentation=$shouldRetryPresentation)"
    }
}

data class LivenessSessionNotSuccessfulNeedsAutoRetry(override val isSuccessful: Boolean, override val livenessCheck: LivenessCheck?,
                                                      override val shouldRetryPresentation: Boolean) : LivenessSessionResponseState()

data class LivenessSessionNotSuccessfulNeedsUserRetry(override val isSuccessful: Boolean, override val livenessCheck: LivenessCheck?,
                                                      override val shouldRetryPresentation: Boolean) : LivenessSessionResponseState()

data class LivenessSessionNotSuccessfulWithoutRetries(override val isSuccessful: Boolean, override val livenessCheck: LivenessCheck?,
                                                      override val shouldRetryPresentation: Boolean) : LivenessSessionResponseState()

data class LivenessSessionNotInitialized(override val isSuccessful: Boolean, override val livenessCheck: LivenessCheck?,
                                         override val shouldRetryPresentation: Boolean) : LivenessSessionResponseState()

