package com.idenfy.idenfySdk.landingpage.ui

import android.content.Context
import android.net.Uri
import android.os.Bundle
import android.support.v4.app.Fragment
import android.support.v4.content.ContextCompat
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView

import com.idenfySdk.R


class SplashScreenFragment : Fragment() {

    private var mListener: OnFragmentInteractionListener? = null
    private var idenfySplashScreenIcon: ImageView?=null

    override fun onPause() {
        super.onPause()

    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        val legacy_splash_screen = context!!.resources.getIdentifier("idenfy_splash_screen", "layout",
                context!!.packageName)
        return if (legacy_splash_screen == 0) {
            inflater.inflate(R.layout.idenfy_splash_screen_fragment_layout, container, false)
        } else {
            inflater.inflate(legacy_splash_screen, container, false)
        }
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        idenfySplashScreenIcon?.adjustViewBounds = true
        try {
            val legacy_splash_screenIcon = context!!.resources.getIdentifier("splash_screen_logo", "id",
                    context!!.packageName)
            idenfySplashScreenIcon = if (legacy_splash_screenIcon == 0) {
                view.findViewById(R.id.idenfy_iv_splash_screen_icon)
            } else {
                view.findViewById(legacy_splash_screenIcon)
            }
        }
        catch (e: Throwable)
        {

        }
        val srcSplashScreen = context!!.getResources().getIdentifier("idenfy_logo", "drawable", context!!.getPackageName())
        if(srcSplashScreen!=0)
        idenfySplashScreenIcon?.setImageDrawable(
                ContextCompat.getDrawable(activity!!, srcSplashScreen))

    }

    override fun onAttach(context: Context?) {
        super.onAttach(context)
        if (context is OnFragmentInteractionListener) {
            mListener = context
        } else {
            throw RuntimeException(context!!.toString() + " must implement OnDocumentScanningFeatureListener")
        }
    }

    override fun onDetach() {
        super.onDetach()
        mListener = null
    }

    interface OnFragmentInteractionListener {
        fun onFragmentInteraction(uri: Uri)
    }
}


