package com.idenfy.idenfySdk.identificationresults.ui.viewmodel

import android.app.Application
import android.arch.lifecycle.AndroidViewModel
import android.arch.lifecycle.MediatorLiveData
import com.idenfy.idenfySdk.core.datasource.repository.RepositoryKotlin
import com.idenfy.idenfySdk.di.DIProvider
import com.idenfy.idenfySdk.identificationresults.presentation.state.IdentificationResultsUIViewModelState
import com.idenfy.idenfySdk.identificationresults.presentation.uiviewmodel.IdentificationResultsUIViewModel

class ResultViewModel(application: Application) : AndroidViewModel(application) {

    lateinit var repository: RepositoryKotlin
    lateinit var diProvider: DIProvider
    var hasRetakeStarted: Boolean = false
    val identificationResultMediatorLiveData = MediatorLiveData<IdentificationResultsUIViewModelState<IdentificationResultsUIViewModel>>()

    fun getRepository(){
        diProvider = DIProvider(getApplication())
        repository = diProvider.getRepositoryKotlin()
        observeResults()
    }

    fun observeResults(){
        identificationResultMediatorLiveData.removeSource(repository.identificationResultsUIViewModelLiveData)
        identificationResultMediatorLiveData.addSource(repository.identificationResultsUIViewModelLiveData)
        {
            identificationResultMediatorLiveData.postValue(it)
        }
    }
}