package com.idenfy.idenfySdk.helpers;

import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponse;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponseInternal;

public class ResultsFormattingHelper {

    public AuthenticationResultResponse getFormattedAuthenticationResponse(AuthenticationResultResponseInternal authenticationResultResponseInternal) {

        String identificationStatus = authenticationResultResponseInternal.getIdentificationStatus();

        IdenfyIdentificationStatus idenfyIdentificationStatus = IdenfyIdentificationStatus.DENIED;

        if (identificationStatus.equals("APPROVED")) {
            idenfyIdentificationStatus = IdenfyIdentificationStatus.APPROVED;
        } else if (identificationStatus.equals("DENIED")) {
            idenfyIdentificationStatus = IdenfyIdentificationStatus.DENIED;
        } else if (identificationStatus.equals("SUSPECTED")) {
            idenfyIdentificationStatus = IdenfyIdentificationStatus.SUSPECTED;
        } else if (identificationStatus.equals("REVIEWING")) {
            idenfyIdentificationStatus = IdenfyIdentificationStatus.REVIEWING;
        }
        AuthenticationResultResponse authenticationResultResponse = new AuthenticationResultResponse(authenticationResultResponseInternal.getIdentificationStatus(), authenticationResultResponseInternal.getErrorMessage(), idenfyIdentificationStatus);
        return authenticationResultResponse;


    }

}
