package com.idenfy.idenfySdk.CoreSdkInitialization

import android.os.Parcel
import android.os.Parcelable


class IdenfyIdentificationResultsSettings() : Parcelable {

    //Results Flow
    var isSuccessResultsViewVisible = true
    var isRetryErrorResultsViewVisible = true
    var isErrorResultsViewVisible = true

    var isRetryingIdentificationAvailable = true

    constructor(parcel: Parcel) : this() {
        isSuccessResultsViewVisible = parcel.readByte() != 0.toByte()
        isRetryErrorResultsViewVisible = parcel.readByte() != 0.toByte()
        isErrorResultsViewVisible = parcel.readByte() != 0.toByte()
        isRetryingIdentificationAvailable = parcel.readByte() != 0.toByte()
    }

    override fun toString(): String {
        return "IdenfyIdentificationResultsSettings{" +
                "isSuccessResultsViewVisible=" + isSuccessResultsViewVisible +
                ", isRetryErrorResultsViewVisible=" + isRetryErrorResultsViewVisible +
                ", isErrorResultsViewVisible=" + isErrorResultsViewVisible +
                ", isRetryingIdentificationAvailable=" + isRetryingIdentificationAvailable +
                '}'.toString()
    }

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeByte(if (isSuccessResultsViewVisible) 1 else 0)
        parcel.writeByte(if (isRetryErrorResultsViewVisible) 1 else 0)
        parcel.writeByte(if (isErrorResultsViewVisible) 1 else 0)
        parcel.writeByte(if (isRetryingIdentificationAvailable) 1 else 0)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<IdenfyIdentificationResultsSettings> {
        override fun createFromParcel(parcel: Parcel): IdenfyIdentificationResultsSettings {
            return IdenfyIdentificationResultsSettings(parcel)
        }

        override fun newArray(size: Int): Array<IdenfyIdentificationResultsSettings?> {
            return arrayOfNulls(size)
        }
    }
}
