package com.idenfy.idenfySdk.facecamerasession.ui.view


import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.content.Context
import android.graphics.Bitmap
import android.graphics.PorterDuff
import android.graphics.Typeface
import android.os.Build
import android.os.Bundle
import android.os.Handler
import android.support.v4.content.ContextCompat
import android.support.v4.graphics.drawable.DrawableCompat
import android.support.v7.app.AppCompatDelegate
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController
import com.idenfy.idenfySdk.core.ui.view.CameraPreviewActivity
import com.idenfy.idenfySdk.core.ui.viewmodel.CameraViewModel
import com.idenfy.idenfySdk.liveness.LivenessesViewModel
import com.idenfy.idenfysdk.core.extensions.livedataextensions.ViewLifecycleFragment
import com.idenfy.idenfysdk.core.extensions.livedataextensions.observeOnce
import com.idenfy.idenfysdk.core.logging.LoggingHelper
import com.idenfySdk.R

class FacePhotoResultFragment : ViewLifecycleFragment() {
    lateinit var cameraViewModel: CameraViewModel
    private var rootView: View? = null
    private var imageViewFullScreenResult: ImageView? = null
    private var retakeButton: Button? = null
    private var nextButton: Button? = null
    lateinit var backImage: ImageView
    lateinit var backTextView: TextView

    lateinit var imageViewResultTitle: TextView
    private var mFragmentClosedListener: OnCameraClosedFragment? = null
    //Handlers
    private val takePictureHandler = Handler()
    private val recreateButtonHandler = Handler()
    private val nextButtonHandler = Handler()
    private val fotoapparatSetupHandler = Handler()

    lateinit var livenessesViewModel: LivenessesViewModel

    private var currentImage: Bitmap? = null
    private var isImageUploaded: Boolean = false

    interface OnCameraClosedFragment {
        fun onCameraNewFragmentClosed(closed: Boolean)
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true)
        super.onCreate(savedInstanceState)
        LoggingHelper.LogLifecycleInfo("onCreateFacePhotoResult")
        livenessesViewModel = ViewModelProviders.of(activity!!).get(LivenessesViewModel::class.java)
        cameraViewModel = ViewModelProviders.of(activity!!).get(CameraViewModel::class.java)

    }

    private fun initializeUI(rootView: View) {
        imageViewResultTitle = rootView.findViewById(R.id.document_photo_result_text_view)
        backImage = rootView.findViewById(R.id.backImage)
        backTextView = rootView.findViewById(R.id.back_text_view)
        imageViewFullScreenResult = rootView.findViewById(R.id.idenfy_iv_face_photo_result)
        retakeButton = rootView.findViewById(R.id.recreateButton)
        nextButton = rootView.findViewById(R.id.nextButton)
    }


    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        rootView = inflater.inflate(R.layout.idenfy_face_photo_result_fragment, container, false)
        initializeUI(rootView!!)
        return rootView
    }


    private fun observeUI() {

        cameraViewModel.getImageViewResultFullSize().observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null) {
                if (imageViewFullScreenResult != null) {
                    imageViewFullScreenResult!!.visibility = if (response) View.VISIBLE else View.INVISIBLE
                }
            }
        })

        cameraViewModel.recreateButtonVisibility.observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null) {
                retakeButton!!.visibility = if (response) View.VISIBLE else View.INVISIBLE
            }
        })

        cameraViewModel.getNextButtonVisibility().observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null)
                nextButton!!.visibility = if (response) View.VISIBLE else View.INVISIBLE
        })
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        setupCustomUI()

    }

    override fun onSaveInstanceState(savedInstanceState: Bundle) {
        super.onSaveInstanceState(savedInstanceState)

    }

    override fun onAttach(context: Context?) {
        super.onAttach(context)

        if (context is OnCameraClosedFragment) {
            mFragmentClosedListener = context
        }
        super.onAttach(context)

    }

    override fun onDetach() {
        super.onDetach()
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null
    }


    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        cameraViewModel.setTakePictureButtonAvailability(true)
        cameraViewModel.setUploadPictureButtonAvailability(true)
        if (cameraViewModel.hasPartnerEnabledZoom) {
            retakeButton!!.visibility = View.INVISIBLE
            nextButton!!.visibility = View.INVISIBLE
        } else {
            retakeButton!!.isEnabled = true
            nextButton!!.isEnabled = true
            cameraViewModel.setNextButtonVisibility(true)
            cameraViewModel.setRecreateButtonAvailability(true)
            cameraViewModel.setNextButtonAvailability(true)
            cameraViewModel.setRecreateButtonVisibility(true)

        }
        if (IdenfyController.getInstance().settings != null) {
            val idenfySettings = IdenfyController.getInstance().settings
            val typeFaceRegular = idenfySettings.customRegularFont
            val typeFaceBold = idenfySettings.customBoldTypeFace
            setupCustomTypeFace(typeFaceRegular, typeFaceBold)
        }
        backTextView.setOnClickListener { onBackPressed() }
        backImage.setOnClickListener { onBackPressed() }
        observeUI()
        observeDocumentType()
        observeButtonsAvailability()
        cameraViewModel.cameraSessionImageResultSizeLiveData.observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null) {
                currentImage = response.documentImage
                isImageUploaded = response.isImageUploaded
                show(response.documentImage,
                        response.rectangleRight!!, response.rectangleLeft!!, response.rectangleBottom!!, response.rectangleTop!!)
            }
        })
    }

    private fun observeDocumentType() {
        cameraViewModel.currentStepUIViewModelLiveData.observeOnce(viewLifecycleOwner!!, Observer { response ->
            if (response != null) {
                imageViewResultTitle.text = resources.getString(response.resultsInformationTitle)
            }
        })
    }


    private fun observeButtonsAvailability() {}


    private fun retakePhotoPressed(bitmap: Bitmap?) {
        cameraViewModel.setTakePictureButtonAvailability(true)
        if (cameraViewModel.isLivenessEnabled())
            cameraViewModel.setAddFaceCameraFragment(true)
        else
            cameraViewModel.setaddFacePhotoResultFragment(false)
        cameraViewModel.setUploadPictureButtonAvailability(true)
        if (bitmap != null && !bitmap.isRecycled) {
            bitmap.recycle()
        }
        recreateImage()

    }

    fun show(bitmap: Bitmap?, rectangleRight: Int, rectangleLeft: Int, rectangleBottom: Int, rectangleTop: Int) {
        cameraViewModel.setShowImageLayoutVisibility(true)
        if (imageViewFullScreenResult != null) {
            cameraViewModel.setImageViewResultFullSize(true)
            imageViewFullScreenResult!!.setImageBitmap(bitmap)
        }
        if (cameraViewModel.hasPartnerEnabledZoom) {
            retakeButton!!.isEnabled = false
            retakeButton!!.isEnabled = false
        }

        retakeButton!!.setOnClickListener {
            cameraViewModel.setRetakeButtonPressed(true)
            retakePhotoPressed(bitmap)
            cameraViewModel.setFaceRetakeButtonPressed(true)
        }

        nextButton!!.setOnClickListener {

            cameraViewModel.setNextButtonPressed(true)
            cameraViewModel.setNextButtonAvailability(false)
            cameraViewModel.setRecreateButtonAvailability(false)
            cameraViewModel.setTakePictureButtonAvailability(true)
            cameraViewModel.setUploadPictureButtonAvailability(true)
            nextStep(currentImage, isImageUploaded)
        }

    }


    override fun onDestroy() {
        super.onDestroy()
        LoggingHelper.LogLifecycleInfo("onDestroyFaceCameraSessionResults")

    }

    private fun nextStep(bitmap: Bitmap?, isImageUploaded: Boolean) {
        cameraViewModel.handleFlow(bitmap!!,  isImageUploaded)
        cameraViewModel.navigate()
    }


    private fun recreateImage() {
        cameraViewModel.changeDocument()
    }


    override fun onPause() {
        super.onPause()
        LoggingHelper.LogLifecycleInfo("onPauseFacePhotoResult")
    }

    override fun onStop() {
        super.onStop()
        LoggingHelper.LogLifecycleInfo("onStopFacePhotoResult")
    }

    override fun onStart() {
        super.onStart()
        LoggingHelper.LogLifecycleInfo("onStartFacePhotoResult")
    }

    override fun onResume() {
        super.onResume()
        LoggingHelper.LogLifecycleInfo("onResumeFacePhotoResult")

    }

    override fun onDestroyView() {
        super.onDestroyView()
        LoggingHelper.onDestroyView(FacePhotoResultFragment::class.java.simpleName)
        imageViewFullScreenResult = null
        nextButton = null
        retakeButton = null
        (activity as CameraPreviewActivity).setSupportActionBar(null)
        takePictureHandler.removeCallbacksAndMessages(null)
        recreateButtonHandler.removeCallbacksAndMessages(null)
        nextButtonHandler.removeCallbacksAndMessages(null)
        fotoapparatSetupHandler.removeCallbacksAndMessages(null)
    }

    fun setupCustomTypeFace(typeface: Typeface?, typeFaceBold: Typeface?) {
        if (typeFaceBold == null) {
            return
        }
        backTextView.typeface = typeFaceBold
        nextButton!!.typeface = typeFaceBold
        retakeButton!!.typeface = typeFaceBold
        imageViewResultTitle!!.typeface = typeFaceBold
    }

    private fun setupCustomUI() {
        if (activity == null) {
            return
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
            DrawableCompat.setTint(backImage.drawable, ContextCompat.getColor(activity!!,
                    R.color.idenfyFaceResultsCameraBackArrowColor))

        } else {
            backImage.drawable.mutate().setColorFilter(ContextCompat.getColor(activity!!,
                    R.color.idenfyFaceResultsCameraBackArrowColor), PorterDuff.Mode.SRC_IN)
        }
        backTextView.setTextColor(resources.getColor(R.color.idenfyFaceResultsBackTextViewColor))
        imageViewResultTitle.setTextColor(resources.getColor(R.color.idenfyFaceResultsInformationTextViewColor))
    }


    fun onBackPressed() {
        (activity as CameraPreviewActivity).onBackPressed()

    }


}
