package com.idenfy.idenfySdk.facecamerasession.ui.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.util.Log;

import com.idenfy.idenfySdk.sharedcamerasession.ui.utils.BitmapPhotoCropper;

import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicBoolean;

import io.fotoapparat.preview.Frame;
import io.fotoapparat.preview.FrameProcessor;

public class FaceCameraFrameProcessor implements FrameProcessor {

    public FaceCameraFrameProcessor(FragmentActivity fragmentActivity) {
        weakContext = new WeakReference<>(fragmentActivity);
    }

    public interface OnPictureListener {
        void OnPictureTaken(Bitmap bitmap, int rotation, String encoded);
    }

    public interface onSessionListener {
        void OnPictureTaken(byte[] bitmap, int rotation, String encoded);
    }

    private OnPictureListener listener = null;
    private onSessionListener sessionListener = null;
    private AtomicBoolean takePicture = new AtomicBoolean(false);
    private AtomicBoolean takeBackgroundPicture = new AtomicBoolean(false);
    private AtomicBoolean takingPicture = new AtomicBoolean(false);
    private static WeakReference<FragmentActivity> weakContext;

    @Override
    public void process(final @NonNull Frame frame) {
        if (weakContext.get() != null) {
            if (takeBackgroundPicture.get()) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                Bitmap bitmap = BitmapPhotoCropper.cropPhoto(frame.getImage(), frame.getSize().width, frame.getSize().height, weakContext.get(), 10);
                byte[] compressed = BitmapPhotoCropper.compressBitmapFace(frame.getRotation(), bitmap, 15, 480f, 640f);
                if (sessionListener != null) {
                    sessionListener.OnPictureTaken(compressed, frame.getRotation(), "");
                    sessionListener = null;
                }
            }
            if (takePicture.get()) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                Bitmap bitmap = BitmapPhotoCropper.cropPhoto(frame.getImage(), frame.getSize().width, frame.getSize().height, weakContext.get(), 90);

                Bitmap scaled = scaleBitmapAndKeepRation(bitmap,960,640);
                if (listener != null) {
                    takeBackgroundPicture.set(false);
                    listener.OnPictureTaken(scaled, frame.getRotation(), "");
                    listener = null;
                }
            }
        }
        takePicture.set(false);
        takingPicture.set(false);
    }

    public static Bitmap scaleBitmapAndKeepRation(Bitmap targetBmp,int reqHeightInPixels,int reqWidthInPixels)
    {
        if(!(targetBmp.getWidth()>reqWidthInPixels && targetBmp.getHeight()>reqHeightInPixels))
        {
            return targetBmp;
        }
        Matrix matrix = new Matrix();
        matrix .setRectToRect(new RectF(0, 0, targetBmp.getWidth(), targetBmp.getHeight()), new RectF(0, 0, reqWidthInPixels, reqHeightInPixels), Matrix.ScaleToFit.CENTER);
        Bitmap scaledBitmap = Bitmap.createBitmap(targetBmp, 0, 0, targetBmp.getWidth(), targetBmp.getHeight(), matrix, true);
        return scaledBitmap;
    }
    public void takePicture(OnPictureListener listener) {
        if (!takingPicture.get()) {
            this.listener = listener;
            takePicture.set(true);
        }
    }

    public void takeBackgroundPicture(onSessionListener listener) {
        takeBackgroundPicture.set(true);
        if (!takingPicture.get()) {
            this.sessionListener = listener;
        }
    }

    public void takePicture() {
        takePicture.set(true);
    }

    public void takeBackgroundPicture() {
        takeBackgroundPicture.set(true);
    }

    public void setListeners(OnPictureListener listener, onSessionListener onPictureListener) {
        this.listener = listener;
        this.sessionListener = onPictureListener;

    }


}