package com.idenfy.idenfySdk.initialagreement.ui.viewmodel

import android.arch.lifecycle.MediatorLiveData
import android.arch.lifecycle.ViewModel
import com.idenfy.idenfySdk.initialagreement.domain.InitialAgreementDataModel
import com.idenfy.idenfySdk.initialagreement.repo.InitialAgreementRepositoryImp
import com.idenfySdk.R

class InitialAgreementViewModel : ViewModel() {


    var initialAgreementDataModelLiveData = MediatorLiveData<InitialAgreementDataModel>()

    fun updateInitialAgreementDataModelLiveData(value: InitialAgreementDataModel?) {
        if (value == null)
            return

        validateInputForActivatingSumbitButton(value)
        initialAgreementDataModelLiveData.value = (value)
    }

    fun validateInputForActivatingSumbitButton(viewData: InitialAgreementDataModel) {

        if (viewData.isCheckBox1Enabled && viewData.isCheckBox2Enabled && (viewData.selectedCountryFromList == null && viewData.selectedCountryFromPartnerInfo == null)) {
            viewData.errorMessageId = R.string.idenfy_error_message_select_your_document_issuing_country_message
            viewData.isStartSessionButtonActive = false
            return

        } else if (!viewData.isCheckBox1Enabled || !viewData.isCheckBox2Enabled && viewData.selectedCountryFromList != null) {
            viewData.errorMessageId = R.string.idenfy_error_message_agree_with_terms_of_service
            viewData.isStartSessionButtonActive = false
            return
        } else if (viewData.isCheckBox1Enabled && viewData.isCheckBox2Enabled && (viewData.selectedCountryFromPartnerInfo != null ||
                        viewData.selectedCountryFromList != null)) {
            viewData.isStartSessionButtonActive = true

            return
        }

    }

    init {
        initialAgreementDataModelLiveData.addSource(InitialAgreementRepositoryImp.initialAgreementDataModel) {
            updateInitialAgreementDataModelLiveData(it)
        }
    }

    override fun onCleared() {
        super.onCleared()
    }
}