package com.idenfy.idenfySdk.uicomponents;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.v7.widget.AppCompatEditText;
import android.util.AttributeSet;

import com.idenfySdk.R;

public class IDenfyEditText extends AppCompatEditText {
    public IDenfyEditText(Context context) {
        super(context);
    }

    public IDenfyEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        applyCustomFont(context, attrs, null);
    }

    public IDenfyEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        applyCustomFont(context, attrs, null);
    }

    //Method is called to set the font programmatically
    public void setCustomFont(Context context, String fontName) {
        applyCustomFont(context, null, fontName);
    }

    private void applyCustomFont(Context context, AttributeSet attrs, String fontName) {
        try {
            Typeface face;
            String customFont = getCustomFont(context, attrs);
            if (fontName != null) {
                face = Typeface.createFromAsset(context.getAssets(), "fonts/" + fontName);
                this.setTypeface(face);
            } else if (customFont != null) {
                face = Typeface.createFromAsset(context.getAssets(), "fonts/" + customFont);
                this.setTypeface(face);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getCustomFont(Context context, AttributeSet attrs) {
        TypedArray ta = null;

        try {
            ta = context.obtainStyledAttributes(attrs, R.styleable.IDenfyEditText, 0, 0);
            return ta.getString(R.styleable.IDenfyEditText_customfont);
        } catch (Exception ex) {
            ex.printStackTrace();
        } finally {
            if (ta != null) {
                ta.recycle();
            }
        }
        return null;
    }
}
