package com.idenfy.idenfySdk.navigation

import android.support.v4.app.FragmentManager
import com.idenfy.idenfySdk.identificationresults.ui.view.AuthenticationResultFragment
import com.idenfy.idenfySdk.documentscamerasession.ui.view.DocumentsCameraSessionFragment
import com.idenfy.idenfySdk.facecamerasession.ui.view.FaceCameraSessionFragment
import com.idenfy.idenfySdk.documentscamerasession.ui.view.DocumentPhotoResultFragment
import com.idenfy.idenfySdk.facecamerasession.ui.view.FacePhotoResultFragment
import com.idenfy.idenfySdk.landingpage.ui.SplashScreenFragment
import com.idenfy.idenfySdk.core.ui.view.CameraPreviewActivity
import com.idenfy.idenfySdk.initialagreement.ui.view.InitialAgreementFragmnet
import com.idenfy.idenfysdk.core.logging.LoggingHelper
import com.idenfySdk.R

class Router {

    fun areFragmentsShown(supportFragmentManager: FragmentManager): Boolean {
        var areFragmentsShown = false
        val faceCameraFragemnt = supportFragmentManager.findFragmentByTag(FACE_CAMERA_SESSION_FRAGMENT)
        val facePhotoResultFragment = supportFragmentManager.findFragmentByTag(FACE_PHOTO_RESULT_FRAGMENT)
        val documentCameraFragment = supportFragmentManager.findFragmentByTag(DOCUMENT_PHOTO_RESULT_FRAGMENT)
        val documentssessionCameraFragment = supportFragmentManager.findFragmentByTag(DOCUMENT_CAMERA_SESSION_FRAGMENT_TAG)
        val docScanningFragment = supportFragmentManager.findFragmentByTag(DOC_SCANNING_FRAGMENT)
        val authentication = supportFragmentManager.findFragmentByTag(AUTHENTICATION_RESULTS_FRAGMENT)
        if (faceCameraFragemnt != null || facePhotoResultFragment != null
                || documentCameraFragment != null || documentssessionCameraFragment != null || authentication != null || docScanningFragment != null) {
            areFragmentsShown = true
        }
        return areFragmentsShown
    }

    fun addDocScanningFragment(supportFragmentManager: FragmentManager) {
        val documentsCameraSessionFragment = com.idenfy.docscanning.docScanning.DocScanningFragment()
        supportFragmentManager.beginTransaction().replace(R.id.idenfy_layout_activity_main_root, documentsCameraSessionFragment, DOC_SCANNING_FRAGMENT)
                .commit()
    }

    fun removeDocScanningFragment(supportFragmentManager: FragmentManager) {
        val fragment = supportFragmentManager.findFragmentByTag(DOC_SCANNING_FRAGMENT)
        if (fragment != null) {
            supportFragmentManager.beginTransaction().remove(fragment)
                    .commit()
        }
    }

    fun addFaceCameraFragment(supportFragmentManager: FragmentManager) {
        LoggingHelper.LogLifecycleInfo("addingFaceCamera")
        val cameraNewFragment = FaceCameraSessionFragment()
        supportFragmentManager.beginTransaction().replace(R.id.idenfy_layout_activity_main_root, cameraNewFragment, FACE_CAMERA_SESSION_FRAGMENT)
                .commitAllowingStateLoss()
    }

    fun removeFaceCameraFragment(supportFragmentManager: FragmentManager) {
        val fragment = supportFragmentManager.findFragmentByTag(FACE_CAMERA_SESSION_FRAGMENT)
        if (fragment != null) {
            LoggingHelper.LogLifecycleInfo("removingFace")
            supportFragmentManager.beginTransaction().remove(fragment)
                    .commitAllowingStateLoss()
        }
    }

    fun addFacePhotoResultFragment(supportFragmentManager: FragmentManager, livenessEnabled: Boolean) {
        val fragment = supportFragmentManager.findFragmentByTag(FACE_PHOTO_RESULT_FRAGMENT)
        if (fragment == null) {
            LoggingHelper.LogLifecycleInfo("addFaceResult")
            val cameraNewFragment = FacePhotoResultFragment()
            supportFragmentManager.beginTransaction().add(R.id.idenfy_layout_activity_main_root, cameraNewFragment, FACE_PHOTO_RESULT_FRAGMENT).commit()

        }
    }

    fun removeFacePhotoResultFragment(supportFragmentManager: FragmentManager) {
        val fragment = supportFragmentManager.findFragmentByTag(FACE_PHOTO_RESULT_FRAGMENT)
        if (fragment != null) {
            LoggingHelper.LogLifecycleInfo("removingfaceresult")
            supportFragmentManager.beginTransaction().remove(fragment)
                    .commit()
        }
    }

    fun addDocumentPhotoResultFragment(supportFragmentManager: FragmentManager) {
        val fragment = supportFragmentManager.findFragmentByTag(DOCUMENT_PHOTO_RESULT_FRAGMENT)
        if (fragment == null) {
            LoggingHelper.LogLifecycleInfo("addingDocumentResultFragemnt")
            val documentPhotoResultFragment = DocumentPhotoResultFragment()
            supportFragmentManager.beginTransaction().add(R.id.idenfy_layout_activity_main_root, documentPhotoResultFragment, DOCUMENT_PHOTO_RESULT_FRAGMENT).commit()
        }
    }

    fun removeDocumentPhotoResultFragment(supportFragmentManager: FragmentManager) {
        val fragment = supportFragmentManager.findFragmentByTag(DOCUMENT_PHOTO_RESULT_FRAGMENT)
        if (fragment != null)
            supportFragmentManager.beginTransaction().remove(fragment).commit()
    }

    fun addDocumentCameraSessionFragment(supportFragmentManager: FragmentManager) {
        val fragment = supportFragmentManager.findFragmentByTag(DOCUMENT_CAMERA_SESSION_FRAGMENT_TAG)
        if (fragment == null) {
            LoggingHelper.LogLifecycleInfo("addingCamera")
            val documentsCameraSessionFragment = DocumentsCameraSessionFragment()
            supportFragmentManager.beginTransaction().replace(R.id.idenfy_layout_activity_main_root, documentsCameraSessionFragment, DOCUMENT_CAMERA_SESSION_FRAGMENT_TAG)
                    .commit()
        }
    }

    fun removeDocumentSelectionFragment(supportFragmentManager: FragmentManager) {
        val cameraFragment = supportFragmentManager.findFragmentByTag(DOCUMENT_CAMERA_SESSION_FRAGMENT_TAG)
        if (cameraFragment != null) {
            LoggingHelper.LogLifecycleInfo("removingCameraFragment")
            supportFragmentManager.beginTransaction().remove(cameraFragment).commit()
        }
    }

    fun addSplashScreenFragment(supportFragmentManager: FragmentManager) {
        val authenticationResultFragment = supportFragmentManager.findFragmentByTag(SPLASH_SCREEN_FRAGMENT)
        if (authenticationResultFragment == null) {
            LoggingHelper.LogLifecycleInfo("addingSplash")
            val cameraNewFragment = SplashScreenFragment()
            supportFragmentManager.beginTransaction().add(R.id.idenfy_layout_activity_main_root, cameraNewFragment, CameraPreviewActivity.SPLASH_SCREEN_FRAGMENT)
                    .commit()
        }
    }

    fun addInitialAgreementFragment(supportFragmentManager: FragmentManager) {
        val initialAgreementFragment = supportFragmentManager.findFragmentByTag(CameraPreviewActivity.INITIAL_AGREEMENT_FRAGMENT)
        if (initialAgreementFragment == null) {
            LoggingHelper.LogLifecycleInfo("addingInitial")
            val cameraNewFragment = InitialAgreementFragmnet()
            supportFragmentManager.beginTransaction().add(R.id.idenfy_fragment_container_activity_main_layout, cameraNewFragment, CameraPreviewActivity.INITIAL_AGREEMENT_FRAGMENT)
                    .commit()
        }
    }

    fun removeInitialAgreementFragment(supportFragmentManager: FragmentManager): Boolean {
        val fragment = supportFragmentManager.findFragmentByTag(INITIAL_AGREEMENT_FRAGMENT)
        if (fragment != null) {
            LoggingHelper.LogLifecycleInfo("removingInitialAgre")
            supportFragmentManager.beginTransaction().remove(fragment).commit()
            return true
        }
        return false

    }

    fun addAuthenticationResultFragment(supportFragmentManager: FragmentManager, commitAllowingStateLoss: Boolean? = null) {
        val auth = supportFragmentManager.findFragmentByTag(AUTHENTICATION_RESULTS_FRAGMENT)
        if (auth == null) {
            LoggingHelper.LogLifecycleInfo("authAdded")
            val transaction = supportFragmentManager.beginTransaction()
            val authenticationResultFragment = AuthenticationResultFragment()
            transaction.replace(R.id.idenfy_layout_activity_main_root, authenticationResultFragment, AUTHENTICATION_RESULTS_FRAGMENT)
            transaction.setCustomAnimations(android.R.anim.fade_in, android.R.anim.fade_out)
            transaction.commit()
        }
    }

    fun removeAuthenticationResultFragment(supportFragmentManager: FragmentManager, commitAllowingStateLoss: Boolean? = null) {
        val fragment = supportFragmentManager.findFragmentByTag(AUTHENTICATION_RESULTS_FRAGMENT)
        if (fragment != null) {
            LoggingHelper.LogLifecycleInfo("removingAuth")
            if (commitAllowingStateLoss == true)
                supportFragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss()
            else supportFragmentManager.beginTransaction().remove(fragment).commit()
        }
    }

    companion object {
        const val INITIAL_AGREEMENT_FRAGMENT = "InitialAgreementFragment"
        const val SPLASH_SCREEN_FRAGMENT = "SplashScreenFragment"
        const val DOCUMENT_PHOTO_RESULT_FRAGMENT = "DOCUMENT_PHOTO_RESULT_FRAGMENT"
        const val FACE_CAMERA_SESSION_FRAGMENT = "FACE_CAMERA_SESSION_FRAGMENT"
        const val FACE_PHOTO_RESULT_FRAGMENT = "FACE_CAMERA_RESULT_FRAGMENT"
        const val DOCUMENT_CAMERA_SESSION_FRAGMENT_TAG = "DocumentsCameraSessionFragment"
        const val DOC_SCANNING_FRAGMENT = "DocumentScanningFragment"
        const val AUTHENTICATION_RESULTS_FRAGMENT = "AuthenticationFragment"

    }
}