package com.idenfy.idenfySdk.core.ui.adapter

import android.content.Context
import android.graphics.Typeface
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView

import com.idenfy.idenfysdk.core.models.documentTypeData.DocumentTypeClass
import com.idenfy.idenfysdk.core.models.documentTypeData.DocumentTypeEnum
import com.idenfySdk.R

class DocumentsRecyclerViewAdapter(private val uploadDocumentPhotoTypes: List<DocumentTypeClass>, private val mListener: OnItemClickListener, private val mContext: Context?, private val typeface: Typeface) : RecyclerView.Adapter<DocumentsRecyclerViewAdapter.ViewHolder>() {

    interface OnItemClickListener {
        fun onClick(type: DocumentTypeClass)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {

        val legacyDocumentTypeItem = mContext!!.resources.getIdentifier("idenfy_documents_type_item", "layout", mContext.packageName)
        val v = if (legacyDocumentTypeItem == 0) {
            LayoutInflater.from(parent.context)
                    .inflate(R.layout.idenfy_item_view_documents_type_selection, parent, false)
        } else {
            LayoutInflater.from(parent.context)
                    .inflate(legacyDocumentTypeItem, parent, false)
        }
        return ViewHolder(v)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {

        val type = uploadDocumentPhotoTypes[position].documentTypeEnum
        if (type == DocumentTypeEnum.ID_CARD) {
            if (mContext != null) {
                holder.textView.text = mContext.resources.getString(R.string.idenfy_documents_selection_list_item_document_type_id_card)
                holder.imageView.setImageResource(R.drawable.idenfy_ic_documents_type_selection_id_card)
            }
        } else if (type == DocumentTypeEnum.PASSPORT) {
            if (mContext != null) {
                holder.textView.text = mContext.resources.getString(R.string.idenfy_documents_selection_list_item_document_type_passport)
                holder.imageView.setImageResource(R.drawable.idenfy_ic_documents_type_selection_passport)
            }
        } else if (type == DocumentTypeEnum.DRIVER_LICENSE) {
            if (mContext != null) {
                holder.textView.text = mContext.resources.getString(R.string.idenfy_documents_selection_list_item_document_type_driver_licence)
                holder.imageView.setImageResource(R.drawable.idenfy_ic_documents_type_selection_driver_license)
            }
        } else if (type == DocumentTypeEnum.OTHER) {
            if (mContext != null) {
                holder.textView.text = mContext.resources.getString(R.string.idenfy_documents_selection_list_item_document_type_other)
                holder.imageView.setImageResource(R.drawable.idenfy_ic_documents_type_selection_other)
            }
        } else if (type == DocumentTypeEnum.RESIDENCE_PERMIT) {
            if (mContext != null) {
                holder.textView.text = mContext.resources.getString(R.string.idenfy_documents_selection_list_item_document_type_residence_permit)
                holder.imageView.setImageResource(R.drawable.idenfy_ic_documents_type_selection_residence_permit)
            }
        }
        holder.textView.typeface = typeface
        holder.itemView.setOnClickListener { mListener.onClick(uploadDocumentPhotoTypes[position]) }
        holder.itemView.tag = type
    }

    override fun getItemCount(): Int {
        return uploadDocumentPhotoTypes.size
    }

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var imageView: ImageView = itemView.findViewById(R.id.idenfy_document_icon)
        var textView: TextView = itemView.findViewById(R.id.idenfy_document_text_view)

    }
}
