package com.idenfy.idenfySdk.countriesselection.domain

import com.idenfy.idenfySdk.countriesselection.ui.model.Country
import com.idenfy.idenfySdk.initialagreement.repo.InitialAgreementRepositoryImp

class GetFormatedCountriesUseCase(val initialAgreementRepositoryImpl: InitialAgreementRepositoryImp) {
    data class FormattedCountries(val countriesList: List<Country>, val countryFromApi: Country?, val selectedCountry: Country?)

    fun getFormattedCountries(countriesBlacklist: MutableList<String>?, countriesList: MutableList<Country>,
                              countryCodeFromIP: String,
                              predifinedCountry: String?): FormattedCountries {

        var countryFromApiIndex = 0;
        var countryFromIP: Country? = null
        var selectedCountry: Country? = null
        for (i in 0 until countriesList.size) {
            if (countriesList[i].countryISO.equals(countryCodeFromIP, ignoreCase = true)) {
                countryFromIP = countriesList.get(i)
                countryFromApiIndex = i

            }
            if (countryFromIP != null) {
                countriesList.add(0, countryFromIP)
                countriesList.removeAt(countryFromApiIndex + 1)
                break
            }
        }
        if (predifinedCountry != null) {
            initialAgreementRepositoryImpl.initialAgreementDataModel.value?.isCountrySelectionEnabled = false
            initialAgreementRepositoryImpl.initialAgreementDataModel.value = initialAgreementRepositoryImpl.initialAgreementDataModel.value

            for (i in 0 until countriesList.size) {
                if (countriesList[i].countryISO.equals(predifinedCountry, ignoreCase = true)) {
                    selectedCountry = countriesList[i]
                    initialAgreementRepositoryImpl.initialAgreementDataModel.value?.selectedCountryFromPartnerInfo = selectedCountry
                    initialAgreementRepositoryImpl.initialAgreementDataModel.value = initialAgreementRepositoryImpl.initialAgreementDataModel.value
                    break
                }
            }
        } else {
            initialAgreementRepositoryImpl.initialAgreementDataModel.value?.isCountrySelectionEnabled = true
            initialAgreementRepositoryImpl.initialAgreementDataModel.value = initialAgreementRepositoryImpl.initialAgreementDataModel.value
        }
        if (countriesBlacklist != null) {
            for (i in countriesBlacklist) {
                val country = Country(i)
                countriesList.remove(country)
            }

        }


        return FormattedCountries(countriesList, countryFromIP, selectedCountry)
    }

    // Get the time.


}