package com.idenfy.idenfySdk.countriesselection.domain

import android.app.Application
import android.arch.lifecycle.MutableLiveData
import com.idenfy.idenfySdk.Networking.Resource
import com.idenfy.idenfySdk.core.datasource.repository.RepositoryKotlin
import com.idenfy.idenfySdk.countriesselection.ui.model.Country
import com.idenfy.idenfySdk.countriesselection.ui.model.CountryEnum
import com.idenfy.idenfysdk.core.extensions.livedataextensions.default
import java.util.*

class GetCountriesListUseCase(val repository: RepositoryKotlin, val application: Application) {
    var countriesListMutableLiveData = MutableLiveData<Resource<List<Country>>>().default(Resource.loading<List<Country>>(null))
    fun fetchCountriesList() {
        val country_enums = ArrayList(EnumSet.allOf(CountryEnum::class.java))
        val countryList = ArrayList<Country>()
        for (i in country_enums.indices) {
            countryList.add(Country(country_enums[i], i, application.applicationContext))
        }
        countriesListMutableLiveData.value = (com.idenfy.idenfySdk.Networking.Resource.success<List<Country>>(countryList))
    }
}