package com.idenfy.idenfySdk.documentscamerasession.ui.view


import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.content.Context
import android.content.Intent
import android.graphics.Color
import android.graphics.PorterDuff
import android.graphics.RectF
import android.graphics.Typeface
import android.os.Build
import android.os.Bundle
import android.os.Handler
import android.provider.MediaStore
import android.support.constraint.ConstraintLayout
import android.support.design.widget.TabLayout
import android.support.v4.content.ContextCompat
import android.support.v4.graphics.drawable.DrawableCompat
import android.support.v4.view.ViewPager
import android.support.v7.app.AppCompatDelegate
import android.support.v7.widget.AppCompatButton
import android.support.v7.widget.AppCompatImageButton
import android.text.SpannableString
import android.text.SpannableStringBuilder
import android.text.Spanned
import android.text.style.ForegroundColorSpan
import android.util.DisplayMetrics
import android.view.LayoutInflater
import android.view.MotionEvent
import android.view.View
import android.view.ViewGroup
import android.view.ViewTreeObserver
import android.widget.ImageView
import android.widget.RelativeLayout
import android.widget.TextView

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController
import com.idenfy.idenfySdk.sharedcamerasession.ui.model.CameraSessionImageResultSize
import com.idenfy.idenfySdk.sharedcamerasession.ui.utils.BitmapPhotoCropper
import com.idenfy.idenfySdk.documentscamerasession.ui.utils.DocumentsCameraSessionFrameProcessor
import com.idenfy.idenfySdk.instructions.ui.utils.InstructionDynamicSizeManager
import com.idenfy.idenfySdk.instructions.ui.adapter.InstructionPagerAdapter
import com.idenfy.idenfySdk.instructions.ui.utils.TopSheetBehavior
import com.idenfy.idenfySdk.instructions.ui.viewmodel.InstructionViewModel
import com.idenfy.idenfySdk.core.ui.view.CameraPreviewActivity
import com.idenfy.idenfySdk.core.ui.viewmodel.CameraViewModel
import com.idenfy.idenfysdk.core.common.presentation.models.InstructionEnum
import com.idenfy.idenfysdk.core.common.presentation.uiviewmodels.CurrentStepUIViewModel
import com.idenfy.idenfysdk.core.extensions.livedataextensions.ViewLifecycleFragment
import com.idenfy.idenfysdk.core.logging.LoggingHelper
import com.idenfy.idenfysdk.core.models.InstructionModel
import com.idenfy.idenfysdk.core.ui.customviews.CustomViewHolder
import com.idenfy.idenfysdk.core.ui.uihelpers.CameraDisplayHelpers
import com.idenfy.idenfysdk.core.ui.uihelpers.CameraViewSize
import com.idenfy.idenfysdk.core.utils.ui.DpToPixelConverter
import com.idenfySdk.R

import java.io.IOException
import java.util.concurrent.atomic.AtomicBoolean

import io.fotoapparat.Fotoapparat
import io.fotoapparat.configuration.UpdateConfiguration
import io.fotoapparat.parameter.FocusMode
import io.fotoapparat.parameter.ScaleType
import io.fotoapparat.parameter.camera.CameraParameters
import io.fotoapparat.result.BitmapPhoto
import io.fotoapparat.result.WhenDoneListener
import io.fotoapparat.view.CameraView
import io.fotoapparat.view.FocusView

import io.fotoapparat.selector.autoFocus
import io.fotoapparat.selector.continuousFocusPicture
import io.fotoapparat.selector.continuousFocusVideo
import io.fotoapparat.selector.fixed
import io.fotoapparat.selector.back
import io.fotoapparat.selector.highestResolution
import io.fotoapparat.selector.firstAvailable

class DocumentsCameraSessionFragment : ViewLifecycleFragment() {

    var fotoapparat: Fotoapparat? = null
    private var viewPager: ViewPager? = null
    private var expandArrow: ImageView? = null
    private var topSheetBehavior: TopSheetBehavior<*>? = null
    private var topSheet: ConstraintLayout? = null
    private var topSheetLayout: ConstraintLayout? = null
    private var instructionPagerAdapter: InstructionPagerAdapter? = null
    private var nextPageButton: ImageView? = null
    private var previousPageButton: ImageView? = null
    private var donePageButton: ImageView? = null
    private var instructionTitle: TextView? = null
    private var instructionText: TextView? = null
    private var cameraView: CameraView? = null
    private lateinit var cameraViewModel: CameraViewModel
    private lateinit var instructionViewModel: InstructionViewModel
    private var documentTitleTutorial: TextView? = null
    private var fotoapparatFocusView: FocusView? = null
    private var takePictureButton: AppCompatImageButton? = null
    private var frameProcessor: DocumentsCameraSessionFrameProcessor? = null
    private var instructionDynamicSizeManager: InstructionDynamicSizeManager? = null

    private val DOCUMENT_CAMERA_SESSION_REQUEST_CODE = 101

    private var imageView: ImageView? = null
    private var documentBorderTextView: TextView? = null
    private var rootView: View? = null
    private var backButton: ImageView? = null
    private var backImage: ImageView? = null
    private var backTextView: TextView? = null
    private var backTextViewDefault: TextView? = null
    private var uploadImageButton: AppCompatButton? = null

    private var instructionList: List<InstructionModel>? = null
    private var shouldShowInstructions: Boolean = false
    private var documentSessionTitle: IntArray? = null
    private var customShapes: RelativeLayout? = null
    private var mFragmentClosedListener: OnCameraClosedFragment? = null
    //Handlers
    private val takePictureHandler = Handler()
    private val recreateButtonHandler = Handler()
    private val nextButtonHandler = Handler()
    private val fotoapparatSetupHandler = Handler()
    private val autoFocusHandler = Handler()
    private val backgroundPhotoHandler = Handler()
    private val slideDownInstructionsHandler = Handler()

    //Logic values
    private var canFocus = AtomicBoolean(true)
    //View drawings values
    private var rectangleLeft: Int = 0
    private var rectangleTop: Int = 0
    private var rectangleRight: Int = 0
    private var rectangleBottom: Int = 0
    private var heightOfImage: Int = 0
    private var yCoordinateOfHeightStart: Int = 0
    private var widthOfImage: Int = 0
    private var xCoordinateOfWidthStart: Int = 0
    private val rectangeMargin = 5


    private var currentStepUIViewModel: CurrentStepUIViewModel? = null


    private var ratio = (125f / 87f).toDouble()

    private val customShape: View?
        get() {
            if (customShapes != null)
                if (customShapes!!.getChildAt(0) != null) {
                    return customShapes!!.getChildAt(0)
                }
            return null
        }

    private val cameraPreviewSize: CameraViewSize
        get() = CameraViewSize(cameraView!!.width, cameraView!!.height)

    private var focusRunnable: Runnable? = Runnable {
        if (fotoapparat != null) {
            fotoapparat?.getCurrentParameters()?.whenAvailable{
                cameraParameters->
                cameraParameters?.let {
                    if (cameraParameters.focusMode != FocusMode.ContinuousFocusPicture || cameraParameters.focusMode != FocusMode.ContinuousFocusVideo) {
                        if (fotoapparat != null) {
                            fotoapparat!!.updateConfiguration(
                                    UpdateConfiguration.builder().focusMode(
                                            firstAvailable(continuousFocusPicture(), continuousFocusVideo())).build())
                            canFocus.set(true)
                        }
                    }

                }

            }
        }
    }

    private var onPreDrawListener: ViewTreeObserver.OnPreDrawListener? = object : ViewTreeObserver.OnPreDrawListener {
        override fun onPreDraw(): Boolean {
            if (ratio != -1.0) {
                val width = rootView!!.width
                val height = rootView!!.height
                val visibleArea = CameraDisplayHelpers.getVisibleArea(width, height, ratio)
                val xPositionRatio = (visibleArea!!.left / width).toDouble()
                val yPositionRatio = (visibleArea.top / height).toDouble()
                if (imageView != null)
                    setupImageViewWithScalledImage(xPositionRatio, yPositionRatio, ratio)
                rootView!!.viewTreeObserver.removeOnPreDrawListener(this)
            }
            return true

        }
    }

    private var topSheetBehaviorCallback: TopSheetBehavior.TopSheetCallback = object : TopSheetBehavior.TopSheetCallback() {
        override fun onStateChanged(bottomSheet: View, newState: Int) {

            if (rootView == null)
                return
            if(shouldShowInstructions) {
                val cameraSessionTitle = rootView!!.findViewById<TextView>(R.id.camera_session_information_text_view_with_instructions)
                if (newState == TopSheetBehavior.STATE_COLLAPSED) {
                    expandArrow!!.setImageResource(R.drawable.idenfy_ic_instructions_arrow_expand_more)
                    cameraSessionTitle.visibility = View.VISIBLE
                    instructionText!!.visibility = View.INVISIBLE
                    backTextView!!.visibility = View.VISIBLE
                    backImage!!.visibility = View.VISIBLE
                    takePictureButton!!.visibility = View.VISIBLE
                    topSheet?.setBackgroundResource(R.drawable.idenfy_custom_drawable_instructions_background_rounded_corners)
                    if (cameraViewModel.partnerInfo != null && cameraViewModel.partnerInfo!!.canUpload)
                        uploadImageButton?.visibility = View.VISIBLE
                    topSheet?.isClickable = false
                } else if (newState == TopSheetBehavior.STATE_EXPANDED) {
                    topSheetBehavior!!.state = TopSheetBehavior.STATE_EXPANDED
                    expandArrow!!.setImageResource(R.drawable.idenfy_ic_instructions_arrow_expand_less)
                    cameraSessionTitle.visibility = View.GONE
                    instructionText!!.visibility = View.VISIBLE
                    donePageButton!!.visibility = View.GONE
                    backTextView!!.visibility = View.GONE
                    backImage!!.visibility = View.GONE
                    takePictureButton!!.visibility = View.INVISIBLE
                    uploadImageButton?.visibility = View.INVISIBLE
                    topSheet?.setBackgroundResource(R.drawable.idenfy_custom_drawable_instructions_background_without_rounded_corners)
                    topSheet?.isClickable = true
                }
            }
        }

        override fun onSlide(bottomSheet: View, slideOffset: Float, isOpening: Boolean?) {

            if (isOpening != null) {
                if (isOpening) {
                    if (slideOffset > 0.7) {
                        topSheetBehavior!!.state = TopSheetBehavior.STATE_EXPANDED
                        expandArrow!!.setImageResource(R.drawable.idenfy_ic_instructions_arrow_expand_less)
                        documentTitleTutorial!!.visibility = View.GONE
                        instructionText!!.visibility = View.VISIBLE
                        donePageButton!!.visibility = View.GONE
                        backTextView!!.visibility = View.GONE
                        backImage!!.visibility = View.GONE
                        takePictureButton!!.visibility = View.INVISIBLE
                        uploadImageButton?.visibility = View.INVISIBLE
                        topSheet!!.setBackgroundResource(R.drawable.idenfy_custom_drawable_instructions_background_without_rounded_corners)
                        topSheet!!.isClickable = true
                    }
                } else {
                    if (slideOffset <= 0.3) {
                        topSheetBehavior!!.state = TopSheetBehavior.STATE_COLLAPSED
                        expandArrow!!.setImageResource(R.drawable.idenfy_ic_instructions_arrow_expand_more)
                        documentTitleTutorial!!.visibility = View.VISIBLE
                        instructionText!!.visibility = View.INVISIBLE
                        backTextView!!.visibility = View.VISIBLE
                        backImage!!.visibility = View.VISIBLE
                        takePictureButton!!.visibility = View.VISIBLE
                        topSheet!!.setBackgroundResource(R.drawable.idenfy_custom_drawable_instructions_background_rounded_corners)
                        if (cameraViewModel.partnerInfo != null && cameraViewModel.partnerInfo!!.canUpload!!)
                            uploadImageButton?.visibility = View.VISIBLE
                        topSheet!!.isClickable = false
                    }
                }
            }
        }
    }


    interface OnCameraClosedFragment {
        fun onCameraNewFragmentClosed(closed: Boolean)
    }


    override fun onCreate(savedInstanceState: Bundle?) {

        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true)
        super.onCreate(savedInstanceState)
        if (savedInstanceState == null) {
            if (activity != null)
                frameProcessor = DocumentsCameraSessionFrameProcessor(activity)
        }
        cameraViewModel = ViewModelProviders.of(activity!!).get(CameraViewModel::class.java)
        instructionViewModel = ViewModelProviders.of(activity!!).get(InstructionViewModel::class.java)
        instructionDynamicSizeManager = InstructionDynamicSizeManager()
    }


    private fun setupCamera() {

        val activity = activity
        if (isAdded && activity != null) {
            if (fotoapparatFocusView != null && cameraView != null) {
                fotoapparat = Fotoapparat
                        .with(getActivity()!!)
                        .into(cameraView!!)
                        .previewScaleType(ScaleType.CenterCrop)
                        .previewResolution(highestResolution())
                        .lensPosition(back())
                        .focusMode(firstAvailable(
                                continuousFocusPicture(),
                                continuousFocusVideo(),
                                autoFocus(),
                                fixed()
                        ))
                        .focusView(fotoapparatFocusView!!)
                        .photoResolution(highestResolution())
                        .frameProcessor(frameProcessor)
                        .cameraErrorCallback { e ->
                            if (cameraViewModel.checkIfCanRetryDocumentCamera())
                                cameraViewModel.setAddDocumentCameraFragment(true)
                            else
                                cameraViewModel.setAddDocumentCameraFragment(false)
                        }
                        .build()
            }

        }
    }

    private fun initializeUI(rootView: View) {
        viewPager = rootView.findViewById(R.id.idenfy_view_pager_instructions)
        expandArrow = rootView.findViewById(R.id.idenfy_iv_instructions_expand_top_layout)
        nextPageButton = rootView.findViewById(R.id.idenfy_iv_instructions_next_page_button)
        previousPageButton = rootView.findViewById(R.id.idenfy_iv_instructions_previous_page_button)
        donePageButton = rootView.findViewById(R.id.idenfy_iv_instructions_done_button)
        topSheet = rootView.findViewById(R.id.idenfy_constraintLayout_instructions_top_sheet_root)
        topSheetLayout = rootView.findViewById(R.id.idenfy_instructions_top_sheet_layout)
        instructionTitle = rootView.findViewById(R.id.idenfy_tv_instructions_current_instruction_title)
        instructionText = rootView.findViewById(R.id.idenfy_tv_instructions_current_instruction_content)
        cameraView = rootView.findViewById(R.id.idenfy_camera_view_document_camera_preview_session)
        documentTitleTutorial = rootView.findViewById(R.id.camera_session_information_text_view)
        takePictureButton = rootView.findViewById(R.id.takePictureButton)
        backImage = rootView.findViewById(R.id.backImage_instructions)
        backTextView = rootView.findViewById(R.id.back_text_view_instructions)
        customShapes = rootView.findViewById(R.id.custom_shapes)
        customShapes!!.visibility = View.VISIBLE
        fotoapparatFocusView = rootView.findViewById(R.id.idenfy_focus_view_document_camera_session)

        imageView = rootView.findViewById(R.id.imageView)
        documentBorderTextView = rootView.findViewById(R.id.document_overlay_title)
        if (fotoapparatFocusView != null) {
            fotoapparatFocusView!!.visibility = View.VISIBLE
        }

    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {

        rootView = inflater.inflate(R.layout.idenfy_document_camera_preview_session_fragment_with_instructions, container, false)
        if (cameraViewModel.currentStepUIViewModelLiveData.value != null && cameraViewModel.currentStepUIViewModelLiveData.value!!.instrcutionEnum !== InstructionEnum.INSTRUCTION_NOT_NEEDED) {
            shouldShowInstructions = true
            initializeUI(rootView!!)
            documentTitleTutorial = rootView!!.findViewById(R.id.camera_session_information_text_view_with_instructions)
        } else {
            initializeUI(rootView!!)
        }
        return rootView
    }

    private fun observeDocumentType() {

        cameraViewModel.currentStepUIViewModelLiveData.observe(viewLifecycleOwner!!, Observer{ response ->


            if (response != null) {
                currentStepUIViewModel = response
                instructionViewModel.setCurrentInstructionEnum(response.instrcutionEnum)
                setupDocumentTitle(response.sessionInformationTitle)
                setupDocumentView(response.documentCameraFrameRatio)
                setupDocumentOverlayString(response.overlayTitle)

                if (response.instrcutionEnum !== InstructionEnum.INSTRUCTION_NOT_NEEDED) {
                    if (context != null) {
                        instructionViewModel.createInstructionModelList(context!!)
                        instructionViewModel.instructionModelList!!.observe(viewLifecycleOwner!!, Observer<List<InstructionModel>> { instructionModels ->
                            instructionList = instructionModels
                            setUpInstructions()
                        })
                    }
                }
                documentSessionTitle = response.sessionInformationTitle
                setUpViews(documentSessionTitle)
                setupListenersForButtons()

            }
        })

    }

    private fun setupDocumentOverlayString(resID: Pair<Int, String?>) {
        if (documentBorderTextView == null) {
            return
        }
        if (resID.second != null)
            documentBorderTextView?.text = resID.second
        else {
            documentBorderTextView?.text = resources.getString(resID.first)
            //handling legacy
            if(resID.first == R.string.idenfy_document_and_face_camera_preview_session_information_overlay_title_document_step_passport_front)
            {
                val legacyPassportID = resources.getIdentifier("idenfy_overlay_title_passport", "string", context!!.packageName)
                if(legacyPassportID!=0){
                    documentBorderTextView?.text = resources.getString(legacyPassportID)
                }
            }
            if(resID.first == R.string.idenfy_document_and_face_camera_preview_session_information_overlay_title_document_step_passport_cover)
            {
                val legacyPassportCoverID = resources.getIdentifier("idenfy_overlay_title_passport_cover", "string", context!!.packageName)
                if(legacyPassportCoverID!=0){
                    documentBorderTextView?.text = resources.getString(legacyPassportCoverID)
                }
            }
            if(resID.first == R.string.idenfy_document_and_face_camera_preview_session_information_overlay_title_document_step_utility_bill)
            {
                val legacyUtilityBillID = resources.getIdentifier("idenfy_overlay_title_utility_bill", "string", context!!.packageName)
                if(legacyUtilityBillID!=0){
                    documentBorderTextView?.text = resources.getString(legacyUtilityBillID)
                }
            }
            if(resID.first == R.string.idenfy_document_and_face_camera_preview_session_information_overlay_title_document_step_default_front)
            {
                val legacyFrontID = resources.getIdentifier("front_document_element_text", "string", context!!.packageName)
                if(legacyFrontID!=0){
                    documentBorderTextView?.text = resources.getString(legacyFrontID)
                }
            }
            if(resID.first == R.string.idenfy_document_and_face_camera_preview_session_information_overlay_title_document_step_default_back)
            {
                val legacyBackID = resources.getIdentifier("back_document_element_text", "string", context!!.packageName)
                if(legacyBackID!=0){
                    documentBorderTextView?.text = resources.getString(legacyBackID)
                }
            }



        }


    }


    private fun setupDocumentTitle(resIdArray: IntArray) {
        if (resIdArray[1] == 0) {
            documentTitleTutorial!!.text = resources.getString(resIdArray[0])
        } else {
            documentTitleTutorial!!.text = getDefaultTitle(resources.getString(resIdArray[1]))
        }

    }


    private fun observeUI() {

        documentTitleTutorial?.visibility = View.VISIBLE
        documentBorderTextView?.visibility = View.VISIBLE

        cameraViewModel.actionButtonVisibility.observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null)
                takePictureButton!!.visibility = if (response) View.VISIBLE else View.INVISIBLE
        })
        cameraViewModel.cropShapeImageView.observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null)
                imageView!!.visibility = if (response) View.VISIBLE else View.INVISIBLE
        })
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        cameraViewModel.setTakePictureButtonAvailability(true)
        cameraViewModel.setUploadPictureButtonAvailability(true)
        setupCustomUI()
    }

    private fun setupDocumentView(documentCameraFrameRatio: Float) {

        if (fotoapparatFocusView != null)
            fotoapparatFocusView!!.visibility = View.VISIBLE
        ratio = documentCameraFrameRatio.toDouble()
        rootView!!.viewTreeObserver.addOnPreDrawListener(onPreDrawListener)

    }


    private fun setupImageViewWithScalledImage(xPositionRatio: Double, yPositionRatio: Double,
                                               uploadDocumentPhotoType: Double) {
        val params = imageView!!.layoutParams as ConstraintLayout.LayoutParams
        val parent = imageView!!.parent as ConstraintLayout
        val parentWidth = parent.width
        val parentHeight = parent.height
        val horizontalMargin = (parent.width * xPositionRatio).toInt()
        val verticalMargin = (parent.height * yPositionRatio).toInt()
        params.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin)
        imageView!!.layoutParams = params

        val view = customShape ?: return
        if (view is CustomViewHolder) {
            determineValuesForDocument(parentWidth, parentHeight, horizontalMargin, verticalMargin)
            view.setValuesForRectangle(rectangleLeft,
                    rectangleTop,
                    rectangleRight,
                    rectangleBottom)
            view.invalidate()
        }
        setupValuesForCropping(verticalMargin, horizontalMargin, parentHeight, parentWidth)

    }

    private fun setupValuesForCropping(verticalMargin: Int, horizontalMargin: Int, parentHeight: Int, parentWidth: Int) {
        yCoordinateOfHeightStart = verticalMargin - horizontalMargin
        heightOfImage = parentHeight - verticalMargin * 2 + horizontalMargin * 2
        widthOfImage = parentWidth
        xCoordinateOfWidthStart = 0
    }

    private fun determineValuesForDocument(parentWidth: Int, parentHeight: Int, horizontalMargin: Int, verticalMargin: Int) {

        rectangleLeft = parentWidth - horizontalMargin + DpToPixelConverter.dpToPx(rectangeMargin)
        rectangleRight = horizontalMargin - DpToPixelConverter.dpToPx(rectangeMargin)
        rectangleBottom = parentHeight - verticalMargin + DpToPixelConverter.dpToPx(rectangeMargin)
        rectangleTop = verticalMargin - DpToPixelConverter.dpToPx(rectangeMargin)
        if (this.rectangleLeft > this.rectangleRight) {
            val c = this.rectangleLeft
            val k = this.rectangleRight
            this.rectangleRight = c
            this.rectangleLeft = k
        }
    }

    override fun onSaveInstanceState(savedInstanceState: Bundle) {
        super.onSaveInstanceState(savedInstanceState)

    }

    override fun onAttach(context: Context?) {
        super.onAttach(context)

        if (context is OnCameraClosedFragment) {
            mFragmentClosedListener = context
        }
        super.onAttach(context)

    }

    override fun onDetach() {
        super.onDetach()
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        setUpUIDynamicSizes()
        pictureButtonOnClickListener()
        val takePhotoButtonIvLegacy = context!!.resources.getIdentifier("idenfy_make_photo", "drawable", context!!.packageName)
        if(takePhotoButtonIvLegacy!=0)
        {
            takePictureButton?.setImageDrawable(
                    ContextCompat.getDrawable(activity!!, takePhotoButtonIvLegacy))
        }
        if (IdenfyController.getInstance().settings != null) {
            val idenfySettings = IdenfyController.getInstance().settings
            val typeFaceRegular = idenfySettings.customRegularFont
            val typeFaceBold = idenfySettings.customBoldTypeFace
            setupCustomTypeFace(typeFaceRegular, typeFaceBold)

        }
        if (fotoapparatFocusView != null)
            fotoapparatFocusView!!.setOnTouchListener(View.OnTouchListener { v, event ->
                if (canFocus.get()) {
                    when (event.action) {
                        MotionEvent.ACTION_DOWN ->

                            if (cameraViewModel.getNextButtonVisibility().value != null && (!cameraViewModel.getNextButtonVisibility().value!!)!!)
                                if (canFocus.get()) {
                                    return@OnTouchListener false
                                } else {
                                }
                    }
                    false
                } else {
                    true
                }
            })
        setupFocus()
        observeUI()
        observeButtonsAvailability()
        observeDocumentType()
        observeButtonClicks()

    }

    private fun setupListenersForButtons() {
        backTextView!!.setOnClickListener { onBackPressed() }
        if (!shouldShowInstructions && backTextViewDefault!!.visibility == View.VISIBLE)
            backTextViewDefault!!.setOnClickListener { onBackPressed() }
        backImage!!.setOnClickListener { onBackPressed() }
        if (!shouldShowInstructions && backTextViewDefault!!.visibility == View.VISIBLE)
            backButton!!.setOnClickListener { onBackPressed() }
    }


    private fun observeButtonClicks() {
        cameraViewModel.getNextButtonPressed().observe(viewLifecycleOwner!!, Observer { aBoolean ->
            if (aBoolean != null) {
                if (aBoolean) {
                    startBackgroundPhotoTaking()
                    setInstructionButtonPositions(true)
                }
            }
        })

        cameraViewModel.getRetakeButtonPressed().observe(viewLifecycleOwner!!, Observer { aBoolean ->
            if (aBoolean != null) {
                if (aBoolean) {
                    startBackgroundPhotoTaking()
                    viewPager!!.currentItem = 0
                    setInstructionButtonPositions()
                    setUpViews(documentSessionTitle)
                    slideDownInstructionsHandler.removeCallbacksAndMessages(null)

                }
            }
        })

        topSheetBehavior?.setTopSheetCallback(topSheetBehaviorCallback)
        nextPageButton!!.setOnClickListener {
            if (viewPager!!.currentItem == 0) {
                previousPageButton!!.visibility = View.INVISIBLE
            } else {
                previousPageButton!!.visibility = View.VISIBLE
            }
            if (viewPager!!.currentItem == instructionPagerAdapter!!.count - 2) {
                nextPageButton!!.visibility = View.GONE
                donePageButton!!.visibility = View.VISIBLE

            } else {
                nextPageButton!!.visibility = View.VISIBLE
                donePageButton!!.visibility = View.GONE
            }
            viewPager!!.setCurrentItem(getNextPossibleItemIndex(1), true)
        }

        previousPageButton!!.setOnClickListener {
            viewPager!!.setCurrentItem(getNextPossibleItemIndex(-1), true)
            if (viewPager!!.currentItem == 0) {
                previousPageButton!!.visibility = View.INVISIBLE
            } else {
                previousPageButton!!.visibility = View.VISIBLE
            }
            nextPageButton!!.visibility = View.VISIBLE
        }

        donePageButton!!.setOnClickListener { topSheetBehavior!!.state = TopSheetBehavior.STATE_COLLAPSED }

        viewPager!!.addOnPageChangeListener(object : ViewPager.OnPageChangeListener {
            override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {

            }

            override fun onPageSelected(position: Int) {
                instructionTitle!!.text = instructionList!![position].instructionTitle
                instructionText!!.text = instructionList!![position].instructionText
                if (position == 0) {
                    previousPageButton!!.visibility = View.INVISIBLE
                } else {
                    previousPageButton!!.visibility = View.VISIBLE
                }
                if (position == instructionPagerAdapter!!.count - 1) {
                    nextPageButton!!.visibility = View.GONE
                    donePageButton!!.visibility = View.VISIBLE

                } else {
                    nextPageButton!!.visibility = View.VISIBLE
                    donePageButton!!.visibility = View.GONE
                }
            }

            override fun onPageScrollStateChanged(state: Int) {}
        })

        expandArrow!!.setOnClickListener {
            if (topSheetBehavior!!.state == TopSheetBehavior.STATE_EXPANDED) {
                topSheetBehavior!!.setState(TopSheetBehavior.STATE_COLLAPSED)
            } else {
                topSheetBehavior!!.setState(TopSheetBehavior.STATE_EXPANDED)
            }
        }

        topSheet!!.setOnClickListener { topSheetBehavior!!.state = TopSheetBehavior.STATE_COLLAPSED }
    }

    private fun observeButtonsAvailability() {

        cameraViewModel.getTakePictureButtonAvailability().observe(viewLifecycleOwner!!, Observer { aBoolean ->
            if (aBoolean != null)
                takePictureButton!!.isEnabled = aBoolean
        })

        cameraViewModel.getUploadPictureButtonAvailability().observe(viewLifecycleOwner!!, Observer { aBoolean ->
            if (aBoolean != null) {
                uploadImageButton?.isEnabled = aBoolean
            }
        })
    }


    private fun setupFocus() {
        if (fotoapparatFocusView != null)
            fotoapparatFocusView!!.setOnClickListener {
                if (canFocus.get()) {
                    if (fotoapparat != null) {
                        canFocus.set(false)
                        fotoapparat!!.getCurrentParameters().whenDone(object : WhenDoneListener<CameraParameters> {
                            override fun whenDone(cameraParameters: CameraParameters?) {
                                if (cameraParameters != null)
                                    if (cameraParameters.component2() != FocusMode.Auto) {
                                        if (fotoapparat != null) {
                                            fotoapparat!!.updateConfiguration(
                                                    UpdateConfiguration.builder().focusMode(
                                                            firstAvailable(autoFocus())).build())
                                            if (autoFocusHandler != null && focusRunnable != null)
                                                autoFocusHandler.postDelayed(focusRunnable, 3000)
                                        }
                                        if (cameraParameters.component2() == FocusMode.Auto) {
                                            if (autoFocusHandler != null && focusRunnable != null)
                                                autoFocusHandler.postDelayed(focusRunnable, 3000)
                                        }
                                    }
                            }
                        })
                    }
                }
            }

    }

    private fun pictureButtonOnClickListener() {
        takePictureButton!!.setOnClickListener {
            backgroundPhotoHandler.removeCallbacksAndMessages(null)
            cameraViewModel.setNextButtonAvailability(false)
            cameraViewModel.setRecreateButtonAvailability(false)
            cameraViewModel.setTakePictureButtonAvailability(false)
            if (activity != null) {
                takePicture()
            }
        }

        uploadImageButton?.setOnClickListener {
            if (activity != null) {
                backgroundPhotoHandler.removeCallbacksAndMessages(null)
                cameraViewModel.setNextButtonAvailability(false)
                cameraViewModel.setRecreateButtonAvailability(false)
                cameraViewModel.setUploadPictureButtonAvailability(false)
                cameraViewModel.setSaveFragments(true)
                val mediaStoreIntent = Intent(Intent.ACTION_PICK,
                        android.provider.MediaStore.Images.Media.EXTERNAL_CONTENT_URI)
                activity?.startActivityForResult(mediaStoreIntent, DOCUMENT_CAMERA_SESSION_REQUEST_CODE)
            }
        }
    }


    private fun startBackgroundPhotoTaking() {
        if (cameraViewModel.partnerInfo!!.recordIdentification!!)
            backgroundPhotoHandler.post(object : Runnable {
                override fun run() {
                    frameProcessor!!.takeBackgroundPicture { bitmap, rotation, encoded -> cameraViewModel.addBackgroundPhoto(bitmap) }
                    backgroundPhotoHandler.postDelayed(this, 250)
                }

            })
    }

    private fun takePicture() {
        if (fotoapparat != null) {
            frameProcessor!!.takePicture { bitmap, rotation, encoded ->
                val photo = BitmapPhoto(bitmap, rotation)
                showPhoto(photo, false)
            }
        }
    }


    private fun showPhoto(bitmapPhoto: BitmapPhoto, isImageUploaded: Boolean?) {
        if (cameraView != null) {
            if (activity != null)
                activity!!.runOnUiThread(Runnable {
                    if (activity == null || cameraView == null || cameraViewModel.currentDocumentClass == null) {
                        return@Runnable
                    }
                    val result = BitmapPhotoCropper.cropPhotoWithPaddings(bitmapPhoto, cameraPreviewSize, RectF(xCoordinateOfWidthStart.toFloat(), yCoordinateOfHeightStart.toFloat(), widthOfImage.toFloat(), heightOfImage.toFloat()),
                            ratio)
                    val uploadDocumentPhotoType = CameraSessionImageResultSize(result, cameraViewModel.currentDocumentStep,
                            rectangleRight, rectangleLeft, rectangleTop, rectangleBottom, isImageUploaded!!)
                    cameraViewModel.setDocumentPhotoResultMutableLiveData(uploadDocumentPhotoType)
                    cameraViewModel.addDocumentPhotoResultFragment.value = true
                })


        }
    }


    override fun onDestroy() {
        super.onDestroy()
        LoggingHelper.LogLifecycleInfo("onDestroyDocumentCameraSession")
        LoggingHelper.LogLifecycleInfo("onDocumentCameraDestroy")

    }

    override fun onPause() {
        super.onPause()
        fotoapparat!!.stop()
        backgroundPhotoHandler.removeCallbacksAndMessages(null)
        cameraViewModel.setNextButtonPressed(false)
        cameraViewModel.setRetakeButtonPressed(false)
        LoggingHelper.LogLifecycleInfo("onDocumentCameraPause")
    }

    override fun onStop() {
        super.onStop()

        LoggingHelper.LogLifecycleInfo("onDocumentCameraStop")
        LoggingHelper.onStop(DocumentsCameraSessionFragment::class.java.simpleName)


    }


    override fun onStart() {
        super.onStart()
        setupCamera()
        LoggingHelper.LogLifecycleInfo("onDocumentCameraStart")
        LoggingHelper.onStart(DocumentsCameraSessionFragment::class.java.simpleName)


    }

    override fun onResume() {
        super.onResume()
        setInstructionButtonPositions()
        LoggingHelper.LogLifecycleInfo("onDocumentCameraResume")
        Handler().postDelayed({
            if (fotoapparat != null) {
                fotoapparat!!.start()
                startBackgroundPhotoTaking()
            }
        }, 100)

    }

    override fun onDestroyView() {
        if (onPreDrawListener != null)
            rootView!!.viewTreeObserver.removeOnPreDrawListener(onPreDrawListener)
        LoggingHelper.onDestroyView(DocumentsCameraSessionFragment::class.java.simpleName)
        onPreDrawListener = null
        super.onDestroyView()
        if (topSheetBehavior != null)
            topSheetBehavior!!.setTopSheetCallback(null)
        fotoapparatFocusView = null
        cameraView = null
        fotoapparat = null
        backTextView = null
        backTextViewDefault = null
        backImage = null
        backButton = null
        if (onPreDrawListener != null)
            rootView!!.viewTreeObserver.removeOnPreDrawListener(onPreDrawListener)
        onPreDrawListener = null
        documentTitleTutorial = null
        takePictureButton = null
        uploadImageButton = null
        (activity as CameraPreviewActivity).setSupportActionBar(null)
        if (customShapes != null) {

            for (i in 0 until customShapes!!.childCount) {
                if (customShapes!!.getChildAt(i) != null) {
                    customShapes!!.removeViewAt(i)
                }
            }
            customShapes = null
        }
        takePictureHandler.removeCallbacksAndMessages(null)
        recreateButtonHandler.removeCallbacksAndMessages(null)
        nextButtonHandler.removeCallbacksAndMessages(null)
        fotoapparatSetupHandler.removeCallbacksAndMessages(null)
    }


    fun onBackPressed() {
        mFragmentClosedListener!!.onCameraNewFragmentClosed(true)
    }

    private fun getDefaultTitle(docPart: String): SpannableStringBuilder {
        val builder = SpannableStringBuilder()
        if (activity == null) {
            builder.append("")
            return builder
        }
        if (shouldShowInstructions) {
            builder.append(setColoredSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, R.color.idenfyWhite)),
                    resources.getString(R.string.idenfy_document_camera_preview_session_message_part_0_document_type_default
                    )))
            builder.append(setColoredSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, R.color.idenfyWhite)), " $docPart "))
            builder.append(setColoredSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, R.color.idenfyWhite)),
                    resources.getString(R.string.idenfy_document_camera_preview_session_message_part_2_document_type_default
                    )))
            return builder
        } else {
            builder.append(setColoredSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, R.color.idenfyBlack)),
                    resources.getString(R.string.idenfy_document_camera_preview_session_message_part_0_document_type_default
                    )))
            builder.append(setColoredSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, R.color.idenfyWhite)), " $docPart "))
            builder.append(setColoredSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, R.color.idenfyBlack)),
                    resources.getString(R.string.idenfy_document_camera_preview_session_message_part_2_document_type_default
                    )))
            return builder
        }
    }

    private fun setColoredSpan(color: ForegroundColorSpan, string: String): SpannableString {
        val spanStr = SpannableString(string)
        spanStr.setSpan(color, 0, spanStr.length, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE)
        return spanStr
    }

    private fun setupCustomTypeFace(typeface: Typeface?, typeFaceBold: Typeface?) {
        if (typeFaceBold == null) {
            return
        }
        backTextView!!.typeface = typeFaceBold
        documentBorderTextView!!.typeface = typeFaceBold
        documentTitleTutorial!!.typeface = typeFaceBold
    }

    private fun setupCustomUI() {
        if (activity == null) {
            return
        }
        if (cameraViewModel.partnerInfo != null && cameraViewModel.partnerInfo!!.canUpload!!) {
            uploadImageButton?.visibility = View.VISIBLE
        } else {
            uploadImageButton?.visibility = View.GONE
        }
        if (shouldShowInstructions)
            documentTitleTutorial!!.setTextColor(ContextCompat.getColor(activity!!, R.color.idenfyWhite))
        else
            documentTitleTutorial!!.setTextColor(ContextCompat.getColor(activity!!, R.color.idenfyBlack))
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
            if (shouldShowInstructions)
                DrawableCompat.setTint(backImage!!.drawable, ContextCompat.getColor(activity!!,
                        R.color.idenfyWhite))
            else
                DrawableCompat.setTint(backImage!!.drawable, ContextCompat.getColor(activity!!,
                        R.color.idenfyDocumentsCameraSessionBackArrowColor))

        } else {
            if (shouldShowInstructions)
                backImage!!.drawable.mutate().setColorFilter(ContextCompat.getColor(activity!!,
                        R.color.idenfyWhite), PorterDuff.Mode.SRC_IN)
            else
                backImage!!.drawable.mutate().setColorFilter(ContextCompat.getColor(activity!!,
                        R.color.idenfyDocumentsCameraSessionBackArrowColor), PorterDuff.Mode.SRC_IN)
        }
        if (shouldShowInstructions)
            backTextView!!.setTextColor(resources.getColor(R.color.idenfyWhite))
        else
            backTextView!!.setTextColor(resources.getColor(R.color.idenfyDocumentsCameraSessionBackTextViewColor))
    }

    private fun setUpUIDynamicSizes() {

        topSheetBehavior = TopSheetBehavior.from(topSheet!!)
        if(shouldShowInstructions) {
            instructionDynamicSizeManager?.setUpUIDynamicSizes(context!!, instructionText!!, instructionTitle!!, viewPager!!)
        }
    }

    private fun setUpInstructions() {

        val viewPagerDots = rootView!!.findViewById<TabLayout>(R.id.idenfy_tabLayout_instructions_viewpager_dots)

        instructionPagerAdapter = InstructionPagerAdapter(childFragmentManager, instructionList!!, instructionTitle!!, instructionText!!, instructionList!!.size)
        viewPager!!.offscreenPageLimit = instructionList!!.size + 1
        viewPager!!.pageMargin = dpToPx(20)
        viewPager!!.adapter = instructionPagerAdapter
        viewPagerDots.setupWithViewPager(viewPager, true)

        if (instructionViewModel.getCurrentInstructionEnum() !== InstructionEnum.INSTRUCTION_NOT_NEEDED) {
            slideDownInstructionsHandler.postDelayed({ topSheetBehavior?.state = TopSheetBehavior.STATE_EXPANDED }, 500)
        }
    }

    /**
     * Method sets back button and session title visibilities
     * going from fragment without instructions to the one with(i.e. from passport cover to passport front)
     */
    private fun setUpViews(resIdArray: IntArray?) {
        if (shouldShowInstructions) {
            backButton = rootView!!.findViewById(R.id.backImage)
            backTextViewDefault = rootView!!.findViewById(R.id.back_text_view)
            backButton!!.visibility = View.GONE
            backTextViewDefault!!.visibility = View.GONE
        } else {
            topSheet!!.visibility = View.GONE
            backButton = rootView!!.findViewById(R.id.backImage)
            backTextViewDefault = rootView!!.findViewById(R.id.back_text_view)
            backButton!!.visibility = View.VISIBLE
            backTextViewDefault!!.visibility = View.VISIBLE
        }
        if (instructionViewModel.getCurrentInstructionEnum() === InstructionEnum.PASSPORT) {
            backButton!!.visibility = View.GONE
            backTextViewDefault!!.visibility = View.GONE
            topSheet!!.visibility = View.VISIBLE
            documentTitleTutorial!!.visibility = View.GONE
            documentTitleTutorial = rootView!!.findViewById(R.id.camera_session_information_text_view_with_instructions)
            documentTitleTutorial!!.visibility = View.VISIBLE
            if (resIdArray!![1] == 0) {
                documentTitleTutorial!!.text = resources.getString(resIdArray[0])
            } else {
                documentTitleTutorial!!.text = getDefaultTitle(resources.getString(resIdArray[1]))
            }
            documentTitleTutorial!!.setTextColor(Color.WHITE)
            backTextView!!.setTextColor(Color.WHITE)
            DrawableCompat.setTint(backImage!!.drawable, ContextCompat.getColor(activity!!,
                    R.color.idenfyWhite))
            slideDownInstructionsHandler.postDelayed({ topSheetBehavior!!.state = TopSheetBehavior.STATE_EXPANDED }, 500)
        }

    }

    /**
     * Method sets viewpager's button positions (visibility) according to the current page
     */
    private fun setInstructionButtonPositions(shouldReset:Boolean = false) {
        if (instructionList == null)
            return

        //resets to initial position
        if(shouldReset)
        {
            nextPageButton!!.visibility = View.VISIBLE
            previousPageButton!!.visibility = View.INVISIBLE
            return
        }

        if (viewPager!!.currentItem == instructionList!!.size - 1) {
            nextPageButton!!.visibility = View.INVISIBLE
            previousPageButton!!.visibility = View.VISIBLE
        }

        else if (viewPager!!.currentItem == 0) {
            nextPageButton!!.visibility = View.VISIBLE
            previousPageButton!!.visibility = View.INVISIBLE
        }

        else {
            nextPageButton!!.visibility = View.VISIBLE
            previousPageButton!!.visibility = View.VISIBLE
        }
    }

    private fun getNextPossibleItemIndex(change: Int): Int {

        val currentIndex = viewPager!!.currentItem
        val total = viewPager!!.adapter!!.count

        return if (currentIndex + change < 0) {
            0
        } else Math.abs((currentIndex + change) % total)

    }

    private fun dpToPx(dp: Int): Int {
        val displayMetrics = activity!!.resources.displayMetrics
        return Math.round(dp * (displayMetrics.xdpi / DisplayMetrics.DENSITY_DEFAULT))
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        val selectedImage = data!!.data
        if (activity != null) {
            try {
                val bitmap = MediaStore.Images.Media.getBitmap(activity!!.contentResolver, selectedImage)
                val photo = BitmapPhoto(bitmap, 0)
                showPhoto(photo, true)
            } catch (e: IOException) {
                e.printStackTrace()
            }

        }
    }

}
