package com.idenfy.idenfySdk.Networking;

import com.idenfy.idenfySdk.Networking.Models.PhotoPost;
import com.idenfy.idenfySdk.Networking.Models.PresignedUrlModel;
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponseInternal;
import com.idenfy.idenfysdk.core.models.documentTypeData.DocumentType;
import com.idenfy.idenfysdk.core.networking.models.requestBodies.AuthTokenRequest;
import com.idenfy.idenfysdk.core.networking.models.requestBodies.CountrySetRequest;
import com.idenfy.idenfysdk.core.networking.models.requestBodies.DocumentTypeRequest;
import com.idenfy.idenfysdk.core.networking.models.requestBodies.S3RequestData;
import com.idenfy.idenfysdk.core.networking.models.requestBodies.SetDeviceTypeForAPI;
import com.idenfy.idenfysdk.core.networking.models.requestBodies.StreamPost;
import com.idenfy.idenfysdk.core.networking.models.responseBodies.CountryCode;
import com.idenfy.idenfysdk.core.networking.models.responseBodies.PartnerInfo;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import io.reactivex.Single;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PartMap;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;

public interface APIService {

    @Headers("Content-Type: application/json")
    @POST("identification/start-process")
    Observable<ResponseBody> startProcessObservable(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("token/start-session")
    Observable<ResponseBody> startSessionObservable(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("document/set")
    Observable<ResponseBody> setDocumentTypeObservable(
            @Body DocumentTypeRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("storage/store/stream")
    Observable<ResponseBody> streamPhotoNewObservable(
            @Body StreamPost moment
    );

    @Headers("Content-Type: application/json")
    @POST("storage/store/upload")
    Observable<ResponseBody> streamUploadPhotoNewObservable(
            @Body StreamPost moment
    );

    @Multipart
    @POST
    Observable<Response<ResponseBody>> streamBackgroundPhotosObservable(
            @PartMap() Map<String, RequestBody> partMap, @Url String url
    );

    @Headers("Content-Type: application/json")
    @POST("/storage/url/videozip")
    Observable<PresignedUrlModel> getBackgroundPhotoPostUrl(
            @Body PhotoPost photoPost
    );

    @Headers("Content-Type: application/json")
    @POST("identification/get/result")
    Call<AuthenticationResultResponseInternal> checkAuthenticationStatus(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("identification/get/result")
    Observable<AuthenticationResultResponseInternal> checkAuthenticationStatusObservable(
            @Body AuthTokenRequest rawJson
    );


    @Headers("Content-Type: application/json")
    @POST("partner/info")
    Observable<PartnerInfo> getPartnerInfoObservable(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("partner/info")
    Single<PartnerInfo> getPartnerInfoSingle(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("identification/get/can-retry")
    Call<ResponseBody> checkIfCanRetry(
            @Body AuthTokenRequest rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("identification/set/country")
    Observable<ResponseBody> setIssuingCountryObservable(
            @Body CountrySetRequest rawJson
    );

    @GET("other/geoip-country")
    Call<CountryCode> getCountryByIPAd(
    );

    @GET("other/geoip-country")
    Single<CountryCode> getCountryByIPObservable(
    );

    @GET("other/geoip-country")
    Single<CountryCode> getCountryByIPAdObservable(
    );

    @GET("other/geoip-country")
    Observable<CountryCode> getCountryByIPAdObservableNew(
    );

    @GET("document/list")
    Call<List<DocumentType>> getDocumentsTypes(
            @Query("authToken") String auhToken
    );

    @GET("document/list")
    Single<List<DocumentType>> getDocumentsTypesObservable(
            @Query("authToken") String auhToken
    );


    @Headers("Content-Type: application/json")
    @POST("document/set")
    Call<ResponseBody> setDocumentType(
            @Body Map<String, String> rawJson
    );

    @Headers("Content-Type: application/json")
    @POST("identification/set/platform")
    Call<SetDeviceTypeForAPI> setDeviceTypeForAPI(
            @Body SetDeviceTypeForAPI deviceTypeForAPI
    );

    @Headers("Content-Type: application/json")
    @POST("identification/set/platform")
    Single<SetDeviceTypeForAPI> setDeviceTypeForAPIObservable(
            @Body SetDeviceTypeForAPI deviceTypeForAPI
    );

    @POST("doc-data/{est}/set")
    Observable<ResponseBody> uploadDocReadingInfo(
            @Path("est") String estKey, @Body String data
    );

    @Headers("Content-Type: application/json")
    @POST("storage/url/stream")
    Observable<com.idenfy.idenfysdk.core.networking.models.requestBodies.PresignedUrlModel> getS3UploadDataForStream(
            @Body S3RequestData requestData
    );

    @Headers("Content-Type: application/json")
    @POST("storage/url/upload")
    Observable<com.idenfy.idenfysdk.core.networking.models.requestBodies.PresignedUrlModel> getS3UploadDataForUpload(
            @Body S3RequestData requestData
    );

    @POST
    @Multipart
    @Headers("Connection: close")
    Observable<Response<ResponseBody>> uploadPhotoToS3(
            @PartMap() Map<String, RequestBody> partMap,
            @Url String url
    );
}
