package com.idenfy.idenfySdk.identificationresults.ui.view

import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.content.Context
import android.os.Bundle
import android.os.Handler
import android.support.v4.app.FragmentActivity
import android.support.v4.content.ContextCompat
import android.support.v7.app.AlertDialog
import android.support.v7.app.AppCompatDelegate
import android.support.v7.widget.AppCompatImageView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.ImageView
import android.widget.ProgressBar
import android.widget.TextView
import com.bumptech.glide.Glide
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyIdentificationResultsSettings
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyResultsSubtitleUISettings
import com.idenfy.idenfySdk.Networking.Resource
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponseInternal
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.ErrorMessage
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyError
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse
import com.idenfy.idenfySdk.identificationresults.ui.viewmodel.ResultViewModel
import com.idenfy.idenfySdk.core.ui.viewmodel.CameraViewModel
import com.idenfy.idenfySdk.helpers.IdenfyIdentificationStatus
import com.idenfy.idenfySdk.helpers.enums.FontEnum
import com.idenfy.idenfySdk.identificationresults.presentation.state.IdentificationResultsUIViewModelState
import com.idenfy.idenfySdk.identificationresults.presentation.state.IdentificationResultsUploadedPhotosState
import com.idenfy.idenfySdk.identificationresults.presentation.uiviewmodel.IdentificationResultsUIViewModel
import com.idenfy.idenfysdk.core.domain.networkrepo.ErrorsHelper
import com.idenfy.idenfysdk.core.extensions.livedataextensions.ViewLifecycleFragment
import com.idenfy.idenfysdk.core.logging.LoggingHelper
import com.idenfy.idenfysdk.core.models.documentTypeData.Step
import com.idenfy.idenfysdk.core.networking.Status
import com.idenfySdk.R
import kotlinx.android.synthetic.main.idenfy_identification_resuts_with_steps_for_all_types_fragment_layout.*
import java.util.*


class AuthenticationResultFragment : ViewLifecycleFragment() {
    private var mFragmentClosedListener: OnAuthenticationResultFragmentClosed? = null
    private var retakeStepsListListener: RetakeStepsListListener? = null
    private lateinit var cameraViewModel: CameraViewModel
    private lateinit var resultViewModel: ResultViewModel
    private var buttonClicked: Boolean = false
    private var btnClose: Button? = null

    private var backPhotoPlaceHolder: ImageView? = null
    private var frontPhotoPlaceHolder: ImageView? = null
    private var facePhotoPlaceHolder: ImageView? = null
    private var backProgressBar: ProgressBar? = null
    private var faceProgressBar: ProgressBar? = null
    private var frontProgressBar: ProgressBar? = null
    private var customLoadingProgressSpinner: ImageView? = null
    private var customResultsImageView: AppCompatImageView? = null
    private var authenticationStatusTextView: TextView? = null
    private var tvIdentificationResultsDescription: TextView? = null
    private var tvAdditionalInformationDescription: TextView? = null
    private var materialProgressBar: ProgressBar? = null
    private var uploadProgressBar: ProgressBar? = null
    private var tvFrontInfo: TextView? = null
    private var tvBackInfo: TextView? = null
    private var tvFaceInfo: TextView? = null
    private var identificationStatusSubtitle: TextView? = null
    private var rewievingStatusDialog: AlertDialog? = null

    private var legacyDrawableErrorId = 0
    private var legacyDrawableSuccessId = 0
    private var legacyDrawableLoadingId = 0

    private var progressBarHideDuration: Long = 900
    private var progressBarHideDelay: Long = 300
    private val MAX_PROGRESS = 100


    private var errorOccured = false


    override fun onCreate(savedInstanceState: Bundle?) {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true)
        super.onCreate(savedInstanceState)
        cameraViewModel = ViewModelProviders.of(activity!!).get(CameraViewModel::class.java)
        resultViewModel = ViewModelProviders.of(activity!!).get(ResultViewModel::class.java)
    }

    private var authenticationResultsObserver = Observer<Resource<AuthenticationResultResponseInternal>> { response ->

        if (response != null) {
            if (response.status == Status.LOADING) {
                handleSubtitle(response.status, IdenfyController.getInstance().settings.idenfyUISettings.idenfyIdentificationResultsUISettings.idenfyResultsSubtitleUISettings)
                startProgressIndicators()
            } else if (response.status == Status.SUCCESS) {

                if (response.data != null) {
                    handleStepsLoading(response.data)
                    if (response.data.processingStatus != null && response.data.processingStatus.equals("FINISHED", ignoreCase = true)) {

                        cameraViewModel.savedIdentificationResultResponse = response.data
                        resultViewModel.hasRetakeStarted = true
                        cameraViewModel.repository.identificationResultsUIViewModel.uploadedPhotosStatesDictionary.clear()
                        if (!response.data.identificationStatus.equals(IdenfyIdentificationStatus.REVIEWING.status, ignoreCase = true))
                            handleFinishedLoading(response.data)
                        materialProgressBar?.visibility = View.INVISIBLE
                        if (response.data.identificationStatus != null) {
                            handleIdentificationStatus(response.data, IdenfyController.getInstance().settings.idenfyIdentificationResultsSettings, IdenfyController.getInstance().settings.idenfyUISettings.idenfyIdentificationResultsUISettings.idenfyResultsSubtitleUISettings)
                        }

                    }
                }
            }
        }

    }
    private var idenfyErrorObserver =
            Observer<IdenfyError> { response ->

                if (response != null) {
                    errorOccured = true
                    if (IdenfyController.getInstance().settings.idenfyIdentificationResultsSettings.isErrorResultsViewVisible) {
                        showIdenfyError(ErrorsHelper.getErrorMessageFromIdentifier(activity!!, response.idenfyErrorResponse.identifier))
                    }
                }

            }


    private fun initializeUI(view: View) {
        backPhotoPlaceHolder = view.findViewById(R.id.back_pr_bar_place_holder)
        materialProgressBar = view.findViewById(R.id.horizontal_progress_bar)
        uploadProgressBar = view.findViewById(R.id.idenfy_progress_bar_additional_information_progress)
        customLoadingProgressSpinner = view.findViewById(R.id.custom_loading_spinner)
        customResultsImageView = view.findViewById(R.id.custom_results_image_view)
        tvBackInfo = view.findViewById(R.id.back_photo_text_view)
        tvFrontInfo = view.findViewById(R.id.front_document_text_view)
        tvFaceInfo = view.findViewById(R.id.face_photo_text_view)
        frontPhotoPlaceHolder = view.findViewById(R.id.front_pr_bar_place_holder)
        facePhotoPlaceHolder = view.findViewById(R.id.face_pr_bar_place_holder)
        authenticationStatusTextView = view.findViewById(R.id.titleTextView)
        tvIdentificationResultsDescription = view.findViewById(R.id.descriptionTextView)
        tvAdditionalInformationDescription = view.findViewById(R.id.idenfy_tv_identification_results_additional_information_description)
        backProgressBar = view.findViewById(R.id.progressBarBack)
        faceProgressBar = view.findViewById(R.id.progressBarFace)
        frontProgressBar = view.findViewById(R.id.progressBarFront)
        btnClose = view.findViewById(R.id.btnClose)
        btnClose?.visibility = View.INVISIBLE
    }


    private fun observeAuthenticationResponse() {
        cameraViewModel.authenticationResultResponseLiveData.observe(viewLifecycleOwner!!, authenticationResultsObserver)
    }


    private fun observeResults() {
        val settings = cameraViewModel.idenfySettings ?: return
        if(!settings.idenfyUISettings.idenfyIdentificationResultsUISettings.isAdditionalUploadingInformationVisible)
        {
            uploadProgressBar?.visibility = View.GONE
            return

        }
        resultViewModel.identificationResultMediatorLiveData.observe(viewLifecycleOwner!!, Observer { response ->

            if (response == null || errorOccured) {
                return@Observer
            }
            when(response)
            {
                is IdentificationResultsUIViewModelState.InProgress->{
                    var loadingUpdated = false;
                    for (key in response.data.uploadedPhotosStatesDictionary.keys) {
                        val dictionaryData = response.data.uploadedPhotosStatesDictionary[key]
                        when (key) {
                            Step.PASSPORT_COVER.toString(), Step.FRONT.toString(), Step.BACK.toString(), Step.FACE.toString(),
                            Step.LIVENESS.toString(), Step.UTILITY_BILL.toString() -> {
                                when (dictionaryData) {
                                    is IdentificationResultsUploadedPhotosState.Success -> {
                                        updateUploadingInformationLoadingSuccess()
                                    }
                                    is IdentificationResultsUploadedPhotosState.Loading -> {
                                        updateUploadingInformationLoadingState(dictionaryData.data)
                                        loadingUpdated = true;
                                    }
                                }
                            }
                        }
                        if(loadingUpdated) break
                    }
                    updateProgressOfUploadedDocuments(response.data)
                }
                is IdentificationResultsUIViewModelState.UploadsFinished->{
                   updateProgressOfUploadedDocuments(response.data)
                }
                is IdentificationResultsUIViewModelState.Reset->{
                    tvAdditionalInformationDescription?.visibility = View.INVISIBLE
                    uploadProgressBar?.visibility = View.INVISIBLE
                }
            }
        })

    }
    private fun updateProgressOfUploadedDocuments(data:IdentificationResultsUIViewModel){
        idenfy_progress_bar_additional_information_progress?.progress = data.progressOfSuccess
        if(data.progressOfSuccess==MAX_PROGRESS){
            hideResultsAdditionalView()
        }
        else{
            tvAdditionalInformationDescription?.visibility = View.VISIBLE
            uploadProgressBar?.visibility = View.VISIBLE
        }
    }
    private fun hideResultsAdditionalView(){
        Handler().postDelayed({
            tvAdditionalInformationDescription?.animate()?.alpha(0f)?.duration = progressBarHideDuration
            uploadProgressBar?.animate()?.alpha(0f)?.duration = progressBarHideDuration
                Handler().postDelayed({
                    cameraViewModel.resetIdentificationResultsUIState()
                },progressBarHideDuration)

        }, progressBarHideDelay)
    }
    private fun updateUploadingInformationLoadingState(stringId:Int){
        tvAdditionalInformationDescription?.visibility = View.VISIBLE
        tvAdditionalInformationDescription?.alpha = 1.0f
        tvAdditionalInformationDescription?.text = resources.getString(stringId)
    }

    private fun updateUploadingInformationLoadingSuccess(){
        tvAdditionalInformationDescription?.visibility = View.VISIBLE
        tvAdditionalInformationDescription?.alpha = 1.0f
    }
    private fun updateUploadingInformationLoadingError(){
        tvAdditionalInformationDescription?.visibility = View.INVISIBLE
        tvAdditionalInformationDescription?.alpha = 0.0f
    }

    private fun handleFinishedLoading(data: AuthenticationResultResponseInternal) {
        if (data.retakeSteps.front == null) {
            if (frontProgressBar?.visibility == View.VISIBLE) {
                frontProgressBar?.visibility = View.INVISIBLE
            }
            if (legacyDrawableErrorId != 0)
                frontPhotoPlaceHolder?.setImageResource(legacyDrawableErrorId)
            else
                frontPhotoPlaceHolder?.setImageResource(R.drawable.idenfy_ic_identification_results_error_spinner_state)
        }
        if (data.retakeSteps.back == null) {
            if (backProgressBar?.visibility == View.VISIBLE) {
                backProgressBar?.visibility = View.INVISIBLE
            }
            if (legacyDrawableErrorId != 0)
                backPhotoPlaceHolder?.setImageResource(legacyDrawableErrorId)
            else
                backPhotoPlaceHolder?.setImageResource(R.drawable.idenfy_ic_identification_results_error_spinner_state)

        }
        if (data.retakeSteps.face == null) {
            if (faceProgressBar?.visibility == View.VISIBLE) {
                faceProgressBar?.visibility = View.INVISIBLE
            }
            if (legacyDrawableErrorId != 0)
                facePhotoPlaceHolder?.setImageResource(legacyDrawableErrorId)
            else
                facePhotoPlaceHolder?.setImageResource(R.drawable.idenfy_ic_identification_results_error_spinner_state)
        }

    }

    private fun handleIdentificationStatus(response: AuthenticationResultResponseInternal, idenfyIdentificationResultsSettings: IdenfyIdentificationResultsSettings, idenfyResultsSubtitleUISettings: IdenfyResultsSubtitleUISettings) {
        if (response.identificationStatus.equals(IdenfyIdentificationStatus.APPROVED.status, ignoreCase = true)) {
            if (idenfyIdentificationResultsSettings.isSuccessResultsViewVisible) {
                handleSubtitle(Status.SUCCESS, idenfyResultsSubtitleUISettings)
                showSuccess("")
            }
            cameraViewModel.setIdentificationSuccessResponse(response)
        } else if (response.identificationStatus.equals(IdenfyIdentificationStatus.DENIED.status, ignoreCase = true)) {
            val sDefSystemLanguage = Locale.getDefault().language
            if (response.errorMessage != null) {
                if (idenfyIdentificationResultsSettings.isRetryErrorResultsViewVisible) {

                    if (!idenfyIdentificationResultsSettings.isErrorResultsViewVisible) {
                        if (response.attemptsLeft == "0") {
                            response.errorMessage = ErrorMessage("Too many attempts!",
                                    "Per daug bandymų!", "Слишком много попыток!", "Zbyt wiele prób!")
                            cameraViewModel.setIdentificationSuccessResponse(response)
                            return
                        }
                    }
                    handleSubtitle(Status.ERROR, idenfyResultsSubtitleUISettings)
                    handleErrorMessage(sDefSystemLanguage, response.errorMessage, response)
                } else {
                    cameraViewModel.setIdentificationSuccessResponse(response)
                }
            }
        } else if (response.identificationStatus.equals(IdenfyIdentificationStatus.SUSPECTED.status, ignoreCase = true)) {
            if (idenfyIdentificationResultsSettings.isErrorResultsViewVisible) {
                showIdenfyError(null)
                handleSubtitle(Status.SUCCESS, idenfyResultsSubtitleUISettings)
            }
            cameraViewModel.setIdentificationSuccessResponse(response)
        } else if (response.identificationStatus.equals(IdenfyIdentificationStatus.REVIEWING.status, ignoreCase = true)) {
            showManualReviewingDialog(response)
        } else {

            cameraViewModel.savedIdentificationResultResponse = null
            if (idenfyIdentificationResultsSettings.isErrorResultsViewVisible) {
                showIdenfyError(null)
                handleSubtitle(Status.ERROR, idenfyResultsSubtitleUISettings)
            }
            cameraViewModel.setIdenfyError(IdenfyError(IdenfyErrorResponse(ErrorsHelper.IDENFY_SERVER_ERROR_IDENTIFIER,
                    ErrorsHelper.getErrorMessageFromIdentifier(activity, ErrorsHelper.IDENFY_SERVER_ERROR_IDENTIFIER))))

        }

    }

    private fun showManualReviewingDialog(response: AuthenticationResultResponseInternal) {

        if (activity == null) {
            return
        }
        val builder = AlertDialog.Builder(activity!!)

        builder.setTitle(activity!!.resources.getString(R.string.idenfy_alert_title_manual_reviewing_information))
        builder.setMessage(activity!!.resources.getString(R.string.idenfy_alert_message_manual_reviewing_information))

        builder.setPositiveButton(activity!!.resources.getString(R.string.idenfy_alert_positive_button_manual_reviewing_information)) { dialog, which ->
            makeProgressBarsInvisible()
            cameraViewModel.identificationSuccessResponse.value = response
            dialog.dismiss()
        }
        rewievingStatusDialog = builder.create()
        rewievingStatusDialog?.show()
        rewievingStatusDialog?.setCancelable(false)
        rewievingStatusDialog?.getButton(AlertDialog.BUTTON_POSITIVE)?.setTextColor(resources.getColor(R.color.idenfyColorAccent))
    }

    private fun observeIdenfyError() {
        cameraViewModel.idenfyError.observe(viewLifecycleOwner!!, idenfyErrorObserver)
    }

    private fun checkIfShouldSetupThreeSpinners(stepsList: List<String>): Boolean {
        return (stepsList.contains("FACE") && stepsList.contains("FRONT") && stepsList.contains("BACK"))
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        var view: View? = null

        if (!IdenfyController.getInstance().settings.isCustomIdentificationLayout) {

            if (cameraViewModel.currentDocumentClass == null) {
                val legacy_all_types_results_id = context!!.resources.getIdentifier("authentication_resut_with_steps_id", "layout", context!!.packageName)
                view = if (legacy_all_types_results_id == 0) {
                    inflater.inflate(R.layout.idenfy_identification_resuts_with_steps_for_all_types_fragment_layout, container, false)
                } else {
                    inflater.inflate(legacy_all_types_results_id, container, false)
                }
            } else {
                if (checkIfShouldSetupThreeSpinners(cameraViewModel.currentDocumentClass!!.originalStepList)) {
                    val legacy_all_types_results_id = context!!.resources.getIdentifier("authentication_resut_with_steps_id", "layout", context!!.packageName)
                    view = if (legacy_all_types_results_id == 0) {
                        inflater.inflate(R.layout.idenfy_identification_resuts_with_steps_for_all_types_fragment_layout, container, false)
                    } else {
                        inflater.inflate(legacy_all_types_results_id, container, false)
                    }
                } else {
                    val legacy_passport_results_id = context!!.resources.getIdentifier("authentication_resut_with_steps_passport", "layout", context!!.packageName)
                    view = if (legacy_passport_results_id == 0) {
                        inflater.inflate(R.layout.idenfy_identification_results_with_steps_for_passport_fragment_layout, container, false)
                    } else {
                        inflater.inflate(legacy_passport_results_id, container, false)
                    }
                }

            }
        } else {
            val legacy_custom_results_id = context!!.resources.getIdentifier("fragment_identification_results_custom_view", "layout", context!!.packageName)
            view = if (legacy_custom_results_id == 0) {
                inflater.inflate(R.layout.idenfy_identification_results_custom_fragment_layout, container, false)
            } else {
                inflater.inflate(legacy_custom_results_id, container, false)
            }
            identificationStatusSubtitle = view.findViewById(R.id.idenfy_identification_results_subtitle)
        }
        initializeUI(view!!)
        return view
    }


    private fun handleStepsLoading(data: AuthenticationResultResponseInternal) {

        if (data.retakeSteps.front != null && !data.retakeSteps.front) {
            frontProgressBar?.visibility = View.INVISIBLE
            if (legacyDrawableErrorId != 0)
                frontPhotoPlaceHolder?.setImageResource(legacyDrawableErrorId)
            else
                frontPhotoPlaceHolder?.setImageResource(R.drawable.idenfy_ic_identification_results_error_spinner_state)
        }
        if (data.retakeSteps.front != null && data.retakeSteps.front!!) {
            frontProgressBar?.visibility = View.INVISIBLE
            if (legacyDrawableSuccessId != 0)
                frontPhotoPlaceHolder?.setImageResource(legacyDrawableSuccessId)
            else
                frontPhotoPlaceHolder?.setImageResource(R.drawable.idenfy_ic_identification_results_success_spinner_state)
        }
        if (data.retakeSteps.face != null && !data.retakeSteps.face) {
            faceProgressBar?.visibility = View.INVISIBLE
            if (legacyDrawableErrorId != 0)
                facePhotoPlaceHolder?.setImageResource(legacyDrawableErrorId)
            else
                facePhotoPlaceHolder?.setImageResource(R.drawable.idenfy_ic_identification_results_error_spinner_state)
        }
        if (data.retakeSteps.face != null && data.retakeSteps.face!!) {
            faceProgressBar?.visibility = View.INVISIBLE
            if (legacyDrawableSuccessId != 0)
                facePhotoPlaceHolder?.setImageResource(legacyDrawableSuccessId)
            else
                facePhotoPlaceHolder?.setImageResource(R.drawable.idenfy_ic_identification_results_success_spinner_state)
        }
        if (data.retakeSteps.back != null && !data.retakeSteps.back) {
            backProgressBar?.visibility = View.INVISIBLE
            if (legacyDrawableErrorId != 0)
                backPhotoPlaceHolder?.setImageResource(legacyDrawableErrorId)
            else
                backPhotoPlaceHolder?.setImageResource(R.drawable.idenfy_ic_identification_results_error_spinner_state)
        }
        if (data.retakeSteps.back != null && data.retakeSteps.back!!) {
            backProgressBar?.visibility = View.INVISIBLE
            if (legacyDrawableSuccessId != 0)
                backPhotoPlaceHolder?.setImageResource(legacyDrawableSuccessId)
            else
                backPhotoPlaceHolder?.setImageResource(R.drawable.idenfy_ic_identification_results_success_spinner_state)
        }

    }

    private fun handleSubtitle(status: Status, subtitleUISettings: IdenfyResultsSubtitleUISettings) {
        if (status == Status.LOADING) {

            identificationStatusSubtitle?.text = subtitleUISettings.loadingSubtitle
            if (subtitleUISettings.isVisibleOnLoading)
                identificationStatusSubtitle?.visibility = View.VISIBLE
            else {
                if (subtitleUISettings.visibilitySetAsGone)
                    identificationStatusSubtitle?.visibility = View.GONE
                else if (subtitleUISettings.visibilitySetAsInvisible) {
                    identificationStatusSubtitle?.visibility = View.INVISIBLE
                }
            }
        } else if (status == Status.SUCCESS) {
            identificationStatusSubtitle?.text = subtitleUISettings.successSubtitle
            if (subtitleUISettings.isVisibleOnSuccess) {
                identificationStatusSubtitle?.visibility = View.VISIBLE
            } else {
                if (subtitleUISettings.visibilitySetAsGone)
                    identificationStatusSubtitle?.visibility = View.GONE
                else if (subtitleUISettings.visibilitySetAsInvisible) {
                    identificationStatusSubtitle?.visibility = View.INVISIBLE
                }
            }
        } else if (status == Status.ERROR) {
            identificationStatusSubtitle?.text = subtitleUISettings.errorSubtitle
            if (subtitleUISettings.isVisibleOnError)
                identificationStatusSubtitle?.visibility = View.VISIBLE
            else {
                if (subtitleUISettings.visibilitySetAsGone)
                    identificationStatusSubtitle?.visibility = View.GONE
                else if (subtitleUISettings.visibilitySetAsInvisible) {
                    identificationStatusSubtitle?.visibility = View.INVISIBLE
                }
            }
        }
    }


    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        legacyDrawableErrorId = context!!.resources.getIdentifier("ic_idenfy_spinner_error", "drawable", context!!.packageName)
        legacyDrawableLoadingId = context!!.resources.getIdentifier("ic_idenfy_spinner_loading", "drawable", context!!.packageName)
        legacyDrawableSuccessId = context!!.resources.getIdentifier("ic_idenfy_spinner_success", "drawable", context!!.packageName)
        observeAuthenticationResponse()
        observeIdenfyError()
        observeResults()
        cameraViewModel.setNextButtonVisibility(true)
        uploadProgressBar?.scaleY = 4f
        if (IdenfyController.getInstance().settings != null) {
            val idenfySettings = IdenfyController.getInstance().settings
            tvIdentificationResultsDescription?.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)
            authenticationStatusTextView?.typeface = idenfySettings.getIdenfyBold(FontEnum.DEFAULT_BOLD)
            tvBackInfo?.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)
            tvFrontInfo?.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)
            tvFaceInfo?.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)

        }
    }

    private fun startProgressIndicators() {
        if (customLoadingProgressSpinner != null) {
            if (IdenfyController.getInstance().settings.customResultsViewSpinner != null) {
                try {
                    Glide.with(Objects.requireNonNull<FragmentActivity>(activity))
                            .load(IdenfyController.getInstance().settings.customResultsViewSpinner)
                            .into(customLoadingProgressSpinner!!)
                } catch (e: Exception) {
                    e.printStackTrace()
                }

            }
        }
        backProgressBar?.visibility = View.VISIBLE
        frontProgressBar?.visibility = View.VISIBLE
        faceProgressBar?.visibility = View.VISIBLE

        if (legacyDrawableLoadingId != 0) {
            frontPhotoPlaceHolder?.setImageResource(legacyDrawableLoadingId)
            backPhotoPlaceHolder?.setImageResource(legacyDrawableLoadingId)
            facePhotoPlaceHolder?.setImageResource(legacyDrawableLoadingId)

        }

    }

    private fun showSuccess(response: String) {
        authenticationStatusTextView?.text = resources.getString(R.string.idenfy_identification_results_title_identification_status_success)
        cameraViewModel.setAuthenticationSuccessForClosing(true)
        if (customResultsImageView != null && customLoadingProgressSpinner != null) {
            customLoadingProgressSpinner?.visibility = View.GONE
            customResultsImageView?.setBackgroundDrawable(ContextCompat.getDrawable(Objects.requireNonNull<FragmentActivity>(activity), R.drawable.idenfy_ic_identification_results_custom_success_spinner_state))

        }
    }

    override fun onStart() {
        super.onStart()
        LoggingHelper.LogLifecycleInfo("onStartAuthenticationResults")
    }

    override fun onResume() {
        super.onResume()
        LoggingHelper.LogLifecycleInfo("onResumeAuthenticationResults")
    }

    override fun onStop() {
        super.onStop()
        LoggingHelper.LogLifecycleInfo("onStoptAuthenticationResults")
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null
    }

    override fun onDestroy() {
        super.onDestroy()
        LoggingHelper.LogLifecycleInfo("onDestroyidentificationResultsFragment")
    }

    private fun showError(response: String, authenticationResultResponse: AuthenticationResultResponseInternal) {

        customResultsImageView?.setImageDrawable(ContextCompat.getDrawable(activity!!, R.drawable.idenfy_ic_identification_results_custom_error_spinner_state))
        customLoadingProgressSpinner?.visibility = View.GONE

        btnClose?.visibility = View.VISIBLE
        val legacyButtonTitleId = resources.getIdentifier("thank_repeat", "string", context!!.packageName)
        if (legacyButtonTitleId != 0) {
            btnClose?.text = resources.getString(legacyButtonTitleId)
        } else {
            btnClose?.text = resources.getString(R.string.idenfy_identification_results_proceed_button_title)
        }
        authenticationStatusTextView?.setText(R.string.idenfy_identification_results_title_identification_status_error)
        tvIdentificationResultsDescription?.visibility = View.VISIBLE
        tvIdentificationResultsDescription?.alpha = 1f
        tvIdentificationResultsDescription?.text = response
        uploadProgressBar?.visibility = View.GONE
        btnClose?.setOnClickListener(View.OnClickListener {
            buttonClicked = true
            if (!IdenfyController.getInstance().settings.idenfyIdentificationResultsSettings.isRetryingIdentificationAvailable) {
                cameraViewModel.setIdentificationSuccessResponse(authenticationResultResponse)
                return@OnClickListener
            }
            if (authenticationResultResponse.attemptsLeft.equals("0", ignoreCase = true)) {
                if (activity != null)
                    cameraViewModel.setIdenfyError(IdenfyError(IdenfyErrorResponse(ErrorsHelper.TOO_MANY_REATTEMPTS_IDENTIFIER,
                            ErrorsHelper.getErrorMessageFromIdentifier(activity!!, ErrorsHelper.TOO_MANY_REATTEMPTS_IDENTIFIER)),
                            false))
                return@OnClickListener
            } else {
                retakeStepsListListener?.onRetakeStepsList(true)
            }
        })
    }

    private fun makeProgressBarsInvisible() {
        backProgressBar?.visibility = View.INVISIBLE
        frontProgressBar?.visibility = View.INVISIBLE
        faceProgressBar?.visibility = View.INVISIBLE
    }

    private fun changeStateOfAllSpinnersToError() {
        if (legacyDrawableErrorId != 0)
            facePhotoPlaceHolder?.setImageResource(legacyDrawableErrorId)
        else
            facePhotoPlaceHolder?.setImageResource(R.drawable.idenfy_ic_identification_results_error_spinner_state)
        if (legacyDrawableErrorId != 0)
            backPhotoPlaceHolder?.setImageResource(legacyDrawableErrorId)
        else
            backPhotoPlaceHolder?.setImageResource(R.drawable.idenfy_ic_identification_results_error_spinner_state)
        if (legacyDrawableErrorId != 0)
            frontPhotoPlaceHolder?.setImageResource(legacyDrawableErrorId)
        else
            frontPhotoPlaceHolder?.setImageResource(R.drawable.idenfy_ic_identification_results_error_spinner_state)
    }

    private fun showIdenfyError(response: String?) {
        updateUploadingInformationLoadingError()
        customResultsImageView?.setImageDrawable(ContextCompat.getDrawable(activity!!, R.drawable.idenfy_ic_identification_results_custom_error_spinner_state))
        changeStateOfAllSpinnersToError()
        customLoadingProgressSpinner?.visibility = View.GONE
        makeProgressBarsInvisible()
        btnClose?.visibility = View.INVISIBLE
        materialProgressBar?.visibility = View.INVISIBLE
        authenticationStatusTextView?.setText(R.string.idenfy_identification_results_title_identification_status_error)
        tvIdentificationResultsDescription?.visibility = View.VISIBLE
        tvIdentificationResultsDescription?.alpha = 1f
        tvIdentificationResultsDescription?.text = response
        uploadProgressBar?.visibility = View.GONE
    }

    override fun onPause() {
        super.onPause()
        LoggingHelper.LogLifecycleInfo("onPauseAuthenticationResults")
    }

    private fun handleErrorMessage(sDefSystemLanguage: String, errorMessage: ErrorMessage, response: AuthenticationResultResponseInternal) {
        when (sDefSystemLanguage) {
            "en" -> showError(errorMessage.en, response)
            "lt" -> showError(errorMessage.lt, response)
            "ru" -> showError(errorMessage.ru, response)
            "pl" -> showError(errorMessage.pl, response)
            else -> showError(errorMessage.en, response)
        }
    }

    override fun onAttach(context: Context?) {
        if (context is OnAuthenticationResultFragmentClosed) {
            mFragmentClosedListener = context
        }
        if (context is RetakeStepsListListener) {
            retakeStepsListListener = context
        }
        super.onAttach(context)

    }

    override fun onDetach() {
        super.onDetach()
        mFragmentClosedListener = null
    }


    interface OnAuthenticationResultFragmentClosed {
        fun onAuthenticationResultFragmentClosed(closed: Boolean)
    }

    interface RetakeStepsListListener {
        fun onRetakeStepsList(value: Boolean?)
    }

}
