package com.idenfy.idenfySdk.facecamerasession.ui.view


import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.content.Intent
import android.graphics.PorterDuff
import android.graphics.RectF
import android.graphics.Typeface
import android.os.Build
import android.os.Bundle
import android.os.Handler
import android.provider.MediaStore
import android.support.constraint.ConstraintLayout
import android.support.design.widget.TabLayout
import android.support.v4.content.ContextCompat
import android.support.v4.graphics.drawable.DrawableCompat
import android.support.v4.view.ViewPager
import android.support.v7.app.AppCompatDelegate
import android.support.v7.widget.AppCompatButton
import android.support.v7.widget.AppCompatImageButton
import android.text.SpannableString
import android.text.SpannableStringBuilder
import android.text.Spanned
import android.text.style.ForegroundColorSpan
import android.util.DisplayMetrics
import android.util.Log
import android.util.Pair
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySDKLoggingSettings
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyError
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse
import com.idenfy.idenfySdk.sharedcamerasession.ui.model.CameraSessionImageResultSize
import com.idenfy.idenfySdk.sharedcamerasession.ui.utils.BitmapPhotoCropper
import com.idenfy.idenfySdk.facecamerasession.ui.utils.FaceCameraFrameProcessor
import com.idenfy.idenfySdk.instructions.ui.utils.InstructionDynamicSizeManager
import com.idenfy.idenfySdk.instructions.ui.adapter.InstructionPagerAdapter
import com.idenfy.idenfySdk.instructions.ui.utils.TopSheetBehavior
import com.idenfy.idenfySdk.instructions.ui.viewmodel.InstructionViewModel
import com.idenfy.idenfySdk.core.ui.view.CameraPreviewActivity
import com.idenfy.idenfySdk.core.ui.view.CameraPreviewActivity.Companion.FACE_CAMERA_SESSION_REQUEST_CODE
import com.idenfy.idenfySdk.core.ui.viewmodel.CameraViewModel
import com.idenfy.idenfySdk.liveness.LivenessesViewModel
import com.idenfy.idenfySdk.liveness.presentation.LivenessSessionNotInitialized
import com.idenfy.idenfySdk.liveness.presentation.LivenessSessionNotSuccessfulNeedsAutoRetry
import com.idenfy.idenfySdk.liveness.presentation.LivenessSessionNotSuccessfulNeedsUserRetry
import com.idenfy.idenfySdk.liveness.presentation.LivenessSessionNotSuccessfulWithoutRetries
import com.idenfy.idenfyliveness.Result
import com.idenfy.idenfysdk.core.common.presentation.models.InstructionEnum
import com.idenfy.idenfysdk.core.domain.networkrepo.ErrorsHelper
import com.idenfy.idenfysdk.core.extensions.livedataextensions.ViewLifecycleFragment
import com.idenfy.idenfysdk.core.extensions.livedataextensions.observeOnce
import com.idenfy.idenfysdk.core.logging.LoggingHelper
import com.idenfy.idenfysdk.core.models.InstructionModel
import com.idenfy.idenfysdk.core.ui.uihelpers.CameraViewSize
import com.idenfySdk.R
import io.fotoapparat.Fotoapparat
import io.fotoapparat.configuration.CameraConfiguration
import io.fotoapparat.parameter.AntiBandingMode
import io.fotoapparat.parameter.FocusMode
import io.fotoapparat.parameter.Resolution
import io.fotoapparat.parameter.ScaleType
import io.fotoapparat.preview.FrameProcessor
import io.fotoapparat.result.BitmapPhoto
import io.fotoapparat.selector.*
import io.fotoapparat.view.CameraView
import java.util.*

class FaceCameraSessionFragment : ViewLifecycleFragment() {
    private var fotoapparat: Fotoapparat? = null
    private var viewPager: ViewPager? = null
    private var expandArrow: ImageView? = null
    private var nextPageButton: ImageView? = null
    private var previousPageButton: ImageView? = null
    private var donePageButton: ImageView? = null
    private var instructionText: TextView? = null
    private var instructionTitle: TextView? = null
    private var topSheetBehavior: TopSheetBehavior<*>? = null
    private var topSheet: ConstraintLayout? = null
    private var topSheetLayout: ConstraintLayout? = null
    private var instructionPagerAdapter: InstructionPagerAdapter? = null
    private var cameraView: CameraView? = null
    private lateinit var cameraViewModel: CameraViewModel
    private lateinit var instructionViewModel: InstructionViewModel
    private lateinit var livenessesViewModel: LivenessesViewModel
    private var documentTitleTutorial: TextView? = null
    private var takePictureButton: AppCompatImageButton? = null
    private var uploadImageButton: AppCompatButton? = null
    private var frameProcessor: FaceCameraFrameProcessor? = null
    private var instructionDynamicSizeManager: InstructionDynamicSizeManager? = null

    private lateinit var faceAndShouldersOverlay: ImageView

    private val backgroundPhotoHandler = Handler()

    private var imageView: ImageView? = null
    private var documentBorderTextView: TextView? = null
    private var rootView: View? = null
    private var backImage: ImageView? = null
    private var backTextView: TextView? = null
    private var backImageDefault: ImageView? = null
    private var backTextViewDefault: TextView? = null

    private var instructionList: List<InstructionModel>? = null
    private var shouldShowInstructions: Boolean = false


    private var cameraConfiguration: CameraConfiguration? = null
    //Handlers
    private val slideDownInstructionsHandler = Handler()
    //View drawings values
    private val rectangleLeft: Int = 0
    private val rectangleTop: Int = 0
    private val rectangleRight: Int = 0
    private val rectangleBottom: Int = 0
    private val heightOfImage: Int = 0
    private val yCoordinateOfHeightStart: Int = 0
    private val widthOfImage: Int = 0
    private val xCoordinateOfWidthStart: Int = 0

    private var liveness_mask_preview: View? = null
    private var instructions_liveness_mask_preview: View? = null


    private val livenessRetryHandler = Handler()


    internal var topSheetBehaviorCallback: TopSheetBehavior.TopSheetCallback = object : TopSheetBehavior.TopSheetCallback() {
        override fun onStateChanged(bottomSheet: View, newState: Int) {

            if (rootView == null)
                return
            if(shouldShowInstructions) {
                val cameraSessionTitle = rootView!!.findViewById<TextView>(R.id.camera_session_information_text_view_with_instructions)
                if (newState == TopSheetBehavior.STATE_COLLAPSED) {
                    expandArrow!!.setImageResource(R.drawable.idenfy_ic_instructions_arrow_expand_more)
                    cameraSessionTitle.visibility = View.VISIBLE
                    instructionText!!.visibility = View.INVISIBLE
                    backTextView!!.visibility = View.VISIBLE
                    backImage!!.visibility = View.VISIBLE
                    takePictureButton!!.visibility = View.VISIBLE
                    topSheet?.setBackgroundResource(R.drawable.idenfy_custom_drawable_instructions_background_rounded_corners)
                    if (cameraViewModel.partnerInfo != null && cameraViewModel.partnerInfo!!.canUpload)
                        uploadImageButton?.visibility = View.VISIBLE
                    topSheet?.isClickable = false
                } else if (newState == TopSheetBehavior.STATE_EXPANDED) {
                    topSheetBehavior!!.state = TopSheetBehavior.STATE_EXPANDED
                    expandArrow!!.setImageResource(R.drawable.idenfy_ic_instructions_arrow_expand_less)
                    cameraSessionTitle.visibility = View.GONE
                    instructionText!!.visibility = View.VISIBLE
                    donePageButton!!.visibility = View.GONE
                    backTextView!!.visibility = View.GONE
                    backImage!!.visibility = View.GONE
                    takePictureButton!!.visibility = View.INVISIBLE
                    uploadImageButton?.visibility = View.INVISIBLE
                    topSheet?.setBackgroundResource(R.drawable.idenfy_custom_drawable_instructions_background_without_rounded_corners)
                    topSheet?.isClickable = true
                }
            }

        }

        override fun onSlide(bottomSheet: View, slideOffset: Float, isOpening: Boolean?) {
            if (rootView == null)
                return
            if(shouldShowInstructions) {
                val cameraSessionTitle = rootView!!.findViewById<TextView>(R.id.camera_session_information_text_view_with_instructions)

                if (isOpening != null) {
                    if (isOpening) {
                        if (slideOffset > 0.7) {
                            topSheetBehavior!!.state = TopSheetBehavior.STATE_EXPANDED
                            expandArrow!!.setImageResource(R.drawable.idenfy_ic_instructions_arrow_expand_less)
                            cameraSessionTitle.visibility = View.GONE
                            instructionText!!.visibility = View.VISIBLE
                            donePageButton!!.visibility = View.GONE
                            backTextView!!.visibility = View.GONE
                            backImage!!.visibility = View.GONE
                            takePictureButton!!.visibility = View.INVISIBLE
                            uploadImageButton?.visibility = View.INVISIBLE
                            topSheet?.setBackgroundResource(R.drawable.idenfy_custom_drawable_instructions_background_without_rounded_corners)
                            topSheet?.isClickable = true
                        }
                    } else {
                        if (slideOffset <= 0.3) {
                            topSheetBehavior!!.state = TopSheetBehavior.STATE_COLLAPSED
                            expandArrow!!.setImageResource(R.drawable.idenfy_ic_instructions_arrow_expand_more)
                            cameraSessionTitle.visibility = View.VISIBLE
                            instructionText!!.visibility = View.INVISIBLE
                            backTextView!!.visibility = View.VISIBLE
                            backImage!!.visibility = View.VISIBLE
                            takePictureButton!!.visibility = View.VISIBLE
                            topSheet?.setBackgroundResource(R.drawable.idenfy_custom_drawable_instructions_background_rounded_corners)
                            if (cameraViewModel.partnerInfo != null && cameraViewModel.partnerInfo!!.canUpload)
                                uploadImageButton?.visibility = View.VISIBLE
                            topSheet?.isClickable = false
                        }
                    }
                }
            }
        }
    }

    private val cameraPreviewSize: CameraViewSize
        get() = CameraViewSize(cameraView!!.width, cameraView!!.height)


    var ratio = -1.0

    override fun onCreate(savedInstanceState: Bundle?) {

        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true)
        super.onCreate(savedInstanceState)
        livenessesViewModel = ViewModelProviders.of(activity!!).get(LivenessesViewModel::class.java)
        instructionViewModel = ViewModelProviders.of(Objects.requireNonNull(activity!!)).get(InstructionViewModel::class.java)
        cameraViewModel = ViewModelProviders.of(Objects.requireNonNull(activity!!)).get(CameraViewModel::class.java)
        instructionDynamicSizeManager = InstructionDynamicSizeManager()
        LoggingHelper.LogLifecycleInfo("onFaceSessionOnCreate")
    }


    private fun setFotoapparatCameraSettings(frameProcessor: FrameProcessor) {
        cameraConfiguration = CameraConfiguration
                .builder()
                .previewFpsRange(highestFps())
                .sensorSensitivity(highestSensorSensitivity())
                .frameProcessor(frameProcessor)
                .antiBandingMode(firstAvailable<Iterable<AntiBandingMode>, AntiBandingMode>(
                        auto(),
                        hz60(),
                        hz50(),
                        none()
                ))
                .focusMode(firstAvailable<Iterable<FocusMode>, FocusMode>(
                        continuousFocusPicture(),
                        continuousFocusVideo(),
                        autoFocus(),
                        fixed()
                ))
                .build()
    }

    private fun initializeUI(rootView: View, withInstructions: Boolean) {
        viewPager = rootView.findViewById(R.id.idenfy_view_pager_instructions)
        expandArrow = rootView.findViewById(R.id.idenfy_iv_instructions_expand_top_layout)
        nextPageButton = rootView.findViewById(R.id.idenfy_iv_instructions_next_page_button)
        previousPageButton = rootView.findViewById(R.id.idenfy_iv_instructions_previous_page_button)
        donePageButton = rootView.findViewById(R.id.idenfy_iv_instructions_done_button)
        topSheet = rootView.findViewById(R.id.idenfy_constraintLayout_instructions_top_sheet_root)
        topSheetLayout = rootView.findViewById(R.id.idenfy_instructions_top_sheet_layout)
        instructionText = rootView.findViewById(R.id.idenfy_tv_instructions_current_instruction_content)
        instructionTitle = rootView.findViewById(R.id.idenfy_tv_instructions_current_instruction_title)
        cameraView = rootView.findViewById(R.id.idenfy_camera_view_face_camera_preview_session)
        documentTitleTutorial = rootView.findViewById(R.id.camera_session_information_text_view)
        takePictureButton = rootView.findViewById(R.id.takePictureButton)
        backImage = rootView.findViewById(R.id.backImage)
        backTextView = rootView.findViewById(R.id.back_text_view)

        //SHAPE
        imageView = rootView.findViewById(R.id.imageView)
        documentBorderTextView = rootView.findViewById(R.id.document_overlay_title)
        liveness_mask_preview = rootView.findViewById(R.id.idenfy_view_liveness_mask_preview)
        instructions_liveness_mask_preview = rootView.findViewById(R.id.idenfy_view_instructions_liveness_mask_preview)

        faceAndShouldersOverlay = rootView.findViewById(R.id.face_shoulder_overlay)

        if(withInstructions){
            backImage = rootView.findViewById(R.id.backImage_instructions)
            backTextView = rootView.findViewById(R.id.back_text_view_instructions)
            documentTitleTutorial = rootView.findViewById(R.id.camera_session_information_text_view_with_instructions)
            backImageDefault = rootView.findViewById(R.id.backImage)
            backImageDefault!!.visibility = View.GONE
            backTextViewDefault = rootView.findViewById(R.id.back_text_view)
            backTextViewDefault!!.visibility = View.GONE
        }
        else{
            backImage = rootView.findViewById(R.id.backImage)
            backTextView = rootView.findViewById(R.id.back_text_view)
            documentTitleTutorial = rootView.findViewById(R.id.camera_session_information_text_view)
        }


    }


    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {

        rootView = inflater.inflate(R.layout.idenfy_face_camera_preview_session_fragment_with_instructions, container, false)
        if (cameraViewModel.currentStepUIViewModelLiveData.value != null && cameraViewModel.currentStepUIViewModelLiveData.value!!.instrcutionEnum !== InstructionEnum.INSTRUCTION_NOT_NEEDED) {
            shouldShowInstructions = true
            initializeUI(rootView!!, shouldShowInstructions)
        } else {
            initializeUI(rootView!!, shouldShowInstructions)
            topSheet!!.visibility = View.GONE
        }
        return rootView
    }


    private fun observeDocumentType() {

        cameraViewModel.currentStepUIViewModelLiveData.observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null) {
                setupDocumentTitle(response.sessionInformationTitle)
                setupDocumentView(response.documentCameraFrameRatio)
                instructionViewModel?.setCurrentInstructionEnum(response.instrcutionEnum)

                if (shouldShowInstructions) {
                    if (context != null) {
                        instructionViewModel?.createInstructionModelList(context!!)
                        instructionViewModel?.instructionModelList!!.observe(viewLifecycleOwner!!, Observer { instructionModels ->
                            instructionList = instructionModels
                            setUpInstructions()
                        })
                    }
                }

            }
        })
    }

    private fun setupDocumentTitle(resIdArray: IntArray) {
        val titleId: Int?
        if (resIdArray[1] == 0) {
            documentTitleTutorial!!.text = resources.getString(resIdArray[0])
        } else {
            documentTitleTutorial!!.text = getDefaultTitle(resources.getString(resIdArray[1]))
        }

    }

    private fun startBackgroundPhotoTaking() {
        if (cameraViewModel.partnerInfo!!.recordIdentification!!)
            backgroundPhotoHandler.post(object : Runnable {
                override fun run() {
                    frameProcessor!!.takeBackgroundPicture { bitmap, rotation, encoded -> cameraViewModel.addBackgroundPhoto(bitmap) }
                    backgroundPhotoHandler.postDelayed(this, 250)
                }

            })
    }


    private fun observeUI() {
        cameraViewModel.actionButtonVisibility.observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null)
                takePictureButton!!.visibility = if (response) View.VISIBLE else View.INVISIBLE
        })
        cameraViewModel.cropShapeImageView.observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null)
                imageView!!.visibility = if (response) View.VISIBLE else View.INVISIBLE
        })
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        cameraViewModel.setUploadPictureButtonAvailability(true)
        cameraViewModel.setTakePictureButtonAvailability(true)
        setupCustomUI()

    }

    fun setupDocumentView(document: Float) {
        setupImageView(document)


    }


    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        setUpUIDynamicSizes()
        val ic_idenfy_shoulder_face_overlayLegacy = context!!.resources.getIdentifier("ic_idenfy_shoulder_face_overlay", "drawable", context!!.packageName)
        if (ic_idenfy_shoulder_face_overlayLegacy != 0)
            faceAndShouldersOverlay.setImageDrawable(
                    ContextCompat.getDrawable(activity!!, ic_idenfy_shoulder_face_overlayLegacy))
        val takePhotoButtonIvLegacy = context!!.resources.getIdentifier("idenfy_make_photo", "drawable", context!!.packageName)
        if (takePhotoButtonIvLegacy != 0) {
            takePictureButton?.setImageDrawable(
                    ContextCompat.getDrawable(activity!!, takePhotoButtonIvLegacy))
        }
        pictureButtonOnClickListener()
        if (IdenfyController.getInstance().settings != null) {
            val idenfySettings = IdenfyController.getInstance().settings
            val typeface = idenfySettings.customRegularFont
            val typefaceBold = idenfySettings.customBoldTypeFace
            setupCustomTypeFace(typeface, typefaceBold)
        }

        livenessesViewModel.zoomSessionResponse.observe(viewLifecycleOwner!!, Observer livenessesViewModel@{ response ->
            if (response != null) {
                if (IdenfyController.getInstance().settings != null && IdenfyController.getInstance().settings.sdkLogging == IdenfySDKLoggingSettings.IdenfySDKLoggingEnum.FULL)
                    Log.d(IdenfySDKLoggingSettings.IdenfySDKLoggingConstants.idenfyLivenessFeatureLogging, "liveness UI state: $response")
                when (response) {
                    is LivenessSessionNotSuccessfulNeedsAutoRetry -> {

                        changeVisibilityOfLivenessPreview(true)
                        livenessRetryHandler.postDelayed({
                            if (activity != null)
                                livenessesViewModel.initializeZoomSDK(activity, true)
                        }, 1000)

                        livenessesViewModel.zoomSessionResponse.value = LivenessSessionNotInitialized(false, null, false)
                    }
                    is LivenessSessionNotSuccessfulWithoutRetries -> {
                        changeVisibilityOfLivenessPreview(true)
                        if (activity != null)
                            cameraViewModel.setIdenfyError(IdenfyError(IdenfyErrorResponse(ErrorsHelper.FACE_LIVENESSS_ERROR_IDENTIFIER,
                                    ErrorsHelper.getErrorMessageFromIdentifier(activity!!, ErrorsHelper.FACE_LIVENESSS_ERROR_IDENTIFIER)),
                                    true, 1200))
                    }
                    is LivenessSessionNotSuccessfulNeedsUserRetry -> {
                        changeVisibilityOfLivenessPreview(false)

                        initializeCameraPreview()
                        livenessesViewModel.zoomSessionResponse.value = LivenessSessionNotInitialized(false, null, false)
                    }

                }

            }
        })

        backTextView!!.setOnClickListener { onBackPressed() }
        backImage!!.setOnClickListener {
            onBackPressed()
        }
        observeUI()
        observeButtonsAvailability()
        observeDocumentType()
        observeButtonClicks()
        cameraViewModel.setTakePictureButtonAvailability(true)
        cameraViewModel.setTakePictureButtonAvailability(true)
        LoggingHelper.LogLifecycleInfo("onFaceSessionActivityCreated")


    }

    private fun observeButtonClicks() {
        cameraViewModel.getNextButtonPressed().observe(viewLifecycleOwner!!, Observer { aBoolean ->
            if (aBoolean != null) {
                if (aBoolean) {
                    startBackgroundPhotoTaking()
                }
            }
        })

        cameraViewModel.getRetakeButtonPressed().observe(viewLifecycleOwner!!, Observer { aBoolean ->
            if (aBoolean != null) {
                if (aBoolean) {
                    startBackgroundPhotoTaking()
                }
            }
        })
        if (shouldShowInstructions) {
            topSheetBehavior!!.setTopSheetCallback(topSheetBehaviorCallback)

            nextPageButton!!.setOnClickListener {
                if (viewPager!!.currentItem == 0) {
                    previousPageButton!!.visibility = View.INVISIBLE
                } else {
                    previousPageButton!!.visibility = View.VISIBLE
                }
                if (viewPager!!.currentItem == instructionPagerAdapter!!.count - 2) {
                    nextPageButton!!.visibility = View.GONE
                    donePageButton!!.visibility = View.VISIBLE

                } else {
                    nextPageButton!!.visibility = View.VISIBLE
                    donePageButton!!.visibility = View.GONE
                }
                viewPager!!.setCurrentItem(getNextPossibleItemIndex(1), true)
            }

            previousPageButton!!.setOnClickListener {
                viewPager!!.setCurrentItem(getNextPossibleItemIndex(-1), true)
                if (viewPager!!.currentItem == 0) {
                    previousPageButton!!.visibility = View.INVISIBLE
                } else {
                    previousPageButton!!.visibility = View.VISIBLE
                }
                nextPageButton!!.visibility = View.VISIBLE
            }

            donePageButton!!.setOnClickListener { topSheetBehavior!!.state = TopSheetBehavior.STATE_COLLAPSED }

            viewPager!!.addOnPageChangeListener(object : ViewPager.OnPageChangeListener {
                override fun onPageScrolled(position: Int, positionOffset: Float, positionOffsetPixels: Int) {

                }

                override fun onPageSelected(position: Int) {
                    instructionTitle!!.text = instructionList!![position].instructionTitle
                    instructionText!!.text = instructionList!![position].instructionText
                    if (position == 0) {
                        previousPageButton!!.visibility = View.INVISIBLE
                    } else {
                        previousPageButton!!.visibility = View.VISIBLE
                    }
                    if (position == instructionPagerAdapter!!.count - 1) {
                        nextPageButton!!.visibility = View.GONE
                        donePageButton!!.visibility = View.VISIBLE

                    } else {
                        nextPageButton!!.visibility = View.VISIBLE
                        donePageButton!!.visibility = View.GONE
                    }
                }

                override fun onPageScrollStateChanged(state: Int) {}
            })

            expandArrow!!.setOnClickListener {
                if (topSheetBehavior!!.state == TopSheetBehavior.STATE_EXPANDED) {
                    topSheetBehavior!!.setState(TopSheetBehavior.STATE_COLLAPSED)
                } else {
                    topSheetBehavior!!.setState(TopSheetBehavior.STATE_EXPANDED)
                }
            }


            cameraViewModel.faceRetakeButtonPressed.observe(viewLifecycleOwner!!, Observer { aBoolean ->
                if (aBoolean != null) {
                    if (aBoolean) {
                        viewPager!!.currentItem = 0
                        slideDownInstructionsHandler.removeCallbacksAndMessages(null)
                        setInstructionButtonPositions(true)
                    }
                }
            })
        }
    }

    private fun observeButtonsAvailability() {

        cameraViewModel.getUploadPictureButtonAvailability().observe(viewLifecycleOwner!!, Observer { aBoolean ->
            if (aBoolean != null) {
                uploadImageButton?.isEnabled = aBoolean
            }
        })
    }


    private fun setupImageView(uploadDocumentPhotoType: Float) {
        val params = imageView!!.layoutParams as ConstraintLayout.LayoutParams
        val parent = imageView!!.parent as ConstraintLayout
        val horizontalMargin = parent.width
        val verticalMargin = parent.height
        params.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin)
        imageView!!.layoutParams = params

    }


    private fun pictureButtonOnClickListener() {
        takePictureButton!!.setOnClickListener {
            cameraViewModel.setNextButtonAvailability(false)
            cameraViewModel.setRecreateButtonAvailability(false)
            cameraViewModel.setTakePictureButtonAvailability(false)
            if (activity != null) {
                takePicture()
            }
        }
        uploadImageButton?.setOnClickListener {
            backgroundPhotoHandler.removeCallbacksAndMessages(null)
            cameraViewModel.setNextButtonAvailability(false)
            cameraViewModel.setRecreateButtonAvailability(false)
            cameraViewModel.setUploadPictureButtonAvailability(false)
            cameraViewModel.setSaveFragments(true)
            var mediaStoreIntent = Intent(Intent.ACTION_PICK,
                    android.provider.MediaStore.Images.Media.EXTERNAL_CONTENT_URI)
            activity?.startActivityForResult(mediaStoreIntent, FACE_CAMERA_SESSION_REQUEST_CODE)

        }


    }


    private fun takePicture() {
        if (fotoapparat != null) {
            frameProcessor!!.takePicture { bitmap, rotation, encoded ->
                val photo = BitmapPhoto(bitmap, rotation)
                showPhoto(photo, false)
            }
        }
    }

    private fun showPhoto(bitmapPhoto: BitmapPhoto, isImageUploaded: Boolean) {
        if (activity != null) {
            requireActivity().runOnUiThread(Runnable {
                if (activity == null || cameraView == null || cameraViewModel.currentDocumentClass == null) {
                    return@Runnable
                }
                if (fotoapparat != null && cameraViewModel.partnerInfo != null && cameraViewModel.partnerInfo!!.zoomLiveliness!!) {
                    fotoapparat!!.stop()
                }

                val result = BitmapPhotoCropper.cropPhotoWithPaddings(bitmapPhoto, cameraPreviewSize, RectF(xCoordinateOfWidthStart.toFloat(), yCoordinateOfHeightStart.toFloat(), widthOfImage.toFloat(), heightOfImage.toFloat()),
                        ratio)
                val uploadDocumentPhotoType = CameraSessionImageResultSize(result, cameraViewModel.currentDocumentStep,
                        rectangleRight, rectangleLeft, rectangleTop, rectangleBottom, isImageUploaded = isImageUploaded)
                if (cameraViewModel.hasPartnerEnabledZoom) {
                    cameraViewModel.savedFacePhotoBitmap = result
                    livenessesViewModel.zoomSDKInicializationResponse.observeOnce(viewLifecycleOwner!!, Observer<Result<Pair<Boolean, String>>> { response ->
                        if (response != null) {
                            if (response is Result.Success) {
                                if (response.data.first) {
                                    initializeZoomLogin()
                                } else {
                                    if (activity != null)
                                        cameraViewModel.setIdenfyError(IdenfyError(IdenfyErrorResponse(ErrorsHelper.FACE_LIVENESSS_ERROR_IDENTIFIER,
                                                ErrorsHelper.getErrorMessageFromIdentifier(activity!!, ErrorsHelper.FACE_LIVENESSS_ERROR_IDENTIFIER)),
                                                true, 1200))
                                }
                            }

                        } else {
                        }
                    })
                } else {
                    if (cameraViewModel.partnerInfo != null && cameraViewModel.partnerInfo!!.zoomLiveliness == true) {
                        cameraViewModel.setIdenfyError(IdenfyError(IdenfyErrorResponse(ErrorsHelper.LIVENESS_SDK_NOT_INTEGRATED,
                                "Liveness SDK module not integrated in the app module. Check documentation for integrating liveness SDK"),
                                true, 1200))
                    } else {
                        cameraViewModel.setDocumentPhotoResultMutableLiveData(uploadDocumentPhotoType)
                        cameraViewModel.setaddFacePhotoResultFragment(true)
                    }
                }
            })


        }
    }


    private fun initializeZoomLogin() {
        changeVisibilityOfLivenessPreview(true)
        livenessesViewModel.startActivityForResult(activity as CameraPreviewActivity)

    }


    override fun onDestroy() {
        super.onDestroy()
        LoggingHelper.LogLifecycleInfo("onDestriyFaceCameraSessionFragment")

    }

    private fun getDefaultTitle(docPart: String): SpannableStringBuilder {
        val builder = SpannableStringBuilder()
        if (activity == null) {
            builder.append("")
            return builder
        }
        builder.append(setColoredSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, R.color.idenfyBlack)),
                resources.getString(R.string.idenfy_document_camera_preview_session_message_part_0_document_type_default
                )))
        builder.append(setColoredSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, R.color.idenfyWhite)), " $docPart "))
        builder.append(setColoredSpan(ForegroundColorSpan(ContextCompat.getColor(activity!!, R.color.idenfyBlack)),
                resources.getString(R.string.idenfy_document_camera_preview_session_message_part_2_document_type_default
                )))
        return builder
    }

    private fun setColoredSpan(color: ForegroundColorSpan, string: String): SpannableString {
        val spanStr = SpannableString(string)
        spanStr.setSpan(color, 0, spanStr.length, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE)
        return spanStr
    }

    override fun onPause() {
        super.onPause()
        fotoapparat!!.stop()
        cameraViewModel.setFaceRetakeButtonPressed(false)
        cameraViewModel.setNextButtonPressed(false)
        cameraViewModel.setRetakeButtonPressed(false)
        LoggingHelper.LogLifecycleInfo("onPauseFaceCameraSessionFragment")
    }

    override fun onStop() {
        super.onStop()
        LoggingHelper.LogLifecycleInfo("onStopFaceCameraSessionFragment")
    }


    override fun onStart() {
        super.onStart()
        if (activity != null) {
            frameProcessor = FaceCameraFrameProcessor(activity)
            setFotoapparatCameraSettings(frameProcessor!!)
        }
        setupCamera()
        LoggingHelper.LogLifecycleInfo("onStartFaceCameraSessionFragment")

    }

    override fun onResume() {
        super.onResume()
        if (shouldShowInstructions)
            setInstructionButtonPositions()

        initializeCameraPreview()
        LoggingHelper.LogLifecycleInfo("onResumeFaceCameraSessionFragment")


    }

    private fun initializeCameraPreview() {
        Handler().postDelayed({
            if (fotoapparat != null) {
                //initializing multiple times, errorCallback is not thrown.
                fotoapparat?.start()
                fotoapparat?.start()
                fotoapparat?.start()

                startBackgroundPhotoTaking()
            }
        }, 100)
    }

    override fun onDestroyView() {
        LoggingHelper.onDestroyView(FaceCameraSessionFragment::class.java.simpleName)
        super.onDestroyView()
        if (topSheetBehavior != null)
            topSheetBehavior!!.setTopSheetCallback(null)
        cameraView = null
        fotoapparat = null
        backTextView = null
        backImage = null
        backImageDefault = null
        backTextViewDefault = null
        documentTitleTutorial = null
        takePictureButton = null
        (activity as CameraPreviewActivity).setSupportActionBar(null)
        imageView = null
        documentBorderTextView = null
        rootView = null
        backgroundPhotoHandler.removeCallbacksAndMessages(null)
        livenessRetryHandler.removeCallbacksAndMessages(null)
    }

    private fun setupCamera() {
        val activity = activity
        if (isAdded && activity != null) {
            fotoapparat = Fotoapparat
                    .with(getActivity()!!)
                    .into(cameraView!!)
                    .previewScaleType(ScaleType.CenterCrop)
                    .previewResolution(firstAvailable<Iterable<Resolution>, Resolution>(highestResolution(), lowestResolution()))
                    .lensPosition(front())
                    .focusMode(firstAvailable<Iterable<FocusMode>, FocusMode>(
                            continuousFocusPicture(),
                            continuousFocusVideo(),
                            autoFocus(),
                            fixed()
                    ))
                    .photoResolution(firstAvailable<Iterable<Resolution>, Resolution>(highestResolution(), lowestResolution()))
                    .frameProcessor(frameProcessor)
                    .cameraErrorCallback { e ->
                        if (cameraViewModel.checkIfCanRetryFaceCamera())
                            cameraViewModel.setAddFaceCameraFragment(true)
                        else
                            cameraViewModel.setAddFaceCameraFragment(false)
                    }
                    .build()

        }

    }


    private fun onBackPressed() {
        (activity as CameraPreviewActivity).onBackPressed()

    }

    private fun setupCustomTypeFace(typeface: Typeface?, typeFaceBold: Typeface?) {
        if (typeFaceBold == null) {
            return
        }
        backTextView!!.typeface = typeFaceBold
        documentTitleTutorial!!.typeface = typeFaceBold
    }

    private fun setupCustomUI() {
        if (activity == null) {
            return
        }
        if (cameraViewModel.partnerInfo != null && cameraViewModel.partnerInfo!!.canUpload) {
            uploadImageButton?.visibility = View.VISIBLE
        } else {
            uploadImageButton?.visibility = View.GONE
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
            DrawableCompat.setTint(backImage!!.drawable, ContextCompat.getColor(activity!!,
                    R.color.idenfyFaceSessionCameraBackArrowColor))

        } else {
            backImage!!.drawable.mutate().setColorFilter(ContextCompat.getColor(activity!!,
                    R.color.idenfyFaceSessionCameraBackArrowColor), PorterDuff.Mode.SRC_IN)
        }
        backTextView!!.setTextColor(resources.getColor(R.color.idenfyFaceSessionBackTextViewColor))
        documentTitleTutorial!!.setTextColor(ContextCompat.getColor(activity!!, R.color.idenfyFaceCameraSessionInformationTextViewColor))
    }

    private fun setUpUIDynamicSizes() {

        topSheetBehavior = TopSheetBehavior.from(topSheet!!)
        if(shouldShowInstructions) {
            instructionDynamicSizeManager?.setUpUIDynamicSizes(context!!, instructionText!!, instructionTitle!!, viewPager!!)
        }
    }

    private fun changeVisibilityOfLivenessPreview(isVisible: Boolean) {
        if (isVisible) {
            liveness_mask_preview?.visibility = View.VISIBLE
            instructions_liveness_mask_preview?.visibility = View.VISIBLE
        } else {
            liveness_mask_preview?.visibility = View.GONE
            instructions_liveness_mask_preview?.visibility = View.GONE
        }
    }

    /**
     * Presents instructions fragment
     */
    private fun setUpInstructions() {

        val viewPagerDots = rootView!!.findViewById<TabLayout>(R.id.idenfy_tabLayout_instructions_viewpager_dots)

        instructionPagerAdapter = InstructionPagerAdapter(childFragmentManager, instructionList!!, instructionTitle!!, instructionText!!, instructionList!!.size)
        viewPager!!.offscreenPageLimit = instructionList!!.size
        viewPager!!.pageMargin = dpToPx(20)
        viewPager!!.adapter = instructionPagerAdapter
        viewPagerDots.setupWithViewPager(viewPager, true)

        slideDownInstructionsHandler.postDelayed({ topSheetBehavior?.state = TopSheetBehavior.STATE_EXPANDED }, 500)
    }

    /**
     * Method sets viewpager's button positions (visibility) according to the current page
     */
    private fun setInstructionButtonPositions(shouldReset:Boolean = false) {
        if (instructionList == null)
            return
        //resets to initial position
        if(shouldReset)
        {
            nextPageButton!!.visibility = View.VISIBLE
            previousPageButton!!.visibility = View.INVISIBLE
            return
        }

        if (viewPager!!.currentItem == instructionList!!.size - 1) {
            nextPageButton!!.visibility = View.INVISIBLE
            previousPageButton!!.visibility = View.VISIBLE
        } else if (viewPager!!.currentItem == 0) {
            nextPageButton!!.visibility = View.VISIBLE
            previousPageButton!!.visibility = View.INVISIBLE
        } else {
            nextPageButton!!.visibility = View.VISIBLE
            previousPageButton!!.visibility = View.VISIBLE
        }
    }

    private fun getNextPossibleItemIndex(change: Int): Int {

        val currentIndex = viewPager!!.currentItem
        val total = Objects.requireNonNull(viewPager!!.adapter)!!.count

        return if (currentIndex + change < 0) {
            0
        } else Math.abs((currentIndex + change) % total)

    }

    fun dpToPx(dp: Int): Int {
        val displayMetrics = activity!!.resources.displayMetrics
        return Math.round(dp * (displayMetrics.xdpi / DisplayMetrics.DENSITY_DEFAULT))
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        val selectedImage = data?.data
        if (activity == null || selectedImage == null)
            return
        try {
            val bitmap = MediaStore.Images.Media.getBitmap(activity!!.contentResolver, selectedImage)
            val bitmapPhoto = BitmapPhoto(bitmap, 0)
            showPhoto(bitmapPhoto, true)
        } catch (e: Exception) {

        }
    }


}

