package com.idenfy.idenfySdk.countriesselection.ui.model;


public enum CountryEnum {
    AF("Afghanistan (‫افغانستان‬‎)", "af", "AFG"),
    AX("Åland Islands (Åland)", "ax", "ALA"),
    AL("Albania (Shqipëri)", "AL", "ALB"),
    DZ("Algeria (‫الجزائر‬‎)", "DZ", "DZA"),
    AS("American Samoa", "AS", "ASM"),
    AD("Andorra", "AD", "AND"),
    AO("Angola", "AO", "AGO"),
    AI("Anguilla", "AI", "AIA"),
    AG("Antigua and Barbuda", "AG", "ATG"),
    AR("Argentina", "AR", "ARG"),
    AM("Armenia (Հայաստան)", "AM", "ARM"),
    AW("Aruba", "AW", "ABW"),
    AU("Australia", "AU", "AUS"),
    AT("Austria (Österreich)", "AT", "AUT"),
    AZ("Azerbaijan (Azərbaycan)", "AZ", "AZE"),
    BS("Bahamas", "BS", "BHS"),
    BH("Bahrain (‫البحرين‬‎)", "BH", "BHR"),
    BD("Bangladesh (বাংলাদেশ)", "BD", "BGD"),
    BB("Barbados", "BB", "BRB"),
    BY("Belarus (Беларусь)", "BY", "BLR"),
    BE("Belgium (België)", "BE", "BEL"),
    BZ("Belize", "BZ", "BLZ"),
    BJ("Benin (Bénin)", "BJ", "BEN"),
    BM("Bermuda", "BM", "BMU"),
    BT("Bhutan (འབྲུག)", "BT", "BTN"),
    BO("Bolivia", "BO", "BOL"),
    BA("Bosnia and Herzegovina (Босна и Херцеговина)", "BA", "BIH"),
    BW("Botswana", "BW", "BWA"),
    BR("Brazil (Brasil)", "BR", "BRA"),
    IO("British Indian Ocean Territory", "IO", "IOT"),
    VG("British Virgin Islands", "VG", "VGB"),
    BN("Brunei", "BN", "BRN"),
    BG("Bulgaria (България)", "BG", "BGR"),
    BF("Burkina Faso", "BF", "BFA"),
    BI("Burundi (Uburundi)", "BI", "BDI"),
    KH("Cambodia (កម្ពុជា)", "KH", "KHM"),
    CM("Cameroon (Cameroun)", "CM", "CMR"),
    CA("Canada", "CA", "CAN"),
    CV("Cape Verde (Kabu Verdi)", "CV", "CPV"),
    BQ("Caribbean Netherlands", "BQ", "BES"),
    KY("Cayman Islands", "KY", "CYM"),
    CF("Central African Republic (République Centrafricaine)", "CF", "CAF"),
    TD("Chad (Tchad)", "TD", "TCD"),
    CL("Chile", "CL", "CHL"),
    CN("China (中国)", "CN", "CHN"),
    CX("Christmas Island", "cx", "CXR"),
    CC("Cocos (Keeling) Islands (Kepulauan Cocos (Keeling))", "cc", "CCK"),
    CO("Colombia", "CO", "COL"),
    KM("Comoros (‫جزر القمر‬‎)", "KM", "COM"),
    CG("Congo (DRC) (Jamhuri ya Kidemokrasia ya Kongo)", "CD", "COD"),
    CD("Congo (Republic) (Congo-Brazzaville)", "CG", "COG"),
    CK("Cook Islands", "CK", "COK"),
    CR("Costa Rica", "CR", "CRI"),
    CI("Côte d’Ivoire", "CI", "CIV"),
    HR("Croatia (Hrvatska)", "HR", "HRV"),
    CU("Cuba", "CU", "CUB"),
    CW("Curaçao", "CW", "CUW"),
    CY("Cyprus (Κύπρος)", "CY", "CYP"),
    CZ("Czech Republic (Česká republika)", "CZ", "CZE"),
    DK("Denmark (Danmark)", "DK", "DNK"),
    DJ("Djibouti", "DJ", "DJI"),
    DM("Dominica", "DM", "DMA"),
    DO("Dominican Republic (República Dominicana)", "DO", "DOM"),
    EC("Ecuador", "EC", "ECU"),
    EG("Egypt (‫مصر‬‎)", "EG", "EGY"),
    SV("El Salvador", "SV", "SLV"),
    GQ("Equatorial Guinea (Guinea Ecuatorial)", "GQ", "GNQ"),
    ER("Eritrea", "ER", "ERI"),
    EE("Estonia (Eesti)", "EE", "EST"),
    ET("Ethiopia", "ET", "ETH"),
    FK("Falkland Islands (Islas Malvinas)", "FK", "FLK"),
    FO("Faroe Islands (Føroyar)", "FO", "FRO"),
    FJ("Fiji", "FJ", "FJI"),
    FI("Finland (Suomi)", "FI", "FIN"),
    FR("France", "FR", "FRA"),
    GF("French Guiana (Guyane française)", "GF", "GUF"),
    PF("French Polynesia (Polynésie française)", "PF", "PYF"),
    GA("Gabon", "GA", "GAB"),
    GM("Gambia", "GM", "GMB"),
    GE("Georgia (საქართველო)", "GE", "GEO"),
    DE("Germany (Deutschland)", "DE", "DEU"),
    GH("Ghana (Gaana)", "GH", "GHA"),
    GI("Gibraltar", "GI", "GIB"),
    GR("Greece (Ελλάδα)", "GR", "GRC"),
    GL("Greenland (Kalaallit Nunaat)", "GL", "GRL"),
    GD("Grenada", "GD", "GRD"),
    GP("Guadeloupe", "GP", "GLP"),
    GU("Guam", "GU", "GUM"),
    GT("Guatemala", "GT", "GTM"),
    GG("Guernsey", "GG", "GGY"),
    GN("Guinea (Guinée)", "GN", "GIN"),
    GW("Guinea-Bissau (Guiné Bissau)", "GW", "GNB"),
    GY("Guyana", "GY", "GUY"),
    HT("Haiti", "HT", "HTI"),
    HN("Honduras", "HN", "HND"),
    HK("Hong Kong (香港)", "HK", "HKG"),
    HU("Hungary (Magyarország)", "HU", "HUN"),
    IS("Iceland (Ísland)", "IS", "ISL"),
    IN("India (भारत)", "IN", "IND"),
    ID("Indonesia", "ID", "IDN"),
    IR("Iran (‫ایران‬‎)", "IR", "IRN"),
    IQ("Iraq (‫العراق‬‎)", "IQ", "IRQ"),
    IE("Ireland", "IE", "IRL"),
    IM("Isle of Man", "IM", "IMN"),
    IL("Israel (‫ישראל‬)", "IL", "ISR"),
    IT("Italy (Italia)", "IT", "ITA"),
    JM("Jamaica", "JM", "JAM"),
    JP("Japan (日本)", "JP", "JPN"),
    JE("Jersey‎", "JE", "JEY"),
    JO("Jordan (‫الأردن‬‎)", "JO", "JOR"),
    KZ("Kazakhstan (Казахстан)", "KZ", "KAZ"),
    KE("Kenya", "KE", "KEN"),
    KI("Kiribati", "KI", "KIR"),
    XK("Kosovo (Kosovë)", "XK", "RKS"),
    KW("Kuwait (‫الكويت‬‎)", "KW", "KWT"),
    KG("Kyrgyzstan (Кыргызстан)", "KG", "KGZ"),
    LA("Laos (ລາວ)", "LA", "LAO"),
    LV("Latvia (Latvija)", "LV", "LVA"),
    LB("Lebanon (‫لبنان‬‎)", "LB", "LBN"),
    LS("Lesotho", "LS", "LSO"),
    LR("Liberia", "LR", "LBR"),
    LY("Libya (‫ليبيا‬‎)", "LY", "LBY"),
    LI("Liechtenstein", "LI", "LIE"),
    LT("Lithuania (Lietuva)", "LT", "LTU"),
    LU("Luxembourg", "LU", "LUX"),
    MO("Macau (澳門)", "MO", "MAC"),
    MK("Macedonia (FYROM) (Македонија)", "MK", "MKD"),
    MG("Madagascar (Madagasikara)", "MG", "MDG"),
    MW("Malawi", "MW", "MWI"),
    MY("Malaysia", "MY", "MYS"),
    MV("Maldives", "MV", "MDV"),
    ML("Mali", "ML", "MLI"),
    MT("Malta", "MT", "MLT"),
    MH("Marshall Islands", "MH", "MHL"),
    MQ("Martinique", "MQ", "MTQ"),
    MR("Mauritania (‫موريتانيا‬‎)", "MR", "MRT"),
    MU("Mauritius (Moris)", "MU", "MUS"),
    YT("Mayotte", "YT", "MYT"),
    MX("Mexico (México)", "MX", "MEX"),
    FM("Micronesia", "FM", "FSM"),
    MD("Moldova (Republica Moldova)", "MD", "MDA"),
    MC("Monaco", "MC", "MCO"),
    MN("Mongolia (Монгол)", "MN", "MNG"),
    ME("Montenegro (Crna Gora)", "ME", "MNE"),
    MS("Montserrat", "MS", "MSR"),
    MA("Morocco (‫المغرب‬‎)", "MA", "MAR"),
    MZ("Mozambique (Moçambique)", "MZ", "MOZ"),
    MM("Myanmar (Burma) (မြန်မာ)", "MM", "MMR"),
    NA("Namibia (Namibië)", "NA", "NAM"),
    NR("Nauru", "NR", "NRU"),
    NP("Nepal (नेपाल)", "NP", "NPL"),
    NL("Netherlands (Nederland)", "NL", "NLD"),
    NC("New Caledonia (Nouvelle-Calédonie)", "NC", "NCL"),
    NZ("New Zealand", "NZ", "NZL"),
    NI("Nicaragua", "NI", "NIC"),
    NE("Niger (Nijar)", "NE", "NER"),
    NG("Nigeria", "NG", "NGA"),
    NU("Niue", "NU", "NIU"),
    NF("Norfolk Island", "NF", "NFK"),
    KP("North Korea (조선 민주주의 인민 공화국)", "KP", "PRK"),
    MP("Northern Mariana Islands", "MP", "MNP"),
    NO("Norway (Norge)", "NO", "NOR"),
    OM("Oman (‫عُمان‬‎)", "OM", "OMN"),
    PK("Pakistan (‫پاکستان‬‎)", "PK", "PAK"),
    PW("Palau", "PW", "PLW"),
    PS("Palestine (‫فلسطين‬‎)", "PS", "PSE"),
    PA("Panama (Panamá)", "PA", "PAN"),
    PG("Papua New Guinea", "PG", "PNG"),
    PY("Paraguay", "PY", "PRY"),
    PE("Peru (Perú)", "PE", "PER"),
    PH("Philippines", "PH", "PHL"),
    PN("Pitcairn Islands", "PN", "PCN"),
    PL("Poland (Polska)", "PL", "POL"),
    PT("Portugal", "PT", "PRT"),
    PR("Puerto Rico", "PR", "PRI"),
    QA("Qatar (‫قطر‬‎)", "QA", "QAT"),
    RE("Réunion (La Réunion)", "RE", "REU"),
    RO("Romania (România)", "RO", "ROU"),
    RU("Russia (Россия)", "RU", "RUS"),
    RW("Rwanda", "RW", "RWA"),
    BL("Saint Barthélemy (Saint-Barthélemy)", "BL", "BLM"),
    SH("Saint Helena", "SH", "SHN"),
    KN("Saint Kitts and Nevis", "KN", "KNA"),
    LC("Saint Lucia", "LC", "LCA"),
    MF("Saint Martin (Saint-Martin (partie française))", "MF", "MAF"),
    PM("Saint Pierre and Miquelon (Saint-Pierre-et-Miquelon)", "PM", "SPM"),
    VC("Saint Vincent and the Grenadines", "VC", "VCT"),
    WS("Samoa", "WS", "WSM"),
    SM("San Marino", "SM", "SMR"),
    ST("São Tomé and Príncipe (São Tomé e Príncipe)", "st", "ST"),
    SA("Saudi Arabia (‫المملكة العربية السعودية‬‎)", "SA", "SAU"),
    SN("Senegal (Sénégal)", "SN", "SEN"),
    RS("Serbia (Србија)", "RS", "SRB"),
    SC("Seychelles", "SC", "SYC"),
    SL("Sierra Leone", "SL", "SLE"),
    SG("Singapore", "SG", "SGP"),
    SX("Sint Maarten", "SX", "SXM"),
    SK("Slovakia (Slovensko)", "SK", "SVK"),
    SI("Slovenia (Slovenija)", "SI", "SVN"),
    SB("Solomon Islands", "SB", "SLB"),
    SO("Somalia (Soomaaliya)", "SO", "SOM"),
    ZA("South Africa", "ZA", "ZAF"),
    GS("South Georgia & South Sandwich Islands", "GS", "SGS"),
    KR("South Korea (대한민국)", "KR", "KOR"),
    SS("South Sudan (‫جنوب السودان‬‎)", "SS", "SSD"),
    ES("Spain (España)", "ES", "ESP"),
    LK("Sri Lanka (ශ්‍රී ලංකාව)", "LK", "LKA"),
    SD("Sudan (‫السودان‬‎)", "SD", "SDN"),
    SR("Suriname", "SR", "SUR"),
    SJ("Svalbard and Jan Mayen (Svalbard og Jan Mayen)", "SJ", "SJM"),
    SZ("Swaziland", "SZ", "SWZ"),
    SE("Sweden (Sverige)", "SE", "SWE"),
    CH("Switzerland (Schweiz)", "CH", "CHE"),
    SY("Syria (‫سوريا‬‎)", "SY", "SYR"),
    TW("Taiwan (台灣)", "TW", "TWN"),
    TJ("Tajikistan", "TJ", "TJK"),
    TZ("Tanzania", "TZ", "TZA"),
    TH("Thailand (ไทย)", "TH", "THA"),
    TL("Timor-Leste", "TL", "TLS"),
    TG("Togo", "TG", "TGO"),
    TK("Tokelau", "TK", "TKL"),
    TO("Tonga", "TO", "TON"),
    TT("Trinidad and Tobago", "TT", "TTO"),
    TN("Tunisia (‫تونس‬‎)", "TN", "TUN"),
    TR("Turkey (Türkiye)", "TR", "TUR"),
    TM("Turkmenistan", "TM", "TKM"),
    TC("Turks and Caicos Islands", "TC", "TCA"),
    TV("Tuvalu", "TV", "TUV"),
    UG("Uganda", "UG", "UGA"),
    UA("Ukraine (Україна)", "UA", "UKR"),
    AE("United Arab Emirates (‫الإمارات العربية المتحدة‬‎)", "AE", "ARE"),
    GB("United Kingdom", "GB", "GBR"),
    US("United States", "US", "USA"),
    UM("U.S. Minor Outlying Islands", "UM", "UMI"),
    VI("U.S. Virgin Islands", "vi", "VIR"),
    UY("Uruguay", "UY", "URY"),
    UZ("Uzbekistan (Oʻzbekiston)", "UZ", "UZB"),
    VU("Vanuatu", "VU", "VUT"),
    VA("Vatican City (Città del Vaticano)", "VA", "VAT"),
    VE("Venezuela", "VE", "VEN"),
    VN("Vietnam (Việt Nam)", "VN", "VNM"),
    WF("Wallis and Futuna", "WF", "WLF"),
    EH("Western Sahara (‫الصحراء الغربية‬‎)", "EH", "ESH"),
    YE("Yemen (‫اليمن‬‎)", "YE", "YEM"),
    ZM("Zambia", "ZM", "ZMB"),
    ZW("Zimbabwe", "ZW", "ZWE");

    private String countryName;
    private String A2Code;
    private String A3Code;
    private String NMCode;

    CountryEnum(String countryName, String A2Code, String A3Code) {
        this.countryName = countryName;
        this.A2Code = A2Code;
        this.A3Code = A3Code;
    }

    public static String getCountryISO3(String abbr) {
        for (CountryEnum v : values()) {
            if (v.getCountryCodeA2().equalsIgnoreCase(abbr)) {
                return v.getCountryCodeA3();
            }
        }

        return null;
    }

    public static String checkIfValidISO3(String abbr) {
        for (CountryEnum v : values()) {
            if (v.getCountryCodeA3().equalsIgnoreCase(abbr)) {
                return v.getCountryCodeA3();
            }
        }

        return null;
    }

    public String getCountryName() {
        return countryName;
    }

    public String getCountryCodeA2() {
        return A2Code;
    }

    public String getCountryCodeA3() {
        return A3Code;
    }

    public String getCountryCodeNM() {
        return NMCode;
    }
}