package com.idenfy.idenfySdk.core.ui.view

import android.Manifest
import android.app.Activity
import android.arch.lifecycle.Observer
import android.arch.lifecycle.ProcessLifecycleOwner
import android.arch.lifecycle.ViewModelProviders
import android.content.DialogInterface
import android.content.Intent
import android.content.pm.ActivityInfo
import android.content.pm.PackageManager
import android.content.res.Configuration
import android.graphics.Typeface
import android.net.Uri
import android.os.Build
import android.os.Bundle
import android.os.Handler
import android.os.Parcelable
import android.support.design.widget.AppBarLayout
import android.support.design.widget.Snackbar
import android.support.v4.app.ActivityCompat
import android.support.v4.app.FragmentManager
import android.support.v4.content.ContextCompat
import android.support.v7.app.AlertDialog
import android.support.v7.app.AppCompatActivity
import android.support.v7.app.AppCompatDelegate
import android.support.v7.widget.AppCompatImageView
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.support.v7.widget.Toolbar
import android.view.MenuItem
import android.view.View
import android.widget.TextView
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySDKLoggingSettings
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings
import com.idenfy.idenfySdk.Networking.Resource
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponseInternal
import com.idenfy.idenfySdk.SdkResponseModels.ExitCode
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyError
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse
import com.idenfy.idenfySdk.identificationresults.ui.view.AuthenticationResultFragment
import com.idenfy.idenfySdk.documentscamerasession.ui.view.DocumentsCameraSessionFragment
import com.idenfy.idenfySdk.landingpage.ui.SplashScreenFragment
import com.idenfy.idenfySdk.identificationresults.ui.viewmodel.ResultViewModel
import com.idenfy.idenfySdk.core.ui.adapter.DocumentsRecyclerViewAdapter
import com.idenfy.idenfySdk.core.ui.viewmodel.CameraViewModel
import com.idenfy.idenfySdk.helpers.IdenfyIdentificationStatus
import com.idenfy.idenfySdk.helpers.ResultsFormattingHelper
import com.idenfy.idenfySdk.helpers.enums.FontEnum
import com.idenfy.idenfySdk.initialagreement.repo.InitialAgreementRepositoryImp
import com.idenfy.idenfySdk.initialagreement.ui.view.InitialAgreementFragmnet
import com.idenfy.idenfySdk.liveness.LivenessesViewModel
import com.idenfy.idenfySdk.liveness.presentation.LivenessSessionNotInitialized
import com.idenfy.idenfySdk.liveness.presentation.LivenessSessionSuccessful
import com.idenfy.idenfySdk.navigation.Router
import com.idenfy.idenfysdk.core.domain.networkrepo.ErrorsHelper
import com.idenfy.idenfysdk.core.features.DocScanningFeatureResult
import com.idenfy.idenfysdk.core.features.OnDocumentScanningFeatureListener
import com.idenfy.idenfysdk.core.internal.settings.IdenfyInternalSettings
import com.idenfy.idenfysdk.core.logging.LoggingHelper
import com.idenfy.idenfysdk.core.models.documentTypeData.DocumentTypeClass
import com.idenfy.idenfysdk.core.models.documentTypeData.DocumentTypeEnum
import com.idenfy.idenfysdk.core.networking.Status
import com.idenfySdk.BuildConfig
import com.idenfySdk.R
import org.json.JSONException
import org.json.JSONObject
import java.util.*

class CameraPreviewActivity : AppCompatActivity(),
        AuthenticationResultFragment.OnAuthenticationResultFragmentClosed,
        DocumentsCameraSessionFragment.OnCameraClosedFragment,
        InitialAgreementFragmnet.OnFragmentInteractionListener,
        AuthenticationResultFragment.RetakeStepsListListener,
        SplashScreenFragment.OnFragmentInteractionListener,
        DocumentsRecyclerViewAdapter.OnItemClickListener, OnDocumentScanningFeatureListener {


    private lateinit var cameraViewModel: CameraViewModel
    private lateinit var resultViewModel: ResultViewModel
    private var livenessesViewModel: LivenessesViewModel? = null
    private val resultsFormattingHelper = ResultsFormattingHelper()
    private var selectedDocument: DocumentTypeClass? = null
    private val authenticationResultResponse = "authenticationResultResponseLiveData"
    private val idenfyError = "idenfyErrorResponse"
    private val settings = "settings"
    private val internalSettings = "internalSettings"


    private var cameraPermissionWasRequested = false
    private val REQUEST_PERMISSIONS_CAMERA = 44444
    private var mReturningWithResult: Boolean = false
    private var wasPermissionRequested = false

    private var idenfyErrorDelayClosing = 1000 //1000
    private val idenfySuccessDelayClosing = 1200 //1200

    private var isDocumentItemPressed: Boolean = false
    private val successHandler = Handler()
    private val errorHandler = Handler()
    private val splashScreenLoading = Handler()

    private var backButton: AppCompatImageView? = null

    lateinit var toolbar: Toolbar

    var restartAuthenticationDialog: AlertDialog? = null

    lateinit var closeAppAlertDialog: AlertDialog

    lateinit var appBarLayout: AppBarLayout

    var toolbarTitle: TextView? = null
    private var recyclerView: RecyclerView? = null
    private var selectDocumentType: TextView? = null

    lateinit var router: Router

    private val cameraPermission: Boolean
        get() {
            if (ActivityCompat.checkSelfPermission(this, Manifest.permission.CAMERA) != PackageManager.PERMISSION_GRANTED) {
                cameraPermissionWasRequested = true
                requestCameraPermission()
                return false
            } else {
                return true
            }
        }

    private val isIdentificationResulsAnalizationFinished: Boolean
        get() = cameraViewModel.authenticationResultResponseLiveData.value != null &&
                cameraViewModel.authenticationResultResponseLiveData.value!!.data != null &&
                cameraViewModel.authenticationResultResponseLiveData.value!!.status == Status.SUCCESS &&
                cameraViewModel.authenticationResultResponseLiveData.value!!.data!!.processingStatus != null &&
                cameraViewModel.authenticationResultResponseLiveData.value!!.data!!.processingStatus.equals("FINISHED", ignoreCase = true)


    public override fun onCreate(savedInstanceState: Bundle?) {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true)
        super.onCreate(savedInstanceState)
        router = Router()
        livenessesViewModel = ViewModelProviders.of(this).get(LivenessesViewModel::class.java)
        cameraViewModel = ViewModelProviders.of(this).get(CameraViewModel::class.java)
        resultViewModel = ViewModelProviders.of(this).get(ResultViewModel::class.java)
        restoreAppAfterDeath(savedInstanceState)
        if (cameraViewModel.wasChangedSettings) {
            cameraViewModel.isRecyclerViewEnabled = savedInstanceState != null
            removeAllFragmentsForRestarting()

        } else {
            cameraViewModel.addDocumentPhotoResultFragment.setValue(false)
            cameraViewModel.setaddFacePhotoResultFragment(false)
            if (!cameraViewModel.isLivenessEnabled()) {
                cameraViewModel.setAddFaceCameraFragment(false)
            } else {
                if (!cameraViewModel.isFaceCameraPresent) {
                    cameraViewModel.setAddFaceCameraFragment(false)
                }
            }
            cameraViewModel.setAddDocumentCameraFragment(false)
            cameraViewModel.setAddDocumentScanningFragment(false)
        }

        //NON UI RELATED
        observeProcessUploadCompletion()
        //UI initialization
        setContentView(R.layout.idenfy_activity_main_layout)
        initializeUI(savedInstanceState)
        //Observation
        observeDocScanningFragment()
        observeDocumentSessionFragment()
        observeFaceCameraFragment()
        observeAuthenticationResultFragment()
        observeInitialAgreementFragment()
        observeSplashScreenFragment()
        observeAddDocumentPhotoResultFragment()
        observeFacePhotoResultFragment()


        observeSDKResponse()
        observeDocumentsTypesLiveData()
        observeInitiationOfPhotosTakingFlow()

        cameraViewModel.observeIdenfyError().observe(this, Observer { error ->
            if (error != null) {
                cameraViewModel.idenfyError.postValue(error)
            }
        })

        //ZoomObservation
        if (livenessesViewModel!!.getLivenessHelper() != null) {
            observeZoomSuccessResults()
            observeIsPartnerSelectedZoom()
            observeZoomSuccessResponse()
            observeZoomErrorOccured()
        }
        ProcessLifecycleOwner.get()
                .lifecycle
                .addObserver(cameraViewModel.foregroundBackgroundListener)
        cameraViewModel.isAppInBackgroundLiveData.observe(this, Observer { response ->
            if (response != null) {

                if (response) {
                    LoggingHelper.logInfo("onPause", CameraPreviewActivity::class.java.simpleName)
                    handleFragmentsRemoval()
                }
            }
        })

    }

    fun handleFragmentsRemoval() {
        if (!cameraViewModel.isLivenessEnabled()) {

            removeFragment()
        } else {
            if (!cameraViewModel.isFaceCameraPresent) {
                removeFragment()
            }
        }
    }

    override fun onStart() {
        super.onStart()
        LoggingHelper.onStart(CameraPreviewActivity::class.java.simpleName)
    }

    override fun onResume() {
        super.onResume()
        cameraViewModel.changeForegroundListener(true)
    }

    override fun onPostResume() {
        super.onPostResume()
        if (mReturningWithResult) {
            if (this.selectedDocument != null) {
                cameraViewModel.setDocumentType(this.selectedDocument!!)
                mReturningWithResult = false
            }
        }
    }

    override fun onStop() {
        super.onStop()
        LoggingHelper.onStop(CameraPreviewActivity::class.java.simpleName)
        cameraViewModel.changeForegroundListener(false)
    }

    public override fun onSaveInstanceState(outState: Bundle) {
        val authenticationResultResponse = cameraViewModel.savedAuthenticationResultResponseInternal

        if (authenticationResultResponse != null &&
                authenticationResultResponse.processingStatus.equals("FINISHED", ignoreCase = true))
            outState.putParcelable(this.authenticationResultResponse, authenticationResultResponse)
        else {
            if (cameraViewModel.idenfyError.value != null) {
                val idenfyError = cameraViewModel.idenfyError.value
                outState.putParcelable(this.idenfyError, idenfyError)
            }
        }
        outState.putParcelable(settings, IdenfyController.getInstance().settings)
        outState.putParcelable(internalSettings, cameraViewModel.repository.idenfyInternalSettings)
        super.onSaveInstanceState(outState)
    }

    override fun onDestroy() {
        if (recyclerView != null) {
            recyclerView!!.adapter = null
            recyclerView!!.layoutManager = null
            recyclerView!!.addItemDecoration(null)
            recyclerView = null
        }
        errorHandler.removeCallbacksAndMessages(null)
        splashScreenLoading.removeCallbacksAndMessages(null)
        successHandler.removeCallbacksAndMessages(null)
        super.onDestroy()
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {

        if (item.itemId == android.R.id.home) {
            onBackPressed()
        }
        return true
    }

    override fun onConfigurationChanged(newConfig: Configuration) {
        super.onConfigurationChanged(newConfig)
        if (IdenfyController.getInstance().settings.customLocale != null) {
            val config = this.resources.configuration
            val locale = Locale(IdenfyController.getInstance().settings.customLocale)
            Locale.setDefault(locale)
            config.locale = locale
            this.baseContext.resources.updateConfiguration(config,
                    this.baseContext.resources.displayMetrics)
        } else {
            this.baseContext.resources.updateConfiguration(newConfig,
                    this.baseContext.resources.displayMetrics)
        }
    }

    private fun restoreAppAfterDeath(savedInstanceState: Bundle?) {

        if (savedInstanceState != null) {
            var idenfySettings: IdenfySettings? = null
            var internalIdenfySettings: IdenfyInternalSettings? = null
            if (savedInstanceState.getParcelable<Parcelable>(settings) != null) {
                idenfySettings = savedInstanceState.getParcelable(settings)
                IdenfyController.getInstance().setSettings(idenfySettings)

            }
            if (savedInstanceState.getParcelable<Parcelable>(internalSettings) != null) {
                internalIdenfySettings = savedInstanceState.getParcelable<IdenfyInternalSettings>(internalSettings)
            }
            cameraViewModel.setupIdenfySettings(idenfySettings!!, internalIdenfySettings, true)
            resultViewModel.getRepository()
            setupCustomLocale(idenfySettings)
            initialRequests(true, savedInstanceState)
            if (savedInstanceState.getParcelable<Parcelable>(authenticationResultResponse) != null) {
                val authenticationResultResponse = savedInstanceState.getParcelable<AuthenticationResultResponseInternal>(authenticationResultResponse)
                if (authenticationResultResponse != null && authenticationResultResponse.identificationStatus.equals(IdenfyIdentificationStatus.APPROVED.status, ignoreCase = true)) {
                    cameraViewModel.setIdentificationSuccessResponse(authenticationResultResponse)
                } else {
                    cameraViewModel.savedIdentificationResultResponse = authenticationResultResponse
                }

            }
            if (savedInstanceState.getParcelable<Parcelable>(idenfyError) != null) {
                val idenfyError = savedInstanceState.getParcelable<IdenfyError>(this.idenfyError)
                if (idenfyError != null) {
                    if (IdenfyController.getInstance().settings.isWithActivityResults) {
                        val intent = Intent()
                        intent.putExtra(IdenfyController.ON_ERROR, idenfyError.idenfyErrorResponse)
                        setResult(IdenfyController.ERROR_CODE, intent)
                        finish()
                    } else if (checkIfNewVersionOfInitialization()) {
                        IdenfyController.idenfyError = idenfyError.idenfyErrorResponse
                        finish()
                    }
                }

            }

        } else {
            resultViewModel.getRepository()
            cameraViewModel.setupIdenfySettings(IdenfyController.getInstance().settings, null, false)
            setupCustomLocale(IdenfyController.getInstance().settings)
            initialRequests(false, savedInstanceState)
        }
    }

    private fun initialRequests(isSavedInstance: Boolean, savedInstanceState: Bundle?) {
        val idenfySettings = IdenfyController.getInstance().settings
        setupRestoredValues(idenfySettings)


    }

    private fun observeSplashScreenFragment() {
        cameraViewModel.addSplashScreenFragmentMutableLiveData.observe(this, Observer { response ->
            if (response != null) {
                if (response) {
                    router.addSplashScreenFragment(supportFragmentManager)
                } else {
                    removeSplashScreenFragment(supportFragmentManager)
                }
            }
        })
    }

    private fun observeDocScanningFragment() {
        cameraViewModel.addDocumentScanningFragment.observe(this, Observer { response ->
            if (response != null) {
                if (response)
                    router.addDocScanningFragment(supportFragmentManager)
                else {
                    router.removeDocScanningFragment(supportFragmentManager)
                }
            }
        })
    }

    private fun observeFacePhotoResultFragment() {
        cameraViewModel.addDocumentFacePhotoResultFragment.observe(this, Observer { response ->
            if (response != null) {
                if (response) {
                    router.addFacePhotoResultFragment(supportFragmentManager, cameraViewModel.isLivenessEnabled())
                } else {
                    router.removeFacePhotoResultFragment(supportFragmentManager)
                }
            }

        })
    }

    private fun observeFaceCameraFragment() {
        cameraViewModel.faceCameraFragmentLiveData.observe(this, Observer { response ->
            if (response != null) {
                if (response) {
                    router.addFaceCameraFragment(supportFragmentManager)
                } else {
                    router.removeFaceCameraFragment(supportFragmentManager)
                }
            }
        })
    }

    private fun observeZoomErrorOccured() {
        livenessesViewModel!!.zoomErrorOccured.observe(this, Observer { response ->
            if (response != null) {
                if (response) {
                    livenessesViewModel?.getLivenessHelper()?.zoomErrorOccured?.value = false
                    cameraViewModel.setIdenfyError(IdenfyError(IdenfyErrorResponse(ErrorsHelper.FACE_LIVENESSS_ERROR_IDENTIFIER,
                            ErrorsHelper.getErrorMessageFromIdentifier(this, ErrorsHelper.FACE_LIVENESSS_ERROR_IDENTIFIER)),
                            true, 1200))
                }
            }
        })

    }

    private fun observeAddDocumentPhotoResultFragment() {
        cameraViewModel.addDocumentPhotoResultFragment.observe(this, Observer { response ->
            if (response != null) {
                if (response) {
                    router.addDocumentPhotoResultFragment(supportFragmentManager)
                } else {
                    router.removeDocumentPhotoResultFragment(supportFragmentManager)
                }
            }
        })
    }

    private fun observeZoomSuccessResults() {
        livenessesViewModel!!.zoomSessionResponse.observe(this, Observer livenessesViewModel@{ response ->
            if (response != null) {
                if (response is LivenessSessionSuccessful) {
                    if (cameraViewModel.currentDocumentClass == null) {
                        return@livenessesViewModel
                    }
                    cameraViewModel.checkLiveness(response.livenessCheck)

                    livenessesViewModel?.zoomSessionResponse?.value = LivenessSessionNotInitialized(false, null, false)
                }
            }

        })
    }

    private fun observeZoomSuccessResponse() {
        livenessesViewModel!!.zoomSessionSuccess.observe(this, Observer livenessesViewModel@{ response ->
            if (response != null && response) {

                if (cameraViewModel.currentDocumentClass == null) {
                    return@livenessesViewModel
                }
                livenessesViewModel!!.zoomSessionSuccess.value = false
                val savedFacePhotoBitmap = cameraViewModel.savedFacePhotoBitmap
                if (savedFacePhotoBitmap != null) {
                    cameraViewModel.handleFlow(savedFacePhotoBitmap, false)
                    cameraViewModel.navigate()
                }
            }
        })

    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        super.onActivityResult(requestCode, resultCode, data)
        if (resultCode == Activity.RESULT_OK) {
            if (requestCode == livenessesViewModel!!.getLivenessHelper()?.REQUEST_CODE_VERIFICATION) {
                if (IdenfyController.getInstance().settings.token != null)
                    livenessesViewModel!!.handleZoomResults(IdenfyController.getInstance().settings.token, data)
            }
        }

        if (resultCode != RESULT_CANCELED) {
            if (requestCode == DOCUMENT_CAMERA_SESSION_REQUEST_CODE && resultCode == Activity.RESULT_OK) {
                val fragment = supportFragmentManager.findFragmentByTag(DOCUMENT_CAMERA_SESSION_FRAGMENT_TAG)
                fragment?.onActivityResult(requestCode, resultCode, data)
            } else if (requestCode == FACE_CAMERA_SESSION_REQUEST_CODE && resultCode == Activity.RESULT_OK) {
                val fragment = supportFragmentManager.findFragmentByTag(FACE_CAMERA_SESSION_FRAGMENT)
                fragment?.onActivityResult(requestCode, resultCode, data)
            }
        } else {
            cameraViewModel.setUploadPictureButtonAvailability(true)
        }
    }


    private fun observeIsPartnerSelectedZoom() {
        cameraViewModel.initialLoadingDataLiveData.observe(this, Observer { response ->
            if (response != null && response.status == Status.SUCCESS) {
                if (response.data != null) {
                    if (response.data!!.partnerInfo.zoomLiveliness!!) {
                        cameraViewModel.hasPartnerEnabledZoom = true
                        setupZoomLiveness()
                    }

                }
            }
        })
    }

    private fun setupZoomLiveness() {

        if (livenessesViewModel!!.getLivenessHelper() != null) {
            var isloggingEnabled = false
            if (IdenfyController.getInstance().settings.sdkLogging == IdenfySDKLoggingSettings.IdenfySDKLoggingEnum.FULL)
                isloggingEnabled = true
            livenessesViewModel!!.preloadZoomResources(this)
            livenessesViewModel!!.initialiazeZoomSdk(this, ContextCompat.getColor(this,
                    R.color.idenfyLivenessBackgroundColor), ContextCompat.getColor(this,
                    R.color.idenfyColorAccent), R.drawable.idenfy_custom_drawable_splash_screen_icon, "dcoAJszvM4HYA1py8LfYM6Gdr1CQSKkH",
                    IdenfyController.getInstance().settings.idenfyUISettings.idenfyLivenessUISettings, isloggingEnabled, IdenfySDKLoggingSettings.IdenfySDKLoggingConstants.idenfyLivenessFeatureLogging)
        }
    }


    private fun setupRestoredValues(idenfySettings: IdenfySettings) {

        if (idenfySettings.customFontPath != null) {

            var customFont: Typeface? = null
            try {
                customFont = Typeface.createFromAsset(applicationContext.assets, idenfySettings.customFontPath)
                idenfySettings.setCustomTypeface(customFont)
            } catch (e: Exception) {
                e.printStackTrace()
            }

        }

    }

    private fun observeInitialAgreementFragment() {
        cameraViewModel.addInitialAgreementFragmentMutableLiveData.observe(this, Observer { canAdd ->
            if (canAdd != null) {
                if (canAdd) {
                    router.addInitialAgreementFragment(supportFragmentManager)
                } else {
                    InitialAgreementRepositoryImp.deinit()
                    if (router.removeInitialAgreementFragment(supportFragmentManager))
                        cameraViewModel.isRecyclerViewEnabled = true
                }
            }
        })
    }

    private fun removeFragment() {
        val fragment = supportFragmentManager.findFragmentByTag(AUTHENTICATION_RESULTS_FRAGMENT)
        if (fragment == null) {
            if (cameraViewModel.getSaveFragment().value == false) {
                removeAllFragmentsForRestarting()
                cameraViewModel.isRecyclerViewEnabled = true
            } else {
                cameraViewModel.setSaveFragments(false)
            }
        }
    }

    private fun initializeUI(savedInstanceState: Bundle?) {
        toolbarTitle = findViewById(R.id.toolbar_title)
        selectDocumentType = findViewById(R.id.select_document_type)
        appBarLayout = findViewById(R.id.idenfy_app_bar_layout_activity_main_root)
        if (toolbarTitle != null)
            toolbarTitle!!.setText(R.string.idenfy_documents_selection_toolbar_title)

        backButton = findViewById(R.id.backImage)
        if (backButton != null)
            backButton!!.setOnClickListener { onBackPressed() }

        toolbar = findViewById<View>(R.id.idenfy_toolbar_activity_main_root) as Toolbar
        setSupportActionBar(toolbar)
        supportActionBar?.elevation = 4f
        supportActionBar?.setDisplayShowTitleEnabled(false)
        supportActionBar?.title = ""
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        supportActionBar?.setDisplayShowHomeEnabled(true)
        requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_NOSENSOR
        setTheme(R.style.IdenfyTheme)
        initRecyclerView()
        setupCustomDesign()
        toolbar.setNavigationOnClickListener { onBackPressed() }


    }

    private fun setupCustomDesign() {
        val idenfySettings = IdenfyController.getInstance().settings
        if (idenfySettings != null) {
            setupFonts()
            enableActionBar(idenfySettings.actionBarEnabled)
        }
    }

    private fun enableActionBar(isActionBarEnabled: Boolean) {
        appBarLayout.visibility = if (isActionBarEnabled) View.VISIBLE else View.GONE

    }

    private fun setupFonts() {
        val idenfySettings = IdenfyController.getInstance().settings
        if (idenfySettings != null) {
            if (selectDocumentType != null)
                selectDocumentType!!.typeface = idenfySettings.getIdenfyBold(FontEnum.DEFAULT_BOLD)
            if (toolbarTitle != null)
                toolbarTitle!!.typeface = idenfySettings.getIdenfyFont(FontEnum.DEFAULT_BOLD)
        }
    }


    private fun checkIfNewVersionOfInitialization(): Boolean {
        return IdenfyController.getInstance().settings.isWithStaticListener
    }


    private fun observeProcessUploadCompletion() {
        cameraViewModel.getStartedProcessingLiveData().observe(this, Observer { uploadCompleted ->
            if (uploadCompleted != null) {
                if (uploadCompleted.status == Status.SUCCESS) {
                    cameraViewModel.startProcessing()
                    cameraViewModel.startedProcessingLiveData.value = Resource.loading(null)
                }
            }
        })
        cameraViewModel.checkingAuthenticationResultsLiveData.observe(this, Observer { uploadCompleted ->
            if (uploadCompleted != null) {
                if (uploadCompleted.status == Status.SUCCESS) {
                    cameraViewModel.checkIdentificationResults()
                    cameraViewModel.checkingAuthenticationResultsLiveData.value = Resource.loading(null)
                }
            }
        })
    }

    private fun setupCustomLocale(idenfySettings: IdenfySettings) {
        if (idenfySettings.customLocale != null) {
            val config = this.resources.configuration
            val locale = Locale(idenfySettings.customLocale)
            Locale.setDefault(locale)
            config.locale = locale
            this.baseContext.resources.updateConfiguration(config,
                    this.baseContext.resources.displayMetrics)
        }
    }


    private fun observeDocumentSessionFragment() {
        cameraViewModel.addDocumentCameraFragment.observe(this, Observer { aBoolean ->
            if (aBoolean != null)
                if (aBoolean) router.addDocumentCameraSessionFragment(supportFragmentManager) else {
                    router.removeDocumentSelectionFragment(supportFragmentManager)
                }
        })
    }

    private fun observeAuthenticationResultFragment() {
        cameraViewModel.authenticationResultFragmentLiveData.observe(this, Observer { response ->
            if (response != null) {
                if (response) {

                    router.addAuthenticationResultFragment(supportFragmentManager, true)
                } else {
                    router.removeAuthenticationResultFragment(supportFragmentManager)
                }
            }
        })
    }

    private fun handleIdenfySuccess(response: AuthenticationResultResponseInternal) {
        if (cameraViewModel.responseEventOccured) {
            return
        }
        cameraViewModel.responseEventOccured = true

        val idenfyIdentificationResultsSettings = cameraViewModel.idenfySettings!!.idenfyIdentificationResultsSettings
        if (!idenfyIdentificationResultsSettings.isSuccessResultsViewVisible) {
            LoggingHelper.logInfo("idenfyError", "terminatingIdenfySucessWithCustomSettings")
            val intent = Intent()
            intent.putExtra(IdenfyController.ON_AUTHENTICATION_RESULT, resultsFormattingHelper.getFormattedAuthenticationResponse(response))
            setResult(IdenfyController.AUTHENTICATION_RESULT_CODE, intent)
            finish()
            return
        }
        successHandler.postDelayed({
            if (IdenfyController.getInstance().settings.isWithActivityResults) {
                LoggingHelper.logInfo("idenfyError", "terminatingIdenfySucessWithRegularSettings")
                val intent = Intent()
                intent.putExtra(IdenfyController.ON_AUTHENTICATION_RESULT, resultsFormattingHelper.getFormattedAuthenticationResponse(response))
                setResult(IdenfyController.AUTHENTICATION_RESULT_CODE, intent)
                finish()
            } else if (checkIfNewVersionOfInitialization()) {
                LoggingHelper.logInfo("idenfyError", "savedIdentificationResultResponselegacynull")
                IdenfyController.authenticationResultResponse = resultsFormattingHelper.getFormattedAuthenticationResponse(response)
                finish()
            }
        }, idenfySuccessDelayClosing.toLong())

    }

    private fun handleIdenfyError(error: IdenfyError) {

        if (cameraViewModel.responseEventOccured) {
            return
        }
        if (cameraViewModel.savedIdentificationResultResponse != null) {
            if (IdenfyController.getInstance().settings != null) {
                val idenfyIdentificationResultsSettings = IdenfyController.getInstance().settings.idenfyIdentificationResultsSettings
                if (idenfyIdentificationResultsSettings.isErrorResultsViewVisible) {
                    if (error.terminateWithoutWaitingResult!!) {
                        cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(true)
                    }
                }
            }

            LoggingHelper.logInfo("idenfyError", "savedIdentificationResultResponsenotnull")
            cameraViewModel.setIdentificationSuccessResponse(cameraViewModel.savedIdentificationResultResponse!!)
            return
        }
        cameraViewModel.responseEventOccured = true
        if (IdenfyController.getInstance().settings != null) {
            val idenfyIdentificationResultsSettings = IdenfyController.getInstance().settings.idenfyIdentificationResultsSettings
            if (!idenfyIdentificationResultsSettings.isErrorResultsViewVisible) {
                LoggingHelper.logInfo("idenfyError", "terminatingIdenfyErrorWithCustomSettings")
                val idenfyErrorResponse = error.idenfyErrorResponse
                val intent = Intent()
                intent.putExtra(IdenfyController.ON_ERROR, idenfyErrorResponse)
                setResult(IdenfyController.ERROR_CODE, intent)
                finish()
                return
            }
        }
        if (error.seconds != 0) {
            idenfyErrorDelayClosing = error.seconds
        }
        //handles if immediately identification results is needs to load
        if (error.terminateWithoutWaitingResult!!) {

            cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(true)
        }


        errorHandler.postDelayed({
            if (IdenfyController.getInstance().settings.isWithActivityResults) {
                LoggingHelper.logInfo("idenfyError", "terminatingRegularWay")
                val idenfyErrorResponse = error.idenfyErrorResponse
                val intent = Intent()
                intent.putExtra(IdenfyController.ON_ERROR, idenfyErrorResponse)
                setResult(IdenfyController.ERROR_CODE, intent)
                finish()
            } else if (checkIfNewVersionOfInitialization()) {
                IdenfyController.idenfyError = error.idenfyErrorResponse
                finish()
            }
        }, idenfyErrorDelayClosing.toLong())
    }

    private fun observeSDKResponse() {
        cameraViewModel.idenfyError.observe(this, Observer {
            if (it != null) this.handleIdenfyError(it)
        }
        )
        cameraViewModel.identificationSuccessResponse.observe(this, Observer {
            if (it != null) this.handleIdenfySuccess(it)
        })
    }

    private fun showSnackBar(message: String) {
        val snackBar = Snackbar.make(findViewById(R.id.idenfy_layout_activity_main_root),
                message, Snackbar.LENGTH_SHORT)
        snackBar.show()
    }

    private fun removeSplashScreenFragment(supportFragmentManager: FragmentManager) {


        splashScreenLoading.postDelayed({
            val fragment = supportFragmentManager.findFragmentByTag(SPLASH_SCREEN_FRAGMENT)
            if (fragment != null) {
                if (IdenfyController.getInstance().settings != null)
                    if (!IdenfyController.getInstance().settings.setupAgreementFragment)
                        cameraViewModel.isRecyclerViewEnabled = true
                LoggingHelper.LogLifecycleInfo("removingsplash")
                supportFragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss()
            }
        }, 300)

    }

    private fun showRestartAuthenticationDialog() {
        val builder = AlertDialog.Builder(this)

        builder.setTitle(R.string.idenfy_alert_title_restart_identification_information)
        builder.setMessage(R.string.idenfy_alert_message_restart_identification_information)
        builder.setPositiveButton(R.string.idenfy_alert_negative_button_restart_identification_information) { dialog, which -> dialog.dismiss() }
        builder.setNegativeButton(resources.getString(R.string.idenfy_alert_positive_button_restart_identification_information)
        ) { dialog, which ->
            cameraViewModel.authenticationResultResponseLiveData.value = Resource.loading(null)
            removeAllFragmentsForRestarting()
            cameraViewModel.isRecyclerViewEnabled = true
            dialog.dismiss()
        }
        restartAuthenticationDialog = builder.create()
        restartAuthenticationDialog?.show()
        restartAuthenticationDialog?.getButton(AlertDialog.BUTTON_NEGATIVE)?.setTextColor(resources.getColor(R.color.idenfyColorPrimary))
        restartAuthenticationDialog?.getButton(AlertDialog.BUTTON_POSITIVE)?.setTextColor(resources.getColor(R.color.idenfyColorAccent))
    }

    private fun removeAllFragmentsForRestarting() {
        cameraViewModel.addDocumentPhotoResultFragment.value = false
        cameraViewModel.setAuthenticationFragmentOpenMutableLiveData(false)
        cameraViewModel.setaddFacePhotoResultFragment(false)
        cameraViewModel.setAddFaceCameraFragment(false)
        cameraViewModel.setAddDocumentCameraFragment(false)
        cameraViewModel.setAddDocumentScanningFragment(false)
    }

    private fun showCloseAppAlertDialog() {


        val builder = AlertDialog.Builder(this)

        builder.setTitle(R.string.idenfy_alert_title_abort_identification_information)
        builder.setMessage(R.string.idenfy_alert_message_abort_identification_information)

        builder.setPositiveButton(R.string.idenfy_alert_negative_button_abort_identification_information) { dialog, which -> dialog.dismiss() }

        builder.setNegativeButton(R.string.idenfy_alert_positive_button_abort_identification_information, DialogInterface.OnClickListener { dialog, which ->
            if (cameraViewModel.savedIdentificationResultResponse != null) {
                cameraViewModel.setIdentificationSuccessResponse(cameraViewModel.savedIdentificationResultResponse!!)
                return@OnClickListener
            }
            if (IdenfyController.getInstance().settings.isWithActivityResults) {
                val intent = Intent()
                val exitCode = ExitCode(1)
                intent.putExtra(IdenfyController.ON_USER_EXIT, exitCode as Parcelable)
                setResult(IdenfyController.USER_EXIT_CODE, intent)
                finish()
            } else if (checkIfNewVersionOfInitialization()) {
                val exitCode = ExitCode(1)
                IdenfyController.exitCode = ExitCode(1)
                finish()
                dialog.dismiss()
            }
        })
        closeAppAlertDialog = builder.create()
        closeAppAlertDialog.show()
        closeAppAlertDialog.getButton(AlertDialog.BUTTON_NEGATIVE).setTextColor(resources.getColor(R.color.idenfyColorPrimary))
        closeAppAlertDialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(resources.getColor(R.color.idenfyColorAccent))
    }


    private fun requestCameraPermission() {
        if (ActivityCompat.shouldShowRequestPermissionRationale(this,
                        Manifest.permission.CAMERA)) {
            ActivityCompat.requestPermissions(this@CameraPreviewActivity,
                    arrayOf(Manifest.permission.CAMERA),
                    REQUEST_PERMISSIONS_CAMERA
            )
        } else {

            ActivityCompat.requestPermissions(this, arrayOf(Manifest.permission.CAMERA),
                    REQUEST_PERMISSIONS_CAMERA
            )
        }
    }

    private fun initRecyclerView() {
        recyclerView = findViewById(R.id.documentsRecyclerView)
        val manager = LinearLayoutManager(this)
        recyclerView!!.layoutManager = manager
    }

    private fun observeDocumentsTypesLiveData() {
        cameraViewModel.documentTypesLiveData.observe(this, Observer { response ->
            if (response != null) {
                val adapter = DocumentsRecyclerViewAdapter(
                        response, this, this,
                        IdenfyController.getInstance().settings.getIdenfyFont(FontEnum.DEFAULT))

                recyclerView!!.adapter = adapter
            }
        })
    }

    fun selectDocument(document: DocumentTypeClass) {
        selectedDocument = document
        resultViewModel.hasRetakeStarted = false
        if (cameraPermission) {
            cameraViewModel.setDocumentType(document)

        } else {
            isDocumentItemPressed = false
            if (wasPermissionRequested) {
                showSnackBar(resources.getString(R.string.idenfy_permission_asks_to_provide_camera_permission_manually))
            }
        }
    }

    private fun observeInitiationOfPhotosTakingFlow() {
        cameraViewModel.setDocumentTypeResponseMutableLiveData.observe(this, Observer { responseBodyResource ->
            if (responseBodyResource != null) {
                if (responseBodyResource.status == Status.LOADING) {

                } else if (responseBodyResource.status == Status.SUCCESS) {
                    setupViewToGetPhoto(responseBodyResource.data!!.documentTypeEnum)
                    cameraViewModel.setDocumentTypeResponseMutableLiveData.value = Resource.loading(null)

                }

            }
        })

    }

    private fun setupViewToGetPhoto(documentTypeEnum: DocumentTypeEnum) {
        cameraViewModel.navigate()
        isDocumentItemPressed = false
    }

    override fun onBackPressed() {

        val fragmentAuth = supportFragmentManager.findFragmentByTag(AUTHENTICATION_RESULTS_FRAGMENT)
        val cameraFragment = supportFragmentManager.findFragmentByTag(DOCUMENT_CAMERA_SESSION_FRAGMENT_TAG)
        val splashScreenFragment = supportFragmentManager.findFragmentByTag(SPLASH_SCREEN_FRAGMENT)
        val documentPhotoResultFragment = supportFragmentManager.findFragmentByTag(DOCUMENT_PHOTO_RESULT_FRAGMENT)
        val facePhotoResultFragment = supportFragmentManager.findFragmentByTag(FACE_PHOTO_RESULT_FRAGMENT)
        val faceSessionFragment = supportFragmentManager.findFragmentByTag(FACE_CAMERA_SESSION_FRAGMENT)
        val docScanningFragment = supportFragmentManager.findFragmentByTag(DOC_SCANNING_FRAGMENT)
        val initialAgreementFragment = supportFragmentManager.findFragmentByTag(INITIAL_AGREEMENT_FRAGMENT)
        if (fragmentAuth != null) {
            if (isIdentificationResulsAnalizationFinished) {
                showRestartAuthenticationDialog()
            }
            return
        }
        if (documentPhotoResultFragment != null || facePhotoResultFragment != null
                || faceSessionFragment != null || cameraFragment != null || docScanningFragment != null) {
            showRestartAuthenticationDialog()
            return
        }
        if (splashScreenFragment != null) {
            return
        }
        if (initialAgreementFragment != null) {
            showCloseAppAlertDialog()
            return
        }
        if (IdenfyController.getInstance().settings.setupAgreementFragment) {
            cameraViewModel.setAddInitialAgreementFragmentMutableLiveData(true)
        } else {
            showCloseAppAlertDialog()
            return
        }


    }

    override fun onRequestPermissionsResult(requestCode: Int, permissions: Array<String>, grantResults: IntArray) {
        if (requestCode == REQUEST_PERMISSIONS_CAMERA) {
            if (permissions.isNotEmpty()) {
                if (permissions[0] == Manifest.permission.CAMERA && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                    mReturningWithResult = true

                } else {
                    wasPermissionRequested = true
                    if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                        if (ActivityCompat.shouldShowRequestPermissionRationale(this,
                                        Manifest.permission.CAMERA)) {
                            ActivityCompat.requestPermissions(this@CameraPreviewActivity,
                                    arrayOf(Manifest.permission.CAMERA),
                                    REQUEST_PERMISSIONS_CAMERA)
                            return
                        }
                    }
                }
            }
        }
    }

    override fun onAuthenticationResultFragmentClosed(closed: Boolean) {
        router.removeAuthenticationResultFragment(supportFragmentManager)

    }

    override fun onCameraNewFragmentClosed(wasSucess: Boolean) {
        onBackPressed()
    }

    override fun onFragmentInteraction(uri: Uri) {

    }

    override fun onRetakeStepsList(value: Boolean?) {
        cameraViewModel.isRecyclerViewEnabled = false
        val retakeSteps = cameraViewModel.handleRetakeSteps(cameraViewModel.savedIdentificationResultResponse!!.retakeSteps)
        val listOfSteps: MutableList<String> = arrayListOf()
        for (step in retakeSteps) {
            listOfSteps.add(step.toString())
        }
        cameraViewModel.setupCurrentDocumentStepsFlow(listOfSteps)
        cameraViewModel.triggerDocumentAsSelected()
        cameraViewModel.navigate()
    }

    override fun onClick(type: DocumentTypeClass) {
        run {
            if (cameraViewModel.isRecyclerViewEnabled) {
                if (router.areFragmentsShown(supportFragmentManager)) {
                    return
                }
                if (!isDocumentItemPressed) {
                    isDocumentItemPressed = true
                    this@CameraPreviewActivity.selectDocument(type)
                }
            }
        }

    }

    override fun OnProvideDocScanningResults(docScanningFeatureResult: DocScanningFeatureResult) {
        val templatesFieldsData = docScanningFeatureResult.templatesFieldsData
        val mrzFieldsData = docScanningFeatureResult.mrzFieldsData
        val documentPhoto = docScanningFeatureResult.photo
        val mainJsonObject = JSONObject()
        try {
            val innerJsonObject = JSONObject()
            if (templatesFieldsData != null) {
                innerJsonObject.put("templateData", templatesFieldsData)
            }
            if (mrzFieldsData != null) {
                innerJsonObject.put("mrzData", mrzFieldsData)
            }
            innerJsonObject.put("documentSide", cameraViewModel.currentDocumentStep.toUpperCase())
            mainJsonObject.put("data", innerJsonObject)
        } catch (e: JSONException) {
            e.printStackTrace()
        }

        LoggingHelper.logDocScanning(com.idenfy.docscanning.DocScanningModule.TAG, mainJsonObject.toString())
        val salt: String = if (BuildConfig.DEBUG) {
            "9aw8rtg796rew8tg7"
        } else {
            "hZPpObNbFfKh8IKV1QTCzZsrwVHwwUQAzjvzogeYGTiNma1z7oVC3KWwSYjB"
        }

        cameraViewModel.handleUploadingDocScanningData(mainJsonObject.toString(), salt, documentPhoto)
    }

    override fun onDocScanningBackPressed(b: Boolean) {
        if (b) onBackPressed()
    }


    override fun onDocScanningDismiss(boolean: Boolean) {
        cameraViewModel.authenticationResultResponseLiveData.value = Resource.loading(null)
        removeAllFragmentsForRestarting()
        cameraViewModel.isRecyclerViewEnabled = true
        restartAuthenticationDialog?.dismiss()
    }

    override fun fragmentShouldBeSwitched() {

        cameraViewModel.setAddDocumentCameraFragment(true)
    }

    companion object {
        const val DOCUMENT_PHOTO_RESULT_FRAGMENT = "DOCUMENT_PHOTO_RESULT_FRAGMENT"
        const val FACE_CAMERA_SESSION_FRAGMENT = "FACE_CAMERA_SESSION_FRAGMENT"
        const val FACE_PHOTO_RESULT_FRAGMENT = "FACE_CAMERA_RESULT_FRAGMENT"
        const val SPLASH_SCREEN_FRAGMENT = "SplashScreenFragment"
        const val DOCUMENT_CAMERA_SESSION_FRAGMENT_TAG = "DocumentsCameraSessionFragment"
        const val DOC_SCANNING_FRAGMENT = "DocumentScanningFragment"
        const val INITIAL_AGREEMENT_FRAGMENT = "InitialAgreementFragment"
        const val AUTHENTICATION_RESULTS_FRAGMENT = "AuthenticationFragment"
        const val DOCUMENT_CAMERA_SESSION_REQUEST_CODE = 101
        const val FACE_CAMERA_SESSION_REQUEST_CODE = 102

    }
}

