package com.idenfy.idenfySdk.initialagreement.ui.views

import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.content.Context
import android.graphics.Point
import android.os.Bundle
import android.support.v4.app.DialogFragment
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.support.v7.widget.SearchView
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.idenfy.idenfySdk.UI.CountriesSelectionView.CountriesRecyclerViewAdapter
import com.idenfy.idenfySdk.UI.CountriesSelectionView.Country
import com.idenfy.idenfySdk.core.ui.viewmodel.CameraViewModel
import com.idenfy.idenfySdk.initialagreement.ui.viewmodels.CountriesSelectionViewModel
import com.idenfy.idenfysdk.core.extensions.livedataextensions.FragmentDialogLifecycleFragment
import com.idenfySdk.R
import java.util.*

class CountriesSelectionFragment : FragmentDialogLifecycleFragment() {

    private var cameraViewModel: CameraViewModel? = null

    val CountriesSelectionViewModel: CountriesSelectionViewModel by lazy {
        ViewModelProviders.of(this).get(com.idenfy.idenfySdk.initialagreement.ui.viewmodels.CountriesSelectionViewModel::class.java)
    }
    private var countryAdapter: CountriesRecyclerViewAdapter? = null
    private var countriesList: List<Country>? = null
    private var recyclerView: RecyclerView? = null
    private var onCountrySelected: OnCountrySelected? = null
    private lateinit var searchView: SearchView

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        cameraViewModel = ViewModelProviders.of(requireActivity()).get(CameraViewModel::class.java)
        setStyle(DialogFragment.STYLE_NO_TITLE, R.style.DialogStyle)

    }

    override fun onResume() {
        if (dialog.window != null) {
            dialog.window!!.setLayout(
                    ViewGroup.LayoutParams.MATCH_PARENT,
                    ViewGroup.LayoutParams.WRAP_CONTENT)
            val window = dialog.window
            dialog.setCanceledOnTouchOutside(true)
            val size = Point()
            val display = window!!.windowManager.defaultDisplay
            display.getSize(size)
            window.setGravity(Gravity.CENTER)
        }

        super.onResume()
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        dialog.setCanceledOnTouchOutside(true)
        isCancelable = true
        super.onViewCreated(view, savedInstanceState)
        val searchView = view.findViewById<SearchView>(R.id.idenfy_search_view_documents_issuing_country)
        searchView.setOnQueryTextListener(object : SearchView.OnQueryTextListener {
            override fun onQueryTextSubmit(query: String): Boolean {
                return false
            }

            override fun onQueryTextChange(newText: String): Boolean {
                val filteredList = ArrayList<Country>()
                if (countriesList != null) {
                    for (i in countriesList!!.indices) {
                        if (countriesList!![i].name.length >= newText.length) {
                            val currentName = countriesList!![i].name.substring(0, newText.length)
                            if (currentName.equals(newText, ignoreCase = true)) {

                                filteredList.add(countriesList!![i])
                            }
                        }
                    }
                    countryAdapter!!.setCountriesList(filteredList)
                }

                return true
            }
        })


    }

    val countriesListObsever = Observer<com.idenfy.idenfySdk.Networking.Resource<List<Country>>>
    {
        if (it == null)
            return@Observer
        countriesList = it.data
        countryAdapter!!.addAll(countriesList)
        countryAdapter!!.notifyDataSetChanged()
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        val linearLayoutManager = LinearLayoutManager(activity)
        countryAdapter = CountriesRecyclerViewAdapter(activity, CountriesRecyclerViewAdapter.onItemClickListener { country ->
            CountriesSelectionViewModel.setSelectedCountry(country)
            cameraViewModel!!.setDismissCountryDialogMutableLiveData(true)
        })

        if (recyclerView != null) {
            recyclerView!!.adapter = countryAdapter
            recyclerView!!.layoutManager = linearLayoutManager
        }

        cameraViewModel!!.getCountriesListMutableLiveData().observe(viewLifecycleOwner!!, countriesListObsever)
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?,
                              savedInstanceState: Bundle?): View? {
        isCancelable = true
        val view = inflater.inflate(R.layout.idenfy_documents_issuing_country_selection_fragment_layout, container, true)
        recyclerView = view.findViewById(R.id.idenfy_documents_issuing_country_selection_recycler_view)
        searchView = view.findViewById(R.id.idenfy_search_view_documents_issuing_country)

        return view
    }

    override fun onAttach(context: Context?) {
        if (context is OnCountrySelected) {
            onCountrySelected = context
        }
        super.onAttach(context)

    }

    override fun onDetach() {
        super.onDetach()
        if (onCountrySelected != null)
            onCountrySelected = null
    }

    override fun onDestroyView() {
        super.onDestroyView()
        if (recyclerView != null) {
            recyclerView!!.adapter = null
            recyclerView!!.layoutManager = null
            recyclerView = null
        }
    }

    companion object {


        fun newInstance(): CountriesSelectionFragment {
            return CountriesSelectionFragment()
        }
    }

    interface OnCountrySelected {
        fun onCountrySelected(country: Country)
    }

}// Required empty public constructor
