package com.idenfy.idenfySdk.core.domain.usecase

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings
import com.idenfy.idenfySdk.Repository.RepositoryKotlin
import com.idenfy.idenfySdk.UI.CountriesSelectionView.Country
import com.idenfy.idenfySdk.domain.GetCountriesListUseCase
import com.idenfy.idenfySdk.domain.GetCountryByIpUseCase
import com.idenfy.idenfySdk.presentation.InitialLoadingDataViewModel
import com.idenfy.idenfysdk.core.models.documentTypeData.DocumentType
import com.idenfy.idenfysdk.core.models.documentTypeData.DocumentTypeClass
import com.idenfy.idenfysdk.core.networking.models.responseBodies.CountryCode
import com.idenfy.idenfysdk.core.networking.models.responseBodies.PartnerInfo
import io.reactivex.Single
import io.reactivex.functions.Function3
import java.util.*

public class InitialLoadingUseCase(val idenfySettings: IdenfySettings,
                                   val getCountriesListUseCase: GetCountriesListUseCase,
                                   val getDocumentTypesUseCase: GetDocumentTypesUseCase,
                                   val getPartnerInfoUseCase: GetPartnerInfoUseCase,
                                   val getCountryByIpUseCase: GetCountryByIpUseCase,
                                   val repository: RepositoryKotlin) {
    fun getInitialLoadingUseCase(): Single<InitialLoadingDataViewModel> {
        getCountriesListUseCase.fetchCountriesList()
        return Single.zip(getDocumentTypesUseCase.getDocumentTypes(), getPartnerInfoUseCase.getPartnerInfo(),
                getCountryByIpUseCase.getCountryCodeByIp(),
                Function3<List<DocumentType>, PartnerInfo, CountryCode, InitialLoadingDataViewModel> { documentsList, partnerInfo, countryCode ->
                    val documentTypeClassList = ArrayList<DocumentTypeClass>()
                    if (!documentsList.isEmpty()) {
                        for (type in documentsList) {
                            val documentTypeClass = DocumentTypeClass(type.getType(), type.getStepEnums(), type.stepEnums)
                            documentTypeClassList.add(documentTypeClass)
                        }
                    }
                    createViewModel(getCountriesListUseCase.countriesListMutableLiveData.value!!.data!!,
                            partnerInfo, documentTypeClassList, countryCode)

                }

        )
    }


    private fun createViewModel(
            countriesList: List<Country>,
            partnerInfo: PartnerInfo,
            documentsList: List<DocumentTypeClass>,
            countryCode: CountryCode
    ): InitialLoadingDataViewModel {


        return InitialLoadingDataViewModel(documentsList, partnerInfo, countryCode, countriesList)
    }

}
