package com.idenfy.idenfySdk.backgrounduploading.domain.usecase

import android.content.Context
import com.idenfy.idenfySdk.backgrounduploading.domain.repository.BackgroundUploadingRepository
import io.reactivex.disposables.CompositeDisposable
import java.io.*
import java.util.zip.ZipEntry
import java.util.zip.ZipOutputStream

class BackgroundCameraPhotosHolderUseCase(val backgroundUploadingRepository: BackgroundUploadingRepository, val applicationContext: Context) {

    fun addNewPhotoToBackgroundPhoto(photo: ByteArray, step: String) {
        backgroundUploadingRepository.addNewPhotoToBackgroundPhotos(photo, step)
    }

    fun setBackgroundPhotos(step: String) {
        if (!backgroundUploadingRepository.getBackgroundPhotos(step).isEmpty()) {
            val bitmapZip = zipBitmap(backgroundUploadingRepository.getBackgroundPhotos(step), step,
                    applicationContext)
            backgroundUploadingRepository.setBackgroundPhotosFile(step,
                    bitmapZip)
        }
    }

    fun zipBitmap(photos: List<ByteArray>, step: String, context: Context): File {
        var photos = photos
        var number = 0
        if (photos.size > 50)
            photos = photos.subList(photos.size - 50, photos.size)

        val zipFile = File(context.cacheDir, step.toUpperCase() + ".zip")
        val baos = ByteArrayOutputStream()
        try {
            ZipOutputStream(baos).use { zos ->
                for (i in 1 until photos.size) {
                    val photo = photos[i]
                    val numberAsString = String.format("%04d", ++number)
                    val entry = ZipEntry(numberAsString)
                    zos.putNextEntry(entry)
                    zos.write(photo)
                    zos.closeEntry()
                }
            }
        } catch (ioe: Exception) {

        }

        try {
            val bos = BufferedOutputStream(FileOutputStream(zipFile))
            bos.write(baos.toByteArray())
            bos.flush()
            bos.close()
        } catch (e: IOException) {

        }
        return zipFile
    }

    fun uploadBackgroundPhotos(libraryLifecycleDisposable: CompositeDisposable, token: String, key: String) {
        backgroundUploadingRepository.uploadBackgroundPhotos(libraryLifecycleDisposable, token, key)
    }


}