package com.idenfy.idenfySdk.UI.UIHelpers.Instructions;

import android.arch.lifecycle.ViewModelProviders;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatDelegate;
import android.view.LayoutInflater;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;

import com.idenfy.idenfySdk.ViewModelsCoreLogic.InstructionViewModel;
import com.idenfy.idenfySdk.core.ui.viewmodel.CameraViewModel;
import com.idenfy.idenfysdk.core.extensions.livedataextensions.ViewLifecycleFragment;
import com.idenfy.idenfysdk.core.models.InstructionModel;
import com.idenfySdk.R;

import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class InstructionFragment extends ViewLifecycleFragment implements TextureView.SurfaceTextureListener {

    private int position;
    private List<InstructionModel> instructionList;
    private InstructionViewModel instructionViewModel;
    private CameraViewModel cameraViewModel;

    private MediaPlayer mMediaPlayer;
    private TextureView mPreview;

    public InstructionFragment newInstance(int position) {
        Bundle args = new Bundle();
        InstructionFragment fragment = new InstructionFragment();
        fragment.setArguments(args);
        args.putInt("position", position);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {

        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);
        instructionViewModel = ViewModelProviders.of(Objects.requireNonNull(getActivity())).get(InstructionViewModel.class);
        cameraViewModel = ViewModelProviders.of(getActivity()).get(CameraViewModel.class);

    }

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.idenfy_view_instructions_video_view_container, container, false);
        Bundle args = getArguments();
        assert args != null;
        position = args.getInt("position");
        mPreview = (TextureView) rootView.findViewById(R.id.idenfy_texture_view_instructions_video_player);
        mPreview.setSurfaceTextureListener(this);

        return rootView;
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {

        if (getContext() == null)
            return;

        try {
            mMediaPlayer = new MediaPlayer();
            if (instructionViewModel.getInstructionModelList() == null || instructionViewModel.getInstructionModelList().getValue() == null)
                return;
            instructionList = instructionViewModel.getInstructionModelList().getValue();
            Uri mediaPath = Uri.parse("android.resource://" + getContext().getPackageName() + "/" + instructionList.get(position).getVideo());
            mMediaPlayer.setDataSource(getContext(), mediaPath);
            mMediaPlayer.setSurface(new Surface(surface));
            mMediaPlayer.setLooping(true);
            mMediaPlayer.prepare();
            mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener() {
                @Override
                public void onPrepared(MediaPlayer mp) {
                    mMediaPlayer.start();
                }
            });
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        } catch (SecurityException e) {
            e.printStackTrace();
        } catch (IllegalStateException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {

    }

    @Override
    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        return false;
    }

    @Override
    public void onSurfaceTextureUpdated(SurfaceTexture surface) {

    }

    @Override
    public void onPause() {
        super.onPause();
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
        if (cameraViewModel.getSaveFragment().getValue() == null || !cameraViewModel.getSaveFragment().getValue()) {
            if (mMediaPlayer != null) {
                mMediaPlayer.release();
                mMediaPlayer = null;
            }
        }
    }
}
