package com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.idenfy.idenfySdk.helpers.IdenfyIdentificationStatus;

public class AuthenticationResultResponse implements Parcelable {
    @SerializedName("identificationStatus")
    @Expose
    private String identificationStatus;
    @SerializedName("errorMessage")
    @Expose
    @Nullable
    private ErrorMessage errorMessage;

    private IdenfyIdentificationStatus idenfyIdentificationStatus;


    public AuthenticationResultResponse(String identificationStatus, ErrorMessage errorMessage, IdenfyIdentificationStatus idenfyIdentificationStatus) {
        this.identificationStatus = identificationStatus;
        this.errorMessage = errorMessage;
        this.idenfyIdentificationStatus = idenfyIdentificationStatus;
    }

    protected AuthenticationResultResponse(Parcel in) {
        identificationStatus = in.readString();
        errorMessage = in.readParcelable(ErrorMessage.class.getClassLoader());
        idenfyIdentificationStatus = IdenfyIdentificationStatus.valueOf(in.readString());
    }


    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(identificationStatus);
        dest.writeParcelable(errorMessage, flags);
        dest.writeString(idenfyIdentificationStatus.name());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<AuthenticationResultResponse> CREATOR = new Creator<AuthenticationResultResponse>() {
        @Override
        public AuthenticationResultResponse createFromParcel(Parcel in) {
            return new AuthenticationResultResponse(in);
        }

        @Override
        public AuthenticationResultResponse[] newArray(int size) {
            return new AuthenticationResultResponse[size];
        }
    };

    public String getIdentificationStatus() {
        return identificationStatus;
    }

    public ErrorMessage getErrorMessage() {
        return errorMessage;
    }

    public IdenfyIdentificationStatus getIdenfyIdentificationStatus() {
        return idenfyIdentificationStatus;
    }

    @Override
    public String toString() {
        return "AuthenticationResultResponse{" +
                "identificationStatus='" + identificationStatus + '\'' +
                ", errorMessage=" + errorMessage +
                ", idenfyIdentificationStatus=" + idenfyIdentificationStatus +
                '}';
    }
}