package com.idenfy.idenfySdk.core.domain.usecase

import android.arch.lifecycle.MutableLiveData
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyUserFlowController
import com.idenfy.idenfySdk.Networking.APIService
import com.idenfy.idenfySdk.Networking.ProcessUploadCompletion
import com.idenfy.idenfySdk.Networking.Resource
import com.idenfy.idenfySdk.Repository.RepositoryKotlin
import com.idenfy.idenfysdk.core.extensions.livedataextensions.default
import com.idenfy.idenfysdk.core.extensions.rxextensions.retryWhenError
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.CompositeDisposable
import io.reactivex.schedulers.Schedulers

class StartProcessingUseCase(val repository: RepositoryKotlin, val apiService: APIService, val disposable: CompositeDisposable) {

    var startedProcessingLiveData = MutableLiveData<Resource<ProcessUploadCompletion>>().default(Resource.loading<ProcessUploadCompletion>(null))
    fun startProcessing() {
        disposable.add(apiService.startProcessObservable(repository.getAuthTokenRequest()).retryWhenError(5, 1, false)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread()).subscribe({
                    IdenfyUserFlowController.onProcessingStarted(true)
                    startedProcessingLiveData.value = Resource.success(ProcessUploadCompletion(true))
                }, {
                    repository.handleErrorInstance(it)
                }))
    }


}