package com.idenfy.idenfySdk.backgrounduploading.datasource

import com.idenfy.idenfySdk.Networking.APIService
import com.idenfy.idenfySdk.backgrounduploading.data.datasource.BackgroundUploadingDataSource
import java.io.File

class BackgroundUploadingDataSourceImpl constructor(val apiService: APIService,
                                                    val documentsPhotoHolder: HashMap<String, MutableList<ByteArray>> =
                                                            HashMap<String, MutableList<ByteArray>>()) : BackgroundUploadingDataSource {
    override fun emptyBackgroundPhotos(step: String) {
        documentsPhotoHolder[step]?.clear()
    }

    override fun setupSteps(steps: List<String>) {

    }

    override fun getUploadingFile(key: String): File? {
        return backgroundPhotos[key]
    }

    override fun getBackgroundPhotos(key: String): MutableList<ByteArray> {
        if (documentsPhotoHolder[key] == null)
            documentsPhotoHolder[key] = arrayListOf()
        // Log.d("background", documentsPhotoHolder[key]?.size.toString())
        return documentsPhotoHolder[key]!!
    }

    override fun uploadBackgroundPhotos() {

    }

    override fun addNewPhotoToBackgroundPhotos(photo: ByteArray, step: String) {
        if (documentsPhotoHolder[step] == null)
            documentsPhotoHolder[step] = arrayListOf()
        if (documentsPhotoHolder[step]!!.size >= 101) {
            documentsPhotoHolder[step]!!.subList(0, documentsPhotoHolder[step]!!.size - 50).clear();
            // Log.d("background", "aftereclrear:" + documentsPhotoHolder[step]!!.size)
        }
        documentsPhotoHolder[step]!!.add(photo)
    }

    override fun setBackgroundPhotosFile(key: String, photos: File) {
        backgroundPhotos[key] = photos
    }

    val backgroundPhotos = java.util.HashMap<String, File>()


}