package com.idenfy.idenfySdk.UI.UIHelpers.Instructions

import android.content.Context
import com.idenfy.idenfysdk.core.models.InstructionModel
import com.idenfySdk.R
import java.util.*

object SetUpInstructionModels {

    fun setUpPassportInstructions(context: Context): List<InstructionModel> {
        val passportStep1 = InstructionModel(R.raw.idenfy_instructions_passport_correct,
                context.getString(R.string.idenfy_instructions_passport_correct_title), context.getString(R.string.idenfy_instructions_passport_correct_text))
        val passportStep2 = InstructionModel(R.raw.idenfy_instructions_passport_mrz,
                context.getString(R.string.idenfy_instructions_passport_mrz_title), context.getString(R.string.idenfy_instructions_passport_mrz_text))
        val passportStep3 = InstructionModel(R.raw.idenfy_instructions_passport_fit_frames,
                context.getString(R.string.idenfy_instructions_passport_fits_frame_title), context.getString(R.string.idenfy_instructions_passport_fits_frame_text))
        val passportStep4 = InstructionModel(R.raw.idenfy_instructions_passport_finger_cover,
                context.getString(R.string.idenfy_instructions_passport_finger_title), context.getString(R.string.idenfy_instructions_passport_finger_text))
        val passportStep5 = InstructionModel(R.raw.idenfy_instructions_passport_light_reflection,
                context.getString(R.string.idenfy_instructions_passport_reflection_title), context.getString(R.string.idenfy_instructions_passport_reflection_text))
        return Arrays.asList(passportStep1, passportStep2, passportStep3, passportStep4, passportStep5)
    }

    fun setUpIdFrontInstructions(context: Context): List<InstructionModel> {
        val idFrontStep1 = InstructionModel(R.raw.idenfy_instructions_id_card_front_correct,
                context.getString(R.string.idenfy_instructions_id_front_correct_title), context.getString(R.string.idenfy_instructions_id_front_correct_text))
        val idFrontStep2 = InstructionModel(R.raw.idenfy_instructions_id_card_front_fit_frames,
                context.getString(R.string.idenfy_instructions_id_front_fit_frame_title), context.getString(R.string.idenfy_instructions_id_front_fit_frame_text))
        val idFrontStep3 = InstructionModel(R.raw.idenfy_instructions_id_card_front_finger_cover,
                context.getString(R.string.idenfy_instructions_id_front_finger_title), context.getString(R.string.idenfy_instructions_id_front_finger_text))
        val idFrontStep4 = InstructionModel(R.raw.idenfy_instructions_id_card_front_light_reflection,
                context.getString(R.string.idenfy_instructions_id_front_reflection_title), context.getString(R.string.idenfy_instructions_id_front_reflection_text))
        return Arrays.asList(idFrontStep1, idFrontStep2, idFrontStep3, idFrontStep4)
    }

    fun setUpIdBackInstructions(context: Context): List<InstructionModel> {
        val idBackStep1 = InstructionModel(R.raw.idenfy_instructions_id_card_back_correct,
                context.getString(R.string.idenfy_instructions_id_back_correct_title), context.getString(R.string.idenfy_instructions_id_back_correct_text))
        val idBackStep2 = InstructionModel(R.raw.idenfy_instructions_id_card_back_mrz,
                context.getString(R.string.idenfy_instructions_id_back_mrz_title), context.getString(R.string.idenfy_instructions_id_back_mrz_text))
        val idBackStep3 = InstructionModel(R.raw.idenfy_instructions_id_card_back_fit_frames,
                context.getString(R.string.idenfy_instructions_id_back_fit_frame_title), context.getString(R.string.idenfy_instructions_id_back_fit_frame_text))
        val idBackStep4 = InstructionModel(R.raw.idenfy_instructions_id_card_back_finger_cover,
                context.getString(R.string.idenfy_instructions_id_back_finger_title), context.getString(R.string.idenfy_instructions_id_back_finger_text))
        return Arrays.asList(idBackStep1, idBackStep2, idBackStep3, idBackStep4)
    }

    fun setUpDriverLicenseFrontInstructions(context: Context): List<InstructionModel> {
        val driverFront1 = InstructionModel(R.raw.idenfy_instructions_driving_license_front_correct,
                context.getString(R.string.idenfy_instructions_driver_license_front_correct_title), context.getString(R.string.idenfy_instructions_driver_license_front_correct_text))
        val driverFront2 = InstructionModel(R.raw.idenfy_instructions_driving_license_front_fit_frames,
                context.getString(R.string.idenfy_instructions_driver_license_front_fit_frame_title), context.getString(R.string.idenfy_instructions_driver_license_front_fit_frame_text))
        val driverFront3 = InstructionModel(R.raw.idenfy_instructions_driving_license_front_finger_cover,
                context.getString(R.string.idenfy_instructions_driver_license_front_finger_title), context.getString(R.string.idenfy_instructions_driver_license_front_finger_text))
        val driverFront4 = InstructionModel(R.raw.idenfy_instructions_driving_license_front_light_reflection,
                context.getString(R.string.idenfy_instructions_driver_license_front_reflection_title), context.getString(R.string.idenfy_instructions_driver_license_front_reflection_text))
        return Arrays.asList(driverFront1, driverFront2, driverFront3, driverFront4)
    }

    fun setUpResidencePermitFrontInstructions(context: Context): List<InstructionModel> {
        val residenceFront1 = InstructionModel(R.raw.idenfy_instructions_residence_permit_front_correct,
                context.getString(R.string.idenfy_instructions_residence_permit_front_correct_title), context.getString(R.string.idenfy_instructions_residence_permit_front_correct_text))
        val residenceFront2 = InstructionModel(R.raw.idenfy_instructions_residence_permit_front_fit_frames,
                context.getString(R.string.idenfy_instructions_residence_permit_front_fit_frame_title), context.getString(R.string.idenfy_instructions_residence_permit_front_fit_frame_text))
        val residenceFront3 = InstructionModel(R.raw.idenfy_instructions_residence_permit_front_finger_cover,
                context.getString(R.string.idenfy_instructions_residence_permit_front_finger_title), context.getString(R.string.idenfy_instructions_residence_permit_front_finger_text))
        val residenceFront4 = InstructionModel(R.raw.idenfy_instructions_residence_permit_front_light_reflection,
                context.getString(R.string.idenfy_instructions_residence_permit_front_reflection_title), context.getString(R.string.idenfy_instructions_residence_permit_front_reflection_text))
        return Arrays.asList(residenceFront1, residenceFront2, residenceFront3, residenceFront4)
    }

    fun setUpResidencePermitBackInstructions(context: Context): List<InstructionModel> {
        val residenceBack1 = InstructionModel(R.raw.idenfy_instructions_id_card_back_correct,
                context.getString(R.string.idenfy_instructions_residence_permit_back_correct_title), context.getString(R.string.idenfy_instructions_residence_permit_back_correct_text))
        val residenceBack2 = InstructionModel(R.raw.idenfy_instructions_id_card_back_mrz,
                context.getString(R.string.idenfy_instructions_residence_permit_back_mrz_title), context.getString(R.string.idenfy_instructions_residence_permit_back_mrz_text))
        val residenceBack3 = InstructionModel(R.raw.idenfy_instructions_id_card_back_fit_frames,
                context.getString(R.string.idenfy_instructions_residence_permit_back_fit_frame_title), context.getString(R.string.idenfy_instructions_residence_permit_back_fit_frame_text))
        val residenceBack4 = InstructionModel(R.raw.idenfy_instructions_id_card_back_finger_cover,
                context.getString(R.string.idenfy_instructions_residence_permit_back_finger_title), context.getString(R.string.idenfy_instructions_residence_permit_back_finger_text))
        return Arrays.asList(residenceBack1, residenceBack2, residenceBack3, residenceBack4)
    }

    fun setUpOtherDocumentsFrontInstructions(context: Context): List<InstructionModel> {
        val otherFront1 = InstructionModel(R.raw.idenfy_instructions_other_documents_front_correct,
                context.getString(R.string.idenfy_instructions_other_front_mrz_title), context.getString(R.string.idenfy_instructions_other_front_mrz_text))
        val otherFront2 = InstructionModel(R.raw.idenfy_instructions_other_documents_front_fit_frames,
                context.getString(R.string.idenfy_instructions_other_front_fit_frame_title), context.getString(R.string.idenfy_instructions_other_front_fit_frame_text))
        val otherFront3 = InstructionModel(R.raw.idenfy_instructions_other_documents_front_finger_cover,
                context.getString(R.string.idenfy_instructions_other_front_finger_title), context.getString(R.string.idenfy_instructions_other_front_finger_text))
        val otherFront4 = InstructionModel(R.raw.idenfy_instructions_other_documents_front_light_reflection,
                context.getString(R.string.idenfy_instructions_other_front_reflection_title), context.getString(R.string.idenfy_instructions_other_front_reflection_text))
        return Arrays.asList(otherFront1, otherFront2, otherFront3, otherFront4)
    }

    fun setUpOtherDocumentsBackInstructions(context: Context): List<InstructionModel> {
        val otherBack1 = InstructionModel(R.raw.idenfy_instructions_other_documents_back_fit_frames,
                context.getString(R.string.idenfy_instructions_other_back_fit_frame_title), context.getString(R.string.idenfy_instructions_other_back_fit_frame_text))
        val otherBack2 = InstructionModel(R.raw.idenfy_instructions_other_documents_back_finger_cover,
                context.getString(R.string.idenfy_instructions_other_back_finger_title), context.getString(R.string.idenfy_instructions_other_back_finger_text))
        return Arrays.asList(otherBack1, otherBack2)
    }

    fun setUpFaceInstructions(context: Context, isZoomNeeded: Boolean): List<InstructionModel> {
        val modelList = ArrayList<InstructionModel>()
        modelList.add(InstructionModel(R.raw.idenfy_instructions_face_fit_frames,
                context.getString(R.string.idenfy_instructions_face_fit_frame_title), context.getString(R.string.idenfy_instructions_face_fit_frame_text)))
        modelList.add(InstructionModel(R.raw.idenfy_instructions_face_only_one_visible,
                context.getString(R.string.idenfy_instructions_face_one_face_title), context.getString(R.string.idenfy_instructions_face_one_face_text)))
        modelList.add(InstructionModel(R.raw.idenfy_instructions_face_covered_shadow,
                context.getString(R.string.idenfy_instructions_face_shadow_title), context.getString(R.string.idenfy_instructions_face_shadow_text)))
        if (isZoomNeeded) {
            modelList.add(InstructionModel(R.raw.idenfy_instructions_face_zoom,
                    context.getString(R.string.idenfy_instructions_face_zoom_title), context.getString(R.string.idenfy_instructions_face_zoom_text)))
        }
        return modelList
    }
}
