package com.idenfy.idenfySdk.core.domain.usecase

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings
import com.idenfy.idenfySdk.Networking.APIService
import com.idenfy.idenfySdk.Repository.RepositoryKotlin
import com.idenfy.idenfysdk.core.networking.models.requestBodies.SetDeviceTypeForAPI
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.CompositeDisposable
import io.reactivex.schedulers.Schedulers

class SetDeviceTypeUseCase(val repository: RepositoryKotlin, val apiService: APIService, val idenfySettings: IdenfySettings, val disposable: CompositeDisposable) {

    val DEVICE_TYPE = "MOBILE_SDK"
    fun setDeviceType() {
        val setDeviceTypeForAPI = SetDeviceTypeForAPI(idenfySettings.token,
                DEVICE_TYPE)
        disposable.add(apiService.setDeviceTypeForAPIObservable(setDeviceTypeForAPI).subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread()).subscribe({
                }, {
                    repository.handleErrorInstance(it)
                }))

    }
}