package com.idenfy.idenfySdk.ViewModelsCoreLogic

import android.app.Application
import android.arch.lifecycle.AndroidViewModel
import android.arch.lifecycle.MutableLiveData
import android.content.Context
import com.idenfy.idenfysdk.core.common.presentation.models.InstructionEnum
import com.idenfy.idenfySdk.UI.UIHelpers.Instructions.SetUpInstructionModels
import com.idenfy.idenfysdk.core.models.InstructionModel
import java.util.*

class InstructionViewModel(application: Application) : AndroidViewModel(application) {

    private var currentInstructionEnum: InstructionEnum? = null

    var instructionModelList: MutableLiveData<List<InstructionModel>>? = MutableLiveData()
        private set

    fun getCurrentInstructionEnum(): InstructionEnum? {
        return currentInstructionEnum
    }

    fun setCurrentInstructionEnum(currentInstructionEnum: InstructionEnum) {
        this.currentInstructionEnum = currentInstructionEnum
    }

    fun createInstructionModelList(context: Context) {

        when (currentInstructionEnum) {
            InstructionEnum.PASSPORT -> {
                instructionModelList?.value = SetUpInstructionModels.setUpPassportInstructions(Objects.requireNonNull(context))
            }
            InstructionEnum.ID_CARD_FRONT -> {
                instructionModelList?.value = SetUpInstructionModels.setUpIdFrontInstructions(Objects.requireNonNull(context))
            }
            InstructionEnum.ID_CARD_BACK -> {
                instructionModelList?.value = SetUpInstructionModels.setUpIdBackInstructions(Objects.requireNonNull(context))
            }
            InstructionEnum.DRIVER_LICENSE -> {
                instructionModelList?.value = SetUpInstructionModels.setUpDriverLicenseFrontInstructions(Objects.requireNonNull(context))
            }
            InstructionEnum.RESIDENCE_PERMIT_FRONT -> {
                instructionModelList?.value = SetUpInstructionModels.setUpResidencePermitFrontInstructions(Objects.requireNonNull(context))
            }
            InstructionEnum.RESIDENCE_PERMIT_BACK -> {
                instructionModelList?.value = SetUpInstructionModels.setUpResidencePermitBackInstructions(Objects.requireNonNull(context))
            }
            InstructionEnum.OTHER_FRONT -> {
                instructionModelList?.value = SetUpInstructionModels.setUpOtherDocumentsFrontInstructions(Objects.requireNonNull(context))
            }
            InstructionEnum.OTHER_BACK -> {
                instructionModelList?.value = SetUpInstructionModels.setUpOtherDocumentsBackInstructions(Objects.requireNonNull(context))
            }
            InstructionEnum.FACE_PHOTO -> instructionModelList?.value = SetUpInstructionModels.setUpFaceInstructions(Objects.requireNonNull(context), false)
            InstructionEnum.FACE_PHOTO_WITH_LIVENESS -> instructionModelList?.value = SetUpInstructionModels.setUpFaceInstructions(Objects.requireNonNull(context), true)
        }
    }


}
