/*
 * Copyright (c) 2014-2015 Amberfog.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.idenfy.idenfySdk.UI.CountriesSelectionView;

import android.content.Context;
import android.support.annotation.NonNull;

public class Country implements Comparable {

    private String mName;
    private String mCountryISO2;
    private String mCountryISO3;
    private int mCountryCode;
    private String mCountryCodeStr;
    private int mPriority;
    private int mResId;
    private int mNum;

    public Country(CountryEnum country_enum, int i, Context context) {
        this.mName = country_enum.getCountryName();
        this.mCountryISO2 = country_enum.getCountryCodeA2();
        this.mCountryISO3 = country_enum.getCountryCodeA3();
        this.mNum = i;
        String fileName = "flag_" + this.getCountryISO().toLowerCase();
        mResId = context.getApplicationContext().getResources().getIdentifier(fileName, "drawable", context.getApplicationContext().getPackageName());
    }

    public Country(String mCountryISO2) {
        this.mCountryISO2 = mCountryISO2;
    }

    @Override
    public String toString() {
        return mCountryISO2 + '(' +
                '"' + mName + '"' +
                ',' + '"' + mCountryISO2 + '"' + ',' + '"' + mCountryCodeStr + '"' +
                ')' + ',' + '\n';
    }

    public String getName() {
        return mName;
    }

    public String getCountryISO() {
        return mCountryISO2;
    }

    public String getmCountryISO3() {
        return mCountryISO3;
    }

    public void setmCountryISO3(String mCountryISO3) {
        this.mCountryISO3 = mCountryISO3;
    }

    public int getCountryCode() {
        return mCountryCode;
    }

    public String getCountryCodeStr() {
        return mCountryCodeStr;
    }

    public int getPriority() {
        return mPriority;
    }

    public int getResId() {
        return mResId;
    }

    public int getNum() {
        return mNum;
    }


    @Override
    public int compareTo(@NonNull Object o) {
        Country country = (Country) o;
        return this.mName.compareTo(country.getName());
    }

    @Override
    public boolean equals(Object obj) {

        try {
            Country country = (Country) obj;
            return mCountryISO2.equals(country.getCountryISO());
        } catch (Exception e) {
            return false;
        }

    }
}
