package com.idenfy.idenfySdk.UI.CameraView;


import android.annotation.SuppressLint;
import android.app.Activity;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.design.widget.TabLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.AppCompatImageButton;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings;
import com.idenfy.idenfysdk.core.common.presentation.uiviewmodels.CurrentStepUIViewModel;
import com.idenfy.idenfysdk.core.common.presentation.models.InstructionEnum;
import com.idenfy.idenfySdk.UI.UIHelpers.DocumentsCameraSessionFrameProcessor;
import com.idenfy.idenfySdk.UI.UIHelpers.Instructions.InstructionDynamicSizeManager;
import com.idenfy.idenfySdk.UI.UIHelpers.Instructions.InstructionPagerAdapter;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.InstructionViewModel;
import com.idenfy.idenfysdk.core.extensions.livedataextensions.ViewLifecycleFragment;
import com.idenfy.idenfysdk.core.ui.customviews.CustomViewHolder;
import com.idenfy.idenfySdk.UI.DocumentPhotoResultView.DocumentPhotoResult;
import com.idenfy.idenfySdk.core.ui.view.CameraPreviewActivity;
import com.idenfy.idenfySdk.UI.UIHelpers.BitmapPhotoCropper;
import com.idenfy.idenfySdk.UI.UIHelpers.Instructions.TopSheetBehavior;
import com.idenfy.idenfySdk.core.ui.viewmodel.CameraViewModel;
import com.idenfy.idenfySdk.liveness.LivenessesViewModel;
import com.idenfy.idenfySdk.helpers.IdentificationStepsTitlesHelper;
import com.idenfy.idenfysdk.core.logging.LoggingHelper;
import com.idenfy.idenfysdk.core.models.InstructionModel;
import com.idenfy.idenfysdk.core.ui.uihelpers.CameraDisplayHelpers;
import com.idenfy.idenfysdk.core.ui.uihelpers.CameraViewSize;
import com.idenfy.idenfysdk.core.utils.ui.DpToPixelConverter;
import com.idenfySdk.R;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

import io.fotoapparat.Fotoapparat;
import io.fotoapparat.configuration.CameraConfiguration;
import io.fotoapparat.configuration.UpdateConfiguration;
import io.fotoapparat.parameter.FocusMode;
import io.fotoapparat.parameter.ScaleType;
import io.fotoapparat.parameter.camera.CameraParameters;
import io.fotoapparat.preview.FrameProcessor;
import io.fotoapparat.result.BitmapPhoto;
import io.fotoapparat.result.WhenDoneListener;
import io.fotoapparat.selector.PreviewFpsRangeSelectorsKt;
import io.fotoapparat.selector.ResolutionSelectorsKt;
import io.fotoapparat.view.CameraView;
import io.fotoapparat.view.FocusView;
import kotlin.Pair;

import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.auto;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz50;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz60;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.none;
import static io.fotoapparat.selector.FocusModeSelectorsKt.autoFocus;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusPicture;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusVideo;
import static io.fotoapparat.selector.FocusModeSelectorsKt.fixed;
import static io.fotoapparat.selector.LensPositionSelectorsKt.back;
import static io.fotoapparat.selector.ResolutionSelectorsKt.highestResolution;
import static io.fotoapparat.selector.SelectorsKt.firstAvailable;
import static io.fotoapparat.selector.SensorSensitivitySelectorsKt.highestSensorSensitivity;

public class DocumentsCameraSessionFragment extends ViewLifecycleFragment {

    public Fotoapparat fotoapparat;
    private ViewPager viewPager;
    private ImageView expandArrow;
    private TopSheetBehavior topSheetBehavior;
    private ConstraintLayout topSheet;
    private ConstraintLayout topSheetLayout;
    private InstructionPagerAdapter instructionPagerAdapter;
    private ImageView nextPageButton;
    private ImageView previousPageButton;
    private ImageView donePageButton;
    private TextView instructionTitle;
    private TextView instructionText;
    CameraView cameraView;
    CameraViewModel cameraViewModel;
    InstructionViewModel instructionViewModel;
    LivenessesViewModel livenessesViewModel;
    ConstraintLayout imageInfoLayout, imageViewResultConstraintLayout;
    TextView documentTitleTutorial;
    ConstraintLayout previewHolder;
    private FocusView fotoapparatFocusView;
    private View customFocusView;
    private AppCompatImageButton takePictureButton;
    private DocumentsCameraSessionFrameProcessor frameProcessor;
    private InstructionDynamicSizeManager instructionDynamicSizeManager;

    private ImageView imageView;
    private TextView documentBorderTextView;
    private View rootView;
    ImageView backButton;
    ImageView backImage;
    TextView backTextView;
    TextView backTextViewDefault;

    private List<InstructionModel> instructionList;
    private boolean shouldShowInstructions;
    private int[] documentSessionTitle;

    private CameraConfiguration cameraConfiguration;
    private RelativeLayout customShapes;
    private OnCameraClosedFragment mFragmentClosedListener;
    //Handlers
    private Handler takePictureHandler = new Handler();
    private Handler recreateButtonHandler = new Handler();
    private Handler nextButtonHandler = new Handler();
    private Handler fotoapparatSetupHandler = new Handler();
    private Handler autoFocusHandler = new Handler();
    private Handler backgroundPhotoHandler = new Handler();
    private Handler slideDownInstructionsHandler = new Handler();

    Runnable focusRunnable = new Runnable() {
        @Override
        public void run() {
            if (fotoapparat != null)
                fotoapparat.getCurrentParameters().whenDone(cameraParameters -> {
                    if (cameraParameters != null)
                        if (!cameraParameters.getFocusMode().equals(FocusMode.ContinuousFocusPicture.INSTANCE) ||
                                !cameraParameters.getFocusMode().equals(FocusMode.ContinuousFocusVideo.INSTANCE)) {
                            if (fotoapparat != null) {
                                fotoapparat.updateConfiguration(
                                        UpdateConfiguration.builder().focusMode(
                                                firstAvailable(continuousFocusPicture(), continuousFocusVideo())).build());
                                canFocus.set(true);
                            }
                        }
                });
        }
    };
    //Logic values
    AtomicBoolean canFocus = new AtomicBoolean(true);
    //View drawings values
    private int rectangleLeft;
    private int rectangleTop;
    private int rectangleRight;
    private int rectangleBottom;
    private int heightOfImage;
    private int yCoordinateOfHeightStart;
    private int widthOfImage;
    private int xCoordinateOfWidthStart;
    private final int rectangeMargin = 5;




    public interface OnCameraClosedFragment {
        public void onCameraNewFragmentClosed(boolean closed);
    }

    public DocumentsCameraSessionFragment() {

    }

    IdentificationStepsTitlesHelper identificationStepsTitlesHelper = new IdentificationStepsTitlesHelper();


    @Override
    public void onCreate(Bundle savedInstanceState) {

        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            if (getActivity() != null)
                frameProcessor = new DocumentsCameraSessionFrameProcessor(getActivity());
            setFotoapparatCameraSettins(frameProcessor);
        }
        livenessesViewModel = ViewModelProviders.of(getActivity()).get(LivenessesViewModel.class);
        cameraViewModel = ViewModelProviders.of(Objects.requireNonNull(getActivity())).get(CameraViewModel.class);
        instructionViewModel = ViewModelProviders.of(Objects.requireNonNull(getActivity())).get(InstructionViewModel.class);
        instructionDynamicSizeManager = new InstructionDynamicSizeManager();
    }


    public void setupCamera() {

        Activity activity = getActivity();
        if (isAdded() && activity != null) {
            if (fotoapparatFocusView != null && cameraView != null) {
                fotoapparat = Fotoapparat
                        .with(getActivity())
                        .into(cameraView)
                        .previewScaleType(ScaleType.CenterCrop)
                        .previewResolution(highestResolution())
                        .lensPosition(back())
                        .focusMode(firstAvailable(
                                continuousFocusPicture(),
                                continuousFocusVideo(),
                                autoFocus(),
                                fixed()
                        ))
                        .focusView(fotoapparatFocusView)
                        .photoResolution(ResolutionSelectorsKt.highestResolution())
                        .frameProcessor(frameProcessor)
                        .cameraErrorCallback(e -> {
                            if(cameraViewModel.checkIfCanRetryDocumentCamera())
                            cameraViewModel.setAddDocumentCameraFragment(true);
                            else cameraViewModel.setAddDocumentCameraFragment(false);
                        })
                        .build();
            }

        }
    }

    private void setFotoapparatCameraSettins(FrameProcessor frameProcessor) {
        cameraConfiguration = CameraConfiguration
                .builder()
                .previewFpsRange(PreviewFpsRangeSelectorsKt.highestFps())
                .sensorSensitivity(highestSensorSensitivity())
                .frameProcessor(frameProcessor)
                .antiBandingMode(firstAvailable(
                        auto(),
                        hz60(),
                        hz50(),
                        none()
                ))
                .focusMode(firstAvailable(
                        continuousFocusPicture(),
                        continuousFocusVideo(),
                        autoFocus(),
                        fixed()
                ))
                .build();
    }

    private void initializeUI(View rootView) {
        viewPager = rootView.findViewById(R.id.instructionViewPager);
        expandArrow = rootView.findViewById(R.id.expandArrow);
        nextPageButton = rootView.findViewById(R.id.nextPageButton);
        previousPageButton = rootView.findViewById(R.id.previousPageButton);
        donePageButton = rootView.findViewById(R.id.donePageButton);
        topSheet = rootView.findViewById(R.id.top_sheet);
        topSheetLayout = rootView.findViewById(R.id.idenfy_topsheet_layout);
        instructionTitle = rootView.findViewById(R.id.instructionTitle);
        instructionText = rootView.findViewById(R.id.instructionText);
        cameraView = rootView.findViewById(R.id.cameraView);
        imageInfoLayout = rootView.findViewById(R.id.showImageLayout);
        documentTitleTutorial = rootView.findViewById(R.id.camera_session_information_text_view);
        takePictureButton = rootView.findViewById(R.id.takePictureButton);
        backImage = rootView.findViewById(R.id.backImage_instructions);
        backTextView = rootView.findViewById(R.id.back_text_view_instructions);
        customShapes = rootView.findViewById(R.id.custom_shapes);
        customShapes.setVisibility(View.VISIBLE);
        imageViewResultConstraintLayout = rootView.findViewById(R.id.results_background);
        fotoapparatFocusView = rootView.findViewById(R.id.fotoapparat_focus);

        imageView = rootView.findViewById(R.id.imageView);
        documentBorderTextView = rootView.findViewById(R.id.document_overlay_title);
        if (fotoapparatFocusView != null) {
            fotoapparatFocusView.setVisibility(View.VISIBLE);
        }
        customFocusView = rootView.findViewById(R.id.custom_focus);

    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        rootView = inflater.inflate(R.layout.idenfy_camera_preview_session_fragment_with_instructions, container, false);
        previewHolder = rootView.findViewById(R.id.previewHolder);
        if (cameraViewModel.getCurrentStepUIViewModelLiveData().getValue()!= null &&
                cameraViewModel.getCurrentStepUIViewModelLiveData().getValue().getInstrcutionEnum()!=InstructionEnum.INSTRUCTION_NOT_NEEDED) {
            shouldShowInstructions = true;
            initializeUI(rootView);
            documentTitleTutorial = rootView.findViewById(R.id.camera_session_information_text_view_instructions);
        }
        else {
            initializeUI(rootView);
        }
        return rootView;
    }

    CurrentStepUIViewModel currentStepUIViewModel;
    private void observeDocumentType() {

        cameraViewModel.getCurrentStepUIViewModelLiveData().observe(getViewLifecycleOwner(), response -> {


            if (response != null) {
                currentStepUIViewModel = response;
                instructionViewModel.setCurrentInstructionEnum(response.getInstrcutionEnum());
                setupDocumentTitle(response.getSessionInformationTitle());
                setupDocumentView(response.getDocumentCameraFrameRatio());
                setupDocumentOverlayString(response.getOverlayTitle());

                if(response.getInstrcutionEnum() != InstructionEnum.INSTRUCTION_NOT_NEEDED) {
                    if(getContext() != null) {
                        instructionViewModel.createInstructionModelList(getContext());
                        instructionViewModel.getInstructionModelList().observe(getViewLifecycleOwner(), new Observer<List<InstructionModel>>() {
                            @Override
                            public void onChanged(@Nullable List<InstructionModel> instructionModels) {
                                instructionList = instructionModels;
                                setUpInstructions();
                            }
                        });
                    }
                }
                documentSessionTitle = response.getSessionInformationTitle();
                setUpViews(documentSessionTitle);
                setupListenersForButtons();

            }
        });

    }

    private void setupUI(CurrentStepUIViewModel response) {

        setupDocumentTitle(response.getSessionInformationTitle());
        setupDocumentView(response.getDocumentCameraFrameRatio());
        setupDocumentOverlayString(response.getOverlayTitle());
    }

    private void setupDocumentOverlayString(Pair<Integer, String> resID) {
        if (documentBorderTextView == null) {
            return;
        }
        if(resID.getSecond()!=null)
            documentBorderTextView.setText(resID.getSecond());
        else{
            documentBorderTextView.setText(getResources().getString(resID.getFirst()));

        }


        }


    private void setupDocumentTitle(int[] resIdArray) {
        if(resIdArray[1]==0){
            documentTitleTutorial.setText(getResources().getString(resIdArray[0]));
        }
        else{
            documentTitleTutorial.setText(getDefaultTitle(getResources().getString(resIdArray[1])));
        }

    }


    private void observeUI() {

        documentTitleTutorial.setVisibility(View.VISIBLE);
        documentBorderTextView.setVisibility(View.VISIBLE);

        cameraViewModel.getActionButtonVisibility().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @SuppressLint("RestrictedApi")
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    takePictureButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
        cameraViewModel.getCropShapeImageView().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    imageView.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        cameraViewModel.setTakePictureButtonAvailability(true);
        setupCustomUI();
        setUpUIDynamicSizes();

    }

    ViewTreeObserver.OnPreDrawListener onPreDrawListener = new ViewTreeObserver.OnPreDrawListener() {
        @Override
        public boolean onPreDraw() {
            if(ratio!=-1f) {
                int width = rootView.getWidth();
                int height = rootView.getHeight();
                RectF visibleArea = CameraDisplayHelpers.getVisibleArea(width, height, ratio);
                final double xPositionRatio = visibleArea.left / width;
                final double yPositionRatio = visibleArea.top / height;
                if (imageView != null)
                    setupImageViewWithScalledImage(xPositionRatio, yPositionRatio, ratio);
                rootView.getViewTreeObserver().removeOnPreDrawListener(this);
            }
            return true;

        }
    };


    private double ratio = 125f/87f;
    public void setupDocumentView(float documentCameraFrameRatio) {

            if (fotoapparatFocusView != null)
                fotoapparatFocusView.setVisibility(View.VISIBLE);
            if (customFocusView != null)
                customFocusView.setEnabled(true);
            ratio = documentCameraFrameRatio;
            rootView.getViewTreeObserver().addOnPreDrawListener(onPreDrawListener);

    }


    private void setupImageViewWithScalledImage(final double xPositionRatio, final double yPositionRatio,
                                                double uploadDocumentPhotoType) {
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams) imageView.getLayoutParams();
            final ConstraintLayout parent = (ConstraintLayout) imageView.getParent();
            int parentWidth = parent.getWidth();
            int parentHeight = parent.getHeight();
            int horizontalMargin = (int) (parent.getWidth() * xPositionRatio);
            int verticalMargin = (int) (parent.getHeight() * yPositionRatio);
            params.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin);
            imageView.setLayoutParams(params);

            View view = getCustomShape();
            if (view == null) {
                return;
            }
            if (view instanceof CustomViewHolder) {
                CustomViewHolder customViewHolder = (CustomViewHolder) view;
                determineValuesForDocument(parentWidth, parentHeight, horizontalMargin, verticalMargin);
                customViewHolder.setValuesForRectangle(rectangleLeft,
                        rectangleTop,
                        rectangleRight,
                        rectangleBottom);
                customViewHolder.invalidate();
            }
            setupValuesForCropping(verticalMargin, horizontalMargin, parentHeight, parentWidth);

    }

    private void setupValuesForCropping(int verticalMargin, int horizontalMargin, int parentHeight, int parentWidth) {
        yCoordinateOfHeightStart = verticalMargin - horizontalMargin;
        heightOfImage = parentHeight - verticalMargin * 2 + horizontalMargin * 2;
        widthOfImage = parentWidth;
        xCoordinateOfWidthStart = 0;
    }

    private void determineValuesForDocument(int parentWidth, int parentHeight, int horizontalMargin, int verticalMargin) {

        rectangleLeft = parentWidth - horizontalMargin + DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleRight = horizontalMargin - DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleBottom = parentHeight - verticalMargin + DpToPixelConverter.dpToPx(rectangeMargin);
        rectangleTop = verticalMargin - DpToPixelConverter.dpToPx(rectangeMargin);
        if (this.rectangleLeft > this.rectangleRight) {
            int c = this.rectangleLeft;
            int k = this.rectangleRight;
            this.rectangleRight = c;
            this.rectangleLeft = k;
        }
    }

    private View getCustomShape() {
        if (customShapes != null)
            if (!(customShapes.getChildAt(0) == null)) {
                return customShapes.getChildAt(0);
            }
        return null;
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof OnCameraClosedFragment) {
            mFragmentClosedListener = (OnCameraClosedFragment) context;
        }
        super.onAttach(context);

    }

    @Override
    public void onDetach() {
        super.onDetach();
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null;
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        pictureButtonOnClickListener();
        if (IdenfyController.getInstance().getSettings() != null) {
            IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
            Typeface typeFaceRegular = idenfySettings.getCustomRegularFont();
            Typeface typeFaceBold = idenfySettings.getCustomBoldTypeFace();
            setupCustomTypeFace(typeFaceRegular, typeFaceBold);

        }
        if (fotoapparatFocusView != null)
            fotoapparatFocusView.setOnTouchListener(new View.OnTouchListener() {
                @Override
                public boolean onTouch(View v, MotionEvent event) {
                    if (canFocus.get()) {
                        switch (event.getAction()) {
                            case MotionEvent.ACTION_DOWN:

                                if (cameraViewModel.getNextButtonVisibility().getValue() != null && !cameraViewModel.getNextButtonVisibility().getValue())
                                    if (canFocus.get()) {
                                        return false;
                                    } else {
                                    }
                        }
                        return false;
                    } else {
                        return true;
                    }
                }

            });
        setupFocus();
        observeUI();
        observeButtonsAvailability();
        observeDocumentType();
        //setupUI(currentStepUIViewModel);
        observeButtonClicks();
    }
    private void setupListenersForButtons()
    {
        backTextView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();

            }
        });
        if(!shouldShowInstructions && backTextViewDefault.getVisibility() == View.VISIBLE)
            backTextViewDefault.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onBackPressed();

                }
            });
        backImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        if(!shouldShowInstructions && backTextViewDefault.getVisibility() == View.VISIBLE)
            backButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onBackPressed();
                }
            });
    }


    public void observeButtonClicks() {
        cameraViewModel.getNextButtonPressed().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null) {
                    if (aBoolean) {
                        startBackgroundPhotoTaking();
                        setInstructionButtonPositions();
                    }
                }
            }
        });

        cameraViewModel.getRetakeButtonPressed().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null) {
                    if (aBoolean) {
                        startBackgroundPhotoTaking();
                        viewPager.setCurrentItem(0);
                        setInstructionButtonPositions();
                        setUpViews(documentSessionTitle);
                        slideDownInstructionsHandler.removeCallbacksAndMessages(null);

                    }
                }
            }
        });

            topSheetBehavior.setTopSheetCallback(topSheetBehaviorCallback);
            nextPageButton.setOnClickListener(new View.OnClickListener() {

                @Override
                public void onClick(View view) {
                    if (viewPager.getCurrentItem() == 0) {
                        previousPageButton.setVisibility(View.INVISIBLE);
                    } else {
                        previousPageButton.setVisibility(View.VISIBLE);
                    }
                    if (viewPager.getCurrentItem() == instructionPagerAdapter.getCount() - 2) {
                        nextPageButton.setVisibility(View.GONE);
                        donePageButton.setVisibility(View.VISIBLE);

                    } else {
                        nextPageButton.setVisibility(View.VISIBLE);
                        donePageButton.setVisibility(View.GONE);
                    }
                    viewPager.setCurrentItem(getNextPossibleItemIndex(1), true);
                }
            });

            previousPageButton.setOnClickListener(new View.OnClickListener() {

                @Override
                public void onClick(View view) {
                    viewPager.setCurrentItem(getNextPossibleItemIndex(-1), true);
                    if (viewPager.getCurrentItem() == 0) {
                        previousPageButton.setVisibility(View.INVISIBLE);
                    } else {
                        previousPageButton.setVisibility(View.VISIBLE);
                    }
                    nextPageButton.setVisibility(View.VISIBLE);
                }
            });

            donePageButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    topSheetBehavior.setState(TopSheetBehavior.STATE_COLLAPSED);
                }
            });

            viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
                @Override
                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

                }

                @Override
                public void onPageSelected(int position) {
                    instructionTitle.setText(instructionList.get(position).getInstructionTitle());
                    instructionText.setText(instructionList.get(position).getInstructionText());
                    if (position == 0) {
                        previousPageButton.setVisibility(View.INVISIBLE);
                    } else {
                        previousPageButton.setVisibility(View.VISIBLE);
                    }
                    if (position == instructionPagerAdapter.getCount() - 1) {
                        nextPageButton.setVisibility(View.GONE);
                        donePageButton.setVisibility(View.VISIBLE);

                    } else {
                        nextPageButton.setVisibility(View.VISIBLE);
                        donePageButton.setVisibility(View.GONE);
                    }
                }

                @Override
                public void onPageScrollStateChanged(int state) {
                }
            });

            expandArrow.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (topSheetBehavior.getState() == TopSheetBehavior.STATE_EXPANDED) {
                        topSheetBehavior.setState(TopSheetBehavior.STATE_COLLAPSED);
                    } else {
                        topSheetBehavior.setState(TopSheetBehavior.STATE_EXPANDED);
                    }
                }
            });

            topSheet.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    topSheetBehavior.setState(TopSheetBehavior.STATE_COLLAPSED);
                }
            });
    }

    private void observeButtonsAvailability() {

        cameraViewModel.getTakePictureButtonAvailability().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null)
                    takePictureButton.setEnabled(aBoolean);
            }
        });
    }


    private void setupFocus() {
        if (fotoapparatFocusView != null)
            fotoapparatFocusView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (canFocus.get()) {
                        if (fotoapparat != null) {
                            canFocus.set(false);
                            fotoapparat.getCurrentParameters().whenDone(new WhenDoneListener<CameraParameters>() {
                                @Override
                                public void whenDone(@org.jetbrains.annotations.Nullable CameraParameters cameraParameters) {
                                    if (cameraParameters != null)
                                        if (!cameraParameters.component2().equals(FocusMode.Auto.INSTANCE)) {
                                            if (fotoapparat != null) {
                                                fotoapparat.updateConfiguration(
                                                        UpdateConfiguration.builder().focusMode(
                                                                firstAvailable(autoFocus())).build());
                                                if (autoFocusHandler != null && focusRunnable != null)
                                                    autoFocusHandler.postDelayed(focusRunnable, 3000);
                                            }
                                            if (cameraParameters.component2().equals(FocusMode.Auto.INSTANCE)) {
                                                if (autoFocusHandler != null && focusRunnable != null)
                                                    autoFocusHandler.postDelayed(focusRunnable, 3000);
                                            }
                                        }
                                }
                            });
                        }
                    }
                }
            });

    }

    private void pictureButtonOnClickListener() {
        takePictureButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                backgroundPhotoHandler.removeCallbacksAndMessages(null);
                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(false);
                if (getActivity() != null) {
                    takePicture();
                }
            }
        });
    }


    private void startBackgroundPhotoTaking() {
        if(cameraViewModel.getPartnerInfo().getRecordIdentification())
        backgroundPhotoHandler.post(new Runnable() {
            @Override
            public void run() {
                frameProcessor.takeBackgroundPicture(new DocumentsCameraSessionFrameProcessor.onSessionListener() {
                    @Override
                    public void OnPictureTaken(byte[] bitmap, int rotation, String encoded) {

                        cameraViewModel.addBackgroundPhoto(bitmap);
                    }
                });
                backgroundPhotoHandler.postDelayed(this, 250);
            }

        });
    }

    public void takePicture() {
        if (fotoapparat != null) {
            frameProcessor.takePicture(new DocumentsCameraSessionFrameProcessor.OnPictureListener() {

                @Override
                public void OnPictureTaken(Bitmap bitmap, int rotation, String encoded) {

                    BitmapPhoto photo = new BitmapPhoto(bitmap, rotation);
                    showPhoto(photo);
                }
            });
        }
    }

    public CameraViewSize getCameraPreviewSize() {

        return new CameraViewSize(cameraView.getWidth(), cameraView.getHeight());
    }


    public void showPhoto(@NonNull final BitmapPhoto bitmapPhoto) {
        if (cameraView != null) {
            if (getActivity() != null)
                getActivity().runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (getActivity() == null || cameraView == null) {
                            return;
                        }
                        Bitmap result = BitmapPhotoCropper.
                                cropPhotoWithPaddings(bitmapPhoto, getCameraPreviewSize(), new RectF(xCoordinateOfWidthStart, yCoordinateOfHeightStart, widthOfImage, heightOfImage),
                                        ratio);
                        DocumentPhotoResult uploadDocumentPhotoType = new DocumentPhotoResult(result, cameraViewModel.getCurrentDocumentStep(),
                                rectangleRight, rectangleLeft, rectangleTop, rectangleBottom);
                        cameraViewModel.setDocumentPhotoResultMutableLiveData(uploadDocumentPhotoType);
                        cameraViewModel.getAddDocumentPhotoResultFragment().setValue(true);
                    }
                });


        }
    }


    @Override
    public void onDestroy() {
        super.onDestroy();
        LoggingHelper.FrgamentsInfo("onDestroyDocumentCameraSession");
        LoggingHelper.FrgamentsInfo("onDocumentCameraDestroy");

    }

    @Override
    public void onPause() {
        super.onPause();
        fotoapparat.stop();
        backgroundPhotoHandler.removeCallbacksAndMessages(null);
        cameraViewModel.setNextButtonPressed(false);
        cameraViewModel.setRetakeButtonPressed(false);
        LoggingHelper.FrgamentsInfo("onDocumentCameraPause");
    }

    @Override
    public void onStop() {
        super.onStop();

        LoggingHelper.FrgamentsInfo("onDocumentCameraStop");
        LoggingHelper.onStop(DocumentsCameraSessionFragment.class.getSimpleName());


    }


    @Override
    public void onStart() {
        super.onStart();
        setupCamera();
        LoggingHelper.FrgamentsInfo("onDocumentCameraStart");
        LoggingHelper.onStart(DocumentsCameraSessionFragment.class.getSimpleName());


    }

    @Override
    public void onResume() {
        super.onResume();
            setInstructionButtonPositions();
        LoggingHelper.FrgamentsInfo("onDocumentCameraResume");
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                if (fotoapparat != null) {
                    fotoapparat.start();
                    startBackgroundPhotoTaking();
                }

            }
        }, 100);

    }
    TopSheetBehavior.TopSheetCallback topSheetBehaviorCallback =  new TopSheetBehavior.TopSheetCallback() {
        @Override
        public void onStateChanged(@NonNull View bottomSheet, int newState) {
        }

        @Override
        public void onSlide(@NonNull View bottomSheet, float slideOffset, @Nullable Boolean isOpening) {

            if (isOpening != null) {
                if (isOpening) {
                    if (slideOffset > 0.7) {
                        topSheetBehavior.setState(TopSheetBehavior.STATE_EXPANDED);
                        expandArrow.setImageResource(R.drawable.idenfy_expand_less);
                        documentTitleTutorial.setVisibility(View.GONE);
                        instructionText.setVisibility(View.VISIBLE);
                        donePageButton.setVisibility(View.GONE);
                        backTextView.setVisibility(View.GONE);
                        backImage.setVisibility(View.GONE);
                        takePictureButton.setVisibility(View.INVISIBLE);
                        topSheet.setClickable(true);
                    }
                } else {
                    if (slideOffset < 0.3) {
                        topSheetBehavior.setState(TopSheetBehavior.STATE_COLLAPSED);
                        expandArrow.setImageResource(R.drawable.idenfy_expand_more);
                        documentTitleTutorial.setVisibility(View.VISIBLE);
                        instructionText.setVisibility(View.INVISIBLE);
                        backTextView.setVisibility(View.VISIBLE);
                        backImage.setVisibility(View.VISIBLE);
                        takePictureButton.setVisibility(View.VISIBLE);
                        topSheet.setClickable(false);
                    }
                }
            }
        }
    };

    @Override
    public void onDestroyView() {
        if (onPreDrawListener != null)
            rootView.getViewTreeObserver().removeOnPreDrawListener(onPreDrawListener);
        LoggingHelper.onDestroyView(DocumentsCameraSessionFragment.class.getSimpleName());
        onPreDrawListener = null;
        super.onDestroyView();
        if(topSheetBehavior!=null)
        topSheetBehavior.setTopSheetCallback(null);
        fotoapparatFocusView = null;
        cameraView = null;
        fotoapparat = null;
        backTextView = null;
        if (onPreDrawListener != null)
            rootView.getViewTreeObserver().removeOnPreDrawListener(onPreDrawListener);
        onPreDrawListener = null;

        imageInfoLayout = null;
        documentTitleTutorial = null;
        takePictureButton = null;
        ((CameraPreviewActivity) getActivity()).setSupportActionBar(null);
        if (customShapes != null) {

            for (int i = 0; i < customShapes.getChildCount(); i++) {
                if (customShapes.getChildAt(i) != null) {
                    customShapes.removeViewAt(i);
                }
            }
            customShapes = null;
        }
        takePictureHandler.removeCallbacksAndMessages(null);
        recreateButtonHandler.removeCallbacksAndMessages(null);
        nextButtonHandler.removeCallbacksAndMessages(null);
        fotoapparatSetupHandler.removeCallbacksAndMessages(null);
    }


    public void onBackPressed() {
        mFragmentClosedListener.onCameraNewFragmentClosed(true);
    }

    private SpannableStringBuilder getDefaultTitle(String docPart) {
        SpannableStringBuilder builder = new SpannableStringBuilder();
        if (getActivity() == null) {
            builder.append("");
            return builder;
        }
        if(shouldShowInstructions) {
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyWhite)),
                    getResources().getString(R.string.document_tutorial_title_default_part_0
                    )));
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyWhite)), " " + docPart + " "));
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyWhite)),
                    getResources().getString(R.string.document_tutorial_title_default_part_2
                    )));
            return builder;
        }
        else{
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyBlack)),
                    getResources().getString(R.string.document_tutorial_title_default_part_0
                    )));
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyWhite)), " " + docPart + " "));
            builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyBlack)),
                    getResources().getString(R.string.document_tutorial_title_default_part_2
                    )));
            return builder;
        }
    }

    private SpannableString setColoredSpan(ForegroundColorSpan color, String string) {
        SpannableString spanStr = new SpannableString(string);
        spanStr.setSpan(color, 0, spanStr.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        return spanStr;
    }

    public void setupCustomTypeFace(Typeface typeface, Typeface typeFaceBold) {
        if (typeFaceBold == null) {
            return;
        }
        backTextView.setTypeface(typeFaceBold);
        documentBorderTextView.setTypeface(typeFaceBold);
        documentTitleTutorial.setTypeface(typeFaceBold);
    }

    private void setupCustomUI() {
        if (getActivity() == null) {
            return;
        }
        if (shouldShowInstructions)
            documentTitleTutorial.setTextColor(ContextCompat.getColor(getActivity(), R.color.idenfyWhite));
        else
            documentTitleTutorial.setTextColor(ContextCompat.getColor(getActivity(), R.color.idenfyBlack));
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
            if (shouldShowInstructions)
                DrawableCompat.setTint(backImage.getDrawable(), ContextCompat.getColor(getActivity(),
                        R.color.idenfyWhite));
            else
                DrawableCompat.setTint(backImage.getDrawable(), ContextCompat.getColor(getActivity(),
                        R.color.idenfyDocumentsCameraSessionBackArrowColor));

        } else {
            if (shouldShowInstructions)
                backImage.getDrawable().mutate().setColorFilter(ContextCompat.getColor(getActivity(),
                        R.color.idenfyWhite), PorterDuff.Mode.SRC_IN);
            else
                backImage.getDrawable().mutate().setColorFilter(ContextCompat.getColor(getActivity(),
                        R.color.idenfyDocumentsCameraSessionBackArrowColor), PorterDuff.Mode.SRC_IN);
        }
        if (shouldShowInstructions)
            backTextView.setTextColor(getResources().getColor(R.color.idenfyWhite));
        else
            backTextView.setTextColor(getResources().getColor(R.color.idenfyDocumentsCameraSessionBackTextViewColor));
    }

    private void setUpUIDynamicSizes() {
        topSheetBehavior = TopSheetBehavior.from(topSheet);
        instructionDynamicSizeManager.setUpUIDynamicSizes(getContext(),instructionText, instructionTitle, viewPager);
    }
    private void setUpInstructions() {

        TabLayout viewPagerDots = rootView.findViewById(R.id.viewpager_dots);

        instructionPagerAdapter = new InstructionPagerAdapter(getChildFragmentManager(), instructionList, instructionTitle, instructionText, instructionList.size());
        viewPager.setOffscreenPageLimit(instructionList.size()+1);
        viewPager.setPageMargin(dpToPx(20));
        viewPager.setAdapter(instructionPagerAdapter);
        viewPagerDots.setupWithViewPager(viewPager, true);

        if(instructionViewModel.getCurrentInstructionEnum() != InstructionEnum.INSTRUCTION_NOT_NEEDED) {
            slideDownInstructionsHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    topSheetBehavior.setState(TopSheetBehavior.STATE_EXPANDED);
                }
            }, 500);
        }
    }

    /**
     * Method sets back button and session title visibilities
     * going from fragment without instructions to the one with(i.e. from passport cover to passport front)
     */
    private void setUpViews(int[] resIdArray)
    {
        if(shouldShowInstructions){
            backButton = rootView.findViewById(R.id.backImage);
            backTextViewDefault = rootView.findViewById(R.id.back_text_view);
            backButton.setVisibility(View.GONE);
            backTextViewDefault.setVisibility(View.GONE);
        }
        else{
            topSheet.setVisibility(View.GONE);
            backButton = rootView.findViewById(R.id.backImage);
            backTextViewDefault = rootView.findViewById(R.id.back_text_view);
            backButton.setVisibility(View.VISIBLE);
            backTextViewDefault.setVisibility(View.VISIBLE);
        }
        if(instructionViewModel.getCurrentInstructionEnum() == InstructionEnum.PASSPORT) {
            backButton.setVisibility(View.GONE);
            backTextViewDefault.setVisibility(View.GONE);
            topSheet.setVisibility(View.VISIBLE);
            documentTitleTutorial.setVisibility(View.GONE);
            documentTitleTutorial = rootView.findViewById(R.id.camera_session_information_text_view_instructions);
            documentTitleTutorial.setVisibility(View.VISIBLE);
            if(resIdArray[1]==0){
                documentTitleTutorial.setText(getResources().getString(resIdArray[0]));
            }
            else{
                documentTitleTutorial.setText(getDefaultTitle(getResources().getString(resIdArray[1])));
            }
            documentTitleTutorial.setTextColor(Color.WHITE);
            backTextView.setTextColor(Color.WHITE);
            DrawableCompat.setTint(backImage.getDrawable(), ContextCompat.getColor(Objects.requireNonNull(getActivity()),
                    R.color.idenfyWhite));
            slideDownInstructionsHandler.postDelayed(new Runnable() {
                @Override
                public void run() {
                    topSheetBehavior.setState(TopSheetBehavior.STATE_EXPANDED);
                }
            }, 500);
        }

    }

    /**
     * Method sets viewpager's button positions (visibility) according to the current page
     */
    private void setInstructionButtonPositions() {
        nextPageButton.setVisibility(View.VISIBLE);
        previousPageButton.setVisibility(View.INVISIBLE);
    }

    private int getNextPossibleItemIndex(int change) {

        int currentIndex = viewPager.getCurrentItem();
        int total = Objects.requireNonNull(viewPager.getAdapter()).getCount();

        if (currentIndex + change < 0) {
            return 0;
        }

        return Math.abs((currentIndex + change) % total);
    }

    public int dpToPx(int dp) {
        DisplayMetrics displayMetrics = getActivity().getResources().getDisplayMetrics();
        return Math.round(dp * (displayMetrics.xdpi / DisplayMetrics.DENSITY_DEFAULT));
    }
}
