package com.idenfy.idenfySdk.core.domain

import android.app.Application
import android.content.Context
import android.graphics.Bitmap
import android.util.Base64
import com.idenfy.idenfySdk.initialagreement.repo.InitialAgreementRepositoryImp
import java.io.ByteArrayOutputStream
import java.io.File
import java.io.FileOutputStream

class ImagesPreparingForUploadUseCase(val applicationContext: Context) {

  suspend fun getBase64ForImageUploading(type: Bitmap): String {


        if(type.isRecycled) return ""

        val stream = ByteArrayOutputStream()
        type.compress(Bitmap.CompressFormat.JPEG, 90, stream)
        val byteArray = stream.toByteArray()
        return Base64.encodeToString(byteArray, Base64.DEFAULT)
    }
    private fun getFilesDir(): File {
        return applicationContext.getDir("idenfy", Context.MODE_PRIVATE)
    }
    fun getFileForImageUploading(type: Bitmap): File? {

        var f: File? = File(getFilesDir(),  type.hashCode().toString())

        try {

            if(f!=null && f.exists())
            {
                f.delete();
            }
            f!!.createNewFile()
            val bos = ByteArrayOutputStream()
            //Quality is  0, it does not affect
            type.compress(Bitmap.CompressFormat.PNG, 0, bos)
            val byteArray = bos.toByteArray()

            val fos = FileOutputStream(f)
            fos.write(byteArray)
            fos.flush()
            fos.close()
        } catch (e: Exception) {
            e.printStackTrace()
            f = null
        }

        return f
    }
}