package com.idenfy.idenfySdk.UI.UIHelpers.Instructions;

import android.app.Activity;
import android.content.Context;
import android.support.constraint.ConstraintLayout;
import android.support.v4.view.ViewPager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.TextView;

import java.util.Objects;

public class InstructionDynamicSizeManager {

    public InstructionDynamicSizeManager() {
    }

    /**
     * Commented code is an option to set the top sheet peek high dynamically according to screen height
     */
    public void setUpUIDynamicSizes(Context context, TextView instructionText, TextView instructionTitle, ViewPager viewPager) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity) Objects.requireNonNull(context)).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int screenHeight = displayMetrics.heightPixels;
        double screenWidth = displayMetrics.widthPixels;
        double viewPagerSizeRatio = 0.85;

       /* ConstraintLayout.LayoutParams topSheetParams = new ConstraintLayout.LayoutParams(topSheet.getLayoutParams());
        topSheetParams.bottomMargin = screenHeight / 5;
        topSheetLayout.setLayoutParams(topSheetParams);*/

        if (screenHeight <= 900) {
            instructionText.setTextSize(TypedValue.COMPLEX_UNIT_SP, 12);
            instructionTitle.setTextSize(TypedValue.COMPLEX_UNIT_SP, 14);
            viewPagerSizeRatio = 0.75;
        }

        ConstraintLayout.LayoutParams viewPagerParams = (ConstraintLayout.LayoutParams) viewPager.getLayoutParams();
        viewPagerParams.height = (int) Math.round(screenWidth * viewPagerSizeRatio);
        viewPagerParams.width = (int) Math.round(screenWidth * viewPagerSizeRatio);
        viewPager.setLayoutParams(viewPagerParams);

        //topSheetBehavior.setPeekHeight(screenHeight / 5);

        instructionTitle.setMaxWidth((int) Math.round(screenWidth * viewPagerSizeRatio));
        instructionText.setMaxWidth((int) Math.round(screenWidth * viewPagerSizeRatio));
    }
}
