package com.idenfy.idenfySdk.UI.DocumentPhotoResultView


import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.content.Context
import android.graphics.Bitmap
import android.graphics.PorterDuff
import android.graphics.Typeface
import android.os.Build
import android.os.Bundle
import android.os.Handler
import android.support.constraint.ConstraintLayout
import android.support.v4.content.ContextCompat
import android.support.v4.graphics.drawable.DrawableCompat
import android.support.v7.app.AppCompatDelegate
import android.util.Log
import android.util.Pair
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController
import com.idenfy.idenfysdk.core.extensions.livedataextensions.ViewLifecycleFragment
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyError
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse
import com.idenfy.idenfySdk.core.ui.view.CameraPreviewActivity
import com.idenfy.idenfySdk.core.ui.viewmodel.CameraViewModel
import com.idenfy.idenfySdk.ViewModelsCoreLogic.LivenessesViewModel
import com.idenfy.idenfysdk.core.domain.networkrepo.ErrorsHelper
import com.idenfy.idenfysdk.core.extensions.livedataextensions.observeOnce
import com.idenfy.idenfysdk.core.logging.LoggingHelper
import com.idenfy.idenfysdk.core.models.documentTypeData.UploadDocumentPhotoType
import com.idenfySdk.R

import java.util.concurrent.atomic.AtomicBoolean

import io.fotoapparat.view.CameraView

class FacePhotoResultFragment : ViewLifecycleFragment() {
    internal var cameraView: CameraView? = null
    lateinit var cameraViewModel: CameraViewModel
    internal var imageInfoLayout: ConstraintLayout? = null

    private var rootView: View? = null
    private var imageViewFullScreenResult: ImageView? = null
    private var imageViewResult: ImageView? = null
    private var retakeButton: Button? = null
    private var nextButton: Button? = null
    lateinit var backImage: ImageView
    lateinit var backTextView: TextView

    lateinit var imageViewResultTitle: TextView
    private var mFragmentClosedListener: OnCameraClosedFragment? = null
    //Handlers
    private val takePictureHandler = Handler()
    private val recreateButtonHandler = Handler()
    private val nextButtonHandler = Handler()
    private val fotoapparatSetupHandler = Handler()
    private val autoFocusHandler = Handler()

    //Logic values
    internal var canFocus = AtomicBoolean(true)
    private val isBackCamera = true
    internal var currentUploadDocumentPhotoType: UploadDocumentPhotoType? = null
    private val BUTTON_DELAY_FOR_UX: Long = 200

    lateinit var livenessesViewModel: LivenessesViewModel

    internal var isUp: Boolean = false
    internal var rootViewHeight: Int = 0



    private val canSetup = AtomicBoolean(true)
    private val observer = Observer<Pair<Boolean, String>> { response ->
        if (response!!.first) {
                initializeZoomLogin()
        } else {
            if (activity != null)
                cameraViewModel.setIdenfyError(IdenfyError(IdenfyErrorResponse(ErrorsHelper.FACE_LIVENESSS_ERROR_IDENTIFIER,
                        activity!!.resources
                                .getString(R.string.IDENFY_FACE_LIVENESS_MESSAGE)),
                        true, 1200))
        }
    }
    //View drawings values

    interface OnCameraClosedFragment {
        fun onCameraNewFragmentClosed(closed: Boolean)
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true)
        super.onCreate(savedInstanceState)
        LoggingHelper.FrgamentsInfo("onCreateFacePhotoResult")
        livenessesViewModel = ViewModelProviders.of(activity!!).get(LivenessesViewModel::class.java)
        cameraViewModel = ViewModelProviders.of(activity!!).get(CameraViewModel::class.java)

    }

    private fun initializeUI(rootView: View) {
        cameraView = rootView.findViewById(R.id.cameraView)
        imageInfoLayout = rootView.findViewById(R.id.showImageLayout)
        imageViewResultTitle = rootView.findViewById(R.id.document_photo_result_text_view)
        backImage = rootView.findViewById(R.id.backImage)
        backTextView = rootView.findViewById(R.id.back_text_view)
        imageViewFullScreenResult = rootView.findViewById(R.id.imageViewFullScreenResult)
        retakeButton = rootView.findViewById(R.id.recreateButton)
        imageViewResult = rootView.findViewById(R.id.imageViewResult)
        nextButton = rootView.findViewById(R.id.nextButton)
//        liveness_mask_preview = rootView.findViewById(R.id.liveness_mask_preview)
//        if(!cameraViewModel.isLivenessEnabled())
//        {
//            liveness_mask_preview.visibility = View.GONE
//        }
    }


    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        rootView = inflater.inflate(R.layout.idenfy_face_photo_result_fragment, container, false)
        initializeUI(rootView!!)
        return rootView
    }


    private fun observeUI() {

        cameraViewModel.getImageViewResult().observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null) {
                if (imageViewResult != null) {
                    imageViewResult!!.visibility = if (response) View.VISIBLE else View.INVISIBLE
                }
            }
        })
        cameraViewModel.getImageViewResultFullSize().observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null) {
                if (imageViewFullScreenResult != null) {
                    imageViewFullScreenResult!!.visibility = if (response) View.VISIBLE else View.INVISIBLE
                }
            }
        })

        cameraViewModel.recreateButtonVisibility.observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null) {
                retakeButton!!.visibility = if (response) View.VISIBLE else View.INVISIBLE
            }
        })
        cameraViewModel.getShowImageLayoutVisibility().observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null) {
                if (imageInfoLayout != null)
                    imageInfoLayout!!.visibility = if (response) View.VISIBLE else View.INVISIBLE
            }
        })

        cameraViewModel.getNextButtonVisibility().observe(viewLifecycleOwner!!, Observer { response ->
            if(response!=null)
            nextButton!!.visibility = if (response) View.VISIBLE else View.INVISIBLE })
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        setupCustomUI()

    }

    override fun onSaveInstanceState(savedInstanceState: Bundle) {
        super.onSaveInstanceState(savedInstanceState)

    }

    override fun onAttach(context: Context?) {
        super.onAttach(context)

        if (context is OnCameraClosedFragment) {
            mFragmentClosedListener = context
        }
        super.onAttach(context)

    }

    override fun onDetach() {
        super.onDetach()
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null
    }


    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        cameraViewModel.setTakePictureButtonAvailability(true)
        if (cameraViewModel.hasPartnerEnabledZoom) {
            retakeButton!!.visibility = View.INVISIBLE
            nextButton!!.visibility = View.INVISIBLE

            if (livenessesViewModel.getLivenessHelper() != null) {
               // livenessesViewModel.zoomInitializationResult.observe(viewLifecycleOwner!!, observer)
                return
            }
        } else {
            retakeButton!!.isEnabled = true
            nextButton!!.isEnabled = true
            cameraViewModel.setNextButtonVisibility(true)
            cameraViewModel.setRecreateButtonAvailability(true)
            cameraViewModel.setNextButtonAvailability(true)
            cameraViewModel.setRecreateButtonVisibility(true)

        }
        if (IdenfyController.getInstance().settings != null) {
            val idenfySettings = IdenfyController.getInstance().settings
            val typeFaceRegular = idenfySettings.customRegularFont
            val typeFaceBold = idenfySettings.customBoldTypeFace
            setupCustomTypeFace(typeFaceRegular, typeFaceBold)
        }
        backTextView.setOnClickListener { onBackPressed() }
        backImage.setOnClickListener { onBackPressed() }
        observeUI()
        observeDocumentType()
        observeButtonsAvailability()
        cameraViewModel.documentPhotoResultLiveData.observe(viewLifecycleOwner!!, Observer{ response ->
            if(response!= null)
            show(response.documentImage,
                    response.rectangleRight!!, response.rectangleLeft!!, response.rectangleBottom!!, response.rectangleTop!!)
        })
    }

    private fun observeDocumentType() {
        cameraViewModel.currentStepUIViewModelLiveData.observeOnce(viewLifecycleOwner!!, Observer {response->
            if (response != null) {
                imageViewResultTitle.text = resources.getString(response.resultsInformationTitle)
            }
        })
    }


    private fun observeButtonsAvailability() {}


    private fun retakePhotoPressed(bitmap: Bitmap?) {
        cameraViewModel.setTakePictureButtonAvailability(true)
        if(cameraViewModel.isLivenessEnabled())
        cameraViewModel.setAddFaceCameraFragment(true)
        else
            cameraViewModel.setaddFacePhotoResultFragment(false)
        if (bitmap != null && !bitmap.isRecycled) {
            bitmap.recycle()
        }
        recreateImage()

    }

    fun show(bitmap: Bitmap?, rectangleRight: Int, rectangleLeft: Int, rectangleBottom: Int, rectangleTop: Int) {
        cameraViewModel.setShowImageLayoutVisibility(true)
        if (imageViewFullScreenResult != null) {
            cameraViewModel.setImageViewResultFullSize(true)
            imageViewFullScreenResult!!.setImageBitmap(bitmap)
        }
        if (cameraViewModel.hasPartnerEnabledZoom) {
            retakeButton!!.isEnabled = false
            retakeButton!!.isEnabled = false
        }

        retakeButton!!.setOnClickListener {
            cameraViewModel.setRetakeButtonPressed(true)
            retakePhotoPressed(bitmap)
            cameraViewModel.setFaceRetakeButtonPressed(true)
        }

        nextButton!!.setOnClickListener {

            cameraViewModel.setNextButtonPressed(true)
            cameraViewModel.setNextButtonAvailability(false)
            cameraViewModel.setRecreateButtonAvailability(false)
            cameraViewModel.setTakePictureButtonAvailability(true)
            nextStep(bitmap)
        }

    }

    internal fun initializeZoomLogin() {
        if(activity!=null) {
            livenessesViewModel.getLivenessHelper()?.startActivityForResult(activity as CameraPreviewActivity)
           // livenessesViewModel.zoomSDKInicializationResponse.removeObserver(observer)
            cameraViewModel.isLivenessOpened = true
        }
    }
    ///lateinit var liveness_mask_preview:View


    override fun onDestroy() {
        super.onDestroy()
        LoggingHelper.FrgamentsInfo("onDestroyFaceCameraSessionResults")

    }

    fun nextStep(bitmap: Bitmap?) {
        cameraViewModel.handleFlow(bitmap!!)
    }


    fun recreateImage() {
        cameraViewModel.changeDocument()
    }


    override fun onPause() {
        super.onPause()
        LoggingHelper.FrgamentsInfo("onPauseFacePhotoResult")
    }

    override fun onStop() {
        super.onStop()
        LoggingHelper.FrgamentsInfo("onStopFacePhotoResult")
    }

    override fun onStart() {
        super.onStart()
        LoggingHelper.FrgamentsInfo("onStartFacePhotoResult")
    }

    override fun onResume() {
        super.onResume()
        LoggingHelper.FrgamentsInfo("onResumeFacePhotoResult")

    }

    override fun onDestroyView() {
        super.onDestroyView()
        LoggingHelper.onDestroyView(FacePhotoResultFragment::class.java.simpleName)
        imageViewFullScreenResult = null
        imageViewResult = null
        imageInfoLayout = null
        cameraView = null
        nextButton = null
        retakeButton = null
        (activity as CameraPreviewActivity).setSupportActionBar(null)
        takePictureHandler.removeCallbacksAndMessages(null)
        recreateButtonHandler.removeCallbacksAndMessages(null)
        nextButtonHandler.removeCallbacksAndMessages(null)
        fotoapparatSetupHandler.removeCallbacksAndMessages(null)
    }

    fun setupCustomTypeFace(typeface: Typeface?, typeFaceBold: Typeface?) {
        if (typeFaceBold == null) {
            return
        }
        backTextView.typeface = typeFaceBold
        nextButton!!.typeface = typeFaceBold
        retakeButton!!.typeface = typeFaceBold
        imageViewResultTitle!!.typeface = typeFaceBold
    }

    private fun setupCustomUI() {
        if (activity == null) {
            return
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
            DrawableCompat.setTint(backImage.drawable, ContextCompat.getColor(activity!!,
                    R.color.idenfyFaceResultsCameraBackArrowColor))

        } else {
            backImage.drawable.mutate().setColorFilter(ContextCompat.getColor(activity!!,
                    R.color.idenfyFaceResultsCameraBackArrowColor), PorterDuff.Mode.SRC_IN)
        }
        backTextView.setTextColor(resources.getColor(R.color.idenfyFaceResultsBackTextViewColor))
        imageViewResultTitle!!.setTextColor(resources.getColor(R.color.idenfyFaceResultsInformationTextViewColor))
    }


    fun onBackPressed() {
        (activity as CameraPreviewActivity).onBackPressed()

    }


}// Required empty public constructor
