package com.idenfy.idenfySdk.UI.DocumentPhotoResultView


import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.content.Context
import android.graphics.Bitmap
import android.graphics.PorterDuff
import android.graphics.Typeface
import android.os.Build
import android.os.Bundle
import android.os.Handler
import android.support.constraint.ConstraintLayout
import android.support.v4.app.FragmentActivity
import android.support.v4.content.ContextCompat
import android.support.v4.graphics.drawable.DrawableCompat
import android.support.v7.app.AppCompatDelegate
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.ImageView
import android.widget.RelativeLayout
import android.widget.TextView

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController
import com.idenfy.idenfysdk.core.extensions.livedataextensions.ViewLifecycleFragment
import com.idenfy.idenfysdk.core.ui.customviews.CustomViewHolder
import com.idenfy.idenfySdk.core.ui.view.CameraPreviewActivity
import com.idenfy.idenfySdk.core.ui.viewmodel.CameraViewModel
import com.idenfy.idenfySdk.ViewModelsCoreLogic.LivenessesViewModel
import com.idenfy.idenfysdk.core.extensions.livedataextensions.observeOnce
import com.idenfy.idenfysdk.core.logging.LoggingHelper
import com.idenfy.idenfysdk.core.models.documentTypeData.UploadDocumentPhotoType
import com.idenfySdk.R

import java.util.Objects
import java.util.concurrent.atomic.AtomicBoolean

import io.fotoapparat.Fotoapparat
import io.fotoapparat.view.CameraView

class DocumentPhotoResultFragment : ViewLifecycleFragment() {
    var fotoapparat: Fotoapparat? = null
    internal var cameraView: CameraView? = null
    lateinit var cameraViewModel: CameraViewModel
    internal var imageInfoLayout: ConstraintLayout? = null
    private var rootView: View? = null
    private var imageViewFullScreenResult: ImageView? = null
    private var imageViewResult: ImageView? = null
    private var retakeButton: Button? = null
    private var nextButton: Button? = null
    lateinit var backImage: ImageView
    lateinit var backTextView: TextView

    lateinit var imageViewResultTitle: TextView
    private var mFragmentClosedListener: OnCameraClosedFragment? = null
    //Handlers
    private val takePictureHandler = Handler()
    private val recreateButtonHandler = Handler()
    private val nextButtonHandler = Handler()
    private val fotoapparatSetupHandler = Handler()
    private val autoFocusHandler = Handler()

    //Logic values
    internal var canFocus = AtomicBoolean(true)
    private val isBackCamera = true
    internal var currentUploadDocumentPhotoType: UploadDocumentPhotoType? = null
    private val BUTTON_DELAY_FOR_UX: Long = 200

    lateinit var livenessesViewModel: LivenessesViewModel

    internal var isUp: Boolean = false
    internal var rootViewHeight: Int = 0

    internal var topIvShoulder: View? = null
    internal var faceShoulderOverlay: View? = null
    internal var bottomIvShoulder: View? = null
    internal var customShapes: RelativeLayout? = null


    private var currentImage: Bitmap? = null

    private val customShape: View?
        get() {
            if (customShapes != null)
                if (customShapes!!.getChildAt(0) != null) {
                    return customShapes!!.getChildAt(0)
                }
            return null
        }

    internal var shouldOpenLiveness = true
    //View drawings values

    interface OnCameraClosedFragment {
        fun onCameraNewFragmentClosed(closed: Boolean)
    }

    interface On {
        fun onFragmentClosed(closed: Boolean)
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true)
        super.onCreate(savedInstanceState)
        LoggingHelper.FrgamentsInfo("onCreateDocumentPhotoResult")
        livenessesViewModel = ViewModelProviders.of(activity!!).get(LivenessesViewModel::class.java)
        cameraViewModel = ViewModelProviders.of(Objects.requireNonNull<FragmentActivity>(activity)).get(CameraViewModel::class.java)

    }

    private fun initializeUI(rootView: View) {
        cameraView = rootView.findViewById(R.id.cameraView)
        imageInfoLayout = rootView.findViewById(R.id.showImageLayout)
        imageViewResultTitle = rootView.findViewById(R.id.document_photo_result_text_view)
        customShapes = rootView.findViewById(R.id.custom_shapes)
        customShapes!!.visibility = View.VISIBLE
        backImage = rootView.findViewById(R.id.backImage)
        backTextView = rootView.findViewById(R.id.back_text_view)
        imageViewFullScreenResult = rootView.findViewById(R.id.imageViewFullScreenResult)
        retakeButton = rootView.findViewById(R.id.recreateButton)
        imageViewResult = rootView.findViewById(R.id.imageViewResult)
        nextButton = rootView.findViewById(R.id.nextButton)
        cameraViewModel.setNextButtonVisibility(true)
        cameraViewModel.setRecreateButtonAvailability(true)
        cameraViewModel.setNextButtonAvailability(true)
        cameraViewModel.setRecreateButtonVisibility(true)

    }


    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        rootView = inflater.inflate(R.layout.idenfy_document_photo_result_fragment, container, false)
        initializeUI(rootView!!)
        return rootView
    }


    private fun observeUI() {

        cameraViewModel.recreateButtonVisibility.observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null) {
                retakeButton!!.visibility = if (response) View.VISIBLE else View.INVISIBLE
            }
        })
        cameraViewModel.getShowImageLayoutVisibility().observe(viewLifecycleOwner!!, Observer { response ->
            if (response != null) {
                if (imageInfoLayout != null)
                    imageInfoLayout!!.visibility = if (response) View.VISIBLE else View.INVISIBLE
            }
        })

        cameraViewModel.getNextButtonVisibility().observe(viewLifecycleOwner!!, Observer {
            response ->
            if(response!=null)
            nextButton!!.visibility = if (response) View.VISIBLE else View.INVISIBLE })
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        setupLayoutUI()
        setupCustomUI()


    }


    override fun onSaveInstanceState(savedInstanceState: Bundle) {
        super.onSaveInstanceState(savedInstanceState)

    }

    override fun onAttach(context: Context?) {
        super.onAttach(context)

        if (context is OnCameraClosedFragment) {
            mFragmentClosedListener = context
        }
        super.onAttach(context)

    }

    override fun onDetach() {
        super.onDetach()
        if (mFragmentClosedListener != null)
            mFragmentClosedListener = null
    }

    private fun setupLayoutUI() {

    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)

        retakeButton!!.isEnabled = true
        nextButton!!.isEnabled = true
        retakeButton!!.setOnClickListener {
            cameraViewModel.setRetakeButtonPressed(true)
            retakePhotoPressed(currentImage)
            cameraViewModel.setRetakeButtonPressed(true)
        }
        nextButton!!.setOnClickListener {
            cameraViewModel.setNextButtonPressed(true)
            cameraViewModel.setNextButtonAvailability(false)
            cameraViewModel.setRecreateButtonAvailability(false)
            cameraViewModel.setTakePictureButtonAvailability(true)
            nextStep(currentImage)
        }

        if (IdenfyController.getInstance().settings != null) {
            val idenfySettings = IdenfyController.getInstance().settings
            val typeface = idenfySettings.customRegularFont
            val typeFaceBold = idenfySettings.customBoldTypeFace
            setupCustomTypeFace(typeface, typeFaceBold)
        }
        backTextView.setOnClickListener { onBackPressed() }
        backImage.setOnClickListener { onBackPressed() }
        observeUI()
        observeButtonsAvailability()
        observeDocumentType()
        cameraViewModel.documentPhotoResultLiveData.observe(viewLifecycleOwner!!, Observer cameraViewModel@{ response ->
            currentImage = response!!.documentImage
            val view = customShape
            if (view == null) {
                return@cameraViewModel
            }
            if (view is CustomViewHolder) {
                val customViewHolder = view as CustomViewHolder?
                customViewHolder!!.changeTransparentBackgroundVisibility(false)
                customViewHolder.setValuesForRectangle(response.rectangleLeft!!,
                        response.rectangleTop!!,
                        response.rectangleRight!!,
                        response.rectangleBottom!!)
                customViewHolder.invalidate()
            }
            show(response.documentImage,
                    response.rectangleRight!!, response.rectangleLeft!!, response.rectangleBottom!!, response.rectangleTop!!)
        })

    }

    private fun observeDocumentType() {
        //        IdentificationStepsTitlesHelper identificationStepsTitlesHelper = new IdentificationStepsTitlesHelper();
        //        if (cameraViewModel.getCurrentDocumentClass() != null)
        //            imageViewResultTitle.setText(identificationStepsTitlesHelper.getPhotoResultTitleText(cameraViewModel.getUploadDocumentPhotoType(), getActivity()));
                cameraViewModel.currentStepUIViewModelLiveData.observeOnce(viewLifecycleOwner!!, Observer {response->
                if (response != null) {
                    imageViewResultTitle.text = resources.getString(response.resultsInformationTitle)
                }
            })
    }

    private fun observeButtonsAvailability() {}


    private fun retakePhotoPressed(bitmap: Bitmap?) {
        cameraViewModel.setNextButtonAvailability(false)
        cameraViewModel.setRecreateButtonAvailability(false)
        cameraViewModel.setTakePictureButtonAvailability(true)
        cameraViewModel.addDocumentPhotoResultFragment.value = false
        if (bitmap != null && !bitmap.isRecycled) {
            bitmap.recycle()
        }
        recreateImage()
    }

    fun show(bitmap: Bitmap?, rectangleRight: Int, rectangleLeft: Int, rectangleBottom: Int, rectangleTop: Int) {
        cameraViewModel.setImageViewResult(true)
        if (imageViewResult != null) {
            imageViewResult!!.visibility = View.VISIBLE
            val params = imageViewResult!!.layoutParams
            params.width = rectangleRight - rectangleLeft
            params.height = rectangleBottom - rectangleTop
            imageViewResult!!.layoutParams = params
            imageViewResult!!.setImageBitmap(bitmap)
        }
    }


    override fun onDestroy() {
        super.onDestroy()
        LoggingHelper.FrgamentsInfo("onDestroyDocumentCameraSessionResults")

    }

    fun nextStep(bitmap: Bitmap?) {
        cameraViewModel.handleFlow(bitmap!!)
    }


    fun recreateImage() {

        cameraViewModel.changeDocument()
    }

    override fun onPause() {
        super.onPause()
        shouldOpenLiveness = false


    }

    override fun onStop() {
        super.onStop()
        LoggingHelper.onStop(DocumentPhotoResultFragment::class.java.simpleName)


    }

    override fun onStart() {
        super.onStart()
        shouldOpenLiveness = true
        LoggingHelper.FrgamentsInfo("onStartDocumentCameraSessionResults")
    }

    override fun onResume() {
        super.onResume()

    }

    override fun onDestroyView() {
        super.onDestroyView()
        LoggingHelper.onDestroyView(DocumentPhotoResultFragment::class.java.simpleName)
        imageViewFullScreenResult = null
        imageViewResult = null
        imageInfoLayout = null
        cameraView = null
        nextButton = null
        retakeButton = null
        (activity as CameraPreviewActivity).setSupportActionBar(null)
        takePictureHandler.removeCallbacksAndMessages(null)
        recreateButtonHandler.removeCallbacksAndMessages(null)
        nextButtonHandler.removeCallbacksAndMessages(null)
        fotoapparatSetupHandler.removeCallbacksAndMessages(null)
    }


    fun onBackPressed() {
        (activity as CameraPreviewActivity).onBackPressed()

    }

    fun setupCustomTypeFace(typeface: Typeface?, typeFaceBold: Typeface?) {
        if (typeFaceBold == null) {
            return
        }
        backTextView.typeface = typeFaceBold
        nextButton!!.typeface = typeFaceBold
        retakeButton!!.typeface = typeFaceBold
        imageViewResultTitle.typeface = typeFaceBold
    }

    private fun setupCustomUI() {
        if (activity == null) {
            return
        }
        backTextView.setTextColor(resources.getColor(R.color.idenfyDocumentsResultsBackTextViewColor))
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
            DrawableCompat.setTint(backImage.drawable, ContextCompat.getColor(activity!!,
                    R.color.idenfyDocumentsResultsCameraBackArrowColor))

        } else {
            backImage.drawable.mutate().setColorFilter(ContextCompat.getColor(activity!!,
                    R.color.idenfyDocumentsResultsCameraBackArrowColor), PorterDuff.Mode.SRC_IN)
        }
        imageViewResultTitle!!.setTextColor(resources.getColor(R.color.idenfyDocumentsResultsInformationTextViewColor))
    }

    companion object {

        val TAG = DocumentPhotoResultFragment::class.java.simpleName
    }


}// Required empty public constructor


