package com.idenfy.idenfySdk.ViewModelsCoreLogic

import android.app.Application
import android.arch.lifecycle.*
import android.util.Pair

import com.idenfy.idenfyliveness.IdenfyLivenessHelper
import com.idenfy.idenfyliveness.LivenessCheck
import com.idenfy.idenfyliveness.Result

class LivenessesViewModel(application: Application) : AndroidViewModel(application) {

    private var livenessHelper: IdenfyLivenessHelper? = null

    var zoomSessionResponse = MediatorLiveData<Result<Pair<Boolean, LivenessCheck>>>()

    val zoomSuccessResponse: LiveData<Boolean>
        get() = Transformations.switchMap(livenessHelper!!.zoomSessionSuccess) { id ->
            val result = MutableLiveData<Boolean>()
            result.postValue(id)
            result
        }

    val zoomInitializationResult: LiveData<Pair<Boolean, String>>
        get() = Transformations.switchMap(livenessHelper!!.zoomSDKInicializationResponse) { id ->
            val result = MutableLiveData<Pair<Boolean, String>>()
            result.postValue(id)
            result
        }

    val zoomErrorOccured: LiveData<Boolean>
        get() = Transformations.switchMap(livenessHelper!!.zoomErrorOccured) { id ->
            val result = MutableLiveData<Boolean>()
            result.postValue(id)
            result
        }

    init {
        livenessHelper = getLivenessHelper()
        setupSources()
    }



    fun setupSources()
    {
        if(livenessHelper==null)
            return

        zoomSessionResponse.addSource(livenessHelper!!.zoomSessionResponse){
            zoomSessionResponse.value = it
        }

    }


    fun getLivenessHelper(): IdenfyLivenessHelper? {
        try {
            Class.forName("com.idenfy.idenfyliveness.IdenfyLivenessHelper")
            if (livenessHelper == null)
                livenessHelper = com.idenfy.idenfyliveness.IdenfyLivenessHelper()
            return livenessHelper
        } catch (t: Throwable) {
            return null
        }

    }
}
