package com.idenfy.idenfySdk.core.ui.viewmodel

import android.app.Application


import android.arch.lifecycle.AndroidViewModel
import android.arch.lifecycle.LiveData
import android.arch.lifecycle.MediatorLiveData
import android.arch.lifecycle.MutableLiveData
import android.arch.lifecycle.Observer
import android.content.Context
import android.graphics.Bitmap
import android.os.Handler

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings
import com.idenfy.idenfySdk.core.presentation.uiviewmodel.CurrentStepUIViewModel
import com.idenfy.idenfySdk.core.presentation.helper.DocumentStepsUIManager
import com.idenfy.idenfySdk.di.DIProvider
import com.idenfy.idenfySdk.Networking.APIService
import com.idenfy.idenfySdk.backgrounduploading.domain.usecase.BackgroundCameraPhotosHolderUseCase
import com.idenfy.idenfySdk.Repository.RepositoryKotlin
import com.idenfy.idenfysdk.core.extensions.livedataextensions.ForegroundBackgroundListener
import com.idenfy.idenfySdk.initialagreement.repo.InitialAgreementRepositoryImp
import com.idenfy.idenfySdk.presentation.InitialLoadingDataViewModel
import com.idenfy.idenfysdk.core.models.documentTypeData.DocumentTypeClass
import com.idenfy.idenfysdk.core.models.documentTypeData.DocumentTypeEnum
import com.idenfy.idenfysdk.core.models.documentTypeData.Step
import com.idenfy.idenfysdk.core.networking.models.requestBodies.DocumentTypeRequest
import com.idenfy.idenfysdk.core.networking.models.requestBodies.S3RequestData
import com.idenfy.idenfysdk.core.networking.models.responseBodies.PartnerInfo
import com.idenfy.idenfySdk.Networking.Resource
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.RetakeSteps
import com.idenfy.idenfySdk.UI.CountriesSelectionView.Country
import com.idenfy.idenfySdk.UI.CountriesSelectionView.CountryEnum
import com.idenfy.idenfySdk.UI.DocumentPhotoResultView.DocumentPhotoResult
import com.idenfy.idenfysdk.core.domain.networkrepo.ErrorsHelper
import com.idenfy.idenfySdk.helpers.SingleLiveEvent
import com.idenfy.idenfySdk.SdkResponseModels.AutenticationResult.AuthenticationResultResponseInternal
import com.idenfy.idenfysdk.core.networking.models.requestBodies.CountrySetRequest
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyError
import com.idenfy.idenfySdk.SdkResponseModels.IdenfyErrorResponse
import com.idenfy.idenfysdk.core.networking.Status
import com.idenfy.idenfySdk.Networking.ProcessUploadCompletion
import com.idenfy.idenfySdk.core.domain.usecase.GetDocumentTypesUseCase
import com.idenfy.idenfySdk.core.domain.usecase.SetDeviceTypeUseCase
import com.idenfy.idenfySdk.core.domain.usecase.StartProcessingUseCase
import com.idenfy.idenfySdk.core.domain.usecase.GetPartnerInfoUseCase
import com.idenfy.idenfySdk.core.domain.ImagesPreparingForUploadUseCase
import com.idenfy.idenfySdk.core.domain.usecase.InitialLoadingUseCase
import com.idenfy.idenfySdk.domain.*
import com.idenfy.idenfysdk.core.internal.settings.IdenfyInternalSettings
import io.reactivex.Observable
import io.reactivex.functions.BiFunction


import java.io.File
import java.io.IOException
import java.util.ArrayList
import java.util.Arrays
import java.util.Locale
import java.util.concurrent.atomic.AtomicBoolean

import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.CompositeDisposable
import io.reactivex.schedulers.Schedulers
import io.reactivex.subjects.ReplaySubject
import kotlinx.coroutines.*
import java.util.concurrent.TimeUnit
import kotlin.coroutines.CoroutineContext

class CameraViewModel(application: Application) : AndroidViewModel(application), CoroutineScope {

    private var initEngineJob: Job = SupervisorJob()
    override val coroutineContext: CoroutineContext
        get() = initEngineJob + Dispatchers.Main
    var currentDocumentClass: DocumentTypeClass? = null
    private lateinit var initialLoadingUseCase: InitialLoadingUseCase
    private lateinit var setDeviceTypeUseCase: SetDeviceTypeUseCase
    private lateinit var startProcessingUseCase: StartProcessingUseCase
    private lateinit var getFormatedCountriesUseCase: GetFormatedCountriesUseCase
    private lateinit var imagesPreparingForUploadUseCase: ImagesPreparingForUploadUseCase

    lateinit var diProvider: DIProvider

    lateinit var documentStepsManager: DocumentStepsUIManager
    var currentStepUIViewModelLiveData = MutableLiveData<CurrentStepUIViewModel>()


    //UI/UX VISIBILITY AND AVAILABILITY
    private val nextButtonVisibility = MutableLiveData<Boolean>()
    val actionButtonVisibility = MutableLiveData<Boolean>()
    val recreateButtonVisibility = MutableLiveData<Boolean>()
    private val showImageLayoutVisibility = MutableLiveData<Boolean>()
    private val cropShapeImageViewVisibility = MutableLiveData<Boolean>()
    private val nextButtonAvailability = MutableLiveData<Boolean>()
    private val recreateButtonAvailability = MutableLiveData<Boolean>()
    private val takePictureButtonAvailability = MutableLiveData<Boolean>()

    internal var imageViewResult = MutableLiveData<Boolean>()
    internal var imageViewResultFullSize = MutableLiveData<Boolean>()
    var authenticationFragmentOpenMutableLiveData = MutableLiveData<Boolean>()
    var setDocumentTypeResponseMutableLiveData = MutableLiveData<Resource<DocumentTypeClass>>()
    private val nextButtonPressed = MutableLiveData<Boolean>()
    private val retakeButtonPressed = MutableLiveData<Boolean>()
    val faceRetakeButtonPressed = MutableLiveData<Boolean>()


    //ADDING REMOVING VIEWS, SAFELY
    private val addDocumentCameraFragment = MutableLiveData<Boolean>()
    private val addDocumentScanningFragment = MutableLiveData<Boolean>()
    private val dismissCountryDialogLiveData = MutableLiveData<Boolean>()
    private val addInitialAgreementFragmentMutableLiveData = MutableLiveData<Boolean>()
    private val addSplashScreenFragmentMutableLiveData = MutableLiveData<Boolean>()

    var isLivenessOpened: Boolean = false
    var partnerInfo: PartnerInfo? = null
    private var initialDataObserver: Observer<com.idenfy.idenfysdk.core.networking.Resource<InitialLoadingDataViewModel>> = Observer { response ->
        if (response == null)
            return@Observer
        if (response.status == Status.SUCCESS) {
            if (response.data == null)
                return@Observer
            partnerInfo = response.data!!.partnerInfo
            if (idenfySettings!!.issuingCountry != null) {
                setCountryForDocumentRequest(idenfySettings!!.issuingCountry)
            }

            if (idenfySettings!!.setupAgreementFragment) {
                if (!repository.getIdenfyInternalSettings().isInitialViewClosed) {
                    setAddInitialAgreementFragmentMutableLiveData(true)
                }
            }
            setAddSplashScreenFragmentMutableLiveData(false)
        } else {
            setAddSplashScreenFragmentMutableLiveData(true)
        }
    }

    var initialLoadingDataLiveData = MediatorLiveData<com.idenfy.idenfysdk.core.networking.Resource<InitialLoadingDataViewModel>>()

    var foregroundBackgroundListener = ForegroundBackgroundListener()
    var isAppInBackgroundLiveData = MediatorLiveData<Boolean>()

    var canSetupZoomLogin = AtomicBoolean(true)

    private var uploadedDocumentsPhotosBase64Array: MutableList<File> = ArrayList()

    private val countriesListMutableLiveData = MutableLiveData<Resource<List<Country>>>()


    //SDK Responses
    val startedProcessingLiveData = MediatorLiveData<Resource<ProcessUploadCompletion>>()

    val checkingAuthenticationResultsLiveData = MediatorLiveData<Resource<ProcessUploadCompletion>>()
    var idenfyError = MutableLiveData<IdenfyError>()

    var countryFromIpMutableLiveData = MutableLiveData<Country>()

    var savedIdentificationResultResponse: AuthenticationResultResponseInternal? = null
    var authenticationResultResponseLiveData = MutableLiveData<Resource<AuthenticationResultResponseInternal>>()
    var savedAuthenticationResultResponseInternal:AuthenticationResultResponseInternal?=null
    var identificationSuccessResponse = MutableLiveData<AuthenticationResultResponseInternal>()


    var selectedCountry = Country("lt")


    lateinit var repository: RepositoryKotlin
    var idenfySettings: IdenfySettings? = null
    var internalIdenfySettings: IdenfyInternalSettings? = null
    var apiService: APIService? = null
    private var docScanningRepository: com.idenfy.docscanning.docScanningRepo.DocScanningRepository? = null
    var libraryLifecycleDisposable = CompositeDisposable()
    var identificationResultsDisposable = CompositeDisposable()
    private val documentsUploadingFlowDispoable = CompositeDisposable()
    private val reusable = CompositeDisposable()

    private val faceCameraFragmentLiveData = MutableLiveData<Boolean>()

    val addDocScanningFragment: LiveData<Boolean>
        get() = this.addDocumentScanningFragment

    var isRecyclerViewEnabled = false

    val addSplashScreenFragmentLiveData: LiveData<Boolean>
        get() = this.addSplashScreenFragmentMutableLiveData

    val authenticationResultFragmentLiveData: LiveData<Boolean>
        get() = authenticationFragmentOpenMutableLiveData

    val currentDocumentStep: String
        get() = currentDocumentClass!!.currentStep

    val cropShapeImageView: LiveData<Boolean>
        get() = cropShapeImageViewVisibility

    var savedFacePhotoBitmap: Bitmap? = null

    private val idenfyErrorMediatorLiveData = MediatorLiveData<IdenfyError>()

    //used for synchronizing SDK responses
    var responseEventOccured = false

    var hasPartnerEnabledZoom = false

    private val authenticationSuccessForClosing = MutableLiveData<Boolean>()


    internal var documentsTypesLiveData = MutableLiveData<List<DocumentTypeClass>>()

    val documentTypesLiveData: LiveData<List<DocumentTypeClass>>
        get() = documentsTypesLiveData

    private val documentPhotoResultMutableLiveData = MutableLiveData<DocumentPhotoResult>()

    val documentPhotoResultLiveData: LiveData<DocumentPhotoResult>
        get() = documentPhotoResultMutableLiveData

    var addDocumentPhotoResultFragment = SingleLiveEvent<Boolean>()
    private val addDocumentFacePhotoResultFragment = SingleLiveEvent<Boolean>()

    private var backgroundCameraPhotosHolderUseCase: BackgroundCameraPhotosHolderUseCase? = null


    fun setNextButtonPressed(nextButtonPressed: Boolean?) {
        this.nextButtonPressed.value = nextButtonPressed
    }

    fun getNextButtonPressed(): LiveData<Boolean> {
        return nextButtonPressed
    }

    fun setRetakeButtonPressed(retakeButtonPressed: Boolean?) {
        this.retakeButtonPressed.value = retakeButtonPressed
    }

    fun getRetakeButtonPressed(): LiveData<Boolean> {
        return retakeButtonPressed
    }

    fun setFaceRetakeButtonPressed(retakeButtonPressed: Boolean?) {
        this.faceRetakeButtonPressed.value = retakeButtonPressed
    }


    private fun getDocScanningRepository(application: Application): com.idenfy.docscanning.docScanningRepo.DocScanningRepository? {

        try {
            Class.forName("com.idenfy.docscanning.docScanningRepo.DocScanningRepositoryProvider")
            return com.idenfy.docscanning.docScanningRepo.DocScanningRepositoryProvider.getInstance(application.applicationContext)
        } catch (e: ClassNotFoundException) {
            return null
        }

    }

    var wasChangedSettings = false
    fun setupIdenfySettings(idenfySettings: IdenfySettings, idenfyInternalSettings: IdenfyInternalSettings?, isSavedInstance: Boolean) {
        wasChangedSettings = false
        if (this.idenfySettings != null)
            return
        wasChangedSettings = true
        this.idenfySettings = idenfySettings
        this.internalIdenfySettings = internalIdenfySettings
        documentStepsManager = DocumentStepsUIManager()
        diProvider = DIProvider(getApplication())
        repository = diProvider.getRepositoryKotlin()
        docScanningRepository = getDocScanningRepository(getApplication())
        repository.setupInitialTriggers()
        repository.setupAuthTokenRequest(idenfySettings.token)
        if (idenfyInternalSettings != null) {
            repository.idenfyInternalSettings = idenfyInternalSettings
        }
        apiService = diProvider.apiServiceProvider.getAPIService()
        setupUseCases(getApplication())
        setupLocale()

        initialLoadingDataLiveData.addSource(repository.returnInitialLoadingDataViewModel()) {
            initialLoadingDataLiveData.value = it
        }

        initialLoadingDataLiveData.observeForever(initialDataObserver)
        checkingAuthenticationResultsLiveData.addSource(startProcessingUseCase.startedProcessingLiveData) { response ->
            checkingAuthenticationResultsLiveData.value = response
        }
        repository.returnInitialLoadingDataViewModel().setValue(com.idenfy.idenfysdk.core.networking.Resource.loading(null))
        observeInitialLoading()
        isAppInBackgroundLiveData.addSource(foregroundBackgroundListener.appIsInBackgroundLiveData) { response ->
            isAppInBackgroundLiveData.setValue(response)


        }
        if (!isSavedInstance) {
            setDeviceType()
        }
        if (idenfySettings.setupAgreementFragment) {
            if (isSavedInstance) {
                if (repository.getIdenfyInternalSettings().isInitialViewClosed) {
                    repository.startSessionTriggerDone()
                    repository.setCountryTriggerDone()
                }
            }
        } else {
            if (isSavedInstance) {
                repository.setCountryTriggerDone()
                repository.startSessionTriggerDone()
            } else {
                startSession()
            }
        }
    }

    init {


    }

    var INTERNAL_OF_RESULTS: Long = 3
    //I need to keep this variable in order to prevent from creating a new response, without waiting previous
    var responseReceived = false
    var identificationRequestSubject:ReplaySubject<Boolean>?=null
    var appIsInForegroundSubject:ReplaySubject<Boolean>?=  null

    private fun indicate(first: Boolean, second: Boolean): Boolean {
        if (first && second) {
            return true
        }
        return false
    }

    fun checkIdentificationResults() {
        authenticationResultResponseLiveData.value = Resource.loading(null)
        identificationRequestSubject = ReplaySubject.create<Boolean>()
        appIsInForegroundSubject =  ReplaySubject.create<Boolean>()
        identificationRequestSubject?.onNext(false)
        appIsInForegroundSubject?.onNext(true)
        identificationResultsDisposable.add(Observable.combineLatest(identificationRequestSubject, appIsInForegroundSubject,
                BiFunction<Boolean, Boolean, Boolean> { identificationRequestSubject, appIsInbackgroundSubject->

                    indicate(identificationRequestSubject, appIsInbackgroundSubject)

                }).subscribeOn(Schedulers.io()).
                observeOn(AndroidSchedulers.mainThread())
                .subscribe(
                        {

                            if (it == true) {
                                identificationRequestSubject?.onNext(false)
                                val disposable =
                                        Observable.defer { checkIfIsInBackground() }
                                                .repeatWhen { observable -> observable.delay(INTERNAL_OF_RESULTS, TimeUnit.SECONDS) }
                                                .takeUntil { it?.processingStatus.equals("FINISHED", true) }
                                                .subscribeOn(Schedulers.io())
                                                .observeOn(AndroidSchedulers.mainThread())
                                                .subscribe({ response ->
                                                    //changing interval to 3 seconds
                                                    authenticationResultResponseLiveData.value = Resource.success(response)
                                                    if (response?.processingStatus.equals("FINISHED", true)) {
                                                        savedAuthenticationResultResponseInternal = response
                                                        //clearing data
                                                        identificationResultsDisposable.clear()
                                                    }
                                                    this.responseReceived = false
                                                }, {
                                                    repository.handleErrorInstance(it)
                                                })
                                this.identificationResultsDisposable.add(disposable)
                            }
                        }, {
                    repository.handleErrorInstance(it)

                }))
        Handler().postDelayed({
            identificationRequestSubject?.onNext(true)
        }, 9000)


    }

    private fun checkIfIsInBackground(): Observable<AuthenticationResultResponseInternal> {
        if (this.responseReceived) {
            return Observable.empty()
        }
        val appIsInBackground = foregroundBackgroundListener.appIsInBackground
        if (appIsInBackground)
            return Observable.empty()

        responseReceived = true
        return repository.checkIdentificationResults()

    }

    private fun setDeviceType() {
        setDeviceTypeUseCase.setDeviceType()
    }


    private fun setupUseCases(application: Application) {
        getFormatedCountriesUseCase = GetFormatedCountriesUseCase(InitialAgreementRepositoryImp)
        startProcessingUseCase = StartProcessingUseCase(repository, apiService!!, libraryLifecycleDisposable)
        initialLoadingUseCase = InitialLoadingUseCase(idenfySettings!!, GetCountriesListUseCase(repository, application),
                GetDocumentTypesUseCase(repository), GetPartnerInfoUseCase(repository),
                GetCountryByIpUseCase(repository), repository)
        setDeviceTypeUseCase = SetDeviceTypeUseCase(repository, apiService!!, idenfySettings!!, libraryLifecycleDisposable)
        backgroundCameraPhotosHolderUseCase = diProvider.getBackgroundUploadingUseCase(libraryLifecycleDisposable)
        imagesPreparingForUploadUseCase = ImagesPreparingForUploadUseCase(application)
    }

    private fun observeInitialLoading() {
        libraryLifecycleDisposable.add(initialLoadingUseCase.getInitialLoadingUseCase().subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread()).subscribe({ response ->
                    val partnerInfo = response.partnerInfo
                    val formattedCountries: GetFormatedCountriesUseCase.FormattedCountries
                    formattedCountries = getFormatedCountriesUseCase!!.getFormattedCountries(partnerInfo.countriesBlacklist, response.countriesList.toMutableList(),
                            response.countyCodeFromIP.country, partnerInfo.country)

                    countryFromIpMutableLiveData.setValue(formattedCountries.countryFromApi)
                    if (partnerInfo.mobileAutoDocScanning!!) {
                        docScanningRepository?.partnerInfo = partnerInfo
                        if (idenfySettings!!.issuingCountry != null) {
                            startDownloadingTemplatesFromAPI(CountryEnum.getCountryISO3(idenfySettings!!.issuingCountry))
                        } else {
                            startDownloadingTemplatesFromAPIUsingInitial(partnerInfo, countryFromIpMutableLiveData.value)
                        }
                    }
                    countriesListMutableLiveData.setValue(Resource.success(formattedCountries.countriesList))
                    documentsTypesLiveData.setValue(response.documentTypes)
                    repository.setPartnerInfo(response.partnerInfo)
                    repository.returnInitialLoadingDataViewModel().setValue(com.idenfy.idenfysdk.core.networking.Resource.success(response))
                }, { error -> repository.handleErrorInstance(error) }))
    }

    private fun setupLocale() {
        if (IdenfyController.getInstance() != null && IdenfyController.getInstance().settings != null && IdenfyController.getInstance().settings.customLocale != null) {
            val config = this.getApplication<Application>().applicationContext.resources.configuration
            val locale = Locale(IdenfyController.getInstance().settings.customLocale)
            Locale.setDefault(locale)
            config.locale = locale
            this.getApplication<Application>().applicationContext.resources.updateConfiguration(config, this.getApplication<Application>().applicationContext.resources.displayMetrics)
        }
    }

    private fun deleteFiles(path: String) {

        val file = File(path)

        if (file.exists()) {
            val deleteCmd = "rm -r $path"
            val runtime = Runtime.getRuntime()
            try {
                runtime.exec(deleteCmd)
            } catch (e: IOException) {
            }

        }
    }

    override fun onCleared() {
        libraryLifecycleDisposable.dispose()
        reusable.dispose()
        documentsUploadingFlowDispoable.dispose()
        identificationResultsDisposable.dispose()
        super.onCleared()
        deleteFiles(getApplication<Application>().getDir("idenfy", Context.MODE_PRIVATE).absolutePath)

        initEngineJob.cancelChildren()
        initEngineJob.cancel()
        repository.startSessionSubjectTrigger.onComplete()
        docScanningRepository?.deinit()
        InitialAgreementRepositoryImp.deinit()
        repository.returnIdenfyErrorIdentifierLiveData().value = null
        repository.deInit()
        initialLoadingDataLiveData.removeObserver(initialDataObserver)
    }


    fun getStartedProcessingLiveData(): LiveData<Resource<ProcessUploadCompletion>> {
        return this.startedProcessingLiveData
    }


    fun setIdenfyError(idenfyError: IdenfyError) {
        this.idenfyError.value = idenfyError
    }


     fun startProcessing() {
        startProcessingUseCase.startProcessing()
    }


    fun getDismissCountryDialogLiveData(): LiveData<Boolean> {
        return dismissCountryDialogLiveData
    }

    fun setDismissCountryDialogMutableLiveData(b: Boolean) {
        dismissCountryDialogLiveData.postValue(b)
    }

    fun setIdentificationSuccessResponse(authenticationResultResponse: AuthenticationResultResponseInternal) {
        this.identificationSuccessResponse.value = authenticationResultResponse
    }

    fun handleRetakeSteps(retakeSteps: RetakeSteps): List<Step> {
        val stepList = ArrayList<Step>()
        if (retakeSteps.front != null && !retakeSteps.front) {
            stepList.add(Step.FRONT)
        }
        if (retakeSteps.back != null && !retakeSteps.back) {
            stepList.add(Step.BACK)
        }
        if (retakeSteps.face != null && !retakeSteps.face) {
            stepList.add(Step.FACE)
        }
        return stepList

    }


    private fun setCurrentDocument(document: DocumentTypeClass) {

        this.currentDocumentClass = document
        this.backgroundCameraPhotosHolderUseCase
    }

    private fun observeThenToStartProcessing() {
        documentsUploadingFlowDispoable.add(repository.observeThenToStartProcessing().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe({ response ->
            authenticationResultResponseLiveData.value = Resource.loading(null)
            documentsUploadingFlowDispoable.clear()
            startedProcessingLiveData.value = Resource.success(ProcessUploadCompletion())
        }, { error -> }))
    }

    fun setCountryForDocument(value: Country?) {
        if (value != null) {
            selectedCountry = value
            setCountryForDocumentRequest(value.countryISO)
            if (partnerInfo!!.mobileAutoDocScanning!!)
                startDownloadingTemplatesFromAPI(value.getmCountryISO3())
        }
    }

    fun startSession() {
        if (repository.getIdenfyInternalSettings().isSessionsStarted) {
            repository.setupInitialTriggers()
            repository.startSessionTriggerDone()
            return
        }
        repository.startSession(idenfySettings!!.token, libraryLifecycleDisposable)
    }

    private fun setCountryForDocumentRequest(value: String) {

        val authTokenRequest = CountrySetRequest()
        authTokenRequest.authToken = IdenfyController
                .getInstance().settings.token
        authTokenRequest.country = value
        repository.setIssuingCountry(authTokenRequest, libraryLifecycleDisposable)

    }
    fun setDocumentType(document: DocumentTypeClass) {
        setupCurrentDocumentForLibraryLifecycle(document)
        setupCurrentDocumentStepsFlow(currentDocumentClass!!.originalStepList)
        setDocumentTypeResponseMutableLiveData.value = Resource.success(document)
    }

    fun setupCurrentDocumentForLibraryLifecycle(document: DocumentTypeClass) {
        setCurrentDocument(document)
        repository.setupDocumentTypeTrigger()
        if (partnerInfo!!.mobileAutoDocScanning!!)
            docScanningRepository?.setDocumentType(document.documentTypeEnum)
        val documentTypeRequest = DocumentTypeRequest(IdenfyController.getInstance().settings.token,
                currentDocumentClass!!.documentTypeEnum.name)
        repository.setupDocument(documentTypeRequest, documentsUploadingFlowDispoable, hasPartnerEnabledZoom)
    }

    fun setupCurrentDocumentStepsFlow(steps: MutableList<String>) {
        authenticationResultResponseLiveData.value = null
        uploadedDocumentsPhotosBase64Array = ArrayList()
        currentDocumentClass!!.setupValuesForCurrentStep(steps)
        startObservingUploads(currentDocumentClass!!.uploadPhotoStepList)
        observeThenToStartProcessing()
    }


    fun triggerDocumentAsSelected() {
        repository.setDocumentTypeTriggerDone()
    }

    private fun startObservingUploads(uploadedSteps: List<String>) {

        repository.startObservingUploads(uploadedSteps)
    }

    fun setTakePictureButtonAvailability(available: Boolean) {
        takePictureButtonAvailability.value = available
    }

    fun setNextButtonAvailability(available: Boolean) {
        this.nextButtonAvailability.value = available
    }

    fun setRecreateButtonAvailability(available: Boolean) {
        this.recreateButtonAvailability.value = available
    }

    fun getTakePictureButtonAvailability(): LiveData<Boolean> {
        return this.takePictureButtonAvailability
    }

    fun setAddDocumentCameraFragment(value: Boolean) {
        this.addDocumentCameraFragment.value = value
    }

    fun setAddDocumentScanningFragment(value: Boolean) {
        this.addDocumentScanningFragment.value = value
    }

    fun setAddFaceCameraFragment(value: Boolean) {
        faceCameraFragmentLiveData.value = value
    }

    fun getFaceCameraFragmentLiveData(): LiveData<Boolean> {
        return faceCameraFragmentLiveData
    }


    fun getAddCameraFragment(): LiveData<Boolean> {
        return this.addDocumentCameraFragment
    }

    fun addInitialAgreementFragmentLiveData(): LiveData<Boolean> {
        return this.addInitialAgreementFragmentMutableLiveData
    }

    fun setAddInitialAgreementFragmentMutableLiveData(addInitialAgreementFragmentMutableLiveData: Boolean?) {
        this.addInitialAgreementFragmentMutableLiveData.value = addInitialAgreementFragmentMutableLiveData
    }

    private fun setAddSplashScreenFragmentMutableLiveData(splashScreenFragmentMutableLiveData: Boolean?) {
        this.addSplashScreenFragmentMutableLiveData.value = splashScreenFragmentMutableLiveData
    }

    fun setAuthenticationFragmentOpenMutableLiveData(authenticationFragmentOpenMutableLiveData: Boolean?) {
        this.authenticationFragmentOpenMutableLiveData.value = authenticationFragmentOpenMutableLiveData
    }

    fun getImageViewResult(): LiveData<Boolean> {
        return imageViewResult
    }

    fun setImageViewResult(imageViewResult: Boolean?) {
        this.imageViewResult.value = imageViewResult
    }

    fun getImageViewResultFullSize(): LiveData<Boolean> {
        return imageViewResultFullSize
    }

    fun setImageViewResultFullSize(imageViewResultFullSize: Boolean?) {
        this.imageViewResultFullSize.value = imageViewResultFullSize
    }

    fun setShowImageLayoutVisibility(showImageLayoutVisibility: Boolean?) {
        this.showImageLayoutVisibility.value = showImageLayoutVisibility
    }

    fun getShowImageLayoutVisibility(): LiveData<Boolean> {
        return showImageLayoutVisibility
    }


    fun getNextButtonVisibility(): LiveData<Boolean> {
        return nextButtonVisibility
    }

    fun setNextButtonVisibility(nextButtonVisibility: Boolean?) {
        this.nextButtonVisibility.value = nextButtonVisibility
    }

    fun setRecreateButtonVisibility(recreateButtonVisibility: Boolean?) {

        this.recreateButtonVisibility.value = recreateButtonVisibility
    }

    private fun increaseCurrentStep() {
        currentDocumentClass!!.increaseCurrentStep()
    }

    private fun checkIfItReadyToOpenResults(): Boolean {
        return currentDocumentClass!!.shouldNavigateToResultsView()
    }

    fun handleFlow(bitmap: Bitmap, shouldNavigateToNewView: Boolean? = null) {
        val currentStep = currentDocumentClass!!.currentStep
        launch {
            val bitmapCopy = bitmap.copy(bitmap.getConfig(), true)
            val deferredBase64 = async(Dispatchers.IO) {
                imagesPreparingForUploadUseCase.getBase64ForImageUploading(bitmapCopy)
            }
            val deferredFile = async(Dispatchers.IO) {
                imagesPreparingForUploadUseCase.getFileForImageUploading(bitmap)
            }
            val file = deferredFile.await()
            val base64 = deferredBase64.await()
            if (file != null) {
                uploadedDocumentsPhotosBase64Array.add(file)
                saveFileToServer(currentStep, file, base64)
            } else {
                repository.uploadDocumentPhotoLegacy(libraryLifecycleDisposable, currentDocumentClass!!.uploadPhotoStepList, base64, currentStep)
            }
        }
        launch {
            val backgroundPhotoZip = async(Dispatchers.IO) {
                setBackgroundPhotos(currentStep)
            }
            backgroundPhotoZip.await()
            saveBackgroundPhotosToServer(currentStep)
        }

        navigate(shouldNavigateToNewView)

    }

    private fun increaseCurrentStepAndChange() {
        increaseCurrentStep()
        changeDocument()
    }

    fun navigate(shouldChangeView: Boolean? = null) {

        if (checkIfItReadyToOpenResults()) {
            authenticationResultResponseLiveData.value = Resource.loading(null)
            setAuthenticationFragmentOpenMutableLiveData(true)
        } else if (currentDocumentClass!!.shouldNavigateToDocumentsView()) {

            if (currentDocumentClass!!.nextStep == Step.FRONT.toString()) {
                if (checkIfCanSetupDocScanning(currentDocumentClass!!.documentTypeEnum)) {
                    increaseCurrentStepAndChange()
                    setAddDocumentScanningFragment(true)
                    return
                }
            }
            if (currentDocumentClass!!.shouldSwitchToDocumentView() || shouldChangeView == true) {
                increaseCurrentStepAndChange()
                setAddDocumentCameraFragment(true)
            } else {
                increaseCurrentStepAndChange()
                addDocumentPhotoResultFragment.setValue(false)
            }

        } else if (currentDocumentClass!!.shouldNavigateToFaceView()) {
            if (currentDocumentClass!!.shouldSwitchToFaceView()) {
                increaseCurrentStepAndChange()
                setAddFaceCameraFragment(true)
            } else {
                increaseCurrentStepAndChange()
                addDocumentFacePhotoResultFragment.setValue(false)
            }
        }
    }

    private fun setBackgroundPhotos(currentStep: String): Boolean {

        if (partnerInfo!!.recordIdentification!!)
            backgroundCameraPhotosHolderUseCase!!.setBackgroundPhotos(currentStep)

        return true

    }

    fun addBackgroundPhoto(bitmap: ByteArray) {
        if (partnerInfo!!.recordIdentification!!)
            backgroundCameraPhotosHolderUseCase!!.addNewPhotoToBackgroundPhoto(bitmap, currentDocumentStep)
    }

    private fun saveBackgroundPhotosToServer(step: String) {
        if (partnerInfo!!.recordIdentification!!)
            backgroundCameraPhotosHolderUseCase!!.uploadBackgroundPhotos(libraryLifecycleDisposable,
                    idenfySettings!!.token, step)
    }

    private fun saveFileToServer(step: String, imageData: File, base64: String) {
        val authToken = IdenfyController
                .getInstance().settings.token
        val s3RequestData = S3RequestData(authToken, step)
        repository.getS3UploadData(reusable, s3RequestData, imageData, base64, currentDocumentClass!!.uploadPhotoStepList)
    }

    fun observeIdenfyError(): LiveData<IdenfyError> {
        idenfyErrorMediatorLiveData.removeSource(repository.getIdenfyErrorIdentifier())
        if (docScanningRepository != null)
            idenfyErrorMediatorLiveData.removeSource(docScanningRepository!!.idenfyErrorIdentifierLiveData)
        if (docScanningRepository != null)
            idenfyErrorMediatorLiveData.addSource(docScanningRepository!!.idenfyErrorIdentifierLiveData) { errorIdentifier ->
                if (errorIdentifier == null) {
                    return@addSource
                }
                val idenfyError = IdenfyError(IdenfyErrorResponse(errorIdentifier,
                        ErrorsHelper.getErrrorMessageFromIdentifier(getApplication<Application>().applicationContext,
                                errorIdentifier)),
                        true, 1000)
                this.idenfyError.postValue(idenfyError)
            }
        idenfyErrorMediatorLiveData.addSource(repository.getIdenfyErrorIdentifier()) { errorIdentifier ->
            if (errorIdentifier == null) {
                return@addSource
            }
            val idenfyError = IdenfyError(IdenfyErrorResponse(errorIdentifier,
                    ErrorsHelper.getErrrorMessageFromIdentifier(getApplication<Application>().applicationContext,
                            errorIdentifier)),
                    true, 1000)
            this.idenfyError.postValue(idenfyError)
        }
        return idenfyErrorMediatorLiveData
    }

    fun getCountriesListMutableLiveData(): LiveData<Resource<List<Country>>> {
        return this.countriesListMutableLiveData
    }

    fun changeDocument() {

        currentStepUIViewModelLiveData.value = documentStepsManager.getCurrentStepUIViewModel(idenfySettings!!.idenfyUISettings, partnerInfo!!,
                currentDocumentClass!!.currentStep, currentDocumentClass!!.documentTypeEnum)
    }

    fun setAuthenticationSuccessForClosing(authenticationSuccessForClosing: Boolean?) {
        this.authenticationSuccessForClosing.value = authenticationSuccessForClosing
    }


    fun setDocumentPhotoResultMutableLiveData(documentPhotoResultMutableLiveData: DocumentPhotoResult) {
        this.documentPhotoResultMutableLiveData.value = documentPhotoResultMutableLiveData
    }

    fun getAddDocumentFacePhotoResultFragment(): LiveData<Boolean> {
        return addDocumentFacePhotoResultFragment
    }

    fun checkLiveness(livenessCheck: com.idenfy.idenfyliveness.LivenessCheck) {
        livenessCheck.authToken = IdenfyController.getInstance().settings.token
        repository.checkLiveness(livenessCheck, libraryLifecycleDisposable)
    }

    fun setaddFacePhotoResultFragment(value: Boolean) {
        addDocumentFacePhotoResultFragment.value = value
    }

    private fun startDownloadingTemplatesFromAPIUsingInitial(partnerInfo: PartnerInfo, countryFromIp: Country?) {

        if (countryFromIp == null)
            return
        docScanningRepository?.setCountryOfDocumentDownload(countryFromIp.getmCountryISO3())
        docScanningRepository?.getTemplateFromAPI(libraryLifecycleDisposable, repository.getAuthTokenRequest(), countryFromIpMutableLiveData.value!!.getmCountryISO3(), null)
        docScanningRepository?.selectedCountryFromIP = countryFromIp.getmCountryISO3()
    }

    private fun startDownloadingTemplatesFromAPI(countryISO: String) {
        docScanningRepository?.setCountryOfDocumentDownload(countryISO)
        docScanningRepository?.getTemplateFromAPI(libraryLifecycleDisposable, repository.getAuthTokenRequest(), countryISO, null)

    }

    private fun checkIfCanSetupDocScanning(documentTypeEnum: DocumentTypeEnum): Boolean {

        var shouldSetupDocScanning = false;
        if (repository.getPartnerInfo()!!.mobileAutoDocScanning!!) {
            if (docScanningRepository == null) {
                repository.setDocScanningTriggerDone()
                return false
            }

            if (documentTypeEnum != DocumentTypeEnum.ID_CARD && documentTypeEnum != DocumentTypeEnum.RESIDENCE_PERMIT
                    && documentTypeEnum != DocumentTypeEnum.PASSPORT && documentTypeEnum != DocumentTypeEnum.DRIVER_LICENSE) {

                repository.setDocScanningTriggerDone()
                shouldSetupDocScanning = false;
                return shouldSetupDocScanning;
            }
            val documentTypeTemplateFormatter = com.idenfy.docscanning.helpers.DocumentTypeTemplateFormatter()
            try {
                val strings = Arrays.asList(*getApplication<Application>().resources.assets.list("doc_recognition")!!)
                for (i in strings.indices) {
                    if (strings[i].contains(documentTypeTemplateFormatter.getPathForSearchingADocument(documentTypeEnum, docScanningRepository!!.docScanningDataViewModel.value!!.selectedCountry!!.toLowerCase()))) {
                        shouldSetupDocScanning = true
                        break;
                    }
                }
                if (!shouldSetupDocScanning)
                    repository.setDocScanningTriggerDone()
                return shouldSetupDocScanning
            } catch (e: IOException) {
                shouldSetupDocScanning = false;
                repository.setDocScanningTriggerDone()
                return shouldSetupDocScanning
            }

        }
        shouldSetupDocScanning = false;
        repository.setDocScanningTriggerDone()
        return shouldSetupDocScanning;
    }

    fun changeForegroundListener(b: Boolean) {
        appIsInForegroundSubject?.onNext(b)
    }
}
