package com.idenfy.idenfySdk.core.presentation.helper

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyUISettings
import com.idenfy.idenfySdk.core.presentation.models.InstructionEnum
import com.idenfy.idenfySdk.core.presentation.uiviewmodel.CurrentStepUIViewModel
import com.idenfy.idenfysdk.core.models.documentTypeData.DocumentTypeEnum
import com.idenfy.idenfysdk.core.models.documentTypeData.Step
import com.idenfy.idenfysdk.core.networking.models.responseBodies.PartnerInfo
import com.idenfySdk.R

class DocumentStepsUIManager {

    var step: String = ""
    var documentTypeEnum: DocumentTypeEnum = DocumentTypeEnum.PASSPORT
    val ID_CARD_RATIO = 30f / 19f
    val OTHER_RATIO = 125f / 87f
    var partnerInfo = PartnerInfo()
    var idenfyUISettings:IdenfyUISettings?= null


    fun setupvalues(step: String, documentTypeEnum: DocumentTypeEnum) {
        this.step = step
        this.documentTypeEnum = documentTypeEnum
    }
    fun getCurrentStepUIViewModel() : CurrentStepUIViewModel
    {
        return CurrentStepUIViewModel(getOverlayTitle(), getDocumentPreviewInformationTitle(),
                getResultInformationTitle(), getDocumentCameraFrameRatio(), getInstructionEnum())
    }
    fun getCurrentStepUIViewModel(idenfyUISettings:IdenfyUISettings, partnerInfo: PartnerInfo, step: String, documentTypeEnum: DocumentTypeEnum?=null) : CurrentStepUIViewModel
    {
        this.partnerInfo = partnerInfo
        this.step = step
        this.idenfyUISettings = idenfyUISettings
        if(documentTypeEnum!=null)
        this.documentTypeEnum = documentTypeEnum
        return getCurrentStepUIViewModel()
    }


    private fun getOverlayTitle(): Pair<Int, String?> {

        var overlay: Pair<Int, String?>
        overlay = when (step) {
            Step.FRONT.name->
                when (documentTypeEnum) {

                    DocumentTypeEnum.PASSPORT ->  Pair(R.string.idenfy_overlay_title_passport, null)
                    else -> Pair(R.string.front_document_element_text, null)
                }
            Step.BACK.name -> Pair(R.string.back_document_element_text, null)
            Step.UTILITY_BILL.name -> Pair(R.string.idenfy_overlay_title_utility_bill, null)
            Step.PASSPORT_COVER.name -> Pair(R.string.idenfy_overlay_title_passport_cover, null)
            Step.FACE.name -> Pair(R.string.idenfy_empty_string, null)

            else -> {
                val withoutUnderscore = step
                withoutUnderscore.replace("_", " ")
                Pair(R.string.idenfy_empty_string, withoutUnderscore)
            }
        }
        return overlay
    }
    private fun getResultInformationTitle() : Int
    {
        var previewTitleID:Int  = -1
        when(step) {
            Step.FRONT.name ->
                when(documentTypeEnum)
                {
                    DocumentTypeEnum.ID_CARD, DocumentTypeEnum.PASSPORT -> previewTitleID = R.string.show_pictured_document_bottom_passport_text
                    else-> {
                        previewTitleID = R.string.show_pictured_document_information_text_default
                    }

                }
            Step.BACK.name->
                when(documentTypeEnum)
                {
                    DocumentTypeEnum.ID_CARD -> previewTitleID = R.string.show_pictured_document_bottom_card_back_text
                    else->
                    {
                        previewTitleID = R.string.show_pictured_document_information_text_default
                    }
                }
             Step.FACE.name->
                previewTitleID= R.string.document_face_photo_result
            else->
            {
                previewTitleID = R.string.show_pictured_document_information_text_default
            }
        }
        return previewTitleID
    }

    private fun getDocumentPreviewInformationTitle(): IntArray
    {
        val previewTitleID  = IntArray(3)
        when(step) {
            Step.FRONT.name ->
            when(documentTypeEnum)
            {
                DocumentTypeEnum.ID_CARD -> previewTitleID[0] = R.string.document_type_id_card_front
                DocumentTypeEnum.PASSPORT -> previewTitleID[0] = R.string.document_type_text

                else-> {
                    previewTitleID[0] = R.string.document_tutorial_title_default_part_0
                    previewTitleID[1] = R.string.document_tutorial_title_default_part_1_front
                    previewTitleID[2] = R.string.document_tutorial_title_default_part_2
                }

            }
            Step.BACK.name->
                when(documentTypeEnum)
                {
                    DocumentTypeEnum.ID_CARD -> previewTitleID[0] = R.string.document_type_id_card_back
                    else->
                    {
                        previewTitleID[0] = R.string.document_tutorial_title_default_part_0
                        previewTitleID[1] = R.string.document_tutorial_title_default_part_1_back
                        previewTitleID[2] = R.string.document_tutorial_title_default_part_2
                    }
                }
            Step.FACE.name->
                previewTitleID[0] = R.string.document_face_photo
            else->
            {
                previewTitleID[0] = R.string.document_tutorial_title_default_part_0
                previewTitleID[1] = R.string.document_tutorial_title_default_part_1_front
                previewTitleID[2] = R.string.document_tutorial_title_default_part_2
            }
        }
        return previewTitleID
    }
    private fun getInstructionEnum(): InstructionEnum
    {
        var instructionEnum  = InstructionEnum.INSTRUCTION_NOT_NEEDED
        if(idenfyUISettings!=null && idenfyUISettings!!.areInstructionsNeeded)
        when(documentTypeEnum) {
            DocumentTypeEnum.ID_CARD ->
                when(step)
                {
                    Step.FRONT.name -> instructionEnum = InstructionEnum.ID_CARD_FRONT
                    Step.BACK.name  -> instructionEnum = InstructionEnum.ID_CARD_BACK
                    Step.FACE.name ->
                        if(partnerInfo.zoomLiveliness)
                        instructionEnum = InstructionEnum.FACE_PHOTO_WITH_LIVENESS
                        else
                            instructionEnum = InstructionEnum.FACE_PHOTO
                    else-> {
                        instructionEnum = InstructionEnum.INSTRUCTION_NOT_NEEDED
                    }

                }
            DocumentTypeEnum.PASSPORT->
                when(step)
                {
                    Step.FRONT.name -> instructionEnum = InstructionEnum.PASSPORT
                    Step.FACE.name ->
                        if(partnerInfo.zoomLiveliness)
                            instructionEnum = InstructionEnum.FACE_PHOTO_WITH_LIVENESS
                        else
                            instructionEnum = InstructionEnum.FACE_PHOTO
                    else-> {
                        instructionEnum = InstructionEnum.INSTRUCTION_NOT_NEEDED
                    }
                }
            DocumentTypeEnum.RESIDENCE_PERMIT->
                when(step)
                {
                    Step.FRONT.name -> instructionEnum = InstructionEnum.RESIDENCE_PERMIT_FRONT
                    Step.BACK.name -> instructionEnum = InstructionEnum.RESIDENCE_PERMIT_BACK
                    Step.FACE.name ->
                        if(partnerInfo.zoomLiveliness)
                            instructionEnum = InstructionEnum.FACE_PHOTO_WITH_LIVENESS
                        else
                            instructionEnum = InstructionEnum.FACE_PHOTO
                    else-> {
                        instructionEnum = InstructionEnum.INSTRUCTION_NOT_NEEDED
                    }
                }
            DocumentTypeEnum.DRIVER_LICENSE->
                when(step)
                {
                    Step.FRONT.name -> instructionEnum = InstructionEnum.DRIVER_LICENSE
                    Step.FACE.name ->
                        if(partnerInfo.zoomLiveliness)
                            instructionEnum = InstructionEnum.FACE_PHOTO_WITH_LIVENESS
                        else
                            instructionEnum = InstructionEnum.FACE_PHOTO
                    else-> {
                        instructionEnum = InstructionEnum.INSTRUCTION_NOT_NEEDED
                    }
                }
            DocumentTypeEnum.OTHER->
            {
                when(step)
                {
                    Step.FRONT.name -> instructionEnum = InstructionEnum.OTHER_FRONT
                    Step.BACK.name -> instructionEnum = InstructionEnum.OTHER_BACK
                    Step.FACE.name ->
                        if(partnerInfo.zoomLiveliness)
                            instructionEnum = InstructionEnum.FACE_PHOTO_WITH_LIVENESS
                        else
                            instructionEnum = InstructionEnum.FACE_PHOTO
                    else-> {
                        instructionEnum = InstructionEnum.INSTRUCTION_NOT_NEEDED
                    }
                }
            }
            else->
            {
                instructionEnum  = InstructionEnum.INSTRUCTION_NOT_NEEDED
            }
        }
        return instructionEnum
    }

    private fun getDocumentCameraFrameRatio(): Float
    {
        var ratio = -1f
        when(step)
        {
            Step.FRONT.name ->
                when(documentTypeEnum)
                {
                    DocumentTypeEnum.ID_CARD ->ratio = ID_CARD_RATIO
                    else ->ratio = OTHER_RATIO
                }
            Step.BACK.name->
                when(documentTypeEnum)
                {
                    DocumentTypeEnum.ID_CARD ->ratio = ID_CARD_RATIO
                    else ->ratio = OTHER_RATIO
                }
            Step.FACE.name -> ratio = -1f
            else->ratio = OTHER_RATIO
        }


        return ratio


    }


}