package com.idenfy.idenfySdk.UI.CameraView;


import android.annotation.SuppressLint;
import android.app.Activity;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.support.design.widget.TabLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatDelegate;
import android.support.v7.widget.AppCompatImageButton;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.style.ForegroundColorSpan;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfyController;
import com.idenfy.idenfySdk.CoreSdkInitialization.IdenfySettings;
import com.idenfy.idenfySdk.core.presentation.uiviewmodel.CurrentStepUIViewModel;
import com.idenfy.idenfySdk.core.presentation.models.InstructionEnum;
import com.idenfy.idenfySdk.UI.UIHelpers.FaceCameraFrameProcessor;
import com.idenfy.idenfySdk.UI.UIHelpers.Instructions.InstructionDynamicSizeManager;
import com.idenfy.idenfySdk.UI.UIHelpers.Instructions.InstructionPagerAdapter;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.InstructionViewModel;
import com.idenfy.idenfysdk.core.extensions.livedataextensions.ViewLifecycleFragment;
import com.idenfy.idenfySdk.UI.DocumentPhotoResultView.DocumentPhotoResult;
import com.idenfy.idenfySdk.core.ui.view.CameraPreviewActivity;
import com.idenfy.idenfySdk.UI.UIHelpers.BitmapPhotoCropper;
import com.idenfy.idenfySdk.UI.UIHelpers.Instructions.TopSheetBehavior;
import com.idenfy.idenfySdk.core.ui.viewmodel.CameraViewModel;
import com.idenfy.idenfySdk.ViewModelsCoreLogic.LivenessesViewModel;
import com.idenfy.idenfysdk.core.logging.LoggingHelper;
import com.idenfy.idenfysdk.core.models.InstructionModel;
import com.idenfy.idenfysdk.core.models.documentTypeData.UploadDocumentPhotoType;
import com.idenfy.idenfysdk.core.ui.uihelpers.CameraViewSize;
import com.idenfySdk.R;

import java.util.List;
import java.util.Objects;

import io.fotoapparat.Fotoapparat;
import io.fotoapparat.configuration.CameraConfiguration;
import io.fotoapparat.error.CameraErrorListener;
import io.fotoapparat.exception.camera.CameraException;
import io.fotoapparat.parameter.ScaleType;
import io.fotoapparat.preview.FrameProcessor;
import io.fotoapparat.result.BitmapPhoto;
import io.fotoapparat.selector.PreviewFpsRangeSelectorsKt;
import io.fotoapparat.selector.ResolutionSelectorsKt;
import io.fotoapparat.view.CameraView;

import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.auto;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz50;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.hz60;
import static io.fotoapparat.selector.AntiBandingModeSelectorsKt.none;
import static io.fotoapparat.selector.FocusModeSelectorsKt.autoFocus;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusPicture;
import static io.fotoapparat.selector.FocusModeSelectorsKt.continuousFocusVideo;
import static io.fotoapparat.selector.FocusModeSelectorsKt.fixed;
import static io.fotoapparat.selector.LensPositionSelectorsKt.front;
import static io.fotoapparat.selector.ResolutionSelectorsKt.highestResolution;
import static io.fotoapparat.selector.SelectorsKt.firstAvailable;
import static io.fotoapparat.selector.SensorSensitivitySelectorsKt.highestSensorSensitivity;

public class FaceCameraSessionFragment extends ViewLifecycleFragment {

    public static final String TAG = FaceCameraSessionFragment.class.getSimpleName();
    public Fotoapparat fotoapparat;
    private ViewPager viewPager;
    private ImageView expandArrow;
    private ImageView nextPageButton;
    private ImageView previousPageButton;
    private ImageView donePageButton;
    private TextView instructionText;
    private TextView instructionTitle;
    private TopSheetBehavior topSheetBehavior;
    ConstraintLayout topSheet;
    ConstraintLayout topSheetLayout;
    private InstructionPagerAdapter instructionPagerAdapter;
    CameraView cameraView;
    CameraViewModel cameraViewModel;
    InstructionViewModel instructionViewModel;
    LivenessesViewModel livenessesViewModel;
    ConstraintLayout imageInfoLayout;
    TextView documentTitleTutorial;
    private AppCompatImageButton takePictureButton;
    private FaceCameraFrameProcessor frameProcessor;
    private InstructionDynamicSizeManager instructionDynamicSizeManager;

    private Handler backgroundPhotoHandler = new Handler();

    private ImageView imageView;
    private TextView documentBorderTextView;
    private View rootView;
    ImageView backImage;
    TextView backTextView;

    private List<InstructionModel> instructionList;
    private boolean areInstructionsNeeded;


    private CameraConfiguration cameraConfiguration;
    //Handlers
    private Handler takePictureHandler = new Handler();
    private Handler slideDownInstructionsHandler = new Handler();
    //Logic values
    //UploadDocumentPhotoType currentUploadDocumentPhotoType;
    private long BUTTON_DELAY_FOR_UX = 50;
    //View drawings values
    private int rectangleLeft;
    private int rectangleTop;
    private int rectangleRight;
    private int rectangleBottom;
    private int heightOfImage;
    private int yCoordinateOfHeightStart;
    private int widthOfImage;
    private int xCoordinateOfWidthStart;

    public interface OnCameraClosedFragment {
        public void onCameraNewFragmentClosed(boolean closed);
    }

    public FaceCameraSessionFragment() {
        // Required empty public constructor
    }


    @Override
    public void onCreate(Bundle savedInstanceState) {

        AppCompatDelegate.setCompatVectorFromResourcesEnabled(true);
        super.onCreate(savedInstanceState);
        livenessesViewModel = ViewModelProviders.of(getActivity()).get(LivenessesViewModel.class);
        instructionViewModel = ViewModelProviders.of(Objects.requireNonNull(getActivity())).get(InstructionViewModel.class);
        cameraViewModel = ViewModelProviders.of(Objects.requireNonNull(getActivity())).get(CameraViewModel.class);
        instructionDynamicSizeManager = new InstructionDynamicSizeManager();
        LoggingHelper.FrgamentsInfo("onFaceSessionOnCreate");
    }


    private void setFotoapparatCameraSettings(FrameProcessor frameProcessor) {
        cameraConfiguration = CameraConfiguration
                .builder()
                .previewFpsRange(PreviewFpsRangeSelectorsKt.highestFps())
                .sensorSensitivity(highestSensorSensitivity())
                .frameProcessor(frameProcessor)
                .antiBandingMode(firstAvailable(
                        auto(),
                        hz60(),
                        hz50(),
                        none()
                ))
                .focusMode(firstAvailable(
                        continuousFocusPicture(),
                        continuousFocusVideo(),
                        autoFocus(),
                        fixed()
                ))
                .build();
    }

    private void initializeUI(View rootView) {
        viewPager = rootView.findViewById(R.id.instructionViewPager);
        expandArrow = rootView.findViewById(R.id.expandArrow);
        nextPageButton = rootView.findViewById(R.id.nextPageButton);
        previousPageButton = rootView.findViewById(R.id.previousPageButton);
        donePageButton = rootView.findViewById(R.id.donePageButton);
        topSheet = rootView.findViewById(R.id.top_sheet);
        topSheetLayout = rootView.findViewById(R.id.idenfy_topsheet_layout);
        instructionText = rootView.findViewById(R.id.instructionText);
        instructionTitle = rootView.findViewById(R.id.instructionTitle);
        cameraView = rootView.findViewById(R.id.cameraView);
        imageInfoLayout = rootView.findViewById(R.id.showImageLayout);
        documentTitleTutorial = rootView.findViewById(R.id.camera_session_information_text_view);
        takePictureButton = rootView.findViewById(R.id.takePictureButton);
        backImage = rootView.findViewById(R.id.backImage);
        backTextView = rootView.findViewById(R.id.back_text_view);
        imageViewResultConstraintLayout = rootView.findViewById(R.id.results_background);

        //SHAPE
        imageView = rootView.findViewById(R.id.imageView);
        documentBorderTextView = rootView.findViewById(R.id.document_overlay_title);


    }
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {

        if (cameraViewModel.getCurrentStepUIViewModelLiveData().getValue()!=null && cameraViewModel.getCurrentStepUIViewModelLiveData().getValue().getInstrcutionEnum()!= InstructionEnum.INSTRUCTION_NOT_NEEDED) {
            areInstructionsNeeded = true;

            rootView = inflater.inflate(R.layout.idenfy_face_camera_preview_session_fragment_with_instructions, container, false);
        }
        else {
            rootView = inflater.inflate(R.layout.idenfy_face_camera_preview_session_fragment, container, false);
        }
        initializeUI(rootView);
        return rootView;
    }


    private void observeDocumentType() {

        cameraViewModel.getCurrentStepUIViewModelLiveData().observe(getViewLifecycleOwner(), new Observer<CurrentStepUIViewModel>() {
            @Override
            public void onChanged(@Nullable CurrentStepUIViewModel response) {

                if (response != null) {
                    setupDocumentTitle(response.getSessionInformationTitle());
                    setupDocumentView(response.getDocumentCameraFrameRatio());
                    instructionViewModel.setCurrentInstructionEnum(response.getInstrcutionEnum());
                  //  setupDocumentOverlayString(response.getOverlayTitle());

                   if (areInstructionsNeeded) {
                       if(getContext() != null) {
                           instructionViewModel.createInstructionModelList(getContext());
                           instructionViewModel.getInstructionModelList().observe(getViewLifecycleOwner(), new Observer<List<InstructionModel>>() {
                               @Override
                               public void onChanged(@Nullable List<InstructionModel> instructionModels) {
                                   instructionList = instructionModels;
                                   setUpInstructions();
                               }
                           });
                       }
                   }

                }
            }
        });
    }
    private void setupDocumentOverlayString(int resID) {
        if (documentBorderTextView == null) {
            return;
        }
        documentBorderTextView.setText(getResources().getString(resID));

    }
    private void setupDocumentTitle(int[] resIdArray) {
        Integer titleId;
        if(resIdArray[1]==0){
            documentTitleTutorial.setText(getResources().getString(resIdArray[0]));
        }
        else{
            documentTitleTutorial.setText(getDefaultTitle(getResources().getString(resIdArray[1])));
        }

    }


    ConstraintLayout imageViewResultConstraintLayout;

    private void setupDocumentOverlayString(UploadDocumentPhotoType uploadDocumentPhotoType) {
        if (documentBorderTextView == null) {
            return;
        }
        switch (uploadDocumentPhotoType) {
            case ID_CARD_BACK:
                documentBorderTextView.setText(getResources().getString(R.string.back_document_element_text));
                break;
            case ID_CARD_FRONT:
                documentBorderTextView.setText(getResources().getString(R.string.front_document_element_text));
                break;
            case PASSPORT:
                documentBorderTextView.setText(getResources().getString(R.string.front_document_element_text));
                break;
            case OTHER_FRONT:
                documentBorderTextView.setText(getResources().getString(R.string.front_document_element_text));
                break;
            case OTHER_BACK:
                documentBorderTextView.setText(getResources().getString(R.string.back_document_element_text));

        }

    }

    private void startBackgroundPhotoTaking() {
        if(cameraViewModel.getPartnerInfo().getRecordIdentification())
        backgroundPhotoHandler.post(new Runnable() {
            @Override
            public void run() {
                frameProcessor.takeBackgroundPicture(new FaceCameraFrameProcessor.onSessionListener() {
                    @Override
                    public void OnPictureTaken(byte[] bitmap, int rotation, String encoded) {
                        cameraViewModel.addBackgroundPhoto(bitmap);
                    }
                });
                backgroundPhotoHandler.postDelayed(this, 250);
            }

        });
    }


    private void observeUI() {
        cameraViewModel.getActionButtonVisibility().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @SuppressLint("RestrictedApi")
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    takePictureButton.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
        cameraViewModel.getCropShapeImageView().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean response) {
                if (response != null)
                    imageView.setVisibility(response ? View.VISIBLE : View.INVISIBLE);
            }
        });
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        cameraViewModel.setTakePictureButtonAvailability(true);
        setupCustomUI();
        if (areInstructionsNeeded)
            setUpUIDynamicSizes();

    }

    public void setupDocumentView(@Nullable float document) {
        setupImageView(document);


    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle savedInstanceState) {
        super.onSaveInstanceState(savedInstanceState);

    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

    }

    @Override
    public void onDetach() {
        super.onDetach();
    }


    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        pictureButtonOnClickListener();
        if (IdenfyController.getInstance().getSettings() != null) {
            IdenfySettings idenfySettings = IdenfyController.getInstance().getSettings();
            Typeface typeface = idenfySettings.getCustomRegularFont();
            Typeface typefaceBold = idenfySettings.getCustomBoldTypeFace();
            setupCustomTypeFace(typeface, typefaceBold);
        }

        backTextView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();

            }
        });
        backImage.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                onBackPressed();
            }
        });
        observeUI();
        observeButtonsAvailability();
        observeDocumentType();
        observeButtonClicks();
        cameraViewModel.setTakePictureButtonAvailability(true);
        cameraViewModel.setTakePictureButtonAvailability(true);
        LoggingHelper.FrgamentsInfo("onFaceSessionActivityCreated");


    }

    TopSheetBehavior.TopSheetCallback topSheetBehaviorCallback =  new TopSheetBehavior.TopSheetCallback() {
        @Override
        public void onStateChanged(@NonNull View bottomSheet, int newState) {
        }

        @Override
        public void onSlide(@NonNull View bottomSheet, float slideOffset, @Nullable Boolean isOpening) {
            if (rootView == null)
                return;
            TextView cameraSessionTitle = rootView.findViewById(R.id.camera_session_information_text_view);

            if (isOpening != null) {
                if (isOpening) {
                    if (slideOffset > 0.7) {
                        topSheetBehavior.setState(TopSheetBehavior.STATE_EXPANDED);
                        expandArrow.setImageResource(R.drawable.idenfy_expand_less);
                        cameraSessionTitle.setVisibility(View.GONE);
                        instructionText.setVisibility(View.VISIBLE);
                        donePageButton.setVisibility(View.GONE);
                        backTextView.setVisibility(View.GONE);
                        backImage.setVisibility(View.GONE);
                        takePictureButton.setVisibility(View.INVISIBLE);
                        topSheet.setClickable(true);
                    }
                } else {
                    if (slideOffset < 0.3) {
                        topSheetBehavior.setState(TopSheetBehavior.STATE_COLLAPSED);
                        expandArrow.setImageResource(R.drawable.idenfy_expand_more);
                        cameraSessionTitle.setVisibility(View.VISIBLE);
                        instructionText.setVisibility(View.INVISIBLE);
                        backTextView.setVisibility(View.VISIBLE);
                        backImage.setVisibility(View.VISIBLE);
                        takePictureButton.setVisibility(View.VISIBLE);
                        topSheet.setClickable(false);
                    }
                }
            }
        }
    };
    private void observeButtonClicks() {
        cameraViewModel.getNextButtonPressed().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null) {
                    if (aBoolean) {
                        startBackgroundPhotoTaking();
                    }
                }
            }
        });

        cameraViewModel.getRetakeButtonPressed().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null) {
                    if (aBoolean) {
                        startBackgroundPhotoTaking();
                    }
                }
            }
        });
        if (areInstructionsNeeded) {
            topSheetBehavior.setTopSheetCallback(topSheetBehaviorCallback);

            nextPageButton.setOnClickListener(new View.OnClickListener() {

                @Override
                public void onClick(View view) {
                    if (viewPager.getCurrentItem() == 0) {
                        previousPageButton.setVisibility(View.INVISIBLE);
                    } else {
                        previousPageButton.setVisibility(View.VISIBLE);
                    }
                    if (viewPager.getCurrentItem() == instructionPagerAdapter.getCount() - 2) {
                        nextPageButton.setVisibility(View.GONE);
                        donePageButton.setVisibility(View.VISIBLE);

                    } else {
                        nextPageButton.setVisibility(View.VISIBLE);
                        donePageButton.setVisibility(View.GONE);
                    }
                    viewPager.setCurrentItem(getNextPossibleItemIndex(1), true);
                }
            });

            previousPageButton.setOnClickListener(new View.OnClickListener() {

                @Override
                public void onClick(View view) {
                    viewPager.setCurrentItem(getNextPossibleItemIndex(-1), true);
                    if (viewPager.getCurrentItem() == 0) {
                        previousPageButton.setVisibility(View.INVISIBLE);
                    } else {
                        previousPageButton.setVisibility(View.VISIBLE);
                    }
                    nextPageButton.setVisibility(View.VISIBLE);
                }
            });

            donePageButton.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    topSheetBehavior.setState(TopSheetBehavior.STATE_COLLAPSED);
                }
            });

            viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
                @Override
                public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {

                }

                @Override
                public void onPageSelected(int position) {
                    instructionTitle.setText(instructionList.get(position).getInstructionTitle());
                    instructionText.setText(instructionList.get(position).getInstructionText());
                    if (position == 0) {
                        previousPageButton.setVisibility(View.INVISIBLE);
                    } else {
                        previousPageButton.setVisibility(View.VISIBLE);
                    }
                    if (position == instructionPagerAdapter.getCount() - 1) {
                        nextPageButton.setVisibility(View.GONE);
                        donePageButton.setVisibility(View.VISIBLE);

                    } else {
                        nextPageButton.setVisibility(View.VISIBLE);
                        donePageButton.setVisibility(View.GONE);
                    }
                }

                @Override
                public void onPageScrollStateChanged(int state) {
                }
            });

            expandArrow.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (topSheetBehavior.getState() == TopSheetBehavior.STATE_EXPANDED) {
                        topSheetBehavior.setState(TopSheetBehavior.STATE_COLLAPSED);
                    } else {
                        topSheetBehavior.setState(TopSheetBehavior.STATE_EXPANDED);
                    }
                }
            });


            cameraViewModel.getFaceRetakeButtonPressed().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
                @Override
                public void onChanged(@Nullable Boolean aBoolean) {
                    if (aBoolean != null) {
                        if (aBoolean) {
                            viewPager.setCurrentItem(0);
                            slideDownInstructionsHandler.removeCallbacksAndMessages(null);
                            setInstructionButtonPositions();
                        }
                    }
                }
            });
        }
    }

    private void observeButtonsAvailability() {

        cameraViewModel.getTakePictureButtonAvailability().observe(getViewLifecycleOwner(), new Observer<Boolean>() {
            @Override
            public void onChanged(@Nullable Boolean aBoolean) {
                if (aBoolean != null)
                    takePictureButton.setEnabled(aBoolean);
            }
        });
    }


    private void setupImageView(float uploadDocumentPhotoType) {
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams) imageView.getLayoutParams();
        final ConstraintLayout parent = (ConstraintLayout) imageView.getParent();
        int horizontalMargin = (int) (parent.getWidth());
        int verticalMargin = (int) (parent.getHeight());
        params.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin);
        imageView.setLayoutParams(params);

    }


    private void pictureButtonOnClickListener() {
        takePictureButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                cameraViewModel.setNextButtonAvailability(false);
                cameraViewModel.setRecreateButtonAvailability(false);
                cameraViewModel.setTakePictureButtonAvailability(false);
                if (getActivity() != null) {
                    takePicture();
                }

            }
        });


    }



    public void takePicture() {
        if (fotoapparat != null) {
            frameProcessor.takePicture(new FaceCameraFrameProcessor.OnPictureListener() {
                @Override
                public void OnPictureTaken(Bitmap bitmap, int rotation, String encoded) {
                    BitmapPhoto photo = new BitmapPhoto(bitmap, rotation);
                    showPhoto(photo);
                }
            });
        }
    }

    public CameraViewSize getCameraPreviewSize() {

        return new CameraViewSize(cameraView.getWidth(), cameraView.getHeight());
    }


    public double ratio = -1;
    public void showPhoto(@NonNull final BitmapPhoto bitmapPhoto) {
        if (getActivity() != null) {
            requireActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {

                    if (getActivity() == null || cameraView == null) {
                        return;
                    }
//                    if(fotoapparat!=null && cameraViewModel.getPartnerInfo()!=null && cameraViewModel.getPartnerInfo().getZoomLiveliness())
//                    fotoapparat.stop();

                    Bitmap result = BitmapPhotoCropper.
                            cropPhotoWithPaddings(bitmapPhoto, getCameraPreviewSize(), new RectF(xCoordinateOfWidthStart, yCoordinateOfHeightStart, widthOfImage, heightOfImage),
                                    ratio);
                    DocumentPhotoResult uploadDocumentPhotoType = new DocumentPhotoResult(result, cameraViewModel.getCurrentDocumentStep(),
                            rectangleRight, rectangleLeft, rectangleTop, rectangleBottom);
                    if (cameraViewModel.getHasPartnerEnabledZoom()) {
                        initializeZoomLogin(result);
                        cameraViewModel.setDocumentPhotoResultMutableLiveData(uploadDocumentPhotoType);
                        cameraViewModel.setaddFacePhotoResultFragment(true);
                    } else {
                        cameraViewModel.setDocumentPhotoResultMutableLiveData(uploadDocumentPhotoType);
                        cameraViewModel.setaddFacePhotoResultFragment(true);
                    }
                }
            });


        }
    }

    void initializeZoomLogin(Bitmap bitmap) {
        cameraViewModel.setSavedFacePhotoBitmap(bitmap);


    }


    @Override
    public void onDestroy() {
        super.onDestroy();
        LoggingHelper.FrgamentsInfo("onDestriyFaceCameraSessionFragment");

    }

    private SpannableStringBuilder getDefaultTitle(String docPart) {
        SpannableStringBuilder builder = new SpannableStringBuilder();
        if (getActivity() == null) {
            builder.append("");
            return builder;
        }
        builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyBlack)),
                getResources().getString(R.string.document_tutorial_title_default_part_0
                )));
        builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyWhite)), " " + docPart + " "));
        builder.append(setColoredSpan(new ForegroundColorSpan(ContextCompat.getColor(getActivity(), R.color.idenfyBlack)),
                getResources().getString(R.string.document_tutorial_title_default_part_2
                )));
        return builder;
    }

    private SpannableString setColoredSpan(ForegroundColorSpan color, String string) {
        SpannableString spanStr = new SpannableString(string);
        spanStr.setSpan(color, 0, spanStr.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        return spanStr;
    }

    @Override
    public void onPause() {
        super.onPause();
        fotoapparat.stop();
        cameraViewModel.setFaceRetakeButtonPressed(false);
        cameraViewModel.setNextButtonPressed(false);
        cameraViewModel.setRetakeButtonPressed(false);
    }

    @Override
    public void onStop() {
        super.onStop();
        LoggingHelper.onStop(FaceCameraSessionFragment.class.getSimpleName());
    }


    @Override
    public void onStart() {
        super.onStart();
        if (getActivity() != null) {
            frameProcessor = new FaceCameraFrameProcessor(getActivity());
            setFotoapparatCameraSettings(frameProcessor);
        }
        setupCamera();
        LoggingHelper.FrgamentsInfo("onStartFaceCameraSessionFragment");

    }
    @Override
    public void onResume() {
        super.onResume();
        if (areInstructionsNeeded)
        setInstructionButtonPositions();
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                if (fotoapparat != null) {
                    fotoapparat.start();
                    startBackgroundPhotoTaking();
                }

            }
        }, 100);
        LoggingHelper.FrgamentsInfo("onResumeFaceCameraSessionFragment");



    }

    @Override
    public void onDestroyView() {
        LoggingHelper.onDestroyView(FaceCameraSessionFragment.class.getSimpleName());
        super.onDestroyView();
        if(topSheetBehavior!=null)
        topSheetBehavior.setTopSheetCallback(null);
        cameraView = null;
        fotoapparat = null;
        backTextView = null;
        backImage = null;
        imageInfoLayout = null;
        documentTitleTutorial = null;
        takePictureButton = null;
        ((CameraPreviewActivity) getActivity()).setSupportActionBar(null);
        takePictureHandler.removeCallbacksAndMessages(null);
        imageView = null;
        documentBorderTextView = null;
        rootView = null;
        backgroundPhotoHandler.removeCallbacksAndMessages(null);
    }

    public void setupCamera() {
        Activity activity = getActivity();
        if (isAdded() && activity != null) {
            fotoapparat = Fotoapparat
                    .with(getActivity())
                    .into(cameraView)
                    .previewScaleType(ScaleType.CenterCrop)
                    .previewResolution(highestResolution())
                    .lensPosition(front())
                    .focusMode(firstAvailable(
                            continuousFocusPicture(),
                            continuousFocusVideo(),
                            autoFocus(),
                            fixed()
                    ))
                    .photoResolution(ResolutionSelectorsKt.highestResolution())
                    .frameProcessor(frameProcessor)
                    .cameraErrorCallback(new CameraErrorListener() {
                        @Override
                        public void onError(@NonNull CameraException e) {
                            if(cameraViewModel.getPartnerInfo()!=null &&
                                    !cameraViewModel.getPartnerInfo().getZoomLiveliness())
                            cameraViewModel.setAddFaceCameraFragment(false);
                        }
                    })
                    .build();

        }

    }


    public void onBackPressed() {
        ((CameraPreviewActivity) getActivity()).onBackPressed();

    }

    public void setupCustomTypeFace(Typeface typeface, Typeface typeFaceBold) {
        if (typeFaceBold == null) {
            return;
        }
        backTextView.setTypeface(typeFaceBold);
        documentTitleTutorial.setTypeface(typeFaceBold);
    }

    private void setupCustomUI() {
        if (getActivity() == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
            DrawableCompat.setTint(backImage.getDrawable(), ContextCompat.getColor(getActivity(),
                    R.color.idenfyFaceSessionCameraBackArrowColor));

        } else {
            backImage.getDrawable().mutate().setColorFilter(ContextCompat.getColor(getActivity(),
                    R.color.idenfyFaceSessionCameraBackArrowColor), PorterDuff.Mode.SRC_IN);
        }
        backTextView.setTextColor(getResources().getColor(R.color.idenfyFaceSessionBackTextViewColor));
        documentTitleTutorial.setTextColor(ContextCompat.getColor(getActivity(), R.color.idenfyFaceCameraSessionInformationTextViewColor));
    }

    private void setUpUIDynamicSizes() {
        topSheetBehavior = TopSheetBehavior.from(topSheet);
        instructionDynamicSizeManager.setUpUIDynamicSizes(getContext(),instructionText, instructionTitle, viewPager);
    }

    private void setUpInstructions() {

        TabLayout viewPagerDots = rootView.findViewById(R.id.viewpager_dots);

        instructionPagerAdapter = new InstructionPagerAdapter(getChildFragmentManager(), instructionList, instructionTitle, instructionText, instructionList.size());
        viewPager.setOffscreenPageLimit(instructionList.size());
        viewPager.setPageMargin(dpToPx(20));
        viewPager.setAdapter(instructionPagerAdapter);
        viewPagerDots.setupWithViewPager(viewPager, true);

        slideDownInstructionsHandler.postDelayed(new Runnable() {
            @Override
            public void run() {
                topSheetBehavior.setState(TopSheetBehavior.STATE_EXPANDED);
            }
        }, 500);
    }

    /**
     * Method sets viewpager's button positions (visibility) according to the current page
     */
    private void setInstructionButtonPositions() {
        if(instructionList == null)
            return;
        if(viewPager.getCurrentItem() == instructionList.size()-1){
            nextPageButton.setVisibility(View.INVISIBLE);
            previousPageButton.setVisibility(View.VISIBLE);
        }
        else if(viewPager.getCurrentItem() == 0)
        {
            nextPageButton.setVisibility(View.VISIBLE);
            previousPageButton.setVisibility(View.INVISIBLE);
        }
        else {
            nextPageButton.setVisibility(View.VISIBLE);
            previousPageButton.setVisibility(View.VISIBLE);
        }
    }

    private int getNextPossibleItemIndex(int change) {

        int currentIndex = viewPager.getCurrentItem();
        int total = Objects.requireNonNull(viewPager.getAdapter()).getCount();

        if (currentIndex + change < 0) {
            return 0;
        }

        return Math.abs((currentIndex + change) % total);
    }

    public int dpToPx(int dp) {
        DisplayMetrics displayMetrics = getActivity().getResources().getDisplayMetrics();
        return Math.round(dp * (displayMetrics.xdpi / DisplayMetrics.DENSITY_DEFAULT));
    }
}

