package com.idenfy.idenfySdk.navigation

import android.support.v4.app.FragmentManager
import com.idenfy.idenfySdk.UI.AuthenticationResultView.AuthenticationResultFragment
import com.idenfy.idenfySdk.UI.CameraView.DocumentsCameraSessionFragment
import com.idenfy.idenfySdk.UI.CameraView.FaceCameraSessionFragment
import com.idenfy.idenfySdk.UI.DocumentPhotoResultView.DocumentPhotoResultFragment
import com.idenfy.idenfySdk.UI.DocumentPhotoResultView.FacePhotoResultFragment
import com.idenfy.idenfySdk.core.ui.view.CameraPreviewActivity
import com.idenfy.idenfySdk.UI.SplashScreenFragment.SplashScreenFragment
import com.idenfy.idenfySdk.initialagreement.ui.views.InitialAgreementFragmnet
import com.idenfy.idenfysdk.core.logging.LoggingHelper
import com.idenfySdk.R

class Router {

    fun areFragmentsShown(supportFragmentManager: FragmentManager): Boolean {
        var areFragmentsShown = false
        val faceCameraFragemnt = supportFragmentManager.findFragmentByTag(FACE_CAMERA_SESSION_FRAGMENT)
        val facePhotoResultFragment = supportFragmentManager.findFragmentByTag(FACE_PHOTO_RESULT_FRAGMENT)
        val documentCameraFragment = supportFragmentManager.findFragmentByTag(DOCUMENT_PHOTO_RESULT_FRAGMENT)
        val documentssessionCameraFragment = supportFragmentManager.findFragmentByTag(DOCUMENT_CAMERA_SESSION_FRAGMENT_TAG)
        val docScanningFragment = supportFragmentManager.findFragmentByTag(DOC_SCANNING_FRAGMENT)
        val authentication = supportFragmentManager.findFragmentByTag(AUTHENTICATION_RESULTS_FRAGMENT)
        if (faceCameraFragemnt != null || facePhotoResultFragment != null
                || documentCameraFragment != null || documentssessionCameraFragment != null || authentication != null || docScanningFragment != null) {
            areFragmentsShown = true
        }
        return areFragmentsShown
    }
    fun addDocScanningFragment(supportFragmentManager: FragmentManager) {
        val fragment = supportFragmentManager.findFragmentByTag(CameraPreviewActivity.DOC_SCANNING_FRAGMENT)
        if (fragment == null) {
            val documentsCameraSessionFragment = com.idenfy.docscanning.docScanning.DocScanningFragment()
            supportFragmentManager.beginTransaction().replace(R.id.newMain, documentsCameraSessionFragment, CameraPreviewActivity.DOC_SCANNING_FRAGMENT)
                    .commit()
        }
    }

    fun removeDocScanningFragment(supportFragmentManager: FragmentManager) {
        val fragment = supportFragmentManager.findFragmentByTag(CameraPreviewActivity.DOC_SCANNING_FRAGMENT)
        if (fragment != null) {
            supportFragmentManager.beginTransaction().remove(fragment)
                    .commit()
        }
    }
    fun addFaceCameraFragment(supportFragmentManager: FragmentManager) {
        val fragment = supportFragmentManager.findFragmentByTag(CameraPreviewActivity.FACE_CAMERA_SESSION_FRAGMENT)
        if (fragment == null) {
            LoggingHelper.FrgamentsInfo("addingFaceCamera")
            val cameraNewFragment = FaceCameraSessionFragment()
            supportFragmentManager.beginTransaction().replace(R.id.newMain, cameraNewFragment, CameraPreviewActivity.FACE_CAMERA_SESSION_FRAGMENT)
                    .commit()

        }
    }
    fun removeFaceCameraFragment(supportFragmentManager: FragmentManager) {
        val fragment = supportFragmentManager.findFragmentByTag(FACE_CAMERA_SESSION_FRAGMENT)
        if (fragment != null) {
            LoggingHelper.FrgamentsInfo("removingFace")
            supportFragmentManager.beginTransaction().remove(fragment)
                    .commit()
        }
    }

    fun addFacePhotoResultFragment(supportFragmentManager: FragmentManager) {
        val fragment = supportFragmentManager.findFragmentByTag(FACE_PHOTO_RESULT_FRAGMENT)
        if (fragment == null) {
            LoggingHelper.FrgamentsInfo("addFaceResult")
            val cameraNewFragment = FacePhotoResultFragment()
            supportFragmentManager.beginTransaction().add(R.id.newMain, cameraNewFragment, FACE_PHOTO_RESULT_FRAGMENT)
                    .commit()
        }
    }

    fun removeFacePhotoResultFragment(supportFragmentManager: FragmentManager) {
        val fragment = supportFragmentManager.findFragmentByTag(FACE_PHOTO_RESULT_FRAGMENT)
        if (fragment != null) {
            LoggingHelper.FrgamentsInfo("removingfaceresult")
            supportFragmentManager.beginTransaction().remove(fragment)
                    .commit()
        }
    }

    fun addDocumentPhotoResultFragment(supportFragmentManager: FragmentManager)
    {
        val fragment = supportFragmentManager.findFragmentByTag(DOCUMENT_PHOTO_RESULT_FRAGMENT)
        if (fragment == null) {
            LoggingHelper.FrgamentsInfo("addingDocumentResultFragemnt")
            val documentPhotoResultFragment = DocumentPhotoResultFragment()
            supportFragmentManager.beginTransaction().add(R.id.newMain, documentPhotoResultFragment, CameraPreviewActivity.DOCUMENT_PHOTO_RESULT_FRAGMENT).commit()
        }
    }
    fun removeDocumentPhotoResultFragment(supportFragmentManager: FragmentManager)
    {
        val fragment = supportFragmentManager.findFragmentByTag(DOCUMENT_PHOTO_RESULT_FRAGMENT)
        if (fragment != null)
            supportFragmentManager.beginTransaction().remove(fragment).commit()
    }

    fun addDocumentCameraSessionFragment(supportFragmentManager: FragmentManager){
        val fragment = supportFragmentManager.findFragmentByTag(DOCUMENT_CAMERA_SESSION_FRAGMENT_TAG)
        if (fragment == null) {
            LoggingHelper.FrgamentsInfo("addingCamera")
            val documentsCameraSessionFragment = DocumentsCameraSessionFragment()
            supportFragmentManager.beginTransaction().replace(R.id.newMain, documentsCameraSessionFragment, CameraPreviewActivity.DOCUMENT_CAMERA_SESSION_FRAGMENT_TAG)
                    .commit()
        }
    }

    fun removeDocumentSelectionFragment(supportFragmentManager: FragmentManager) {
        val cameraFragment = supportFragmentManager.findFragmentByTag(CameraPreviewActivity.DOCUMENT_CAMERA_SESSION_FRAGMENT_TAG)
        if (cameraFragment != null) {
            LoggingHelper.FrgamentsInfo("removingCameraFragment")
            supportFragmentManager.beginTransaction().remove(cameraFragment).commit()
        }
    }

    fun addSplashScreenFragment(supportFragmentManager: FragmentManager) {
        val authenticationResultFragment = supportFragmentManager.findFragmentByTag(CameraPreviewActivity.SPLASH_SCREEN_FRAGMENT)
        if (authenticationResultFragment == null) {
            LoggingHelper.FrgamentsInfo("addingSplash")
            val cameraNewFragment = SplashScreenFragment()
            supportFragmentManager.beginTransaction().add(R.id.newMain, cameraNewFragment, CameraPreviewActivity.SPLASH_SCREEN_FRAGMENT)
                    .commit()
        }
    }

    fun addInitialAgreementFragment(supportFragmentManager: FragmentManager) {
        val initialAgreementFragment = supportFragmentManager.findFragmentByTag(CameraPreviewActivity.INITIAL_AGREEMENT_FRAGMENT)
        if (initialAgreementFragment == null) {
            LoggingHelper.FrgamentsInfo("addingInitial")
            val cameraNewFragment = InitialAgreementFragmnet()
            supportFragmentManager.beginTransaction().add(R.id.setupContainer, cameraNewFragment, CameraPreviewActivity.INITIAL_AGREEMENT_FRAGMENT)
                    .commit()
        }
    }
    fun removeInitialAgreementFragment(supportFragmentManager: FragmentManager) :Boolean {
        val fragment = supportFragmentManager.findFragmentByTag(CameraPreviewActivity.INITIAL_AGREEMENT_FRAGMENT)
        if (fragment != null) {
            LoggingHelper.FrgamentsInfo("removingInitialAgre")
            supportFragmentManager.beginTransaction().remove(fragment).commit()
            return true
        }
        return false

    }

    fun addAuthenticationResultFragment(supportFragmentManager: FragmentManager) {
        val auth = supportFragmentManager.findFragmentByTag(CameraPreviewActivity.AUTHENTICATION_RESULTS_FRAGMENT)
        if (auth == null) {
            LoggingHelper.FrgamentsInfo("authAdded")
            val transaction = supportFragmentManager.beginTransaction()
            val authenticationResultFragment = AuthenticationResultFragment()
            transaction.add(R.id.newMain, authenticationResultFragment, CameraPreviewActivity.AUTHENTICATION_RESULTS_FRAGMENT)
            transaction.replace(R.id.newMain, authenticationResultFragment, CameraPreviewActivity.AUTHENTICATION_RESULTS_FRAGMENT)
            transaction.setCustomAnimations(android.R.anim.fade_in, android.R.anim.fade_out)
            transaction.commit()
        }
    }
    fun removeAuthenticationResultFragment(supportFragmentManager: FragmentManager) {
        val fragment = supportFragmentManager.findFragmentByTag(CameraPreviewActivity.AUTHENTICATION_RESULTS_FRAGMENT)
        if (fragment != null) {
            LoggingHelper.FrgamentsInfo("removingAuth")
            supportFragmentManager.beginTransaction().remove(fragment).commit()
        }
    }

    companion object {
        const val INITIAL_AGREEMENT_FRAGMENT = "InitialAgreementFragment"
        const val SPLASH_SCREEN_FRAGMENT = "SplashScreenFragment"
        const val DOCUMENT_PHOTO_RESULT_FRAGMENT = "DOCUMENT_PHOTO_RESULT_FRAGMENT"
        const val FACE_CAMERA_SESSION_FRAGMENT = "FACE_CAMERA_SESSION_FRAGMENT"
        const val FACE_PHOTO_RESULT_FRAGMENT = "FACE_CAMERA_RESULT_FRAGMENT"
        const val DOCUMENT_CAMERA_SESSION_FRAGMENT_TAG = "DocumentsCameraSessionFragment"
        const val DOC_SCANNING_FRAGMENT = "DocumentScanningFragment"
        const val AUTHENTICATION_RESULTS_FRAGMENT = "AuthenticationFragment"

    }
}