package com.idenfy.idenfySdk.initialagreement.ui.viewmodels

import android.arch.lifecycle.MediatorLiveData
import android.arch.lifecycle.MutableLiveData
import android.arch.lifecycle.ViewModel
import com.idenfy.idenfySdk.initialagreement.domain.InitialAgreementDataModel
import com.idenfy.idenfySdk.initialagreement.repo.InitialAgreementRepositoryImp
import com.idenfy.idenfysdk.core.extensions.livedataextensions.default
import com.idenfySdk.R

class InitialAgreementViewModel : ViewModel() {


    var initialAgreementDataModelLiveData = MediatorLiveData<InitialAgreementDataModel>()

    fun updateInitialAgreementDataModelLiveData(value: InitialAgreementDataModel?) {
        if (value == null)
            return

        validateInputForActivatingSumbitButton(value)
        initialAgreementDataModelLiveData.value = (value)
    }

    fun validateInputForActivatingSumbitButton(viewData: InitialAgreementDataModel) {

        if (viewData.isCheckBox1Enabled && viewData.isCheckBox2Enabled && (viewData.selectedCountryFromList == null && viewData.selectedCountryFromPartnerInfo ==null)) {
            viewData.errorMessageId = R.string.select_your_document_issuing_country_message
            viewData.isStartSessionButtonActive = false
            return

        } else if (!viewData.isCheckBox1Enabled || !viewData.isCheckBox2Enabled && viewData.selectedCountryFromList != null) {
            viewData.errorMessageId = R.string.agree_with_terms_of_service_message
            viewData.isStartSessionButtonActive = false
            return
        } else if (viewData.isCheckBox1Enabled && viewData.isCheckBox2Enabled && (viewData.selectedCountryFromPartnerInfo != null ||
                viewData.selectedCountryFromList != null)) {
            viewData.isStartSessionButtonActive = true

            return
        }

    }

    init {
        initialAgreementDataModelLiveData.addSource(InitialAgreementRepositoryImp.initialAgreementDataModel) {
            updateInitialAgreementDataModelLiveData(it)
        }
    }

    override fun onCleared() {
        super.onCleared()
    }
}